/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs.mibparser;

import com.adventnet.snmp.mibs.mibparser.BaseSyntax;
import com.adventnet.snmp.mibs.mibparser.CommentClass;
import com.adventnet.snmp.mibs.mibparser.MIBConstants;
import com.adventnet.snmp.mibs.mibparser.MIBParser;
import com.adventnet.snmp.mibs.mibparser.RangeList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SyntaxOID
implements BaseSyntax,
MIBConstants {
    SyntaxOID parentOIDSyntax;
    public Vector childOIDList;
    int[] oid_tree;
    Vector childoids = new Vector();
    int value = -1;
    String identity;
    BaseSyntax syntax;
    public CommentClass commentObj;

    SyntaxOID() {
        this.childOIDList = new Vector();
        this.commentObj = new CommentClass();
    }

    public SyntaxOID addChild(int n) {
        Integer n2;
        if (this.childOIDList == null) {
            this.childOIDList = new Vector();
        }
        if (this.childoids == null) {
            this.childoids = new Vector();
        }
        if (this.childoids.contains(n2 = new Integer(n))) {
            return (SyntaxOID)this.childOIDList.elementAt(this.childoids.indexOf(n2));
        }
        SyntaxOID syntaxOID = new SyntaxOID();
        int n3 = this.oid_tree.length;
        syntaxOID.oid_tree = new int[n3 + 1];
        System.arraycopy(this.oid_tree, 0, syntaxOID.oid_tree, 0, n3);
        syntaxOID.oid_tree[n3] = n;
        syntaxOID.parentOIDSyntax = this;
        syntaxOID.value = n;
        this.childOIDList.addElement(syntaxOID);
        this.childoids.addElement(n2);
        return syntaxOID;
    }

    public void assign(SyntaxOID syntaxOID) {
        this.parentOIDSyntax = syntaxOID.parentOIDSyntax;
        if (this.parentOIDSyntax != null) {
            int n = this.parentOIDSyntax.childOIDList.indexOf(syntaxOID);
            this.parentOIDSyntax.childOIDList.setElementAt(this, n);
        } else {
            System.err.println(" Got a null Parent ");
        }
        this.childOIDList = syntaxOID.childOIDList;
        this.oid_tree = syntaxOID.oid_tree;
        this.childoids = syntaxOID.childoids;
        this.value = syntaxOID.value;
        this.identity = syntaxOID.identity;
    }

    SyntaxOID[] detectRoot() {
        int n = MIBParser.phantomOidList.size();
        if (n == 0) {
            SyntaxOID[] syntaxOIDArray = new SyntaxOID[]{(SyntaxOID)MIBParser.oidList.get("iso")};
            return syntaxOIDArray;
        }
        SyntaxOID[] syntaxOIDArray = new SyntaxOID[n];
        int n2 = 0;
        Enumeration enumeration = MIBParser.phantomOidList.elements();
        while (enumeration.hasMoreElements()) {
            syntaxOIDArray[n2++] = (SyntaxOID)enumeration.nextElement();
        }
        return syntaxOIDArray;
    }

    public static SyntaxOID getInstance(SyntaxOID syntaxOID, String string, int n) {
        SyntaxOID syntaxOID2;
        if (syntaxOID != null) {
            syntaxOID2 = syntaxOID.addChild(n);
        } else {
            syntaxOID2 = new SyntaxOID();
            syntaxOID2.oid_tree = new int[1];
            syntaxOID2.oid_tree[0] = n;
            syntaxOID2.childOIDList = new Vector();
            syntaxOID2.childoids = new Vector();
        }
        syntaxOID2.identity = string;
        syntaxOID2.value = n;
        return syntaxOID2;
    }

    public String getName() {
        return this.identity;
    }

    public int[] getOIDValue() {
        int n = this.oid_tree.length;
        int[] nArray = new int[n];
        System.arraycopy(this.oid_tree, 0, nArray, 0, n);
        return nArray;
    }

    public RangeList getRange() {
        return null;
    }

    public BaseSyntax getSyntax() {
        if (this.syntax == null) {
            return this;
        }
        return this.syntax.getSyntax();
    }

    public int getType() {
        return 1;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isChild(SyntaxOID syntaxOID) {
        return this.childOIDList.contains(syntaxOID);
    }

    public void merge(SyntaxOID syntaxOID) {
        Object object;
        if (syntaxOID.childOIDList == null) {
            return;
        }
        Enumeration enumeration = syntaxOID.childOIDList.elements();
        while (enumeration.hasMoreElements()) {
            object = (SyntaxOID)enumeration.nextElement();
            this.childOIDList.addElement(object);
            ((SyntaxOID)object).parentOIDSyntax = this;
            ((SyntaxOID)object).oid_tree = new int[this.oid_tree.length + 1];
            System.arraycopy(this.oid_tree, 0, ((SyntaxOID)object).oid_tree, 0, this.oid_tree.length);
            ((SyntaxOID)object).oid_tree[((SyntaxOID)object).oid_tree.length - 1] = ((SyntaxOID)object).value;
        }
        object = syntaxOID.childoids.elements();
        while (object.hasMoreElements()) {
            Integer n = (Integer)object.nextElement();
            this.childoids.addElement(n);
        }
    }

    public SyntaxOID removeInstance() {
        Enumeration enumeration = this.childOIDList.elements();
        while (enumeration.hasMoreElements()) {
            ((SyntaxOID)enumeration.nextElement()).removeInstance();
        }
        if (this.parentOIDSyntax != null) {
            this.parentOIDSyntax.childOIDList.removeElement(this);
            this.parentOIDSyntax.childoids.removeElement(new Integer(this.value));
        }
        return this;
    }

    public void setName(String string) {
        this.identity = string;
    }

    public void setRange(RangeList rangeList) {
    }

    public void setSyntax(BaseSyntax baseSyntax) {
        this.syntax = baseSyntax;
    }

    public void setValue(int n) {
        this.value = n;
    }

    int size() {
        int n = 0;
        Enumeration enumeration = this.childOIDList.elements();
        while (enumeration.hasMoreElements()) {
            n += ((SyntaxOID)enumeration.nextElement()).size();
        }
        return n++;
    }

    public String toBigString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toBigString(stringBuffer);
        return stringBuffer.toString();
    }

    private void toBigString(StringBuffer stringBuffer) {
        if (this.parentOIDSyntax != null) {
            this.parentOIDSyntax.toBigString(stringBuffer);
        }
        stringBuffer.append("." + this.identity);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.oid_tree != null) {
            int n = 0;
            while (n < this.oid_tree.length) {
                if (MIBParser.JDBC && n > 0) {
                    stringBuffer.append("." + ((long)this.oid_tree[n] & 0xFFFFFFFFL));
                } else {
                    stringBuffer.append("." + this.oid_tree[n]);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void writeElements(DataOutputStream dataOutputStream, DataOutputStream dataOutputStream2) throws IOException {
        dataOutputStream.writeUTF(this.identity);
        dataOutputStream.writeInt(this.value);
        int n = this.getType();
        dataOutputStream.writeInt(n);
        this.writeSyntaxRelated(dataOutputStream, dataOutputStream2);
        dataOutputStream.write(10);
        dataOutputStream.writeInt(this.childOIDList.size());
        dataOutputStream.write(10);
        Enumeration enumeration = this.childOIDList.elements();
        while (enumeration.hasMoreElements()) {
            SyntaxOID syntaxOID = (SyntaxOID)enumeration.nextElement();
            syntaxOID.writeElements(dataOutputStream, dataOutputStream2);
        }
    }

    void writeSyntaxRelated(DataOutputStream dataOutputStream, DataOutputStream dataOutputStream2) throws IOException {
        dataOutputStream2.writeUTF(this.commentObj.node);
        dataOutputStream2.writeUTF(this.commentObj.commentStr);
    }
}

