/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.mibs.mibparser;

public class TokenMgrError
extends Error {
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;

    public TokenMgrError() {
    }

    public TokenMgrError(String string, int n) {
        super(string);
        this.errorCode = n;
    }

    public TokenMgrError(boolean bl, int n, int n2, int n3, String string, char c, int n4) {
        this(TokenMgrError.LexicalError(bl, n, n2, n3, string, c), n4);
    }

    private static final String LexicalError(boolean bl, int n, int n2, int n3, String string, char c) {
        return "Lexical error at line " + n2 + ", column " + n3 + ".  Encountered: " + (bl ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(c)) + "\"" + " (" + c + "), ") + "after : \"" + TokenMgrError.addEscapes(string) + "\"";
    }

    protected static final String addEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    char c = string.charAt(n);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        break;
                    }
                    stringBuffer.append(c);
                }
                case '\u0000': 
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getMessage() {
        return super.getMessage();
    }
}

