/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpCounter;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpGauge;
import com.adventnet.snmp.snmp2.SnmpInt;
import com.adventnet.snmp.snmp2.SnmpIpAddress;
import com.adventnet.snmp.snmp2.SnmpNull;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpOpaque;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpTimeticks;
import com.adventnet.snmp.snmp2.SnmpUnsignedInt;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;
import java.util.Vector;

class ASN1Parser
implements Serializable {
    byte[] data;
    int m_idx;
    int spaceLeft;
    int bookMark;
    int dataLength;
    int requiredSize = 1024;
    boolean DEBUG = false;

    ASN1Parser() {
        this.data = new byte[this.requiredSize];
        this.dataLength = this.spaceLeft = this.data.length;
        this.bookMark = 0;
    }

    ASN1Parser(byte[] byArray) {
        this.data = byArray;
        this.dataLength = this.spaceLeft = this.data.length;
        this.bookMark = 0;
        this.m_idx = 0;
    }

    boolean createSpace() {
        if (this.dataLength >= 65536) {
            SnmpAPI.debugPrintLow(SnmpUtils.getString("Trying to allocate a VERY BIG PDU"));
            return false;
        }
        this.spaceLeft = this.dataLength *= 2;
        return true;
    }

    public int decodeInteger() throws ArrayIndexOutOfBoundsException {
        int n = this.decodeLength();
        int n2 = this.data[this.m_idx++];
        while (--n > 0) {
            n2 = n2 << 8 | this.data[this.m_idx++] & 0xFF;
        }
        return n2;
    }

    public int decodeLength() throws ArrayIndexOutOfBoundsException {
        int n;
        if ((n = this.data[this.m_idx++]) < 0) {
            int n2 = n & 0x7F;
            n = 0;
            while (n2-- > 0) {
                n = n << 8 | this.data[this.m_idx++] & 0xFF;
            }
        }
        return n;
    }

    public long[] decodeLong() throws ArrayIndexOutOfBoundsException {
        int n = this.decodeLength();
        long[] lArray = new long[2];
        if (n > 4) {
            lArray[1] = this.data[this.m_idx++];
            while (--n > 4) {
                lArray[1] = lArray[1] << 8 | (long)(this.data[this.m_idx++] & 0xFF);
            }
            lArray[1] = lArray[1] & 0xFFFFFFFFL;
        }
        while (n > 0) {
            lArray[0] = lArray[0] << 8 | (long)(this.data[this.m_idx++] & 0xFF);
            --n;
        }
        return lArray;
    }

    public int[] decodeOID() throws ArrayIndexOutOfBoundsException {
        byte by;
        int n;
        int n2 = this.decodeLength();
        int n3 = this.m_idx + n2;
        if (n2 == 0) {
            int[] nArray = new int[2];
            nArray[1] = 0;
            nArray[0] = 0;
            return nArray;
        }
        int n4 = n2 + 1;
        int n5 = n2;
        int n6 = this.m_idx;
        while (n5 > 0) {
            if (this.data[n6] < 0) {
                --n4;
            }
            --n5;
            ++n6;
        }
        int[] nArray = new int[n4];
        if ((n = this.data[this.m_idx++]) < 0) {
            n &= 0x7F;
            do {
                by = this.data[this.m_idx++];
                n = n << 7 | by & 0x7F;
            } while (by < 0);
        }
        nArray[0] = n / 40;
        nArray[1] = n % 40;
        int n7 = 2;
        while (this.m_idx < n3) {
            if ((n = this.data[this.m_idx++]) < 0) {
                n &= 0x7F;
                do {
                    by = this.data[this.m_idx++];
                    n = n << 7 | by & 0x7F;
                } while (by < 0);
            }
            nArray[n7] = n;
            ++n7;
        }
        return nArray;
    }

    public byte[] decodeOctetString() throws ArrayIndexOutOfBoundsException {
        int n = this.decodeLength();
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, this.m_idx, byArray, 0, n);
        this.m_idx += n;
        return byArray;
    }

    public void decodeVarBindList(Vector vector) throws SnmpException {
        int n = this.decodeLength();
        int n2 = this.m_idx + n;
        while (this.m_idx < n2) {
            SnmpVar snmpVar;
            if (!this.isMessageSequence()) {
                SnmpAPI.debugPrintMedium(SnmpUtils.getString("Parse Auth: Incorrect VarBind"));
                throw new SnmpException(SnmpUtils.getString("Parse Auth: Incorrect VarBind"));
            }
            this.decodeLength();
            SnmpVarBind snmpVarBind = new SnmpVarBind();
            if (!this.isOID()) {
                SnmpAPI.debugPrintMedium(SnmpUtils.getString("Parse Error: Decoding enterprise."));
                throw new SnmpException(SnmpUtils.getString("Parse Error: Decoding enterprise."));
            }
            snmpVarBind.oid = SnmpOID.newInstance(this.decodeOID());
            snmpVarBind.variable = snmpVar = this.decodeVariable();
            vector.addElement(snmpVarBind);
        }
    }

    SnmpVar decodeVariable() throws SnmpException {
        SnmpVar snmpVar = null;
        byte by = this.getTag();
        switch (by) {
            case 2: {
                snmpVar = new SnmpInt(this.decodeInteger());
                break;
            }
            case 4: {
                snmpVar = SnmpString.newInstance(this.decodeOctetString());
                break;
            }
            case 6: {
                snmpVar = SnmpOID.newInstance(this.decodeOID());
                break;
            }
            case 5: {
                ++this.m_idx;
                snmpVar = new SnmpNull();
                break;
            }
            case 64: {
                snmpVar = SnmpIpAddress.newInstance(this.decodeOctetString());
                break;
            }
            case 65: {
                snmpVar = new SnmpCounter((long)this.decodeInteger() & 0xFFFFFFFFL);
                break;
            }
            case 66: {
                snmpVar = new SnmpGauge((long)this.decodeInteger() & 0xFFFFFFFFL);
                break;
            }
            case 67: {
                snmpVar = new SnmpTimeticks((long)this.decodeInteger() & 0xFFFFFFFFL);
                break;
            }
            case 68: {
                snmpVar = SnmpOpaque.newInstance(this.decodeOctetString());
                break;
            }
            case 71: {
                snmpVar = new SnmpUnsignedInt((long)this.decodeInteger() & 0xFFFFFFFFL);
                break;
            }
            default: {
                SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("Cannot decode ASN Type: ")) + " " + Integer.toString(by, 16));
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Cannot decode ASN Type: ")) + " " + Integer.toString(by, 16));
            }
        }
        return snmpVar;
    }

    static SnmpVar decodeVariable(byte[] byArray) throws SnmpException {
        ASN1Parser aSN1Parser = new ASN1Parser(byArray);
        try {
            return aSN1Parser.decodeVariable();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SnmpAPI.debugPrintMedium(SnmpUtils.getString("Error decoding variable"));
            throw new SnmpException(SnmpUtils.getString("Error decoding variable"));
        }
    }

    public void encodeCommand(byte by) {
        this.spaceLeft = ASNTypes.encodeSequence(this.data, this.spaceLeft, this.dataLength - this.spaceLeft, by);
    }

    public void encodeEnterprise(SnmpOID snmpOID) {
        this.spaceLeft = snmpOID.encode(this.data, this.spaceLeft);
    }

    public void encodeIPAddress(SnmpString snmpString) {
        this.spaceLeft = ASNTypes.encodeString(this.data, this.spaceLeft, (String)snmpString.toValue(), 0, 4, 64);
    }

    public void encodeInt(int n) {
        this.spaceLeft = ASNTypes.encodeInt(this.data, this.spaceLeft, n, 2);
    }

    public void encodeOctets(byte[] byArray, int n) {
        this.spaceLeft = ASNTypes.encodeOctets(this.data, this.spaceLeft, byArray, 0, n, 4);
    }

    public void encodeSequence() {
        this.spaceLeft = ASNTypes.encodeSequence(this.data, this.spaceLeft, this.dataLength - this.spaceLeft, 48);
    }

    public void encodeSequence(byte by) {
        this.spaceLeft = ASNTypes.encodeSequence(this.data, this.spaceLeft, this.dataLength - this.spaceLeft, by);
    }

    public void encodeSequence(int n) {
        this.spaceLeft = ASNTypes.encodeSequence(this.data, this.spaceLeft, n - this.spaceLeft, 48);
    }

    public void encodeSequence(int n, byte by) {
        this.spaceLeft = ASNTypes.encodeSequence(this.data, this.spaceLeft, n - this.spaceLeft, by);
    }

    public void encodeString(String string) {
        this.spaceLeft = ASNTypes.encodeString(this.data, this.spaceLeft, string, 0, string != null ? string.length() : 0, 4);
    }

    public void encodeUInt(int n) {
        this.spaceLeft = ASNTypes.encodeUInt(this.data, this.spaceLeft, n, 67);
    }

    public void encodeVarBindList(Vector vector) {
        int n = vector.size() - 1;
        int n2 = this.dataLength;
        while (n >= 0) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)vector.elementAt(n);
            n2 = this.spaceLeft = snmpVarBind.encode(this.data, this.spaceLeft);
            --n;
        }
    }

    public int getBookMark() {
        return this.bookMark;
    }

    public byte getTag() {
        return this.data[this.m_idx++];
    }

    void init() {
        this.data = this.requiredSize > this.dataLength ? new byte[this.requiredSize] : new byte[this.dataLength];
        this.dataLength = this.spaceLeft = this.data.length;
        this.bookMark = 0;
        this.m_idx = 0;
    }

    public boolean isIPAddress() {
        return this.data[this.m_idx++] == 64;
    }

    public boolean isInteger() {
        return this.data[this.m_idx++] == 2;
    }

    public boolean isMessageSequence() {
        return this.data[this.m_idx++] == 48;
    }

    public boolean isOID() {
        return this.data[this.m_idx++] == 6;
    }

    public boolean isOctetString() {
        return this.data[this.m_idx++] == 4;
    }

    public boolean isTimeTicks() {
        return this.data[this.m_idx++] == 67;
    }

    void prepareToSend() {
        byte[] byArray = new byte[this.dataLength - this.spaceLeft];
        System.arraycopy(this.data, this.spaceLeft, byArray, 0, this.dataLength - this.spaceLeft);
        this.data = byArray;
        this.dataLength = this.data.length;
        this.spaceLeft = 0;
    }

    public void setBookMark() {
        this.bookMark = this.spaceLeft;
    }

    void setDebug(boolean bl) {
        this.DEBUG = bl;
    }
}

