/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.SnmpVar;

class ASNTypes {
    static int MAX_SUBID = -1;
    static int MAX_OID_LEN = 64;
    static final byte ASN_BOOLEAN = 1;
    static final byte ASN_INTEGER = 2;
    static final byte ASN_BIT_STR = 3;
    static final byte ASN_OCTET_STR = 4;
    static final byte ASN_NULL = 5;
    static final byte ASN_OBJECT_ID = 6;
    static final byte ASN_SEQUENCE = 16;
    static final byte ASN_SET = 17;
    static final byte ASN_UNIVERSAL = 0;
    static final byte ASN_APPLICATION = 64;
    static final byte ASN_CONTEXT = -128;
    static final byte ASN_PRIVATE = -64;
    static final int ASN_EXCEPTION = 128;
    static final byte ASN_PRIMITIVE = 0;
    static final byte ASN_CONSTRUCTOR = 32;
    static final byte ASN_LONG_LEN = -128;
    static final byte ASN_EXTENSION_ID = 31;
    static final byte ASN_BIT8 = -128;

    ASNTypes() {
    }

    static boolean IS_CONSTRUCTOR(byte by) {
        return (by & 0x20) != 0;
    }

    static boolean IS_EXTENSION_ID(byte by) {
        return (by & 0x1F) == 31;
    }

    static int byteToInt(byte by) {
        return by & 0xFF;
    }

    static int encodeInt(byte[] byArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        int n4 = n2 < 0 ? -128 : 0;
        int n5 = 0;
        while (true) {
            byArray[--n] = (byte)(n2 & 0xFF);
            ++n5;
            if ((n2 & 0xFFFFFF80) == n4) break;
            n2 >>= 8;
        }
        byArray[--n] = (byte)n5;
        byArray[--n] = (byte)n3;
        return n;
    }

    private static int encodeLength(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (n2 < 128) {
            byArray[--n] = (byte)n2;
        } else {
            int n3 = 0;
            do {
                byArray[--n] = (byte)(n2 & 0xFF);
                ++n3;
            } while ((n2 >>>= 8) != 0);
            byArray[--n] = (byte)(n3 | 0x80);
        }
        return n;
    }

    static int encodeNull(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        byArray[--n] = 0;
        byArray[--n] = (byte)n2;
        return n;
    }

    static int encodeOctets(byte[] byArray, int n, byte[] byArray2, int n2, int n3, int n4) throws ArrayIndexOutOfBoundsException {
        if (byArray2 != null) {
            System.arraycopy(byArray2, n2, byArray, n - n3, n3);
        } else {
            n3 = 0;
        }
        n = ASNTypes.encodeLength(byArray, n - n3, n3);
        byArray[--n] = (byte)n4;
        return n;
    }

    static int encodeOid(byte[] byArray, int n, int[] nArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        int n4 = 1;
        if (n2 < 2) {
            byArray[--n] = 0;
        } else {
            int n5 = n2 - 1;
            while (n5 > 1) {
                int n6 = nArray[n5];
                byArray[--n] = (byte)(n6 & 0x7F);
                ++n4;
                while ((n6 & 0xFFFFFF80) != 0) {
                    byArray[--n] = (byte)((n6 >>>= 7) & 0x7F | 0x80);
                    ++n4;
                }
                --n5;
            }
            byArray[--n] = (byte)(40 * nArray[0] + nArray[1]);
        }
        n = ASNTypes.encodeLength(byArray, n, n4);
        byArray[--n] = (byte)n3;
        return n;
    }

    static int encodeSequence(byte[] byArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        n = ASNTypes.encodeLength(byArray, n, n2);
        byArray[--n] = (byte)n3;
        return n;
    }

    static int encodeString(byte[] byArray, int n, String string, int n2, int n3, int n4) throws ArrayIndexOutOfBoundsException {
        if (string != null) {
            string.getBytes(n2, n2 + n3, byArray, n - n3);
        } else {
            n3 = 0;
        }
        n = ASNTypes.encodeLength(byArray, n - n3, n3);
        byArray[--n] = (byte)n4;
        return n;
    }

    static int encodeUInt(byte[] byArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        int n4 = 0;
        while (true) {
            byArray[--n] = (byte)(n2 & 0xFF);
            ++n4;
            if ((n2 & 0xFFFFFF80) == 0) break;
            n2 >>>= 8;
        }
        byArray[--n] = (byte)n4;
        byArray[--n] = (byte)n3;
        return n;
    }

    static int encodeUInt(byte[] byArray, int n, long[] lArray, int n2) throws ArrayIndexOutOfBoundsException {
        int n3 = 0;
        long l = 0L;
        l |= lArray[1] & 0xFFFFFFFFFFFFFFFFL;
        l <<= 32;
        l |= lArray[0] & 0xFFFFFFFFFFFFFFFFL;
        do {
            byArray[--n] = (byte)(l & 0xFFL);
            ++n3;
        } while ((l >>>= 8) != 0L);
        if ((byArray[n] & 0xFF) > 127) {
            byArray[--n] = 0;
            ++n3;
        }
        byArray[--n] = (byte)n3;
        byArray[--n] = (byte)n2;
        return n;
    }

    static byte[] encodeVariable(SnmpVar snmpVar) {
        int n = 10;
        int n2 = 0;
        byte[] byArray = new byte[n];
        while (true) {
            try {
                n2 = snmpVar.encode(byArray, byArray.length);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                n += n;
                byArray = new byte[n];
                continue;
            }
            break;
        }
        byte[] byArray2 = new byte[n - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }
}

