/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.TransportAddress;
import com.adventnet.snmp.snmp2.TransportPacket;
import com.adventnet.snmp.snmp2.TransportSocket;
import com.adventnet.utils.SnmpUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Vector;

class IpTSocket
extends TransportSocket
implements Serializable {
    transient DatagramSocket sock;
    int waitTime = 0;
    Vector vector = null;
    boolean exitThread = false;

    IpTSocket() {
    }

    IpTSocket(int n, TransportAddress transportAddress) throws SocketException {
        this.sock = transportAddress != null ? new DatagramSocket(n, (InetAddress)transportAddress.getProtocolAddress()) : new DatagramSocket(n);
    }

    synchronized int calculateTimeExpires(int n) {
        int n2 = this.vector.size();
        if (n2 == 0) {
            return this.waitTime + n;
        }
        return n2 * this.waitTime + n;
    }

    void close() {
        this.sock.close();
    }

    int getLocalPort() {
        return this.sock.getLocalPort();
    }

    synchronized int getSoTimeout() throws SocketException {
        return this.sock.getSoTimeout();
    }

    synchronized void receive(TransportPacket transportPacket) throws IOException {
        this.sock.receive((DatagramPacket)transportPacket.getProtocolPacket());
    }

    public void run() {
        Object var1_1 = null;
        TransportPacket transportPacket = null;
        while (true) {
            if (this.vector != null && this.vector.size() > 0) {
                transportPacket = (TransportPacket)this.vector.elementAt(0);
                try {
                    this.sock.send((DatagramPacket)transportPacket.getProtocolPacket());
                }
                catch (SocketException socketException) {
                    this.sock = null;
                    return;
                }
                catch (Exception exception) {
                    SnmpAPI.debugPrintHigh(SnmpUtils.getString("Send Error: "));
                    SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Error in sending :")) + " " + transportPacket.getAddress() + " " + transportPacket.getPort());
                    SnmpAPI.debugPrintHigh(exception);
                }
                this.vector.removeElement(transportPacket);
                try {
                    Thread.sleep(this.waitTime);
                }
                catch (Exception exception) {}
                continue;
            }
            if (this.exitThread) {
                this.exitThread = false;
                this.vector.removeAllElements();
                this.vector = null;
                return;
            }
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    void send(TransportPacket transportPacket) throws IOException {
        if (this.waitTime == 0) {
            this.sock.send((DatagramPacket)transportPacket.getProtocolPacket());
        } else {
            this.vector.addElement(transportPacket);
        }
    }

    synchronized void setSoTimeout(int n) throws SocketException {
        this.sock.setSoTimeout(n);
    }

    void setTimeToWait(int n) {
        if (n == 0) {
            this.exitThread = true;
        } else if (!this.isAlive()) {
            this.exitThread = false;
            this.start();
        }
        if (this.vector == null) {
            this.vector = new Vector();
        }
        this.waitTime = n;
    }
}

