/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ResultSetAdapter;
import com.adventnet.utils.SnmpUtils;
import java.sql.SQLException;

class ResultSetImpl
extends ResultSetAdapter {
    int index = 0;
    int rowCount;
    String[] columnNames;
    String[][] values;

    ResultSetImpl(String[] stringArray, String[][] stringArray2) {
        this.columnNames = stringArray;
        this.values = stringArray2;
        this.rowCount = stringArray2 == null ? 0 : stringArray2.length;
    }

    public void afterLast() throws SQLException {
        if (this.rowCount > 0) {
            this.index = this.rowCount + 1;
        }
    }

    public void beforeFirst() throws SQLException {
        this.index = 0;
    }

    public boolean first() throws SQLException {
        if (this.rowCount > 0) {
            this.index = 1;
            return true;
        }
        return false;
    }

    int getColumnIndex(String string) {
        if (string == null) {
            return -1;
        }
        if (this.columnNames == null) {
            return -2;
        }
        int n = 0;
        while (n < this.columnNames.length) {
            if (this.columnNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getRow() throws SQLException {
        return this.index;
    }

    public String getString(int n) throws SQLException {
        if (this.columnNames == null) {
            throw new SQLException(SnmpUtils.getString("No Columns Present in this ResultSet"));
        }
        if (n < 1 || n > this.columnNames.length) {
            throw new SQLException(String.valueOf(SnmpUtils.getString("Invalid ColumnIndex: ")) + " " + n);
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(SnmpUtils.getString("No Valid row specified"));
        }
        return this.values[this.index - 1][n - 1];
    }

    public String getString(String string) throws SQLException {
        int n = this.getColumnIndex(string);
        if (n == -1) {
            throw new SQLException(String.valueOf(SnmpUtils.getString("Invalid ColumnName: ")) + " " + string);
        }
        if (n == -2) {
            throw new SQLException(SnmpUtils.getString("No Columns Present in this ResultSet"));
        }
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw new SQLException(SnmpUtils.getString("No Valid row specified"));
        }
        return this.values[this.index - 1][n];
    }

    public boolean isAfterLast() throws SQLException {
        return this.index == this.rowCount + 1;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.index == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.index == 1;
    }

    public boolean isLast() throws SQLException {
        return this.index == this.rowCount;
    }

    public boolean last() throws SQLException {
        this.index = this.rowCount;
        return this.rowCount > 0;
    }

    public boolean next() throws SQLException {
        if (this.index < this.rowCount) {
            ++this.index;
            return true;
        }
        if (this.index == this.rowCount) {
            ++this.index;
            return false;
        }
        return false;
    }
}

