/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.management.transport.SessionTransportProvider;
import com.adventnet.management.transport.TcpClientTransportImpl;
import com.adventnet.management.transport.TransportException;
import com.adventnet.management.transport.TransportProvider;
import com.adventnet.snmp.snmp2.SASResponseMsg;
import com.adventnet.snmp.snmp2.ServletCommunication;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Properties;
import java.util.Vector;

public class SASClient
extends Observable
implements Serializable,
Runnable {
    URL url = null;
    Properties props = null;
    ServletCommunication msg = null;
    public static final int TCP_PROTOCOL = 1;
    public static final int HTTP_PROTOCOL = 2;
    int protocol = 1;
    Applet app = null;
    private boolean debug = false;
    Vector responses = new Vector();
    int timeOut = 2000;
    static int reqID = 1;
    static boolean fileWrite = true;
    boolean connected = false;
    SessionTransportProvider sock = null;
    static final int SAS_INVALID_TYPE = -1;
    static final int SAS_OPEN = 1;
    static final int SAS_SEND = 2;
    static final int SAS_RECEIVED = 3;
    static final int SAS_CLOSE = 4;
    static final int SAS_SAVE = 5;
    static final int SAS_ERROR = 6;
    static final int SAS_APPEND = 7;
    static final int SAS_DELETE_FILE = 8;
    static final int SAS_CREATE_DIR = 9;
    static final int SAS_DELETE_DIR = 10;
    static final int SAS_CLIENT_CALL = 11;
    static final int SAS_CLIENT_RESPONSE = 12;
    static final int SAS_ALIVE = 13;
    static final int SAS_TRAP_REQUEST = 14;
    static final int SAS_NAME_LOOKUP = 15;
    static final int SAS_ADDRESS_LOOKUP = 16;
    static final int SAS_ASYNC_RESPONSE = 17;
    static final int SAS_DB_CONNECT = 18;
    static final int SAS_DB_CLOSE = 19;
    static final int SAS_DB_QUERY = 20;
    static final int SAS_DB_UPDATE = 21;
    static final int SAS_DB_FAILURE = 100;
    static final int SAS_DB_SUCCESS = 101;
    static final int SAS_VALID_TYPES = 21;
    static final int HTTP_OPEN = 31;
    static final int HTTP_SEND = 32;
    static final int HTTP_RECEIVED = 33;
    static final int HTTP_CLOSE = 34;
    static final int HTTP_SAVE = 35;
    static final int HTTP_ERROR = 36;
    static final int HTTP_APPEND = 37;
    static final int HTTP_DELETE_FILE = 38;
    static final int HTTP_CREATE_DIR = 39;
    static final int HTTP_DELETE_DIR = 40;
    static final int HTTP_CLIENT_CALL = 41;
    static final int HTTP_CLIENT_RESPONSE = 42;
    static final int HTTP_ALIVE = 43;
    static final int HTTP_TRAP_REQUEST = 44;
    static final int HTTP_NAME_LOOKUP = 45;
    static final int HTTP_ADDRESS_LOOKUP = 46;
    static final int HTTP_ASYNC_RESPONSE = 47;
    int port;
    int len;
    byte[] data;
    String remoteHost;
    String remoteHostName;
    private Thread sasClientThread = null;
    private String addr;
    private String host;
    boolean closeSocket = false;
    boolean gotResponse = true;
    byte[] callData;
    int CALL_TIMEOUT = 60;
    boolean gotUserResponse = false;
    byte[] userRcvData;
    int user_req_type = -1;
    TransportProvider provider = null;

    public SASClient(Applet applet, boolean bl) throws SnmpException {
        this(applet, bl, 1);
    }

    public SASClient(Applet applet, boolean bl, int n) throws SnmpException {
        this.app = applet;
        this.protocol = n;
        try {
            if (n == 1) {
                String string = applet.getParameter("TRANSPORT_PROVIDER");
                this.setTransportProvider(string);
                String string2 = applet.getParameter("SAS_PORT_DIR");
                String string3 = applet.getParameter("PORT_FILE_NAME");
                if (string3 == null) {
                    string3 = "SASPort.html";
                }
                Object[] objectArray = new Object[]{applet, string2, string3};
                this.provider.init(objectArray);
                this.sock = this.provider.open(null);
            } else if (n == 2) {
                this.port = applet.getCodeBase().getPort();
                if (this.port == -1) {
                    this.port = 8080;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error: Connecting to Applet Host : ")) + " " + exception);
            throw new SnmpException(String.valueOf(SnmpUtils.getString("Error: Connecting to Applet Host : ")) + " " + exception);
        }
        this.connected = true;
    }

    void addResponse(SASResponseMsg sASResponseMsg) {
        this.responses.addElement(sASResponseMsg);
    }

    public void appendFile(String string, byte[] byArray) throws TransportException, IOException {
        block3: {
            int n;
            Object object;
            if (this.protocol == 1) {
                object = null;
                object = this.convertIntToByteArray(7);
                this.sock.write((byte[])object, ((byte[])object).length);
                object = string.getBytes();
                this.sock.write((byte[])object, ((byte[])object).length);
                n = byArray.length;
                this.sock.write(byArray, n);
            }
            if (this.protocol != 2) break block3;
            this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
            this.props = new Properties();
            ((Hashtable)this.props).put("request", "37");
            object = new File("HTTPUsers" + File.separator + string);
            ((Hashtable)this.props).put("filename", ((File)object).getAbsolutePath());
            n = byArray.length;
            ((Hashtable)this.props).put("length", String.valueOf(n));
            ((Hashtable)this.props).put("data", new String(byArray));
            this.msg = new ServletCommunication(this.url);
            try {
                this.msg.sendPostMessage(this.props);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized byte[] clientCall(byte[] byArray) {
        this.gotResponse = false;
        this.callData = null;
        try {
            byte[] byArray2 = null;
            byArray2 = this.convertIntToByteArray(11);
            this.sock.write(byArray2, byArray2.length);
            int n = byArray.length;
            this.sock.write(byArray, n);
        }
        catch (TransportException transportException) {
            System.err.println(String.valueOf(SnmpUtils.getString("IO error: ")) + " " + transportException.toString());
            return null;
        }
        int n = 0;
        while (!this.gotResponse) {
            try {
                Thread.sleep(50L);
                if (n++ <= this.CALL_TIMEOUT * 20) continue;
                System.err.println(SnmpUtils.getString("Client Call Timeout."));
                return null;
            }
            catch (Exception exception) {}
        }
        return this.callData;
    }

    synchronized void close() {
        if (this.protocol == 1) {
            try {
                try {
                    this.closeDB();
                }
                catch (Exception exception) {}
                byte[] byArray = null;
                byArray = this.convertIntToByteArray(4);
                this.sock.write(byArray, byArray.length);
            }
            catch (TransportException transportException) {}
        }
        this.closeSocket = true;
        this.connected = false;
        int n = -1;
        try {
            n = this.sock.close();
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Exception closing socket ")) + " " + exception);
        }
    }

    public synchronized void closeDB() throws SQLException {
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(this.convertIntToByteArray(19));
        int n = reqID;
        vector.addElement(this.convertIntToByteArray(reqID++));
        byte[] byArray = this.getData(vector);
        try {
            int n2 = this.sock.write(byArray, byArray.length);
            if (n2 != 0) {
                throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
            }
        }
        catch (Exception exception) {
            throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
        }
        SASResponseMsg sASResponseMsg = null;
        long l = System.currentTimeMillis();
        while ((sASResponseMsg = this.getResponse(n)) == null) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
            if (System.currentTimeMillis() - l > (long)this.timeOut) break;
        }
        if (sASResponseMsg == null) {
            throw new SQLException(SnmpUtils.getString("Timed out"));
        }
        if (sASResponseMsg.state == 100 && sASResponseMsg.expString != null) {
            throw new SQLException(sASResponseMsg.expString);
        }
    }

    public synchronized void connectDB(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        String string5;
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(this.convertIntToByteArray(18));
        int n = reqID;
        vector.addElement(this.convertIntToByteArray(reqID++));
        byte[] byArray = string.getBytes();
        byte[] byArray2 = this.convertIntToByteArray(byArray.length);
        vector.addElement(byArray2);
        vector.addElement(byArray);
        byte[] byArray3 = string2.getBytes();
        byte[] byArray4 = this.convertIntToByteArray(byArray3.length);
        vector.addElement(byArray4);
        vector.addElement(byArray3);
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        if (string3 == null) {
            byArray6 = new byte[4];
            vector.addElement(byArray6);
        } else {
            byArray5 = string3.getBytes();
            byArray6 = this.convertIntToByteArray(byArray5.length);
            vector.addElement(byArray6);
            vector.addElement(byArray5);
        }
        byte[] byArray7 = null;
        byte[] byArray8 = null;
        if (string4 == null) {
            byArray8 = new byte[4];
            vector.addElement(byArray8);
        } else {
            byArray7 = string4.getBytes();
            byArray8 = this.convertIntToByteArray(byArray7.length);
            vector.addElement(byArray8);
            vector.addElement(byArray7);
        }
        byte[] byArray9 = this.getData(vector);
        long l = System.currentTimeMillis();
        try {
            int n2 = this.sock.write(byArray9, byArray9.length);
            if (n2 != 0) {
                throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
            }
        }
        catch (Exception exception) {
            throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
        }
        SASResponseMsg sASResponseMsg = null;
        while ((sASResponseMsg = this.getResponse(n)) == null) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
            if (System.currentTimeMillis() - l > (long)this.timeOut) break;
        }
        if (sASResponseMsg == null) {
            throw new SQLException(SnmpUtils.getString("Timed out"));
        }
        if (sASResponseMsg.state == 100 && (string5 = sASResponseMsg.expString) != null) {
            if (string5.equals(String.valueOf(SnmpUtils.getString("Driver class not found: ")) + " " + string)) {
                throw new ClassNotFoundException(string5);
            }
            if (string5.equals(SnmpUtils.getString("Unable to create Connection: Database access error"))) {
                throw new SQLException(string5);
            }
            if (string5.equals(SnmpUtils.getString("Unable to create Statement: Database access error"))) {
                throw new SQLException(string5);
            }
        }
    }

    int convertByteArrayToInt(byte[] byArray) throws IOException {
        return this.convertByteArrayToInt(byArray, 0);
    }

    int convertByteArrayToInt(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            throw new IOException(SnmpUtils.getString("Null Byte Array"));
        }
        if (byArray.length < 4) {
            throw new IOException(SnmpUtils.getString("Invalid Byte Array"));
        }
        if (n < 0 || n > byArray.length - 4) {
            throw new IOException(SnmpUtils.getString("Invalid Index"));
        }
        int n2 = 0;
        int n3 = n;
        while (n3 < n + 4) {
            n2 = n2 << 8 | byArray[n3] & 0xFF;
            ++n3;
        }
        return n2;
    }

    byte[] convertIntToByteArray(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public synchronized void createDir(String string) throws TransportException, IOException {
        block3: {
            block2: {
                if (this.protocol != 1) break block2;
                byte[] byArray = null;
                byArray = this.convertIntToByteArray(9);
                this.sock.write(byArray, byArray.length);
                byArray = string.getBytes();
                this.sock.write(byArray, byArray.length);
                break block3;
            }
            if (this.protocol != 2) break block3;
            this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
            this.props = new Properties();
            ((Hashtable)this.props).put("request", "39");
            File file = new File("HTTPUsers" + File.separator + string);
            ((Hashtable)this.props).put("directory", file.getAbsolutePath());
            this.msg = new ServletCommunication(this.url);
            try {
                this.msg.sendPostMessage(this.props);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void deleteDir(String string) throws TransportException, IOException {
        block3: {
            block2: {
                if (this.protocol != 1) break block2;
                byte[] byArray = null;
                byArray = this.convertIntToByteArray(10);
                this.sock.write(byArray, byArray.length);
                byArray = string.getBytes();
                this.sock.write(byArray, byArray.length);
                break block3;
            }
            if (this.protocol != 2) break block3;
            this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
            this.props = new Properties();
            ((Hashtable)this.props).put("request", "40");
            File file = new File("HTTPUsers" + File.separator + string);
            ((Hashtable)this.props).put("directory", file.getAbsolutePath());
            this.msg = new ServletCommunication(this.url);
            try {
                this.msg.sendPostMessage(this.props);
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void deleteFile(String string) throws TransportException, IOException {
        block3: {
            block2: {
                if (this.protocol != 1) break block2;
                byte[] byArray = null;
                byArray = this.convertIntToByteArray(8);
                this.sock.write(byArray, byArray.length);
                byArray = string.getBytes();
                this.sock.write(byArray, byArray.length);
                break block3;
            }
            if (this.protocol != 2) break block3;
            this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
            this.props = new Properties();
            ((Hashtable)this.props).put("request", "38");
            File file = new File("HTTPUsers" + File.separator + string);
            ((Hashtable)this.props).put("filename", file.getAbsolutePath());
            this.msg = new ServletCommunication(this.url);
            try {
                this.msg.sendPostMessage(this.props);
            }
            catch (Exception exception) {}
        }
    }

    byte[] getData(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += ((byte[])vector.elementAt(n3)).length;
            ++n3;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            byte[] byArray2 = (byte[])vector.elementAt(n5);
            int n6 = 0;
            while (n6 < byArray2.length) {
                byArray[n4++] = byArray2[n6];
                ++n6;
            }
            ++n5;
        }
        return byArray;
    }

    public synchronized String getHostAddress(String string, int n) throws TransportException {
        String string2;
        if (n == 0) {
            n = 2000;
        }
        if (string == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        this.host = string;
        byte[] byArray = null;
        byArray = this.convertIntToByteArray(15);
        this.sock.write(byArray, byArray.length);
        byArray = string.getBytes();
        this.sock.write(byArray, byArray.length);
        while (this.addr == null) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
            long l2 = System.currentTimeMillis();
            if (l2 - l <= (long)n) continue;
            this.addr = null;
            this.host = null;
            return null;
        }
        String string3 = this.host;
        synchronized (string3) {
            string2 = this.addr;
            this.host = null;
            this.addr = null;
        }
        if (string2.equals("NULL")) {
            return null;
        }
        return string2;
    }

    public synchronized String getHostName(String string, int n) throws TransportException {
        String string2;
        if (string == null) {
            return null;
        }
        if (n == 0) {
            n = 2000;
        }
        long l = System.currentTimeMillis();
        byte[] byArray = null;
        byArray = this.convertIntToByteArray(16);
        this.sock.write(byArray, byArray.length);
        byArray = string.getBytes();
        this.sock.write(byArray, byArray.length);
        this.addr = string;
        while (this.host == null) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {}
            long l2 = System.currentTimeMillis();
            if (l2 - l <= (long)n) continue;
            this.addr = null;
            this.host = null;
            return null;
        }
        String string3 = this.addr;
        synchronized (string3) {
            string2 = this.host;
            this.addr = null;
            this.host = null;
        }
        if (string2.equals("NULL")) {
            return null;
        }
        return string2;
    }

    public int getMaxSasTypes() {
        return 21;
    }

    SASResponseMsg getResponse(int n) {
        int n2 = this.responses.size();
        int n3 = 0;
        while (n3 < n2) {
            SASResponseMsg sASResponseMsg = (SASResponseMsg)this.responses.elementAt(n3);
            if (sASResponseMsg.ID == n) {
                return (SASResponseMsg)this.responses.remove(n3);
            }
            ++n3;
        }
        return null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static boolean isFileReadWrite() {
        return fileWrite;
    }

    public boolean isKnownSASType(int n) {
        return n <= 21;
    }

    void open(int n) {
        block2: {
            if (this.protocol != 1) break block2;
            try {
                byte[] byArray = null;
                byArray = this.convertIntToByteArray(1);
                this.sock.write(byArray, byArray.length);
                byArray = null;
                byArray = this.convertIntToByteArray(n);
                this.sock.write(byArray, byArray.length);
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                System.err.println(SnmpUtils.getString("Error opening socket at applet host."));
            }
        }
    }

    public synchronized ResultSet queryDB(String string) throws SQLException {
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(this.convertIntToByteArray(20));
        int n = reqID;
        vector.addElement(this.convertIntToByteArray(reqID++));
        vector.addElement(string.getBytes());
        byte[] byArray = this.getData(vector);
        long l = System.currentTimeMillis();
        try {
            int n2 = this.sock.write(byArray, byArray.length);
            if (n2 != 0) {
                throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
            }
        }
        catch (Exception exception) {
            throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
        }
        SASResponseMsg sASResponseMsg = null;
        while ((sASResponseMsg = this.getResponse(n)) == null) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
            if (System.currentTimeMillis() - l > (long)this.timeOut) break;
        }
        if (sASResponseMsg == null) {
            throw new SQLException(SnmpUtils.getString("Timed out"));
        }
        if (sASResponseMsg.state == 100 && sASResponseMsg.expString != null) {
            throw new SQLException(sASResponseMsg.expString);
        }
        return sASResponseMsg.resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receive() throws SnmpException, TransportException, IOException {
        int n = -1;
        try {
            block15: while (true) {
                Object object;
                Object object2;
                if (this.protocol == 1) {
                    Object object3;
                    object2 = null;
                    object = null;
                    object2 = this.sock.read();
                    n = this.convertByteArrayToInt((byte[])object2);
                    if (n == 13) continue;
                    if (n == 12) {
                        this.callData = this.sock.read();
                        this.gotResponse = true;
                        continue;
                    }
                    if (n == 17) {
                        object3 = null;
                        object3 = this.sock.read();
                        this.setChanged();
                        this.notifyObservers(object3);
                        continue;
                    }
                    if (n == this.user_req_type) {
                        this.userRcvData = this.sock.read();
                        this.gotUserResponse = true;
                        this.user_req_type = -1;
                        continue;
                    }
                    switch (n) {
                        case 16: {
                            if (this.addr == null) {
                                object3 = null;
                                object = this.sock.read();
                                object3 = new String((byte[])object);
                                object = this.sock.read();
                                object3 = new String((byte[])object);
                                this.addr = null;
                                this.host = null;
                                continue block15;
                            }
                            object = this.sock.read();
                            this.addr = new String((byte[])object);
                            object = this.sock.read();
                            this.host = new String((byte[])object);
                            continue block15;
                        }
                        case 15: {
                            if (this.host == null) {
                                object3 = null;
                                object = this.sock.read();
                                object3 = new String((byte[])object);
                                object = this.sock.read();
                                object3 = new String((byte[])object);
                                this.addr = null;
                                this.host = null;
                                continue block15;
                            }
                            object = this.sock.read();
                            this.addr = new String((byte[])object);
                            object = this.sock.read();
                            this.host = new String((byte[])object);
                            continue block15;
                        }
                        case 3: {
                            int n2 = 4;
                            int n3 = this.convertByteArrayToInt((byte[])object2, n2);
                            byte[] byArray = new byte[n3];
                            System.arraycopy(object2, n2 += 4, byArray, 0, n3);
                            this.remoteHost = this.host = new String(byArray);
                            this.port = this.convertByteArrayToInt((byte[])object2, n2 += n3);
                            this.data = new byte[((Object)object2).length - (n2 += 4)];
                            System.arraycopy(object2, n2, this.data, 0, this.data.length);
                            return;
                        }
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: {
                            try {
                                this.addResponse(new SASResponseMsg((byte[])object2));
                            }
                            catch (Exception exception) {}
                            continue block15;
                        }
                        case 6: {
                            object3 = null;
                            object3 = this.sock.read();
                            System.err.println(String.valueOf(SnmpUtils.getString("SAS error message : ")) + " " + new String((byte[])object3, "8859_1"));
                            continue block15;
                        }
                    }
                    throw new SnmpException(SnmpUtils.getString("Receive error"));
                }
                if (this.protocol != 2) continue;
                object2 = null;
                try {
                    object = null;
                    while (true) {
                        if (object != null) {
                            this.remoteHost = object2.readLine();
                            this.port = Integer.parseInt(object2.readLine());
                            this.len = Integer.parseInt(object2.readLine());
                            this.data = new byte[this.len];
                            object2.readFully(this.data, 0, this.len);
                            return;
                        }
                        this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
                        this.msg = new ServletCommunication(this.url);
                        InputStream inputStream = null;
                        try {
                            inputStream = this.msg.sendGetMessage();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        object2 = new DataInputStream(new BufferedInputStream(inputStream));
                        object = object2.readLine();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            if (this.closeSocket) {
                throw new IOException(SnmpUtils.getString("Socket terminated"));
            }
            if (this.debug) {
                System.err.println(String.valueOf(SnmpUtils.getString("Error communicating with SAS Server. ")) + " ");
            }
            throw new TransportException(String.valueOf(SnmpUtils.getString("Receive Error ")) + " " + iOException.getMessage());
        }
    }

    public synchronized void reqTraps(int n) throws IOException, TransportException {
        block3: {
            block2: {
                if (this.protocol != 1) break block2;
                byte[] byArray = null;
                byArray = this.convertIntToByteArray(14);
                this.sock.write(byArray, byArray.length);
                byArray = null;
                byArray = this.convertIntToByteArray(n);
                this.sock.write(byArray, byArray.length);
                break block3;
            }
            if (this.protocol != 2) break block3;
            this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
            this.props = new Properties();
            ((Hashtable)this.props).put("request", "44");
            ((Hashtable)this.props).put("port", String.valueOf(n));
            this.msg = new ServletCommunication(this.url);
            try {
                this.msg.sendPostMessage(this.props);
            }
            catch (Exception exception) {}
        }
    }

    public void run() {
        try {
            this.receive();
        }
        catch (Exception exception) {}
    }

    public synchronized void saveFile(String string, byte[] byArray) throws TransportException, IOException {
        block3: {
            block2: {
                if (this.protocol != 1) break block2;
                byte[] byArray2 = null;
                byArray2 = this.convertIntToByteArray(5);
                this.sock.write(byArray2, byArray2.length);
                byArray2 = string.getBytes();
                this.sock.write(byArray2, byArray2.length);
                int n = byArray.length;
                this.sock.write(byArray, n);
                break block3;
            }
            if (this.protocol != 2) break block3;
            this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
            this.props = new Properties();
            ((Hashtable)this.props).put("request", "35");
            File file = new File("HTTPUsers" + File.separator + string);
            string = file.getAbsolutePath();
            ((Hashtable)this.props).put("filename", string);
            ((Hashtable)this.props).put("length", String.valueOf(this.len));
            ((Hashtable)this.props).put("data", new String(byArray));
            this.msg = new ServletCommunication(this.url);
            try {
                this.msg.sendPostMessage(this.props);
            }
            catch (Exception exception) {}
        }
    }

    synchronized void send(String string, int n, byte[] byArray) throws IOException, TransportException {
        if (this.protocol == 1) {
            Vector<byte[]> vector = new Vector<byte[]>();
            byte[] byArray2 = string.getBytes();
            vector.addElement(this.convertIntToByteArray(2));
            vector.addElement(this.convertIntToByteArray(byArray2.length));
            vector.addElement(byArray2);
            vector.addElement(this.convertIntToByteArray(n));
            vector.addElement(byArray);
            byte[] byArray3 = this.getData(vector);
            this.sock.write(byArray3, byArray3.length);
        } else if (this.protocol == 2) {
            this.url = new URL(this.app.getCodeBase(), "../servlet/com.adventnet.servlets.HttpSnmpGWServlet");
            this.props = new Properties();
            ((Hashtable)this.props).put("request", "32");
            ((Hashtable)this.props).put("hostname", string);
            ((Hashtable)this.props).put("port", String.valueOf(n));
            ((Hashtable)this.props).put("length", String.valueOf(byArray.length));
            ((Hashtable)this.props).put("data", new String(byArray));
            this.msg = new ServletCommunication(this.url);
            this.msg.sendPostMessage(this.props);
        }
    }

    public static void setFileReadWrite(boolean bl) {
        fileWrite = bl;
    }

    public void setTimeout(int n) {
        this.timeOut = n;
    }

    void setTransportProvider(String string) throws Exception {
        if (string == null) {
            this.provider = new TcpClientTransportImpl();
            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Setting transport provider to default."));
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                this.provider = (TransportProvider)clazz.newInstance();
                SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Setting SAS transport provider to: ")) + " " + string);
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid SAS transport provider: ")) + " " + exception.getMessage());
                this.provider = new TcpClientTransportImpl();
                System.out.println(SnmpUtils.getString("Setting transport provider to default."));
            }
        }
    }

    public void start() {
        if (this.sasClientThread == null) {
            this.sasClientThread = new Thread((Runnable)this, "SASClient");
            this.sasClientThread.start();
        }
    }

    public void stop() {
        this.sasClientThread = null;
        this.close();
    }

    public synchronized int updateDB(String string) throws SQLException {
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(this.convertIntToByteArray(21));
        int n = reqID;
        vector.addElement(this.convertIntToByteArray(reqID++));
        vector.addElement(string.getBytes());
        byte[] byArray = this.getData(vector);
        long l = System.currentTimeMillis();
        try {
            int n2 = this.sock.write(byArray, byArray.length);
            if (n2 != 0) {
                throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
            }
        }
        catch (Exception exception) {
            throw new SQLException(SnmpUtils.getString("Unable to write to socket"));
        }
        SASResponseMsg sASResponseMsg = null;
        while ((sASResponseMsg = this.getResponse(n)) == null) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
            if (System.currentTimeMillis() - l > (long)this.timeOut) break;
        }
        if (sASResponseMsg == null) {
            throw new SQLException(SnmpUtils.getString("Timed out"));
        }
        if (sASResponseMsg.state == 100 && sASResponseMsg.expString != null) {
            throw new SQLException(sASResponseMsg.expString);
        }
        return sASResponseMsg.updateResponse;
    }

    public synchronized byte[] userSyncSend(int n, byte[] byArray) {
        if (this.isKnownSASType(n)) {
            System.err.println(SnmpUtils.getString("User should use unknown SAS type as userType (> SAS_VALID_TYPES)"));
            return null;
        }
        this.gotUserResponse = false;
        this.userRcvData = null;
        this.user_req_type = n;
        try {
            byte[] byArray2 = null;
            byArray2 = this.convertIntToByteArray(n);
            this.sock.write(byArray2, byArray2.length);
            int n2 = byArray.length;
            this.sock.write(byArray, n2);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("IO error: ")) + " " + exception);
            return null;
        }
        int n3 = 0;
        while (!this.gotUserResponse) {
            try {
                Thread.sleep(50L);
                if (n3++ <= this.CALL_TIMEOUT * 20) continue;
                System.err.println(SnmpUtils.getString("Client Call Timeout."));
                return null;
            }
            catch (Exception exception) {}
        }
        this.user_req_type = -1;
        return this.userRcvData;
    }
}

