/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ResultSetImpl;
import com.adventnet.utils.SnmpUtils;
import java.sql.ResultSet;
import java.util.Vector;

class SASResponseMsg {
    static final int SAS_DB_CONNECT = 18;
    static final int SAS_DB_CLOSE = 19;
    static final int SAS_DB_QUERY = 20;
    static final int SAS_DB_UPDATE = 21;
    static final int SAS_DB_FAILURE = 100;
    static final int SAS_DB_SUCCESS = 101;
    int tag = 0;
    int ID = -1;
    int state = 0;
    String expString = null;
    ResultSet resultSet = null;
    int updateResponse = 0;
    int index = 0;

    SASResponseMsg(byte[] byArray) throws Exception {
        this.tag = this.getInt(byArray);
        if (!this.isValidTag(this.tag)) {
            throw new Exception(String.valueOf(SnmpUtils.getString("Invalid Tag: ")) + " " + this.tag);
        }
        this.ID = this.getInt(byArray);
        if (this.tag == 18) {
            this.decodeConnect(byArray);
        } else if (this.tag == 19) {
            this.decodeClose(byArray);
        } else if (this.tag == 20) {
            this.decodeQuery(byArray);
        } else if (this.tag == 21) {
            this.decodeUpdate(byArray);
        }
    }

    void decodeClose(byte[] byArray) {
        this.state = this.getInt(byArray);
        if (this.state == 100) {
            this.expString = new String(this.getPart(byArray, byArray.length - this.index));
        }
    }

    void decodeConnect(byte[] byArray) throws Exception {
        this.state = this.getInt(byArray);
        if (this.state == 100) {
            this.expString = new String(this.getPart(byArray, byArray.length - this.index));
        }
    }

    void decodeQuery(byte[] byArray) {
        this.state = this.getInt(byArray);
        if (this.state == 100) {
            this.expString = new String(this.getPart(byArray, byArray.length - this.index));
            return;
        }
        this.decodeQueryResponse(byArray);
    }

    void decodeQueryResponse(byte[] byArray) {
        try {
            int n = this.getInt(byArray);
            int n2 = this.getInt(byArray);
            String[][] stringArray = null;
            if (n <= 0 || n2 <= 0) {
                this.resultSet = new ResultSetImpl(null, null);
                return;
            }
            String[] stringArray2 = this.getRow(byArray);
            stringArray = new String[n][n2];
            int n3 = 0;
            while (n3 < n) {
                stringArray[n3] = this.getRow(byArray);
                ++n3;
            }
            this.resultSet = new ResultSetImpl(stringArray2, stringArray);
        }
        catch (Exception exception) {}
    }

    void decodeUpdate(byte[] byArray) {
        this.state = this.getInt(byArray);
        if (this.state == 100) {
            this.expString = new String(this.getPart(byArray, byArray.length - this.index));
            return;
        }
        this.updateResponse = this.getInt(byArray);
    }

    int getInt(byte[] byArray) {
        int n = 0;
        int n2 = this.index + 4;
        while (this.index < n2) {
            n <<= 8;
            n |= byArray[this.index] & 0xFF;
            ++this.index;
        }
        return n;
    }

    byte[] getPart(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, this.index, byArray2, 0, n);
        this.index += n;
        return byArray2;
    }

    String[] getRow(byte[] byArray) {
        String[] stringArray;
        int n;
        int n2 = this.getInt(byArray);
        int n3 = this.index + n2;
        Vector<Object> vector = new Vector<Object>();
        while (this.index < n3) {
            n = this.getInt(byArray);
            if (n > 0) {
                vector.addElement(new String(this.getPart(byArray, n)));
                continue;
            }
            stringArray = null;
            vector.addElement(stringArray);
        }
        n = vector.size();
        if (n == 0) {
            return null;
        }
        stringArray = new String[n];
        int n4 = 0;
        while (n4 < n) {
            stringArray[n4] = (String)vector.elementAt(n4);
            ++n4;
        }
        return stringArray;
    }

    boolean isValidTag(int n) {
        if (n == 18) {
            return true;
        }
        if (n == 19) {
            return true;
        }
        if (n == 20) {
            return true;
        }
        return n == 21;
    }
}

