/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ResultSetImpl;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpGroup;
import com.adventnet.snmp.snmp2.SnmpProperties;
import com.adventnet.snmp.snmp2.SnmpSession;
import com.adventnet.utils.DatabaseOperations;
import com.adventnet.utils.LogManager;
import com.adventnet.utils.SnmpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SnmpAPI
extends Thread
implements Serializable,
DatabaseOperations {
    Vector sessionList = new Vector();
    static boolean DEBUG = false;
    boolean threadStop = false;
    int reqID = -1;
    int MONITOR_SLEEP = 500;
    static Statement stmt = null;
    Connection connection = null;
    static SASClient sasclient = null;
    boolean v3dBaseFlag = false;
    static int prevId = 0;
    public static String ENCODING = "ISO8859_1";
    public int SNMP_PORT = 161;
    public int SNMP_TRAP_PORT = 162;
    public static final int SNMP_VERSION_1 = 0;
    public static final byte GET_REQ_MSG = -96;
    public static final byte GETNEXT_REQ_MSG = -95;
    public static final byte GET_RSP_MSG = -94;
    public static final byte SET_REQ_MSG = -93;
    public static final byte TRP_REQ_MSG = -92;
    public static final byte SNMP_ERR_NOERROR = 0;
    public static final byte SNMP_ERR_TOOBIG = 1;
    public static final byte SNMP_ERR_NOSUCHNAME = 2;
    public static final byte SNMP_ERR_BADVALUE = 3;
    public static final byte SNMP_ERR_READONLY = 4;
    public static final byte SNMP_ERR_GENERR = 5;
    public static final byte INTEGER = 2;
    public static final byte STRING = 4;
    public static final byte OBJID = 6;
    public static final byte NULLOBJ = 5;
    public static final byte IPADDRESS = 64;
    public static final byte NETWORKADDRESS = 64;
    public static final byte COUNTER = 65;
    public static final byte GAUGE = 66;
    public static final byte UNSIGNED32 = 66;
    public static final byte TIMETICKS = 67;
    public static final byte OPAQUE = 68;
    public static final byte UINTEGER32 = 71;
    static int SID_MAX_LEN = 64;
    static int MAX_NAME_LEN = 64;
    public static final int RONLY = 43690;
    public static final int WONLY = 43691;
    public static final int RWRITE = 43706;
    public static final int NOACCESS = 0;
    public static String Standard_Prefix = ".1.3.6.1.2.1.";
    static Hashtable snmpGroupTable = new Hashtable();
    public static final int FATAL = 1;
    public static final int CRITICAL = 2;
    public static final int NON_CRITICAL = 3;
    static final int METHOD_TRACE = 7;
    static final int MESSAGE_TRACE = 8;
    static boolean setupStdOutErrDone = false;
    public static int debugLevel = 1;

    public SnmpAPI() {
    }

    public SnmpAPI(boolean bl) {
        this();
        DEBUG = bl;
    }

    void addElement(Object object, SnmpGroup snmpGroup) {
        snmpGroupTable.put(object, snmpGroup);
    }

    public Vector checkResponses() {
        Vector<SnmpSession> vector = new Vector<SnmpSession>();
        Enumeration enumeration = this.sessionList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSession snmpSession = (SnmpSession)enumeration.nextElement();
            int[] nArray = snmpSession.checkResponses();
            if (nArray == null || nArray.length <= 0) continue;
            vector.addElement(snmpSession);
        }
        return vector;
    }

    public Vector checkTimeouts() {
        Vector<SnmpSession> vector = new Vector<SnmpSession>();
        Enumeration enumeration = this.sessionList.elements();
        while (enumeration.hasMoreElements()) {
            SnmpSession snmpSession = (SnmpSession)enumeration.nextElement();
            if (snmpSession.timeouts.size() <= 0) continue;
            vector.addElement(snmpSession);
        }
        return vector;
    }

    public void close() {
        while (this.sessionList.size() != 0) {
            ((SnmpSession)this.sessionList.elementAt(0)).close();
        }
        if (sasclient != null) {
            try {
                sasclient.stop();
                sasclient = null;
            }
            catch (Exception exception) {}
        } else if (this.v3dBaseFlag && this.connection != null) {
            try {
                stmt.close();
                this.connection.close();
                stmt = null;
                this.connection = null;
            }
            catch (Exception exception) {}
        }
        this.threadStop = true;
    }

    public synchronized void closeDB() throws SQLException {
        if (sasclient != null) {
            sasclient.closeDB();
        } else if (stmt != null) {
            stmt.close();
            this.connection.close();
            stmt = null;
            this.connection = null;
        } else {
            throw new SQLException(SnmpUtils.getString("Database not connected"));
        }
    }

    public static boolean compare(int[] nArray, int[] nArray2) {
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        int n2 = nArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (nArray[n3] == nArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public synchronized void connectDB(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        if (sasclient != null) {
            sasclient.connectDB(string, string2, string3, string4);
        } else {
            Class.forName(string);
            this.connection = DriverManager.getConnection(string2, string3, string4);
            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Connection has been established"));
            stmt = this.connection.createStatement();
        }
    }

    public static void debugPrintHigh(Object object) {
        if (DEBUG && (debugLevel >= 1 && debugLevel <= 3 || debugLevel == 7 || debugLevel == 8)) {
            if (LogManager.getLogClients() != null) {
                LogManager.logMessage((String)object);
            } else {
                System.out.println(object);
            }
            System.out.flush();
        }
    }

    public static void debugPrintLow(Object object) {
        if (DEBUG && (debugLevel == 3 || debugLevel == 7 || debugLevel == 8)) {
            if (LogManager.getLogClients() != null) {
                LogManager.logMessage((String)object);
            } else {
                System.out.println(object);
            }
            System.out.flush();
        }
    }

    public static void debugPrintMedium(Object object) {
        if (DEBUG && (debugLevel == 2 || debugLevel == 3 || debugLevel == 7 || debugLevel == 8)) {
            if (LogManager.getLogClients() != null) {
                LogManager.logMessage((String)object);
            } else {
                System.err.println(object);
            }
            System.err.flush();
        }
    }

    public int genReqID() {
        this.reqID = ++prevId;
        this.reqID &= Integer.MAX_VALUE;
        if (this.reqID > 0x3FFFFFFF) {
            this.reqID -= 0x3FFFFFFF;
        }
        return this.reqID;
    }

    public String getCharacterEncoding() {
        return ENCODING;
    }

    public boolean getDebug() {
        return DEBUG;
    }

    Object getGroupKey(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append("##");
        stringBuffer.append(new Integer(n).toString());
        return stringBuffer.toString();
    }

    public static int getMajorVersion() {
        return SnmpProperties.getMajorVersion();
    }

    public static int getMinorVersion() {
        return SnmpProperties.getMinorVersion();
    }

    public static int getPatchVersion() {
        return SnmpProperties.getPatchVersion();
    }

    static String getReleaseDate() {
        return SnmpProperties.getReleaseDate();
    }

    public static SASClient getSASClient() {
        return sasclient;
    }

    public Vector getSessionList() {
        return this.sessionList;
    }

    public SnmpGroup getSnmpGroup(String string, int n) {
        Object object = this.getGroupKey(string, n);
        SnmpGroup snmpGroup = (SnmpGroup)snmpGroupTable.get(object);
        return snmpGroup;
    }

    public static Statement getStatement() {
        return stmt;
    }

    public static String getVersionString() {
        return SnmpProperties.getVersionString();
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        this.connectDB(string, string2, string3, string4);
    }

    private static void messageTrace(Object object) {
        if (DEBUG && debugLevel == 8) {
            if (LogManager.getLogClients() != null) {
                LogManager.logMessage((String)object);
            } else {
                System.out.println(object);
            }
            System.out.flush();
        }
    }

    private static void methodTrace(Object object) {
        if (DEBUG && (debugLevel == 7 || debugLevel == 8)) {
            if (LogManager.getLogClients() != null) {
                LogManager.logMessage((String)object);
            } else {
                System.out.println(object);
            }
            System.out.flush();
        }
    }

    public synchronized ResultSet queryDB(String string) throws SQLException {
        if (sasclient != null) {
            return sasclient.queryDB(string);
        }
        if (stmt != null) {
            ResultSet resultSet = stmt.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = null;
            if (n > 0) {
                stringArray = new String[n];
                int n2 = 0;
                while (n2 < n) {
                    stringArray[n2] = resultSetMetaData.getColumnName(n2 + 1);
                    ++n2;
                }
            }
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            while (resultSet.next()) {
                int n4 = 0;
                while (n4 < n) {
                    vector.addElement(resultSet.getString(n4 + 1));
                    ++n4;
                }
                ++n3;
            }
            resultSet.close();
            String[][] stringArray2 = null;
            if (n3 > 0 && n > 0 && vector.size() == n3 * n) {
                stringArray2 = new String[n3][n];
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = 0;
                    while (n6 < n) {
                        stringArray2[n5][n6] = (String)vector.elementAt(n5 * n + n6);
                        ++n6;
                    }
                    ++n5;
                }
            }
            ResultSetImpl resultSetImpl = new ResultSetImpl(stringArray, stringArray2);
            return resultSetImpl;
        }
        throw new SQLException(SnmpUtils.getString("Database not connected"));
    }

    void removeElement(String string, int n) {
        Object object = this.getGroupKey(string, n);
        if (object != null) {
            snmpGroupTable.remove(object);
        }
    }

    public void run() {
        this.reqID = this.genReqID();
        do {
            Enumeration enumeration = this.sessionList.elements();
            while (enumeration.hasMoreElements()) {
                if (!enumeration.hasMoreElements()) break;
                try {
                    ((SnmpSession)enumeration.nextElement()).monitorRequests();
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            try {
                Thread.sleep(this.MONITOR_SLEEP);
            }
            catch (InterruptedException interruptedException) {}
        } while (!this.threadStop);
    }

    public void setCharacterEncoding(String string) {
        ENCODING = string;
    }

    public void setDebug(boolean bl) {
        DEBUG = bl;
    }

    public static void setDebugLevel(int n) {
        debugLevel = n;
    }

    static void setSASClient(SASClient sASClient) {
        sasclient = sASClient;
    }

    public static void setupStdOutErr() {
        String string = new String("." + File.separator + "logs");
        SnmpAPI.setupStdOutErr(string);
    }

    public static void setupStdOutErr(String string) {
        if (setupStdOutErrDone) {
            return;
        }
        setupStdOutErrDone = true;
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(file, "stdout");
        File file3 = new File(file, "stderr");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            FileOutputStream fileOutputStream2 = new FileOutputStream(file3);
            System.setOut(new PrintStream(fileOutputStream, true));
            System.setErr(new PrintStream(fileOutputStream2, true));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized int updateDB(String string) throws SQLException {
        if (sasclient != null) {
            return sasclient.updateDB(string);
        }
        if (stmt != null) {
            return stmt.executeUpdate(string);
        }
        throw new SQLException(SnmpUtils.getString("Database not connected"));
    }
}

