/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.CallbackArgs;
import com.adventnet.snmp.snmp2.PacketArgs;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpClient;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpSession;
import com.adventnet.snmp.snmp2.TransportPacket;
import com.adventnet.utils.SnmpUtils;
import java.util.Vector;

class SnmpCallback
extends Thread {
    Vector responses = new Vector();
    Vector packets = new Vector(10000);
    boolean closeCallback = false;

    synchronized void close() {
        this.closeCallback = true;
        this.notifyAll();
    }

    synchronized void enQ(SnmpClient snmpClient, SnmpSession snmpSession, SnmpPDU snmpPDU, int n) {
        CallbackArgs callbackArgs = snmpPDU != null ? new CallbackArgs(snmpClient, snmpSession, snmpPDU, n) : new CallbackArgs(snmpClient, snmpSession, null, n);
        this.responses.addElement(callbackArgs);
        this.notifyAll();
    }

    synchronized void enQ(TransportPacket transportPacket, SnmpSession snmpSession, SnmpPDU snmpPDU) {
        PacketArgs packetArgs = new PacketArgs(transportPacket, snmpSession, snmpPDU);
        if (this.packets.size() >= 10000) {
            return;
        }
        this.packets.addElement(packetArgs);
        this.notifyAll();
    }

    synchronized PacketArgs getPDU() {
        try {
            if (this.packets.size() <= 0) {
                return null;
            }
            PacketArgs packetArgs = (PacketArgs)this.packets.firstElement();
            this.packets.removeElementAt(0);
            return packetArgs;
        }
        catch (Exception exception) {
            return null;
        }
    }

    synchronized CallbackArgs getTimeoutPdu() {
        try {
            if (this.responses.size() <= 0) {
                return null;
            }
            CallbackArgs callbackArgs = (CallbackArgs)this.responses.firstElement();
            this.responses.removeElementAt(0);
            return callbackArgs;
        }
        catch (Exception exception) {
            return null;
        }
    }

    void processPacket(TransportPacket transportPacket, SnmpSession snmpSession, SnmpPDU snmpPDU) {
        snmpSession.processPacket(transportPacket, snmpPDU);
    }

    public void run() {
        while (true) {
            CallbackArgs callbackArgs;
            PacketArgs packetArgs;
            if ((packetArgs = this.getPDU()) != null) {
                this.processPacket(packetArgs.packet, packetArgs.session, packetArgs.pdu);
            }
            if ((callbackArgs = this.getTimeoutPdu()) != null && callbackArgs.client != null) {
                callbackArgs.client.callback(callbackArgs.session, null, callbackArgs.reqid);
            }
            if (callbackArgs != null || packetArgs != null) continue;
            if (this.closeCallback) {
                return;
            }
            this.sleepUntilNotified();
        }
    }

    synchronized void sleepUntilNotified() {
        try {
            this.wait();
        }
        catch (Exception exception) {
            SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Caught Exception: ")) + " " + exception.getMessage());
        }
    }
}

