/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.SnmpVar;

public class SnmpInt
extends SnmpVar {
    int value = 0;
    byte[] byteValue;

    public SnmpInt(int n) {
        this.value = n;
        this.Type = (byte)2;
    }

    int encode(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeInt(byArray, n, this.value, 2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SnmpInt) {
            SnmpInt snmpInt = (SnmpInt)object;
            return this.value == snmpInt.intValue();
        }
        return false;
    }

    public Object getVarObject() {
        return this.toValue();
    }

    public int intValue() {
        return this.value;
    }

    public byte[] toBytes() {
        if (this.byteValue == null) {
            this.byteValue = new byte[4];
            int n = this.value;
            int n2 = this.byteValue.length;
            while (n != 0) {
                this.byteValue[--n2] = (byte)(n & 0xFF);
                n >>>= 8;
            }
        }
        return this.byteValue;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public String toTagString() {
        return "INTEGER: " + Integer.toString(this.value);
    }

    public Object toValue() {
        return new Integer(this.value);
    }
}

