/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.utils.SnmpUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpIpAddress
extends SnmpString {
    String ipAddr = null;
    private static final char[] digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    SnmpIpAddress() {
    }

    public SnmpIpAddress(String string) {
        this.Type = (byte)64;
        if (string != null && !string.equals("0.0.0.0")) {
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                this.byteValue = inetAddress.getAddress();
            }
            catch (SecurityException securityException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Security error creating SnmpIpAddress instance.")) + " " + securityException);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Error creating SnmpIpAddress : invalid String arg.")) + " " + unknownHostException);
            }
        } else {
            this.byteValue = new byte[4];
        }
    }

    public SnmpIpAddress(byte[] byArray) {
        this.Type = (byte)64;
        this.byteValue = new byte[4];
        if (byArray != null && byArray.length == 4) {
            System.arraycopy(byArray, 0, this.byteValue, 0, byArray.length);
        } else {
            System.err.println(SnmpUtils.getString("Error creating SnmpIpAddress : invalid byte arg."));
        }
    }

    int encode(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeOctets(byArray, n, this.byteValue, 0, this.byteValue.length, 64);
    }

    public Object getVarObject() {
        return this.toString();
    }

    public static String netbToString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 4];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            n2 = byArray[n3] & 0xFF;
            if (n2 > 99) {
                cArray[n++] = digit[n2 / 100];
                cArray[n++] = digit[(n2 %= 100) / 10];
                n2 %= 10;
            } else if (n2 > 9) {
                cArray[n++] = digit[n2 / 10];
                n2 %= 10;
            }
            cArray[n++] = digit[n2];
            cArray[n++] = 46;
            ++n3;
        }
        return new String(cArray, 0, n - 1);
    }

    static SnmpVar newInstance(byte[] byArray) {
        SnmpIpAddress snmpIpAddress = new SnmpIpAddress();
        snmpIpAddress.Type = (byte)64;
        snmpIpAddress.byteValue = byArray;
        return snmpIpAddress;
    }

    public String toHostName() {
        String string = this.toString();
        try {
            string = InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (SecurityException securityException) {}
        return string;
    }

    public String toString() {
        if (this.ipAddr == null && this.byteValue.length != 0) {
            this.ipAddr = SnmpIpAddress.netbToString(this.byteValue);
        }
        return this.ipAddr;
    }

    public String toTagString() {
        return "IpAddress: " + this.toString();
    }

    public Object toValue() {
        if (this.byteValue.length == 0) {
            return null;
        }
        return super.toString();
    }
}

