/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASN1Parser;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpClient;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpSession;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public class SnmpMessage
implements Serializable {
    int msgVersion = 0;
    String community;
    String writeCommunity;
    String communityEnc = null;
    boolean isDebug = false;
    boolean alwaysEncode = true;
    SnmpPDU pdu;
    ASN1Parser asnParser;

    SnmpMessage() {
        this.asnParser = new ASN1Parser();
        this.pdu = new SnmpPDU(this);
        this.init();
    }

    SnmpMessage(SnmpPDU snmpPDU) {
        this.pdu = snmpPDU;
        this.asnParser = snmpPDU.asnParser;
        this.init();
    }

    public SnmpMessage(byte[] byArray) throws SnmpException {
        this.pdu = new SnmpPDU(this);
        this.pdu.asnParser = this.asnParser = new ASN1Parser(byArray);
        this.decodeMsgVersion();
        switch (this.msgVersion) {
            case 0: {
                this.decodeCommunity();
                break;
            }
            default: {
                SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Parse Error: Wrong SNMP Version: ")) + " " + this.msgVersion + " " + SnmpUtils.getString("Continuing Anyway"));
            }
        }
        this.pdu.decode_hdr();
    }

    int authenticate(SnmpSession snmpSession) {
        switch (this.msgVersion) {
            case 0: {
                boolean bl = false;
                if (this.pdu.command == -93 && snmpSession.writeCommunity != null) {
                    bl = true;
                }
                if (this.pdu.useWriteValidate) {
                    bl = true;
                }
                if (snmpSession.community == null && !bl) {
                    return 0;
                }
                if (snmpSession.clients == null) {
                    return 0;
                }
                Enumeration enumeration = snmpSession.clients.elements();
                while (enumeration.hasMoreElements()) {
                    SnmpClient snmpClient = (SnmpClient)enumeration.nextElement();
                    if (snmpClient.authenticate(this.pdu, bl ? snmpSession.writeCommunity : snmpSession.community)) continue;
                    return -1;
                }
                return 0;
            }
        }
        return -1;
    }

    boolean authenticate(SnmpSession snmpSession, SnmpClient snmpClient) {
        boolean bl = false;
        if (this.pdu.command == -93 && snmpSession.writeCommunity != null) {
            bl = true;
        }
        if (this.pdu.useWriteValidate) {
            bl = true;
        }
        if (snmpSession.community == null && !bl) {
            return true;
        }
        return snmpClient.authenticate(this.pdu, bl ? snmpSession.writeCommunity : snmpSession.community);
    }

    void copy(SnmpMessage snmpMessage) {
        snmpMessage.msgVersion = this.msgVersion;
        snmpMessage.community = this.community;
        snmpMessage.writeCommunity = this.writeCommunity;
        snmpMessage.communityEnc = this.communityEnc;
        snmpMessage.isDebug = this.isDebug;
        snmpMessage.alwaysEncode = this.alwaysEncode;
    }

    private void decodeCommunity() throws SnmpException {
        if (!this.asnParser.isOctetString()) {
            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Parse Version: Incorrect ASN header"));
            throw new SnmpException(SnmpUtils.getString("Parse Version: Incorrect ASN header"));
        }
        try {
            this.community = this.communityEnc == null ? new String(this.asnParser.decodeOctetString(), 0) : new String(this.asnParser.decodeOctetString(), this.communityEnc);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.community = new String(this.asnParser.decodeOctetString());
        }
    }

    private void decodeMsgVersion() throws SnmpException {
        try {
            if (!this.asnParser.isMessageSequence()) {
                SnmpAPI.debugPrintHigh(SnmpUtils.getString("Parse Auth: Incorrect ASN header"));
                throw new SnmpException(SnmpUtils.getString("Parse Auth: Incorrect ASN header"));
            }
            this.asnParser.decodeLength();
            if (!this.asnParser.isInteger()) {
                SnmpAPI.debugPrintHigh(SnmpUtils.getString("Parse Auth: Incorrect ASN header"));
                throw new SnmpException(SnmpUtils.getString("Parse Version: Incorrect ASN header"));
            }
            this.msgVersion = this.asnParser.decodeInteger();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Parse Error: unrecognized SNMP message"));
            throw new SnmpException(SnmpUtils.getString("Parse Error: unrecognized SNMP message"));
        }
    }

    boolean encode(SnmpSession snmpSession) {
        switch (this.msgVersion) {
            case 0: {
                this.encodeCommunity();
                break;
            }
            default: {
                SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Parse Error: Wrong SNMP Version: ")) + " " + this.msgVersion + " " + SnmpUtils.getString("Continuing Anyway"));
            }
        }
        this.encodeMsgVersion();
        return true;
    }

    void encodeCommunity() {
        if (this.pdu.getCommand() == -93 && this.writeCommunity != null) {
            this.asnParser.encodeString(this.writeCommunity);
        } else {
            this.asnParser.encodeString(this.community);
        }
    }

    void encodeMsgVersion() {
        this.asnParser.encodeInt(this.msgVersion);
        this.asnParser.encodeSequence();
        this.asnParser.prepareToSend();
    }

    String getCommunity() {
        return this.community;
    }

    String getCommunityEncoding() {
        return this.communityEnc;
    }

    int getMsgVersion() {
        return this.msgVersion;
    }

    public SnmpPDU getPDU() {
        return this.pdu;
    }

    String getWriteCommunity() {
        return this.writeCommunity;
    }

    void init() {
    }

    private boolean isReportable() {
        return this.pdu.command != -92 && this.pdu.command != -94;
    }

    public void print() {
        System.out.println(String.valueOf(SnmpUtils.getString("Message Version")) + " = " + this.msgVersion);
        SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Message Version")) + " = " + this.msgVersion);
        switch (this.msgVersion) {
            case 0: {
                System.out.println(String.valueOf(SnmpUtils.getString("Community")) + " = " + this.community);
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Community")) + " = " + this.community);
                break;
            }
            default: {
                SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Parse Error: Wrong SNMP Version: ")) + " " + this.msgVersion + " " + SnmpUtils.getString("Continuing Anyway"));
            }
        }
    }

    void setCommunity(String string) {
        this.community = string;
    }

    void setCommunityEncoding(String string) {
        this.communityEnc = string;
    }

    void setDebug(boolean bl) {
        this.isDebug = bl;
    }

    public void setMsgVersion(int n) {
        this.msgVersion = n;
    }

    void setReEncode(boolean bl) {
        this.alwaysEncode = bl;
    }

    void setWriteCommunity(String string) {
        this.writeCommunity = string;
    }
}

