/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.utils.SnmpUtils;

public class SnmpOID
extends SnmpVar {
    int[] value = null;
    byte[] byteValue;
    private static int[] zeroDotZero = new int[2];
    private static final char[] radixTenTenths = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] radixTenUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    SnmpOID() {
        this.Type = (byte)6;
    }

    public SnmpOID(String string) {
        this.Type = (byte)6;
        if (string == null) {
            return;
        }
        this.setOID(string);
    }

    public SnmpOID(int[] nArray) {
        this.Type = (byte)6;
        this.value = new int[nArray.length];
        System.arraycopy(nArray, 0, this.value, 0, nArray.length);
    }

    long[] convertIntArrayToLongArray(int[] nArray) {
        long[] lArray = new long[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            lArray[n] = (long)nArray[n] & 0xFFFFFFFFL;
            ++n;
        }
        return lArray;
    }

    int encode(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        int[] nArray = this.value == null ? zeroDotZero : this.value;
        return ASNTypes.encodeOid(byArray, n, nArray, nArray.length, 6);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof SnmpOID && SnmpAPI.compare(this.value, ((SnmpOID)object).value);
    }

    private int getCharacterCount() {
        int n = 0;
        int n2 = this.value.length;
        int n3 = 48;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.value[n4];
            do {
                int n6 = n5 % 100;
                n += 2;
                n3 = radixTenTenths[n6];
            } while ((n5 /= 100) != 0);
            if (n3 == 48) {
                --n;
            }
            ++n4;
        }
        return n;
    }

    public Object getVarObject() {
        return this.toString();
    }

    public int hashCode() {
        int n = this.getCharacterCount();
        char[] cArray = this.toCharArray(n);
        int n2 = 0;
        int n3 = 1;
        int n4 = n + this.value.length;
        int n5 = 0;
        while (n5 < n4) {
            n2 = 31 * n2 + cArray[n3++];
            ++n5;
        }
        return n2;
    }

    static SnmpOID newInstance(int[] nArray) {
        SnmpOID snmpOID = new SnmpOID();
        snmpOID.Type = (byte)6;
        snmpOID.value = nArray;
        return snmpOID;
    }

    private void setOID(String string) {
        try {
            if (string.charAt(0) != '.') {
                string = String.valueOf(SnmpAPI.Standard_Prefix) + string;
            }
            char[] cArray = string.toCharArray();
            int n = 0;
            int n2 = cArray.length;
            if (cArray[n] == '.') {
                ++n;
            }
            if (cArray[n2 - 1] == '.') {
                --n2;
            }
            int n3 = 1;
            int n4 = n;
            while (n4 < n2) {
                if (cArray[n4] == '.') {
                    ++n3;
                }
                ++n4;
            }
            this.value = new int[n3];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = n;
            while (n8 < n2) {
                if (cArray[n8] == '.') {
                    this.value[n5++] = (int)((long)n6 & 0xFFFFFFFFL);
                    n6 = 0;
                } else {
                    n7 = Character.digit(cArray[n8], 10);
                    if (n7 >= 0) {
                        n6 = n6 * 10 + n7;
                    } else {
                        throw new Exception();
                    }
                }
                ++n8;
            }
            this.value[n5] = (int)((long)n6 & 0xFFFFFFFFL);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Invalid OID format: ")) + " " + string);
            this.value = null;
        }
    }

    public byte[] toBytes() {
        if (this.byteValue == null) {
            int n = this.value.length;
            this.byteValue = new byte[4 * n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.value[n2];
                int n4 = (n2 + 1) * 4;
                while (n3 != 0) {
                    this.byteValue[--n4] = (byte)(n3 & 0xFF);
                    n3 >>>= 8;
                }
                ++n2;
            }
        }
        return this.byteValue;
    }

    private char[] toCharArray(int n) {
        char[] cArray = new char[n + 1 + this.value.length];
        int n2 = n + 1 + this.value.length;
        int n3 = 0;
        int n4 = this.value.length;
        int n5 = n4 - 1;
        while (n5 >= 0) {
            n3 = this.value[n5];
            do {
                int n6 = n3 % 100;
                cArray[--n2] = radixTenUnits[n6];
                cArray[--n2] = radixTenTenths[n6];
            } while ((n3 /= 100) != 0);
            if (cArray[n2] == '0') {
                ++n2;
            }
            cArray[--n2] = 46;
            --n5;
        }
        return cArray;
    }

    public int[] toIntArray() {
        int[] nArray = new int[this.value.length];
        System.arraycopy(this.value, 0, nArray, 0, this.value.length);
        return nArray;
    }

    public long[] toLongArray() {
        return this.convertIntArrayToLongArray(this.value);
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            long l = (long)this.value[n2] & Integer.MAX_VALUE;
            if (this.value[n2] < 0) {
                l += 0x80000000L;
            }
            stringBuffer.append("." + Long.toString(l));
            ++n2;
        }
        return stringBuffer.toString().intern();
    }

    public String toTagString() {
        return new String("Object ID: " + this.toString());
    }

    public Object toValue() {
        if (this.value == null) {
            return null;
        }
        return this.toIntArray();
    }
}

