/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASN1Parser;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpClient;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpIpAddress;
import com.adventnet.snmp.snmp2.SnmpMessage;
import com.adventnet.snmp.snmp2.SnmpNull;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpSession;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.snmp.snmp2.TransportAddress;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpPDU
implements Serializable {
    SnmpMessage msg;
    ASN1Parser asnParser;
    InetAddress address;
    boolean lookup = true;
    private String agentAddr = null;
    TransportAddress transportAddress = null;
    ProtocolOptions protocolOptions = null;
    String remoteHost;
    int remotePort = 0;
    byte command;
    int reqid = 0;
    int errstat = 0;
    int errindex = 0;
    SnmpOID enterprise = null;
    InetAddress agent_addr;
    int trap_type = 0;
    int specific_type = 0;
    long time = 0L;
    Vector variables;
    boolean useWriteValidate = false;
    int timeout = 0;
    int retries = 0;
    boolean isDebug = false;
    SnmpClient callBackClient = null;
    long time_sent;
    long time_expires;
    long time_received;
    String encodeError = "";
    int clientID = 0;

    public SnmpPDU() {
        this.asnParser = new ASN1Parser();
        this.msg = new SnmpMessage(this);
        this.variables = new Vector();
    }

    SnmpPDU(SnmpClient snmpClient) {
        this();
        this.callBackClient = snmpClient;
    }

    SnmpPDU(SnmpMessage snmpMessage) {
        this.variables = new Vector();
        this.msg = snmpMessage;
        this.asnParser = this.msg.asnParser;
    }

    public void addNull(SnmpOID snmpOID) {
        if (snmpOID == null) {
            return;
        }
        SnmpVarBind snmpVarBind = new SnmpVarBind();
        snmpVarBind.oid = snmpOID;
        snmpVarBind.variable = new SnmpNull();
        this.variables.addElement(snmpVarBind);
    }

    void addTrapAddressVarBind() {
        try {
            SnmpOID snmpOID = new SnmpOID(".1.3.6.1.6.3.18.1.3.0");
            SnmpVar snmpVar = SnmpVar.createVariable(this.agent_addr.getHostAddress(), (byte)64);
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpOID, snmpVar);
            this.variables.addElement(snmpVarBind);
        }
        catch (SnmpException snmpException) {}
    }

    public void addVariableBinding(int n, SnmpVarBind snmpVarBind) {
        if (snmpVarBind == null || snmpVarBind.oid == null || n < 0 || n > this.variables.size()) {
            return;
        }
        this.variables.insertElementAt(snmpVarBind, n);
    }

    public void addVariableBinding(SnmpVarBind snmpVarBind) {
        if (snmpVarBind == null || snmpVarBind.oid == null) {
            return;
        }
        this.variables.addElement(snmpVarBind);
    }

    boolean checkTrapAddress(boolean bl) {
        int n = this.variables.size();
        SnmpVarBind snmpVarBind = null;
        SnmpOID snmpOID = null;
        int n2 = 0;
        while (n2 < n) {
            snmpVarBind = (SnmpVarBind)this.variables.elementAt(n2);
            snmpOID = snmpVarBind.getObjectID();
            if (snmpOID.toString().equals(".1.3.6.1.6.3.18.1.3.0")) {
                try {
                    if (bl) {
                        this.agent_addr = InetAddress.getByName(snmpVarBind.getVariable().toString());
                    }
                }
                catch (Exception exception) {}
                return false;
            }
            ++n2;
        }
        return true;
    }

    public SnmpPDU copy() {
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.remoteHost = this.remoteHost;
        snmpPDU.remotePort = this.remotePort;
        snmpPDU.time_sent = this.time_sent;
        snmpPDU.time_expires = this.time_expires;
        snmpPDU.time_received = this.time_received;
        snmpPDU.timeout = this.timeout;
        snmpPDU.retries = this.retries;
        snmpPDU.address = this.address;
        snmpPDU.transportAddress = this.transportAddress;
        snmpPDU.agent_addr = this.agent_addr;
        this.msg.copy(snmpPDU.msg);
        if (this.asnParser.data != null) {
            snmpPDU.asnParser.data = new byte[this.asnParser.data.length];
            System.arraycopy(this.asnParser.data, 0, snmpPDU.asnParser.data, 0, this.asnParser.data.length);
        }
        snmpPDU.command = this.command;
        snmpPDU.reqid = this.reqid;
        snmpPDU.errstat = this.errstat;
        snmpPDU.errindex = this.errindex;
        snmpPDU.enterprise = this.enterprise;
        snmpPDU.trap_type = this.trap_type;
        snmpPDU.specific_type = this.specific_type;
        snmpPDU.time = this.time;
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.getObjectID(), snmpVarBind.getVariable());
            snmpPDU.addVariableBinding(snmpVarBind2);
        }
        return snmpPDU;
    }

    public boolean decode() throws SnmpException {
        try {
            if (this.command != -92) {
                if (!this.asnParser.isInteger()) {
                    return this.error(SnmpUtils.getString("Parse Error: Decoding errstat."));
                }
                this.errstat = this.asnParser.decodeInteger();
                if (!this.asnParser.isInteger()) {
                    return this.error(SnmpUtils.getString("Parse Error: Decoding errindex."));
                }
                this.errindex = this.asnParser.decodeInteger();
            } else {
                if (!this.asnParser.isOID()) {
                    return this.error(SnmpUtils.getString("Parse Error: Decoding enterprise."));
                }
                this.enterprise = SnmpOID.newInstance(this.asnParser.decodeOID());
                if (!this.asnParser.isIPAddress()) {
                    return this.error(SnmpUtils.getString("Parse Error: Decoding agent_address."));
                }
                byte[] byArray = this.asnParser.decodeOctetString();
                this.agentAddr = SnmpIpAddress.netbToString(byArray);
                if (!this.asnParser.isInteger()) {
                    return this.error(SnmpUtils.getString("Parse Error: Decoding trap_type."));
                }
                this.trap_type = this.asnParser.decodeInteger();
                if (!this.asnParser.isInteger()) {
                    return this.error(SnmpUtils.getString("Parse Error: Decoding specific_type."));
                }
                this.specific_type = this.asnParser.decodeInteger();
                if (!this.asnParser.isTimeTicks()) {
                    return this.error(SnmpUtils.getString("Parse Error: Decoding uptime."));
                }
                this.time = (long)this.asnParser.decodeInteger() & 0xFFFFFFFFL;
            }
            if (!this.asnParser.isMessageSequence()) {
                SnmpAPI.debugPrintMedium(SnmpUtils.getString("Incorrect VarBindList"));
                throw new SnmpException(SnmpUtils.getString("Parse Auth: Incorrect VarBindList"));
            }
            this.asnParser.decodeVarBindList(this.variables);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SnmpAPI.debugPrintMedium(SnmpUtils.getString("Parse Error: unrecognized SNMP message"));
            throw new SnmpException(SnmpUtils.getString("Parse Error: unrecognized SNMP message"));
        }
        return true;
    }

    void decode_hdr() throws SnmpException {
        try {
            this.command = this.asnParser.getTag();
            this.asnParser.decodeLength();
            if (this.command != -92) {
                if (!this.asnParser.isInteger()) {
                    SnmpAPI.debugPrintHigh(SnmpUtils.getString("Parse Error: Decoding reqid."));
                    throw new SnmpException(SnmpUtils.getString("Parse Error: Decoding reqid."));
                }
                this.reqid = this.asnParser.decodeInteger();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Parse Error: unrecognized SNMP message"));
            throw new SnmpException(SnmpUtils.getString("Parse Error: unrecognized SNMP message"));
        }
    }

    boolean encode(SnmpSession snmpSession) {
        boolean bl = true;
        do {
            try {
                this.asnParser.init();
                this.asnParser.encodeVarBindList(this.variables);
                this.asnParser.encodeSequence();
                if (this.command != -92) {
                    this.asnParser.encodeInt(this.errindex);
                    this.asnParser.encodeInt(this.errstat);
                    this.asnParser.encodeInt(this.reqid);
                } else {
                    this.asnParser.encodeUInt((int)this.time);
                    this.asnParser.encodeInt(this.specific_type);
                    this.asnParser.encodeInt(this.trap_type);
                    SnmpIpAddress snmpIpAddress = null;
                    snmpIpAddress = this.agent_addr != null ? new SnmpIpAddress(this.agent_addr.getAddress()) : new SnmpIpAddress("0.0.0.0");
                    this.asnParser.encodeIPAddress(snmpIpAddress);
                    this.asnParser.encodeEnterprise(this.enterprise);
                }
                this.asnParser.encodeCommand(this.command);
                this.msg.encode(snmpSession);
                bl = false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (this.asnParser.createSpace()) continue;
                return false;
            }
            catch (NullPointerException nullPointerException) {
                return this.error(((Throwable)nullPointerException).getMessage());
            }
        } while (bl);
        return true;
    }

    private boolean error(String string) {
        SnmpAPI.debugPrintMedium(string);
        return false;
    }

    public void fix() {
        if (this.errindex > 0) {
            this.variables.removeElementAt(this.errindex - 1);
        }
    }

    public InetAddress getAddress() {
        if (this.transportAddress == null) {
            return null;
        }
        try {
            InetAddress inetAddress = (InetAddress)this.transportAddress.getProtocolAddress();
            return inetAddress;
        }
        catch (ClassCastException classCastException) {
            SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("ClassCastException while retriving address ")) + " " + classCastException);
            return null;
        }
    }

    public String getAgentAddr() {
        if (this.agentAddr == null && this.agent_addr != null) {
            this.agentAddr = SnmpIpAddress.netbToString(this.agent_addr.getAddress());
        }
        return this.agentAddr;
    }

    public InetAddress getAgentAddress() {
        block3: {
            if (this.agentAddr == null) break block3;
            try {
                this.agent_addr = InetAddress.getByName(this.agentAddr);
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {}
        }
        return this.agent_addr;
    }

    public int getClientID() {
        return this.clientID;
    }

    public byte getCommand() {
        return this.command;
    }

    public String getCommunity() {
        return this.msg.community;
    }

    public byte[] getData() {
        return this.asnParser.data;
    }

    String getEncodeError() {
        return this.encodeError;
    }

    public int getEncodedLength(SnmpSession snmpSession) {
        this.encode(snmpSession);
        if (this.asnParser.data != null) {
            return this.asnParser.data.length;
        }
        return -1;
    }

    public SnmpOID getEnterprise() {
        return this.enterprise;
    }

    public int getErrindex() {
        return this.errindex;
    }

    public String getError() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.errstat != 0) {
            stringBuffer.append(String.valueOf(SnmpUtils.getString("Error in response")) + ". ");
            stringBuffer.append(SnmpException.exceptionString((byte)this.errstat).toString());
            stringBuffer.append("\n" + SnmpUtils.getString("Index:") + " " + this.errindex + "\n");
            if (this.errindex > 0) {
                stringBuffer.append(String.valueOf(SnmpUtils.getString("Errored Object ID:")) + " " + this.getObjectID(this.errindex - 1) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public int getErrstat() {
        return this.errstat;
    }

    public int getMaxRepetitions() {
        return this.getErrindex();
    }

    public SnmpMessage getMsg() {
        return this.msg;
    }

    public int getNonRepeaters() {
        return this.getErrstat();
    }

    public SnmpOID getObjectID(int n) {
        if (n < 0 || n >= this.variables.size()) {
            return null;
        }
        return ((SnmpVarBind)this.variables.elementAt((int)n)).oid;
    }

    public ProtocolOptions getProtocolOptions() {
        return this.protocolOptions;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getReqid() {
        return this.reqid;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getRoundTripDelay() {
        if (this.time_sent > 0L && this.time_received > 0L) {
            return this.time_received - this.time_sent;
        }
        return -1L;
    }

    public int getSpecificType() {
        return this.specific_type;
    }

    public int getTimeout() {
        return this.timeout;
    }

    TransportAddress getTransportAddress() {
        return this.transportAddress;
    }

    public int getTrapType() {
        return this.trap_type;
    }

    public long getUpTime() {
        return this.time;
    }

    public SnmpVar getVariable(int n) {
        if (n < 0 || n >= this.variables.size()) {
            return null;
        }
        return ((SnmpVarBind)this.variables.elementAt((int)n)).variable;
    }

    public SnmpVarBind getVariableBinding(int n) {
        if (n < 0 || n >= this.variables.size()) {
            return null;
        }
        return (SnmpVarBind)this.variables.elementAt(n);
    }

    public Vector getVariableBindings() {
        return this.variables;
    }

    public int getVersion() {
        return this.msg.msgVersion;
    }

    public String getWriteCommunity() {
        return this.msg.writeCommunity;
    }

    public String printVarBinds() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.variables.elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            stringBuffer.append(snmpVarBind.toTagString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void removeVariableBinding(int n) {
        if (n < 0 || n >= this.variables.size()) {
            return;
        }
        this.variables.removeElementAt(n);
    }

    public void removeVariableBinding(SnmpVarBind snmpVarBind) {
        if (snmpVarBind == null || snmpVarBind.oid == null) {
            return;
        }
        this.variables.removeElement(snmpVarBind);
    }

    public void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
        if (inetAddress == null) {
            this.transportAddress = null;
            return;
        }
        if (this.lookup) {
            this.remoteHost = inetAddress.getHostName();
        }
        try {
            this.transportAddress = TransportAddress.getByName(1, inetAddress.getHostAddress());
        }
        catch (Exception exception) {
            SnmpAPI.debugPrintMedium(SnmpUtils.getString("Couldn't mask into transportAddress"));
        }
    }

    public void setAgentAddress(InetAddress inetAddress) {
        this.agent_addr = inetAddress;
    }

    public void setClientID(int n) {
        this.clientID = n;
    }

    public void setCommand(byte by) {
        this.command = by;
    }

    public void setCommunity(String string) {
        this.msg.community = string;
    }

    public void setCommunityEncoding(String string) {
        this.msg.communityEnc = string;
    }

    public void setDNSLookup(boolean bl) {
        this.lookup = bl;
    }

    public void setData(byte[] byArray) {
        this.asnParser.data = byArray;
    }

    void setDebug(boolean bl) {
        this.isDebug = bl;
        this.msg.setDebug(bl);
        this.asnParser.setDebug(bl);
    }

    void setEncodeError(String string) {
        this.encodeError = string;
    }

    public void setEnterprise(SnmpOID snmpOID) {
        this.enterprise = snmpOID;
    }

    public void setErrindex(int n) {
        this.errindex = n;
    }

    public void setErrstat(int n) {
        this.errstat = n;
    }

    public void setMaxRepetitions(int n) {
        this.setErrindex(n);
    }

    public void setNonRepeaters(int n) {
        this.setErrstat(n);
    }

    public void setProtocolOptions(ProtocolOptions protocolOptions) {
        this.protocolOptions = protocolOptions;
    }

    public void setReEncode(boolean bl) {
        this.msg.alwaysEncode = bl;
    }

    public void setRemoteHost(String string) {
        block4: {
            this.remoteHost = string;
            this.address = null;
            this.transportAddress = null;
            if (!this.lookup) break block4;
            try {
                this.address = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                return;
            }
            try {
                this.transportAddress = TransportAddress.getByName(1, this.address.getHostAddress());
            }
            catch (Exception exception) {
                SnmpAPI.debugPrintMedium(SnmpUtils.getString("Couldn't mask into transportAddress"));
            }
        }
    }

    public void setRemotePort(int n) {
        this.remotePort = n;
    }

    public void setReqid(int n) {
        this.reqid = n;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    public void setSpecificType(int n) {
        this.specific_type = n;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    void setTransportAddress(TransportAddress transportAddress) {
        this.address = transportAddress.getDomainId() == 1 ? (InetAddress)transportAddress.getProtocolAddress() : null;
        this.transportAddress = transportAddress;
    }

    public void setTrapType(int n) {
        this.trap_type = n;
    }

    public void setUpTime(long l) {
        this.time = l;
    }

    public void setVariable(int n, SnmpVar snmpVar) {
        if (n < 0 || n >= this.variables.size()) {
            return;
        }
        ((SnmpVarBind)this.variables.elementAt((int)n)).variable = snmpVar;
    }

    public void setVersion(int n) {
        this.msg.msgVersion = n;
    }

    public void setWriteCommunity(String string) {
        this.msg.writeCommunity = string;
    }
}

