/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.utils.SnmpUtils;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class SnmpProperties {
    private static final int MAJOR_VERSION = 3;
    private static final int MINOR_VERSION = 3;
    private static final int INTER_VERSION = 0;
    private static final int PATCH_VERSION = 0;
    private static final boolean IS_SNAPSHOT = false;
    private static final String RCS_DATE = "$Date: 2001/06/04 10:27:01 $";
    static final String PRODUCT_NAME = "AdventNet SNMPV1 ";
    static final String[] PROPERTIES_FILES = new String[]{"snmp.properties", ".snmp.properties"};
    private static final Properties properties = new Properties();
    static /* synthetic */ Class class$com$adventnet$snmp$snmp2$SnmpProperties;

    static {
        try {
            SnmpProperties.setProperties();
        }
        catch (Exception exception) {
            String string = String.valueOf(SnmpUtils.getString("Warning: Unable to load the ")) + " " + PRODUCT_NAME + " " + SnmpUtils.getString(" properties file");
            System.err.println(string);
        }
    }

    private SnmpProperties() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static int getIntermediateVersion() {
        return 0;
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 3;
    }

    public static int getPatchVersion() {
        return 0;
    }

    public static String getProperty(String string) {
        return properties.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }

    public static String getReleaseDate() {
        try {
            return RCS_DATE.substring(7, 17);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return "unknown";
        }
    }

    public static String getVersionString() {
        StringBuffer stringBuffer = new StringBuffer("AdventNet SNMPV1 Release ").append(3).append(".").append(3);
        return stringBuffer.toString();
    }

    public static boolean isVersionAtLeast(int n, int n2, int n3) {
        if (n < 3) {
            return true;
        }
        if (n > 3) {
            return false;
        }
        if (n2 < 3) {
            return true;
        }
        if (n2 > 3) {
            return false;
        }
        return n3 <= 0;
    }

    public static void list(PrintStream printStream) {
        properties.list(printStream);
    }

    public static void list(PrintWriter printWriter) {
        properties.list(printWriter);
    }

    public static void main(String[] stringArray) {
        System.out.println(SnmpProperties.getVersionString());
        System.out.println();
    }

    public static Enumeration propertyNames() {
        return properties.propertyNames();
    }

    public static void save(OutputStream outputStream, String string) {
        properties.save(outputStream, string);
    }

    private static void setProperties() {
        InputStream inputStream = (class$com$adventnet$snmp$snmp2$SnmpProperties != null ? class$com$adventnet$snmp$snmp2$SnmpProperties : (class$com$adventnet$snmp$snmp2$SnmpProperties = SnmpProperties.class$("com.adventnet.snmp.snmp2.SnmpProperties"))).getResourceAsStream("snmp.properties");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Warning: Unable to load the ")) + " " + PRODUCT_NAME + " " + SnmpUtils.getString(" properties file."));
        }
    }

    public static String setProperty(String string, String string2) {
        return ((Hashtable)properties).put(string, string2);
    }
}

