/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.management.transport.TransportException;
import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.ConnectionListener;
import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SimplePDU;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpCallback;
import com.adventnet.snmp.snmp2.SnmpClient;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpGroup;
import com.adventnet.snmp.snmp2.SnmpIpAddress;
import com.adventnet.snmp.snmp2.SnmpMessage;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpProperties;
import com.adventnet.snmp.snmp2.SnmpTransportPacket;
import com.adventnet.snmp.snmp2.SnmpTransportProvider;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.snmp.snmp2.TransportAddress;
import com.adventnet.snmp.snmp2.TransportPacket;
import com.adventnet.snmp.snmp2.TransportSocket;
import com.adventnet.utils.LogManager;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SnmpSession
extends Thread
implements Serializable {
    ConnectionListener connListener = null;
    int version = 0;
    Hashtable snmpClients = null;
    int id = 1000000;
    int waitTime = 0;
    boolean CALLBACK_THREAD = false;
    String community = "public";
    String writeCommunity = null;
    int retries = 0;
    static int sasProtocol = 0;
    int timeout = 5000;
    int packetBufferSize = 64000;
    String peername;
    int remote_port = 0;
    String[] local_addrs;
    int local_port = 0;
    static int startLocalPort = 6000;
    int encodeBufferSize = 1000;
    SASClient sasclient = null;
    Vector clients = null;
    int socketTimeout = 250;
    int socketDelay = 0;
    private String cachedPeername;
    private TransportAddress cachedTransportAddress;
    public static final int IP = 1;
    public static final int TRANSPORT_PROVIDER = 2;
    int protocol = 1;
    private String errStr;
    ProtocolOptions protocolOptions = null;
    boolean closeSocket = false;
    private boolean TIMED_OUT = false;
    SnmpGroup group;
    SnmpAPI API;
    private TransportSocket sock;
    private TransportAddress address;
    Vector requestList = new Vector();
    Vector responseList = new Vector();
    Vector timeouts = new Vector();
    int RESP_QUEUE_SIZE = RSP_Q_SIZE;
    int TIMEOUT_QUEUE_SIZE = TIMEOUT_Q_SIZE;
    SnmpCallback snmpcallback = null;
    boolean authenticationFailed = false;
    private static int RSP_Q_SIZE = 100;
    private static int TIMEOUT_Q_SIZE = 50;
    private static byte GCJ_FLAG = 0;
    SnmpTransportProvider transportProvider = null;
    String transportProviderFileName = "/snmpTransport.config";
    boolean isSessionEstablished = false;

    static {
        try {
            RSP_Q_SIZE = Integer.parseInt(SnmpProperties.getProperty("RESPONSE_QUEUE_SIZE", new Integer(RSP_Q_SIZE).toString()));
            TIMEOUT_Q_SIZE = Integer.parseInt(SnmpProperties.getProperty("TIMEOUT_QUEUE_SIZE", new Integer(TIMEOUT_Q_SIZE).toString()));
            GCJ_FLAG = Byte.parseByte(SnmpProperties.getProperty("GCJ_COMPILE", new Byte(GCJ_FLAG).toString()));
        }
        catch (NumberFormatException numberFormatException) {
            SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Exception while assigning data from SnmpProperties :Not a number ")) + " " + numberFormatException);
        }
    }

    public SnmpSession(SnmpAPI snmpAPI) {
        this.API = snmpAPI;
        while (this.API.reqID <= 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (SnmpAPI.DEBUG) {
            System.out.println("\n" + SnmpUtils.getString("RELEASE : ") + " " + SnmpAPI.getVersionString() + "\n");
        }
    }

    public void addSnmpClient(SnmpClient snmpClient) {
        if (this.clients == null) {
            this.clients = new Vector();
        }
        this.clients.addElement(snmpClient);
    }

    public int addSnmpClientWithID(SnmpClient snmpClient) {
        if (this.clients == null) {
            this.clients = new Vector();
            this.clients.addElement(snmpClient);
        }
        if (this.snmpClients == null) {
            this.snmpClients = new Hashtable();
        }
        String string = new Integer(this.id).toString();
        this.snmpClients.put(string, snmpClient);
        return this.id++;
    }

    public synchronized int[] checkResponses() {
        int n = this.responseList.size();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < nArray.length) {
            SnmpPDU snmpPDU = (SnmpPDU)this.responseList.elementAt(n2);
            if (snmpPDU != null) {
                nArray[n2] = snmpPDU.reqid;
            }
            ++n2;
        }
        return nArray;
    }

    synchronized int checkSyncResponse(int n) throws SnmpException {
        int[] nArray = this.checkResponses();
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n == nArray[n2]) {
                    return 1;
                }
                ++n2;
            }
        }
        if (this.checkTimeout(n)) {
            return -1;
        }
        try {
            this.wait(0L);
        }
        catch (InterruptedException interruptedException) {}
        return 0;
    }

    public boolean checkTimeout(int n) {
        Enumeration enumeration = this.timeouts.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n != n2) continue;
            this.timeouts.removeElement(n2);
            return true;
        }
        return false;
    }

    public void close() {
        this.API.sessionList.removeElement(this);
        this.closeSocket = true;
        if (this.sasclient != null) {
            this.sasclient.close();
        }
        if (this.snmpcallback != null) {
            this.snmpcallback.close();
            this.snmpcallback = null;
        }
        if (this.local_addrs != null) {
            this.API.removeElement(this.local_addrs[this.local_addrs.length - 1], this.local_port);
        }
        try {
            if (this.protocol != 1) {
                if (this.transportProvider != null) {
                    this.transportProvider.close();
                }
                this.isSessionEstablished = false;
                this.transportProvider = null;
            }
        }
        catch (IOException iOException) {
            SnmpAPI.debugPrintHigh(iOException.getMessage());
        }
        if (this.clients != null) {
            this.clients.removeAllElements();
            this.clients = null;
        }
        if (this.snmpClients != null) {
            this.snmpClients.clear();
            this.snmpClients = null;
        }
    }

    synchronized Object deQ(Vector vector, int n) {
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            try {
                Object e = vector.elementAt(n3);
                if (e instanceof SimplePDU) {
                    SimplePDU simplePDU = (SimplePDU)e;
                    String string = null;
                    if (this.sasclient == null) {
                        TransportAddress transportAddress = null;
                        transportAddress = simplePDU.transportAddress;
                        if (transportAddress != null) {
                            string = SnmpIpAddress.netbToString(((InetAddress)transportAddress.getProtocolAddress()).getAddress());
                        }
                    } else {
                        string = simplePDU.remoteHost;
                    }
                    if (simplePDU.reqid == n) {
                        if (this.protocol == 1) {
                            if (string != null && (!string.endsWith(".255") && !string.endsWith(".0") || this.TIMED_OUT)) {
                                vector.removeElement(simplePDU);
                                this.TIMED_OUT = false;
                            }
                        } else {
                            vector.removeElement(simplePDU);
                            this.TIMED_OUT = false;
                        }
                        this.notifyAll();
                        return simplePDU;
                    }
                } else {
                    SnmpPDU snmpPDU = (SnmpPDU)e;
                    if (n == 0 || snmpPDU.reqid == n) {
                        vector.removeElement(snmpPDU);
                        this.notifyAll();
                        return snmpPDU;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n3;
        }
        return null;
    }

    void debugPrint(String string) {
        if (!SnmpAPI.DEBUG) {
            return;
        }
        if (this.clients != null && this.clients.size() > 0) {
            Enumeration enumeration = this.clients.elements();
            while (enumeration.hasMoreElements()) {
                SnmpClient snmpClient = (SnmpClient)enumeration.nextElement();
                snmpClient.debugPrint(string);
            }
        } else {
            SnmpAPI.debugPrintHigh(string);
        }
    }

    void debugPrint(String string, int n) {
        LogManager.logMessage(string, n);
    }

    void debugPrint(boolean bl, String string, int n) {
        if (this.snmpClients != null) {
            String string2 = new Integer(n).toString();
            SnmpClient snmpClient = (SnmpClient)this.snmpClients.get(string2);
            if (snmpClient != null) {
                snmpClient.debugPrint(string);
            } else {
                this.debugPrint(string, n);
            }
        } else {
            this.debugPrint(string, n);
        }
    }

    synchronized void enQ(Vector vector, SimplePDU simplePDU) {
        vector.addElement(simplePDU);
        this.notifyAll();
    }

    synchronized void enQ(Vector vector, SnmpPDU snmpPDU) {
        vector.addElement(snmpPDU);
        this.notifyAll();
    }

    public SnmpVar get(SnmpOID snmpOID) throws SnmpException {
        return this.snmpRequest((byte)-96, snmpOID, null);
    }

    public SnmpVar get(String string) throws SnmpException {
        SnmpOID snmpOID = new SnmpOID(string);
        if (snmpOID.toValue() == null) {
            SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("Specified OID : ")) + " " + string + " " + SnmpUtils.getString(" is invalid"));
            throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid OID String: ")) + " " + string);
        }
        return this.snmpRequest((byte)-96, snmpOID, null);
    }

    public String getCommunity() {
        return this.community;
    }

    public ConnectionListener getConnectionListener() {
        return this.connListener;
    }

    public String[] getLocalAddresses() {
        return this.local_addrs;
    }

    public int getLocalPort() {
        return this.local_port;
    }

    public int getPacketBufferSize() {
        return this.packetBufferSize;
    }

    public String getPeername() {
        return this.peername;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public ProtocolOptions getProtocolOptions() {
        return this.protocolOptions;
    }

    public int getRemotePort() {
        return this.remote_port;
    }

    public int getRetries() {
        return this.retries;
    }

    public SASClient getSASClient() {
        return this.sasclient;
    }

    public int getSASProtocol() {
        return sasProtocol;
    }

    public SnmpAPI getSnmpAPI() {
        return this.API;
    }

    public Vector getSnmpClients() {
        return this.clients;
    }

    public int getSnmpClientsSize() {
        if (this.clients == null) {
            return 0;
        }
        return this.clients.size();
    }

    public Hashtable getSnmpClientsWithID() {
        return this.snmpClients;
    }

    public int getStartLocalPort() {
        return startLocalPort;
    }

    public int getTimeToWait() {
        return this.waitTime;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getVersion() {
        return this.version;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public SnmpVar getnext(SnmpOID snmpOID) throws SnmpException {
        return this.snmpRequest((byte)-95, snmpOID, null);
    }

    public SnmpVar getnext(String string) throws SnmpException {
        SnmpOID snmpOID = new SnmpOID(string);
        if (snmpOID.toValue() == null) {
            SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("Specified OID : ")) + " " + string + " " + SnmpUtils.getString(" is invalid"));
            throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid OID String: ")) + " " + string);
        }
        return this.snmpRequest((byte)-95, snmpOID, null);
    }

    void initTransportProvider() throws Exception {
        String string = "";
        BufferedReader bufferedReader = null;
        String string2 = null;
        SnmpAPI.debugPrintHigh(SnmpUtils.getString("In initTransportProvider()"));
        URL uRL = this.getClass().getResource(this.transportProviderFileName);
        if (uRL == null) {
            SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Unable to find TransportConfigFile")) + " " + this.transportProviderFileName);
            return;
        }
        try {
            Object object;
            block6: {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                do {
                    try {
                        string = bufferedReader.readLine();
                    }
                    catch (Exception exception) {
                        SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Cannot read file : ")) + " " + this.transportProviderFileName);
                        throw new Exception(String.valueOf(SnmpUtils.getString("Cannot read file : ")) + " " + this.transportProviderFileName);
                    }
                    if (string == null) break block6;
                } while (string.trim().startsWith(" ") || string.trim().equals("") || string.trim().startsWith("#"));
                object = new StringTokenizer(string);
                string2 = ((StringTokenizer)object).nextToken();
            }
            object = Class.forName(string2);
            this.transportProvider = (SnmpTransportProvider)((Class)object).newInstance();
        }
        catch (Exception exception) {
            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Invalid File Name "));
            throw new Exception(SnmpUtils.getString("Invalid File Name "));
        }
    }

    public boolean isSessionEstablished() {
        return this.isSessionEstablished;
    }

    synchronized void monitorRequests() {
        boolean bl = false;
        Enumeration enumeration = this.requestList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                SimplePDU simplePDU;
                block45: {
                    simplePDU = (SimplePDU)enumeration.nextElement();
                    if (System.currentTimeMillis() <= simplePDU.time_expires) continue;
                    if (simplePDU.retries <= 0) {
                        Object object;
                        String string;
                        this.TIMED_OUT = true;
                        this.deQ(this.requestList, simplePDU.reqid);
                        if (this.timeouts.size() >= this.TIMEOUT_QUEUE_SIZE) {
                            this.timeouts.removeElementAt(0);
                        }
                        this.timeouts.addElement(new Integer(simplePDU.reqid));
                        if (this.clients != null) {
                            if (simplePDU.clientId != 0) {
                                string = new Integer(simplePDU.clientId).toString();
                                object = (SnmpClient)this.snmpClients.get(string);
                                if (this.CALLBACK_THREAD) {
                                    if (this.snmpcallback == null) {
                                        this.snmpcallback = new SnmpCallback();
                                        this.snmpcallback.start();
                                    }
                                    this.snmpcallback.enQ((SnmpClient)object, this, null, simplePDU.reqid);
                                } else {
                                    object.callback(this, null, simplePDU.reqid);
                                }
                            } else {
                                Enumeration enumeration2 = this.clients.elements();
                                while (enumeration2.hasMoreElements()) {
                                    object = (SnmpClient)enumeration2.nextElement();
                                    if (this.CALLBACK_THREAD) {
                                        if (this.snmpcallback == null) {
                                            this.snmpcallback = new SnmpCallback();
                                            this.snmpcallback.start();
                                        }
                                        this.snmpcallback.enQ((SnmpClient)object, this, null, simplePDU.reqid);
                                        continue;
                                    }
                                    object.callback(this, null, simplePDU.reqid);
                                }
                            }
                        }
                        if (!SnmpAPI.DEBUG) continue;
                        if (this.protocol == 1) {
                            string = simplePDU.remoteHost;
                            if (string == null) {
                                string = simplePDU.transportAddress.toString();
                            }
                            object = String.valueOf(SnmpUtils.getString("\nTimed out: no more retries to ")) + " " + string + "  : " + simplePDU.remotePort + "  " + SnmpUtils.getString("ReqID: ") + " " + simplePDU.reqid;
                            if (simplePDU.clientId != 0) {
                                this.debugPrint(true, (String)object, simplePDU.clientId);
                                continue;
                            }
                            this.debugPrint((String)object);
                            continue;
                        }
                        string = SnmpUtils.getString("\nTimed out: no more retries to ");
                        if (simplePDU.clientId != 0) {
                            this.debugPrint(true, string, simplePDU.clientId);
                            continue;
                        }
                        this.debugPrint(string);
                        continue;
                    }
                    --simplePDU.retries;
                    try {
                        if (this.sasclient != null) {
                            try {
                                this.sasclient.send(simplePDU.remoteHost, simplePDU.remotePort, simplePDU.data);
                            }
                            catch (TransportException transportException) {
                                System.out.println(String.valueOf(SnmpUtils.getString("Error in sending : ")) + " " + transportException.toString());
                            }
                            break block45;
                        }
                        try {
                            if (this.protocol == 1) {
                                this.sock.send(TransportPacket.getInstance(this.protocol, simplePDU.data, simplePDU.data.length, simplePDU.transportAddress, simplePDU.remotePort));
                            } else {
                                SnmpTransportPacket snmpTransportPacket = new SnmpTransportPacket();
                                snmpTransportPacket.setProtocolOptions(simplePDU.protocolOptions);
                                snmpTransportPacket.setProtocolData(simplePDU.data);
                                this.transportProvider.write(snmpTransportPacket);
                            }
                        }
                        catch (Exception exception) {
                            SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("IO Exception while retransmitting the PDU ")) + " " + exception);
                            throw new IOException(String.valueOf(SnmpUtils.getString("Send Error : ")) + " " + exception);
                        }
                    }
                    catch (IOException iOException) {
                        if (this.sasclient != null) {
                            SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("IO error resending to ")) + " " + simplePDU.remoteHost + "  : " + Integer.toString(simplePDU.remotePort));
                        }
                        if (this.protocol == 1) {
                            SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("IO error resending to ")) + " " + simplePDU.transportAddress.toString() + "  : " + Integer.toString(simplePDU.remotePort));
                        }
                        SnmpAPI.debugPrintHigh(SnmpUtils.getString("IO error message being resent"));
                    }
                }
                if (SnmpAPI.DEBUG) {
                    if (this.protocol == 1) {
                        if (this.sasclient == null) {
                            if (simplePDU.clientId != 0) {
                                this.debugPrint(true, String.valueOf(SnmpUtils.getString("Timed out: Resent to ")) + " " + simplePDU.transportAddress.toString() + "  : " + simplePDU.remotePort, simplePDU.clientId);
                            } else {
                                this.debugPrint(String.valueOf(SnmpUtils.getString("Timed out: Resent to ")) + " " + simplePDU.transportAddress.toString() + "  : " + simplePDU.remotePort);
                            }
                        } else if (simplePDU.clientId != 0) {
                            this.debugPrint(true, String.valueOf(SnmpUtils.getString("Timed out: Resent to ")) + " " + simplePDU.remoteHost + "  : " + simplePDU.remotePort, simplePDU.clientId);
                        } else {
                            this.debugPrint(String.valueOf(SnmpUtils.getString("Timed out: Resent to ")) + " " + simplePDU.remoteHost + "  : " + simplePDU.remotePort);
                        }
                        if (simplePDU.clientId != 0) {
                            this.debugPrint(true, String.valueOf(SnmpUtils.getString("ReqID: ")) + " " + simplePDU.reqid, simplePDU.clientId);
                        } else {
                            this.debugPrint(String.valueOf(SnmpUtils.getString("ReqID: ")) + " " + simplePDU.reqid);
                        }
                    } else if (simplePDU.clientId != 0) {
                        this.debugPrint(true, SnmpUtils.getString("Timed out : Resending"), simplePDU.clientId);
                    } else {
                        this.debugPrint(SnmpUtils.getString("Timed out : Resending"));
                    }
                }
                if (this.waitTime != 0 && this.sock != null) {
                    int n = this.sock.calculateTimeExpires(simplePDU.timeout);
                    simplePDU.time_sent = System.currentTimeMillis();
                    simplePDU.time_expires = simplePDU.time_sent + (long)n;
                    continue;
                }
                long l = simplePDU.time_expires - simplePDU.time_sent;
                simplePDU.time_sent = System.currentTimeMillis();
                simplePDU.time_expires = simplePDU.time_sent + 2L * l;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        int n = this.responseList.size() - this.RESP_QUEUE_SIZE;
        int n2 = 0;
        while (n2 < n) {
            SnmpPDU snmpPDU = (SnmpPDU)this.deQ(this.responseList, 0);
            if (this.timeouts.size() >= this.TIMEOUT_QUEUE_SIZE) {
                this.timeouts.removeElementAt(0);
            }
            this.timeouts.addElement(new Integer(snmpPDU.reqid));
            ++n2;
        }
    }

    public void open() throws SnmpException {
        if (this.protocol == 1) {
            try {
                if (this.local_addrs == null) {
                    if (this.local_port == 0) {
                        this.sock = TransportSocket.getInstance(this.protocol);
                        this.local_port = this.sock.getLocalPort();
                    }
                    this.sock = TransportSocket.getInstance(this.protocol, this.local_port);
                }
                int n = 0;
                while (n < this.local_addrs.length) {
                    try {
                        this.sock = TransportSocket.getInstance(this.protocol, this.local_port, TransportAddress.getByName(this.protocol, this.local_addrs[n]));
                    }
                    catch (UnknownHostException unknownHostException) {
                        SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Cannot bind to address: ")) + " " + this.local_addrs[n] + " : " + unknownHostException);
                    }
                    ++n;
                }
            }
            catch (SocketException socketException) {
                if (SnmpAPI.DEBUG) {
                    this.debugPrint(socketException.toString());
                }
                throw new SnmpException(socketException.toString());
            }
        } else {
            try {
                this.initTransportProvider();
            }
            catch (Exception exception) {
                SnmpAPI.debugPrintHigh(SnmpUtils.getString("Transport provider not configured."));
                throw new SnmpException(SnmpUtils.getString("Transport provider not configured"));
            }
            try {
                this.transportProvider.open(this.protocolOptions);
                this.isSessionEstablished = true;
            }
            catch (Exception exception) {
                SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Error in open : ")) + " " + exception.getMessage());
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Error in open : ")) + " " + exception.getMessage());
            }
        }
        Object object = null;
        if (this.local_addrs == null) {
            try {
                this.local_addrs = new String[1];
                this.local_addrs[0] = GCJ_FLAG == 0 ? InetAddress.getLocalHost().getHostAddress() : "127.0.0.1";
            }
            catch (UnknownHostException unknownHostException) {
                this.local_addrs[0] = "127.0.0.1";
            }
        }
        object = this.API.getGroupKey(this.local_addrs[this.local_addrs.length - 1], this.local_port);
        this.group = new SnmpGroup();
        this.API.addElement(object, this.group);
        this.closeSocket = false;
        this.start();
    }

    public void open(Applet applet) throws SnmpException {
        Object object;
        if (GCJ_FLAG != 0) {
            throw new SnmpException(SnmpUtils.getString("Applet not supported"));
        }
        if (sasProtocol == 0) {
            sasProtocol = applet.getParameter("PROTOCOL") != null ? Integer.parseInt(applet.getParameter("PROTOCOL")) : 1;
        }
        SASClient sASClient = null;
        try {
            this.sasclient = new SASClient(applet, SnmpAPI.DEBUG, sasProtocol);
            if (SnmpAPI.getSASClient() == null) {
                sASClient = new SASClient(applet, SnmpAPI.DEBUG, sasProtocol);
            }
        }
        catch (SnmpException snmpException) {
            this.sasclient = null;
            sASClient = null;
        }
        if (this.local_addrs == null) {
            this.local_addrs = new String[1];
            this.local_addrs[0] = "127.0.0.1";
        }
        if (this.sasclient != null && this.sasclient.connected) {
            if (SnmpAPI.DEBUG) {
                SnmpAPI.debugPrintMedium(SnmpUtils.getString("Connected to remote socket on applet host."));
            }
            this.sasclient.open(this.local_port);
            object = this.API.getGroupKey(this.local_addrs[this.local_addrs.length - 1], this.local_port);
            this.group = new SnmpGroup();
            this.API.addElement(object, this.group);
            this.start();
        }
        if (sASClient == null && this.sasclient != null && this.sasclient.connected) {
            return;
        }
        if (sASClient != null && sASClient.connected) {
            if (SnmpAPI.DEBUG) {
                SnmpAPI.debugPrintMedium(SnmpUtils.getString("Connected to remote socket on applet host."));
            }
            sASClient.open(this.local_port);
            object = this.API.getGroupKey(this.local_addrs[this.local_addrs.length - 1], this.local_port);
            this.group = new SnmpGroup();
            this.API.addElement(object, this.group);
            sASClient.start();
            SnmpAPI.setSASClient(sASClient);
            return;
        }
        this.sasclient = null;
        sASClient = null;
        block6: while (true) {
            try {
                while (true) {
                    if (this.local_port == 0) {
                        boolean bl = false;
                        try {
                            String string = System.getProperty("browser", "");
                            if (string.equals("ActiveX Scripting Host")) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {}
                        this.sock = bl ? TransportSocket.getInstance(this.protocol, startLocalPort) : TransportSocket.getInstance(this.protocol);
                        this.local_port = this.sock.getLocalPort();
                        break block6;
                    }
                    this.sock = TransportSocket.getInstance(this.protocol, this.local_port);
                }
            }
            catch (SocketException socketException) {
                if (SnmpAPI.DEBUG) {
                    this.debugPrint(socketException.toString());
                }
                ++startLocalPort;
                continue;
            }
            break;
        }
        Object object2 = this.API.getGroupKey(this.local_addrs[this.local_addrs.length - 1], this.local_port);
        this.group = new SnmpGroup();
        this.API.addElement(object2, this.group);
        this.closeSocket = false;
        this.start();
    }

    public Hashtable partialSet(SnmpPDU snmpPDU) throws SnmpException {
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        int n = 0;
        int n2 = 0;
        int n3 = snmpPDU.getVariableBindings().size();
        SnmpPDU snmpPDU2 = null;
        while (snmpPDU.getVariableBindings().size() != 0) {
            snmpPDU.setReqid(0);
            snmpPDU.setErrindex(0);
            snmpPDU.setErrstat(0);
            snmpPDU2 = this.syncSend(snmpPDU);
            if (snmpPDU2 == null) {
                return null;
            }
            if (snmpPDU2.getErrstat() == 0) break;
            n = snmpPDU2.getErrindex();
            if (n == 0) {
                int n4 = 0;
                while (n4 < n3) {
                    SnmpPDU snmpPDU3 = new SnmpPDU();
                    snmpPDU3.setCommand((byte)-93);
                    snmpPDU3.addVariableBinding(snmpPDU.getVariableBinding(n4));
                    snmpPDU3 = this.syncSend(snmpPDU);
                    if (snmpPDU3 == null) {
                        return null;
                    }
                    if (snmpPDU3.getErrstat() != 0) {
                        hashtable.put(new Integer(n4), new Integer(snmpPDU3.getErrstat()));
                    }
                    ++n4;
                }
                break;
            }
            snmpPDU.setErrindex(snmpPDU2.getErrindex());
            snmpPDU.fix();
            hashtable.put(new Integer((n += n2) - 1), new Integer(snmpPDU2.getErrstat()));
            ++n2;
        }
        return hashtable;
    }

    public Hashtable partialSet(SnmpOID[] snmpOIDArray, SnmpVar[] snmpVarArray) throws SnmpException {
        if (snmpOIDArray == null || snmpVarArray == null) {
            throw new SnmpException(SnmpUtils.getString("Null value for OIDs or Vars"));
        }
        if (snmpOIDArray.length != snmpVarArray.length) {
            throw new SnmpException(SnmpUtils.getString("Incorrect no of OIDs and Vars"));
        }
        SnmpPDU snmpPDU = new SnmpPDU();
        int n = snmpOIDArray.length;
        int n2 = 0;
        while (n2 < n) {
            snmpPDU.addVariableBinding(new SnmpVarBind(snmpOIDArray[n2], snmpVarArray[n2]));
            ++n2;
        }
        snmpPDU.setCommand((byte)-93);
        return this.partialSet(snmpPDU);
    }

    String printOctets(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 20;
        if (byArray.length < n) {
            n = byArray.length;
        }
        int n4 = 0;
        while (n4 < n) {
            String string;
            if (n2++ > 19) {
                n2 = 1;
                stringBuffer.append("\n");
            }
            if ((string = Integer.toString(ASNTypes.byteToInt(byArray[n4]), 16)).length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(String.valueOf(string) + " ");
            ++n4;
        }
        return stringBuffer.toString();
    }

    void processPacket(TransportPacket transportPacket, SnmpPDU snmpPDU) {
        Object object;
        Object object2;
        int n;
        block38: {
            block37: {
                int n2 = snmpPDU.asnParser.data.length;
                n = snmpPDU.reqid;
                if (this.group != null) {
                    ++this.group.snmpInPkts;
                }
                if (this.sasclient == null && this.protocol == 1) {
                    snmpPDU.remoteHost = SnmpIpAddress.netbToString(snmpPDU.transportAddress.getAddress());
                }
                if (SnmpAPI.DEBUG) {
                    object2 = this.printOctets(snmpPDU.asnParser.data, n2);
                    if (this.protocol == 1) {
                        if (snmpPDU.clientID != 0) {
                            this.debugPrint(true, "\n" + SnmpUtils.getString("Packet from: ") + " " + snmpPDU.remoteHost + "  : " + snmpPDU.remotePort + "\n" + SnmpUtils.getString("DATA:") + "\n" + (String)object2 + "\n", snmpPDU.clientID);
                        } else {
                            this.debugPrint(String.valueOf(SnmpUtils.getString("Packet from: ")) + " " + snmpPDU.remoteHost + "  : " + snmpPDU.remotePort + "\n" + SnmpUtils.getString("DATA:") + "\n" + (String)object2 + "\n");
                        }
                    } else if (snmpPDU.clientID != 0) {
                        this.debugPrint(true, "\n " + SnmpUtils.getString("Received Packet") + "\n" + object2, snmpPDU.clientID);
                    } else {
                        this.debugPrint("\n " + SnmpUtils.getString("Received Packet") + "\n" + object2);
                    }
                }
                try {
                    if (snmpPDU.decode()) break block37;
                    if (this.group != null) {
                        ++this.group.snmpInASNParseErrs;
                    }
                    SnmpAPI.debugPrintHigh(SnmpUtils.getString("Unable to decode PDU."));
                    object2 = this.timeouts;
                    synchronized (object2) {
                        if (n != 0) {
                            this.timeouts.addElement(new Integer(n));
                        }
                    }
                    snmpPDU = null;
                }
                catch (SnmpException snmpException) {
                    if (this.group != null) {
                        ++this.group.snmpInASNParseErrs;
                    }
                    SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Error decoding Packet: ")) + " " + snmpException);
                    object = this.timeouts;
                    synchronized (object) {
                        if (n != 0) {
                            this.timeouts.addElement(new Integer(n));
                        }
                    }
                    snmpPDU = null;
                }
                break block38;
            }
            if (SnmpAPI.DEBUG) {
                if (snmpPDU.clientID != 0) {
                    this.debugPrint(true, String.valueOf(SnmpUtils.getString("Packet ReqID: ")) + " " + n + "\n", snmpPDU.clientID);
                } else {
                    this.debugPrint(String.valueOf(SnmpUtils.getString("Packet ReqID: ")) + " " + n);
                }
            }
            if (this.sasclient != null && snmpPDU.command == -92 && snmpPDU.getVersion() == 0 && (snmpPDU.agent_addr == null || snmpPDU.agent_addr.toString().startsWith("0.0"))) {
                try {
                    snmpPDU.setAgentAddress(InetAddress.getByName(this.sasclient.remoteHost));
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
            if (this.group != null) {
                this.group.processInErrors(snmpPDU);
                this.group.processInCommands(snmpPDU);
            }
        }
        if (snmpPDU != null && snmpPDU.callBackClient != null) {
            if (snmpPDU.callBackClient.callback(this, snmpPDU, n)) {
                return;
            }
            this.enQ(this.responseList, snmpPDU);
            return;
        }
        if (this.clients != null) {
            if (snmpPDU != null && snmpPDU.clientID != 0) {
                boolean bl;
                object2 = new Integer(snmpPDU.getClientID()).toString();
                object = (SnmpClient)this.snmpClients.get(object2);
                if (object != null && snmpPDU.msg.authenticate(this, (SnmpClient)object) && (bl = object.callback(this, snmpPDU, n))) {
                    return;
                }
            } else {
                object2 = this.clients.elements();
                while (object2.hasMoreElements()) {
                    object = (SnmpClient)object2.nextElement();
                    if (snmpPDU != null) {
                        boolean bl;
                        if (!snmpPDU.msg.authenticate(this, (SnmpClient)object) || !(bl = object.callback(this, snmpPDU, n))) continue;
                        return;
                    }
                    object.callback(this, null, n);
                }
            }
        }
        if (snmpPDU != null) {
            this.enQ(this.responseList, snmpPDU);
        }
    }

    public SnmpPDU receive(int n) {
        Thread.yield();
        return (SnmpPDU)this.deQ(this.responseList, n);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void receiveFromIP(byte[] var1_1, TransportPacket var2_2) {
        while (true) {
            block37: {
                block36: {
                    block35: {
                        if (this.sock == null && this.sasclient == null) break block37;
                        try {
                            if (this.sasclient != null) {
                                try {
                                    this.sasclient.receive();
                                    break block35;
                                }
                                catch (TransportException v0) {
                                    SnmpAPI.debugPrintLow(SnmpUtils.getString("Receive error: Aborting session receiver"));
                                    if (this.sasclient != null) {
                                        this.sasclient.close();
                                    }
                                    return;
                                }
                            }
                            while (true) {
                                try {
                                    this.sock.receive(var2_2);
                                }
                                catch (InterruptedIOException v1) {
                                    if (this.closeSocket) {
                                        this.sock.close();
                                        return;
                                    }
                                    try {
                                        Thread.sleep(this.socketDelay);
                                    }
                                    catch (InterruptedException v2) {}
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException v3) {
                            if (this.sasclient == null) {
                                if (this.closeSocket) {
                                    return;
                                }
                                var3_3 = var2_2.getLength();
                                if (var3_3 != 0) continue;
                                var2_2.setData(var1_1);
                                var2_2.setLength(var1_1.length);
                                if (SnmpSession.GCJ_FLAG != 0) continue;
                                var2_2.setAddress(null);
                                continue;
                            }
                            SnmpAPI.debugPrintLow(SnmpUtils.getString("Receive error: Aborting session receiver"));
                            this.sasclient.close();
                            return;
                        }
                        catch (SnmpException v4) {
                            SnmpAPI.debugPrintLow(SnmpUtils.getString("Receive error: Ignoring the Received message and starting receiver again"));
                            continue;
                        }
                    }
                    if (this.closeSocket) {
                        this.sock.close();
                        return;
                    }
                    var3_4 = null;
                    var4_5 = null;
                    var5_6 = 0;
                    try {
                        if (this.sasclient == null) ** GOTO lbl71
                        if (this.sasclient.data != null) {
                            var3_4 = new SnmpMessage(this.sasclient.data);
                            var4_5 = var3_4.pdu;
                            var4_5.time_received = System.currentTimeMillis();
                            var6_7 /* !! */  = (byte[])((SimplePDU)this.deQ(this.requestList, var4_5.reqid));
                            if (var6_7 /* !! */  != null) {
                                var4_5.time_sent = var6_7 /* !! */ .time_sent;
                                var4_5.clientID = var6_7 /* !! */ .clientId;
                                if (var6_7 /* !! */ .command == -93 && this.writeCommunity != null) {
                                    var4_5.useWriteValidate = true;
                                }
                                var6_7 /* !! */  = null;
                            } else if (var4_5.command == -94) continue;
                            var4_5.setRemoteHost(this.sasclient.remoteHost);
                            var4_5.remotePort = this.sasclient.port;
                            var5_6 = this.sasclient.data.length;
                        } else {
                            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Data is null"));
                            break;
lbl71:
                            // 1 sources

                            var5_6 = var2_2.getLength();
                            if (var5_6 == 0) {
                                var2_2.setData(var1_1);
                                var2_2.setLength(var1_1.length);
                                if (SnmpSession.GCJ_FLAG != 0) continue;
                                var2_2.setAddress(null);
                                continue;
                            }
                            var6_7 /* !! */  = new byte[var5_6];
                            System.arraycopy(var2_2.getData(), 0, var6_7 /* !! */ , 0, var5_6);
                            var3_4 = new SnmpMessage(var6_7 /* !! */ );
                            var4_5 = var3_4.pdu;
                            var4_5.time_received = System.currentTimeMillis();
                            var4_5.transportAddress = var2_2.getAddress();
                            var4_5.remotePort = var2_2.getPort();
                            var2_2.setData(var1_1);
                            var2_2.setLength(var1_1.length);
                            if (SnmpSession.GCJ_FLAG == 0) {
                                var2_2.setAddress(null);
                            }
                            if ((var7_9 = (SimplePDU)this.deQ(this.requestList, var4_5.reqid)) != null) {
                                var4_5.callBackClient = var7_9.getCallBack();
                                var4_5.time_sent = var7_9.time_sent;
                                var4_5.clientID = var7_9.clientId;
                                if (var7_9.command == -93 && this.writeCommunity != null) {
                                    var4_5.useWriteValidate = true;
                                }
                                var7_9 = null;
                            } else if (var4_5.command == -94) continue;
                        }
                        if (this.CALLBACK_THREAD) {
                            if (this.snmpcallback == null) {
                                this.snmpcallback = new SnmpCallback();
                                this.snmpcallback.start();
                            }
                            this.snmpcallback.enQ(null, this, var4_5);
                        }
                        break block36;
                    }
                    catch (SnmpException var6_8) {
                        SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Exception while constructing message after receiving PDU. Dropping this PDU ")) + " " + var6_8);
                        if (var6_8.toString().startsWith("com.adventnet.snmp.snmp2.SnmpException: " + SnmpUtils.getString("Parse Error: Wrong SNMP Version:"))) {
                            if (this.group != null) {
                                ++this.group.snmpInBadVersions;
                            }
                        } else if (this.group != null) {
                            ++this.group.snmpInASNParseErrs;
                        }
                        var2_2.setData(var1_1);
                        var2_2.setLength(var1_1.length);
                        if (SnmpSession.GCJ_FLAG != 0) continue;
                        var2_2.setAddress(null);
                    }
                    continue;
                }
                this.processPacket(null, var4_5);
                continue;
            }
            Thread.yield();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void receiveFromTransportProvider(byte[] var1_1) {
        var2_2 = new byte[this.packetBufferSize];
        var3_3 = new SnmpTransportPacket(null, var2_2);
        var4_4 = 0;
        while (true) {
            block46: {
                block45: {
                    block44: {
                        if (this.transportProvider == null && this.sasclient == null) break block46;
                        try {
                            if (this.sasclient != null) {
                                try {
                                    this.sasclient.receive();
                                    break block44;
                                }
                                catch (TransportException v0) {
                                    SnmpAPI.debugPrintLow(SnmpUtils.getString("Receive error: Aborting session receiver"));
                                    this.sasclient.close();
                                    return;
                                }
                            }
                            while (true) {
                                try {
                                    var4_4 = this.transportProvider.read(var3_3);
                                }
                                catch (IOException v1) {
                                    if (this.connListener != null) {
                                        this.connListener.processConnectionDown(this, var3_3.getProtocolOptions());
                                    }
                                    if (this.closeSocket) {
                                        try {
                                            if (this.transportProvider != null) {
                                                this.transportProvider.close();
                                            }
                                            this.isSessionEstablished = false;
                                            return;
                                        }
                                        catch (Exception var5_5) {
                                            System.err.println(String.valueOf(SnmpUtils.getString("Error in closing the socket : ")) + " " + var5_5.getMessage());
                                        }
                                    }
                                    try {
                                        Thread.sleep(this.socketDelay);
                                    }
                                    catch (InterruptedException v2) {}
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException v3) {
                            if (this.sasclient == null) {
                                if (this.closeSocket) {
                                    return;
                                }
                                var5_6 = var4_4;
                                if (var5_6 != 0) continue;
                                var3_3.setProtocolData(var1_1);
                                continue;
                            }
                            SnmpAPI.debugPrintLow(SnmpUtils.getString("Receive error: Aborting session receiver"));
                            this.sasclient.close();
                            return;
                        }
                        catch (SnmpException v4) {
                            SnmpAPI.debugPrintLow(SnmpUtils.getString("Receive error: Ignoring the Received message and starting receiver again"));
                            continue;
                        }
                    }
                    if (this.closeSocket) {
                        try {
                            if (this.transportProvider != null) {
                                this.transportProvider.close();
                            }
                            this.isSessionEstablished = false;
                            return;
                        }
                        catch (Exception var5_7) {
                            System.err.println(String.valueOf(SnmpUtils.getString("Error in closing the socket : ")) + " " + var5_7.getMessage());
                        }
                    }
                    var5_8 = null;
                    var6_9 = null;
                    var7_10 = 0;
                    try {
                        if (this.sasclient == null) ** GOTO lbl82
                        if (this.sasclient.data != null) {
                            var5_8 = new SnmpMessage(this.sasclient.data);
                            var6_9 = var5_8.pdu;
                            var6_9.time_received = System.currentTimeMillis();
                            var8_11 /* !! */  = (byte[])((SimplePDU)this.deQ(this.requestList, var6_9.reqid));
                            if (var8_11 /* !! */  != null) {
                                var6_9.time_sent = var8_11 /* !! */ .time_sent;
                                var6_9.clientID = var8_11 /* !! */ .clientId;
                                if (var8_11 /* !! */ .command == -93 && this.writeCommunity != null) {
                                    var6_9.useWriteValidate = true;
                                }
                                var8_11 /* !! */  = null;
                            } else if (var6_9.command == -94) continue;
                            var6_9.setRemoteHost(this.sasclient.remoteHost);
                            var6_9.remotePort = this.sasclient.port;
                            var7_10 = this.sasclient.data.length;
                        } else {
                            SnmpAPI.debugPrintHigh(SnmpUtils.getString("Data is null"));
                            break;
lbl82:
                            // 1 sources

                            if (var4_4 != -1) {
                                var7_10 = var4_4;
                            } else {
                                try {
                                    Thread.sleep(1L);
                                }
                                catch (Exception v5) {}
                            }
                            if (var7_10 == 0) {
                                var3_3.setProtocolData(var1_1);
                                continue;
                            }
                            var8_11 /* !! */  = new byte[var7_10];
                            System.arraycopy(var3_3.getProtocolData(), 0, var8_11 /* !! */ , 0, var7_10);
                            var5_8 = new SnmpMessage(var8_11 /* !! */ );
                            var6_9 = var5_8.pdu;
                            var6_9.time_received = System.currentTimeMillis();
                            var3_3.setProtocolData(var1_1);
                            var9_13 = (SimplePDU)this.deQ(this.requestList, var6_9.reqid);
                            if (var9_13 != null) {
                                var6_9.setProtocolOptions(var9_13.protocolOptions);
                                var6_9.callBackClient = var9_13.getCallBack();
                                var6_9.time_sent = var9_13.time_sent;
                                if (var9_13.command == -93 && this.writeCommunity != null) {
                                    var6_9.useWriteValidate = true;
                                }
                                var9_13 = null;
                            } else {
                                var6_9.setProtocolOptions(var3_3.getProtocolOptions());
                                if (var6_9.command == -94) continue;
                            }
                        }
                        if (this.CALLBACK_THREAD) {
                            if (this.snmpcallback == null) {
                                this.snmpcallback = new SnmpCallback();
                                this.snmpcallback.start();
                            }
                            this.snmpcallback.enQ(null, this, var6_9);
                        }
                        break block45;
                    }
                    catch (SnmpException var8_12) {
                        SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("Exception while constructing message after receiving PDU. Dropping this PDU ")) + " " + var8_12);
                        if (var8_12.toString().startsWith("com.adventnet.snmp.snmp2.SnmpException: " + SnmpUtils.getString("Parse Error: Wrong SNMP Version:"))) {
                            if (this.group != null) {
                                ++this.group.snmpInBadVersions;
                            }
                        } else if (this.group != null) {
                            ++this.group.snmpInASNParseErrs;
                        }
                        var3_3.setProtocolData(var1_1);
                    }
                    continue;
                }
                this.processPacket(null, var6_9);
                continue;
            }
            Thread.yield();
        }
    }

    private void receiver() {
        SnmpAPI.debugPrintLow(SnmpUtils.getString("Starting Receiver on this session"));
        byte[] byArray = new byte[this.packetBufferSize];
        TransportPacket transportPacket = null;
        if (this.protocol == 1) {
            if (this.sock != null) {
                try {
                    this.sock.setSoTimeout(this.socketTimeout);
                }
                catch (Exception exception) {
                    SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("Failed set timeout : ")) + " " + exception.getMessage());
                    return;
                }
            }
            if (GCJ_FLAG != 0) {
                TransportAddress transportAddress = null;
                try {
                    transportAddress = TransportAddress.getByName(this.protocol, "0.0.0.0");
                    transportPacket = TransportPacket.getInstance(this.protocol, byArray, this.packetBufferSize, transportAddress, 0);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                transportPacket = TransportPacket.getInstance(this.protocol, byArray, this.packetBufferSize);
            }
            this.receiveFromIP(byArray, transportPacket);
        } else {
            this.receiveFromTransportProvider(byArray);
        }
    }

    public void removeConnectionListener() {
        this.connListener = null;
    }

    public void removeSnmpClient(SnmpClient snmpClient) {
        if (this.clients == null) {
            return;
        }
        this.clients.removeElement(snmpClient);
    }

    public void removeSnmpClientWithID(int n) {
        SnmpClient snmpClient = null;
        if (this.snmpClients != null) {
            String string = new Integer(n).toString();
            this.snmpClients.remove(string);
            snmpClient = (SnmpClient)this.snmpClients.get(string);
            this.clients.removeElement(snmpClient);
        }
    }

    public void run() {
        this.API.sessionList.addElement(this);
        this.receiver();
    }

    /*
     * Unable to fully structure code
     */
    public int send(SnmpPDU var1_1) throws SnmpException {
        block50: {
            var2_2 = null;
            if (var1_1.msg.msgVersion == 0) {
                var1_1.msg.msgVersion = this.version;
            }
            var1_1.setDebug(SnmpAPI.DEBUG);
            if (var1_1.command != -94 && var1_1.reqid == 0) {
                var1_1.reqid = this.API.genReqID();
            }
            if (var1_1.transportAddress == null) {
                if (this.protocol == 1 && var1_1.remoteHost == null && this.peername == null) {
                    SnmpAPI.debugPrintLow(SnmpUtils.getString("Remote address is not specified."));
                    throw new SnmpException(SnmpUtils.getString("No remote IP address specified."));
                }
                if (this.sasclient == null) {
                    try {
                        if (this.protocol == 1) {
                            if (var1_1.remoteHost == null) {
                                var1_1.remoteHost = this.peername;
                                if (this.cachedPeername != this.peername) {
                                    this.cachedTransportAddress = TransportAddress.getByName(this.protocol, this.peername);
                                }
                                var1_1.transportAddress = this.cachedTransportAddress;
                                this.cachedPeername = this.peername;
                            }
                            var1_1.setTransportAddress(TransportAddress.getByName(this.protocol, var1_1.remoteHost));
                        }
                        var2_2 = new SnmpTransportPacket();
                        if (var1_1.getProtocolOptions() != null) ** GOTO lbl38
                        var1_1.setProtocolOptions(this.getProtocolOptions());
                    }
                    catch (UnknownHostException var3_3) {
                        SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("UnknownHostException : ")) + " " + var3_3);
                        throw new SnmpException(SnmpUtils.getString("Session Remote Host Unknown."));
                    }
                    catch (SecurityException var3_4) {
                        SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("session.send : SecurityException while connecting to remote host: ")) + " " + var3_4);
                        throw new SnmpException(SnmpUtils.getString("Security Exception connecting to remote host"));
                    }
                } else if (var1_1.remoteHost == null) {
                    var1_1.remoteHost = this.peername;
                }
            } else if (this.sasclient != null) {
                var1_1.remoteHost = SnmpIpAddress.netbToString(var1_1.address.getAddress());
            }
lbl38:
            // 8 sources

            if (var1_1.msg.community == null) {
                var1_1.msg.community = this.community;
            }
            if (var1_1.getWriteCommunity() == null && this.writeCommunity != null) {
                var1_1.setWriteCommunity(this.writeCommunity);
            }
            if (this.protocol == 1) {
                if (this.remote_port == 0) {
                    this.remote_port = this.API.SNMP_PORT;
                }
                if (var1_1.remotePort == 0) {
                    var1_1.remotePort = this.remote_port;
                }
            }
            if (var1_1.timeout == 0) {
                var1_1.timeout = this.timeout;
            }
            if (var1_1.retries == 0) {
                var1_1.retries = this.retries;
            }
            if ((var1_1.msg.alwaysEncode || var1_1.asnParser.data == null) && !var1_1.encode(this)) {
                if (var1_1.asnParser.dataLength >= 65536) {
                    SnmpAPI.debugPrintHigh(SnmpUtils.getString("Trying to allocate a VERY BIG PDU"));
                    throw new SnmpException(SnmpUtils.getString("Trying to allocate a VERY BIG PDU"));
                }
                SnmpAPI.debugPrintHigh(String.valueOf(SnmpUtils.getString("session.send: Unable to encode PDU ")) + " " + var1_1.getEncodeError());
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Unable to encode PDU.")) + " " + var1_1.getEncodeError());
            }
            if (SnmpAPI.DEBUG) {
                if (this.protocol == 1) {
                    if (var1_1.getClientID() != 0) {
                        this.debugPrint(true, "\n" + SnmpUtils.getString("Sent Type:") + var1_1.command + " " + SnmpUtils.getString("Request ID:") + " " + var1_1.reqid + " " + SnmpUtils.getString("to") + " " + var1_1.getRemoteHost() + "  : " + var1_1.remotePort + "\n" + SnmpUtils.getString("DATA") + "\n" + this.printOctets(var1_1.asnParser.data, var1_1.asnParser.data.length), var1_1.getClientID());
                    } else {
                        this.debugPrint(String.valueOf(SnmpUtils.getString("Sent Type:")) + " " + var1_1.command + " " + SnmpUtils.getString("Request ID:") + " " + var1_1.reqid + " " + SnmpUtils.getString("to") + " " + var1_1.getRemoteHost() + "  : " + var1_1.remotePort + "\n" + SnmpUtils.getString("DATA") + "\n" + this.printOctets(var1_1.asnParser.data, var1_1.asnParser.data.length));
                    }
                } else if (var1_1.getClientID() != 0) {
                    this.debugPrint(true, "\n" + SnmpUtils.getString("Sent Type:") + "\n" + this.printOctets(var1_1.asnParser.data, var1_1.asnParser.data.length), var1_1.getClientID());
                } else {
                    this.debugPrint("\n" + SnmpUtils.getString("Sent Type:") + "\n" + this.printOctets(var1_1.asnParser.data, var1_1.asnParser.data.length));
                }
            }
            if (var1_1.command == -96 || var1_1.command == -95 || var1_1.command == -93) {
                var3_5 = var1_1.timeout;
                if (this.waitTime != 0 && this.sock != null) {
                    var3_5 = this.sock.calculateTimeExpires(var3_5);
                }
                if (this.protocol == 1) {
                    var4_9 = var1_1.getAddress();
                    if (var4_9 != null) {
                        var5_10 = SnmpIpAddress.netbToString(var4_9.getAddress());
                        if (var5_10 != null && (var5_10.endsWith(".255") || var5_10.endsWith(".0"))) {
                            var1_1.time_sent = System.currentTimeMillis();
                            var1_1.time_expires = var1_1.timeout == this.timeout ? var1_1.time_sent + 120000L : var1_1.time_sent + (long)var1_1.timeout;
                        } else {
                            var1_1.time_sent = System.currentTimeMillis();
                            var1_1.time_expires = var1_1.time_sent + (long)var3_5;
                        }
                    } else {
                        var1_1.time_sent = System.currentTimeMillis();
                        var1_1.time_expires = var1_1.time_sent + (long)var3_5;
                    }
                } else {
                    var1_1.time_sent = System.currentTimeMillis();
                    var1_1.time_expires = var1_1.time_sent + (long)var3_5;
                }
                var4_9 = null;
                var4_9 = this.protocol == 1 ? (var1_1.getClientID() != 0 ? new SimplePDU(var1_1.getClientID(), var1_1.reqid, var1_1.command, var1_1.time_sent, var1_1.time_expires, var1_1.retries, var1_1.retries > 0 ? var1_1.asnParser.data : null, var1_1.remoteHost, var1_1.remotePort, var1_1.transportAddress, var1_1.timeout) : new SimplePDU(var1_1.reqid, var1_1.command, var1_1.time_sent, var1_1.time_expires, var1_1.retries, var1_1.retries > 0 ? var1_1.asnParser.data : null, var1_1.remoteHost, var1_1.remotePort, var1_1.transportAddress, var1_1.timeout)) : (var1_1.getClientID() != 0 ? new SimplePDU(var1_1.getClientID(), var1_1.reqid, var1_1.command, var1_1.time_sent, var1_1.time_expires, var1_1.retries, var1_1.retries > 0 ? var1_1.asnParser.data : null, var1_1.getProtocolOptions(), var1_1.timeout) : new SimplePDU(var1_1.reqid, var1_1.command, var1_1.time_sent, var1_1.time_expires, var1_1.retries, var1_1.retries > 0 ? var1_1.asnParser.data : null, var1_1.getProtocolOptions(), var1_1.timeout));
                if (var1_1.callBackClient != null) {
                    var4_9.setCallBack(var1_1.callBackClient);
                }
                this.enQ(this.requestList, (SimplePDU)var4_9);
                SnmpAPI.debugPrintLow("\n " + SnmpUtils.getString("Placed PDU in request queue."));
            }
            if (this.group != null) {
                this.group.processOutPackets(var1_1);
            }
            try {
                if (this.sasclient != null) {
                    try {
                        this.sasclient.send(var1_1.remoteHost, var1_1.remotePort, var1_1.asnParser.data);
                        break block50;
                    }
                    catch (TransportException var3_6) {
                        throw new SnmpException(String.valueOf(SnmpUtils.getString("Error in sending pdu : ")) + " " + var3_6.getMessage());
                    }
                }
                try {
                    if (this.protocol == 1) {
                        this.sock.send(TransportPacket.getInstance(this.protocol, var1_1.asnParser.data, var1_1.asnParser.data.length, var1_1.transportAddress, var1_1.remotePort));
                    } else {
                        var2_2.setProtocolData(var1_1.asnParser.data);
                        var2_2.setProtocolOptions(var1_1.getProtocolOptions());
                        this.transportProvider.write(var2_2);
                    }
                }
                catch (Exception var3_7) {
                    SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("session.send: error while sending ")) + " " + var3_7);
                    throw new IOException(String.valueOf(SnmpUtils.getString("Send Error: ")) + " " + var3_7);
                }
            }
            catch (IOException var3_8) {
                SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("session.send: IO error while sending ")) + " " + var3_8);
                throw new SnmpException(String.valueOf(SnmpUtils.getString("IO error sending PDU.")) + " " + var3_8);
            }
        }
        return var1_1.reqid;
    }

    public SnmpVar set(SnmpOID snmpOID, SnmpVar snmpVar) throws SnmpException {
        return this.snmpRequest((byte)-93, snmpOID, snmpVar);
    }

    public SnmpVar set(String string, String string2, byte by) throws SnmpException {
        SnmpOID snmpOID = new SnmpOID(string);
        if (snmpOID.toValue() == null) {
            SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("Specified OID : ")) + " " + string + " " + SnmpUtils.getString(" is invalid"));
            throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid OID String: ")) + " " + string);
        }
        SnmpVar snmpVar = SnmpVar.createVariable(string2, by);
        return this.snmpRequest((byte)-93, snmpOID, snmpVar);
    }

    public void setCallbackthread(boolean bl) {
        this.CALLBACK_THREAD = bl;
    }

    public void setCommunity(String string) {
        this.community = string;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connListener = connectionListener;
    }

    public void setLocalAddresses(String[] stringArray) {
        this.local_addrs = stringArray;
    }

    public void setLocalPort(int n) {
        this.local_port = n;
    }

    public void setPacketBufferSize(int n) {
        if (n > 8000) {
            this.packetBufferSize = n;
        }
    }

    public void setPeername(String string) {
        this.peername = string;
    }

    public void setProtocol(int n) {
        this.protocol = n;
    }

    public void setProtocolOptions(ProtocolOptions protocolOptions) {
        this.protocolOptions = protocolOptions;
    }

    public void setRemotePort(int n) {
        this.remote_port = n;
    }

    public void setRetries(int n) {
        this.retries = n;
    }

    public void setSASProtocol(int n) {
        sasProtocol = n;
    }

    public void setSocketParms(int n, int n2) {
        if (n > 25) {
            this.socketTimeout = n;
        }
        if (n2 > 500) {
            this.socketDelay = n2;
        }
    }

    public void setStartLocalPort(int n) {
        startLocalPort = n;
    }

    public void setTimeToWait(int n) {
        this.waitTime = n;
        this.sock.setTimeToWait(n);
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public void setWriteCommunity(String string) {
        this.writeCommunity = string;
    }

    SnmpVar snmpRequest(byte by, SnmpOID snmpOID, SnmpVar snmpVar) throws SnmpException {
        SnmpPDU snmpPDU = new SnmpPDU();
        snmpPDU.command = by;
        if (by == -93) {
            SnmpVarBind snmpVarBind = new SnmpVarBind();
            snmpVarBind.oid = snmpOID;
            snmpVarBind.variable = snmpVar;
            snmpPDU.variables.addElement(snmpVarBind);
        } else {
            snmpPDU.addNull(snmpOID);
        }
        snmpPDU = this.syncSend(snmpPDU);
        if (snmpPDU == null) {
            return null;
        }
        if (snmpPDU.errstat != 0) {
            SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("Response had a non-zero errorStatus value : ")) + " " + snmpPDU.errstat + ". " + SnmpUtils.getString("ErrorString is ") + " " + SnmpException.exceptionString((byte)snmpPDU.errstat));
            throw new SnmpException(SnmpException.exceptionString((byte)snmpPDU.errstat));
        }
        try {
            return ((SnmpVarBind)snmpPDU.variables.firstElement()).variable;
        }
        catch (NoSuchElementException noSuchElementException) {
            SnmpAPI.debugPrintMedium(SnmpUtils.getString("No elements in varbind. Returning null"));
            return null;
        }
    }

    public SnmpPDU syncSend(SnmpPDU snmpPDU) throws SnmpException {
        int n;
        int n2 = snmpPDU.retries == 0 ? this.retries : snmpPDU.retries;
        long l = snmpPDU.timeout == 0 ? this.timeout : snmpPDU.timeout;
        long l2 = System.currentTimeMillis() + l;
        int n3 = 1;
        while (n3 <= n2) {
            l += l;
            l2 += l;
            ++n3;
        }
        this.send(snmpPDU);
        boolean bl = false;
        do {
            int n4;
            if ((n4 = this.checkSyncResponse(n = snmpPDU.reqid)) == -1) {
                return null;
            }
            if (n4 <= 0) continue;
            return (SnmpPDU)this.deQ(this.responseList, n);
        } while (this.waitTime != 0 || System.currentTimeMillis() <= l2 + 1000L);
        SnmpAPI.debugPrintMedium(String.valueOf(SnmpUtils.getString("SyncSend request Failed: ")) + " " + n);
        return null;
    }
}

