/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.utils.SnmpUtils;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;

public class SnmpString
extends SnmpVar {
    static final byte[] s_emptyString = new byte[0];
    String value;
    byte[] byteValue = s_emptyString;
    public static String enc = SnmpAPI.ENCODING;

    protected SnmpString() {
    }

    public SnmpString(String string) {
        this(string, enc);
    }

    public SnmpString(String string, String string2) {
        try {
            enc = string2 != null ? string2 : (string2 = SnmpAPI.ENCODING);
            this.Type = (byte)4;
            if (string == null) {
                return;
            }
            if (string.startsWith("'") && string.endsWith("'") && string.indexOf(":") != -1) {
                try {
                    String string3 = string.substring(1, string.length() - 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                    byte[] byArray = new byte[stringTokenizer.countTokens()];
                    int n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if (string3.length() > 2) {
                            throw new Exception();
                        }
                        byArray[n] = (byte)Integer.parseInt(string3, 16);
                        ++n;
                    }
                    this.byteValue = byArray;
                    this.value = new String(byArray, 0);
                    return;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {}
        this.value = string;
        int n = this.value.length();
        this.byteValue = null;
        if (string2 == null) {
            this.byteValue = this.value.getBytes();
        } else {
            try {
                this.byteValue = this.value.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Encoding Not Supported ")) + " " + unsupportedEncodingException.getMessage() + " " + string2);
                this.byteValue = this.value.getBytes();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Error getting method to encode ")) + " " + noSuchMethodError.getMessage());
                this.byteValue = this.value.getBytes();
            }
        }
    }

    public SnmpString(byte[] byArray) {
        this.Type = (byte)4;
        if (byArray == null) {
            return;
        }
        this.byteValue = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.byteValue, 0, byArray.length);
    }

    int encode(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeOctets(byArray, n, this.byteValue, 0, this.byteValue.length, 4);
    }

    public boolean equals(Object object) {
        try {
            if (object != null && object instanceof SnmpString) {
                SnmpString snmpString = (SnmpString)object;
                byte[] byArray = snmpString.toBytes();
                if (byArray.length != this.byteValue.length) {
                    return false;
                }
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (byArray[n2] != this.byteValue[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public Object getVarObject() {
        return this.toValue();
    }

    static SnmpVar newInstance(byte[] byArray) {
        SnmpString snmpString = new SnmpString();
        snmpString.Type = (byte)4;
        snmpString.byteValue = byArray;
        return snmpString;
    }

    public String toByteString() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer(this.byteValue.length * 3);
        int n = 0;
        while (n < this.byteValue.length) {
            string = Integer.toString(this.byteValue[n] & 0xFF, 16);
            stringBuffer.append(string.length() == 1 ? "0" + string : string);
            stringBuffer.append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public byte[] toBytes() {
        byte[] byArray = new byte[this.byteValue.length];
        System.arraycopy(this.byteValue, 0, byArray, 0, this.byteValue.length);
        return byArray;
    }

    public String toString() {
        if (!enc.equals(SnmpAPI.ENCODING)) {
            enc = SnmpAPI.ENCODING;
        }
        if (this.value == null && enc != null) {
            try {
                this.value = new String(this.byteValue, enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Encoding Not Supported ")) + " " + unsupportedEncodingException.getMessage() + " " + enc);
                this.value = new String(this.byteValue, 0);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Error getting method to encode ")) + " " + noSuchMethodError.getMessage());
                this.value = new String(this.byteValue, 0);
            }
        } else if (this.value == null) {
            this.value = new String(this.byteValue, 0);
        }
        return this.value;
    }

    public String toTagString() {
        return "STRING: " + this.toString();
    }

    public Object toValue() {
        return this.toString();
    }
}

