/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.SnmpVar;

public class SnmpUnsignedInt
extends SnmpVar {
    long value = 0L;
    byte[] byteValue;

    public SnmpUnsignedInt(long l) {
        this.value = l;
        this.Type = (byte)66;
    }

    int encode(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        return ASNTypes.encodeUInt(byArray, n, (int)this.value, 66);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SnmpUnsignedInt)) {
            return false;
        }
        SnmpUnsignedInt snmpUnsignedInt = (SnmpUnsignedInt)object;
        return this.value == snmpUnsignedInt.longValue();
    }

    public Object getVarObject() {
        return this.toValue();
    }

    public long longValue() {
        return this.value;
    }

    public byte[] toBytes() {
        if (this.byteValue == null) {
            this.byteValue = new byte[4];
            int n = (int)this.value;
            int n2 = this.byteValue.length;
            while (n != 0) {
                this.byteValue[--n2] = (byte)(n & 0xFF);
                n >>>= 8;
            }
        }
        return this.byteValue;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public String toTagString() {
        return "UNSIGNED: " + Long.toString(this.value);
    }

    public Object toValue() {
        return new Long(this.value);
    }
}

