/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpCounter;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpGauge;
import com.adventnet.snmp.snmp2.SnmpInt;
import com.adventnet.snmp.snmp2.SnmpIpAddress;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpOpaque;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpTimeticks;
import com.adventnet.utils.SnmpUtils;
import java.io.Serializable;

public abstract class SnmpVar
implements Serializable {
    byte Type;

    SnmpVar() {
    }

    public static SnmpVar createVariable(String string, byte by) throws SnmpException {
        if (by == 4) {
            return new SnmpString(string);
        }
        if (by == 64) {
            return new SnmpIpAddress(string);
        }
        if (by == 68) {
            return new SnmpOpaque(string);
        }
        if (by == 6) {
            SnmpOID snmpOID = new SnmpOID(string);
            if (snmpOID.value == null) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Invalid OID format: ")) + " " + string + " " + SnmpUtils.getString(" while creating SnmpVar"));
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid OID format: ")) + " " + string);
            }
            return snmpOID;
        }
        if (by == 2) {
            int n;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Invalid OID format: ")) + " " + string + " " + SnmpUtils.getString(" while creating SnmpVar"));
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for : ")) + " " + string);
            }
            return new SnmpInt(n);
        }
        if (by == 67) {
            long l;
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Invalid OID format: ")) + " " + string + " " + SnmpUtils.getString(" while creating SnmpVar"));
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for : ")) + " " + string);
            }
            return new SnmpTimeticks(l);
        }
        if (by == 65) {
            long l;
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Invalid OID format: ")) + " " + string + " " + SnmpUtils.getString(" while creating SnmpVar"));
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for : ")) + " " + string);
            }
            return new SnmpCounter(l);
        }
        if (by == 66) {
            long l;
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                SnmpAPI.debugPrintLow(String.valueOf(SnmpUtils.getString("Invalid OID format: ")) + " " + string + " " + SnmpUtils.getString(" while creating SnmpVar"));
                throw new SnmpException(String.valueOf(SnmpUtils.getString("Invalid format for : ")) + " " + string);
            }
            return new SnmpGauge(l);
        }
        return null;
    }

    abstract int encode(byte[] var1, int var2) throws ArrayIndexOutOfBoundsException;

    public byte getType() {
        return this.Type;
    }

    public String getTypeString() {
        if (this.Type == 2) {
            return "INTEGER";
        }
        if (this.Type == 4) {
            return "STRING";
        }
        if (this.Type == 6) {
            return "OBJID";
        }
        if (this.Type == 5) {
            return "NULLOBJ";
        }
        if (this.Type == 64) {
            return "IPADDRESS";
        }
        if (this.Type == 65) {
            return "COUNTER";
        }
        if (this.Type == 66) {
            return "GAUGE";
        }
        if (this.Type == 66) {
            return "UNSIGNED32";
        }
        if (this.Type == 67) {
            return "TIMETICKS";
        }
        if (this.Type == 68) {
            return "OPAQUE";
        }
        if (this.Type == 71) {
            return "UINTEGER32";
        }
        return "UNKNOWN";
    }

    public abstract Object getVarObject();

    public abstract byte[] toBytes();

    public abstract String toString();

    public abstract String toTagString();

    public abstract Object toValue();
}

