/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ASNTypes;
import com.adventnet.snmp.snmp2.SnmpInt;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpVar;
import java.io.Serializable;

public class SnmpVarBind
implements Serializable {
    SnmpOID oid = null;
    SnmpVar variable = null;

    SnmpVarBind() {
    }

    public SnmpVarBind(SnmpOID snmpOID, SnmpVar snmpVar) {
        this.oid = snmpOID;
        this.variable = snmpVar;
    }

    int encode(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        int n2 = n;
        n = this.variable == null ? ASNTypes.encodeNull(byArray, n, 5) : this.variable.encode(byArray, n);
        n = this.oid.encode(byArray, n);
        n = ASNTypes.encodeSequence(byArray, n, n2 - n, 48);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SnmpVarBind)) {
            return false;
        }
        SnmpVarBind snmpVarBind = (SnmpVarBind)object;
        if (this == snmpVarBind) {
            return true;
        }
        if (this.oid == null && snmpVarBind.getObjectID() == null && this.variable == null && snmpVarBind.getVariable() == null) {
            return true;
        }
        if (this.oid == null && snmpVarBind.getObjectID() != null || this.oid != null && snmpVarBind.getObjectID() == null) {
            return false;
        }
        if (this.variable == null && snmpVarBind.getVariable() != null || this.variable != null && snmpVarBind.getVariable() == null) {
            return false;
        }
        if (this.variable.getType() != snmpVarBind.getVariable().getType()) {
            return false;
        }
        return this.oid.equals(snmpVarBind.getObjectID()) && this.variable.equals(snmpVarBind.getVariable());
    }

    public SnmpOID getObjectID() {
        return this.oid;
    }

    public SnmpVar getVariable() {
        return this.variable;
    }

    public void setObjectID(SnmpOID snmpOID) {
        this.oid = snmpOID;
    }

    public void setVariable(SnmpVar snmpVar) {
        this.variable = snmpVar;
    }

    public String toString() {
        String string = null;
        string = this.variable.Type == 2 ? ((SnmpInt)this.variable).toString() : this.variable.toString();
        if (this.variable.Type == 4 && (string.indexOf(0) > -1 || this.oid.toString().startsWith(".1.3.6.1.2.1.3.1.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.4.22.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.2.2.1.6"))) {
            string = ((SnmpString)this.variable).toByteString();
        }
        if (this.oid == null || this.variable == null) {
            return null;
        }
        return String.valueOf(this.oid.toString()) + ": " + string;
    }

    public String toTagString() {
        String string = null;
        string = this.variable.Type == 2 ? ((SnmpInt)this.variable).toTagString() : this.variable.toTagString();
        if (this.variable.Type == 4) {
            if (this.oid.toString().startsWith(".1.3.6.1.2.1.3.1.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.4.22.1.2") || this.oid.toString().startsWith(".1.3.6.1.2.1.2.2.1.6")) {
                string = "PhysAddress: " + ((SnmpString)this.variable).toByteString();
            } else if (string.indexOf(0) != -1) {
                string = "STRING: " + ((SnmpString)this.variable).toByteString();
            }
        }
        if (this.oid == null || this.variable == null) {
            return null;
        }
        return String.valueOf(this.oid.toTagString()) + "\n" + string;
    }
}

