/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.TcpProperty;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;

class TcpReceiver
extends Thread {
    ServerSocket servSock = null;
    private Hashtable ht = null;
    private TcpProperty property = null;

    public TcpReceiver(int n, String string, Hashtable hashtable) throws IOException {
        this.ht = hashtable;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {}
        this.servSock = new ServerSocket(n, 0, inetAddress);
    }

    public TcpReceiver(int n, Hashtable hashtable) throws IOException {
        this.ht = hashtable;
        this.servSock = new ServerSocket(n);
    }

    public void close() throws IOException {
        if (this.servSock != null) {
            this.servSock.close();
            this.servSock = null;
        }
        if (this.property != null) {
            this.property.close();
            this.property = null;
        }
        if (this.ht != null) {
            this.ht = null;
        }
    }

    public void run() {
        while (true) {
            Socket socket = null;
            try {
                socket = this.servSock.accept();
            }
            catch (IOException iOException) {
                return;
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            if (socket == null) continue;
            String string = null;
            string = String.valueOf(socket.getInetAddress().getHostName()) + socket.getPort();
            if (this.ht.containsKey(string)) continue;
            this.property = new TcpProperty(socket);
            this.ht.put(string, this.property);
        }
    }
}

