/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.snmp2;

import com.adventnet.snmp.snmp2.ProtocolOptions;
import com.adventnet.snmp.snmp2.SnmpTransportPacket;
import com.adventnet.snmp.snmp2.SnmpTransportProvider;
import com.adventnet.snmp.snmp2.TcpProperty;
import com.adventnet.snmp.snmp2.TcpProtocolOptionsImpl;
import com.adventnet.snmp.snmp2.TcpReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

public class TcpTransportImpl
implements SnmpTransportProvider {
    private InputStream is = null;
    private Socket localSocket = null;
    private TcpProperty lastProperty = null;
    private TcpProperty property = null;
    private TcpReceiver serverImpl = null;
    private Hashtable ht = null;

    public TcpTransportImpl() {
        if (this.ht == null) {
            this.ht = new Hashtable();
        }
    }

    public void close() throws IOException {
        if (this.localSocket != null) {
            this.localSocket.close();
            this.localSocket = null;
        }
        if (this.ht != null) {
            Enumeration enumeration = this.ht.elements();
            TcpProperty tcpProperty = null;
            while (enumeration.hasMoreElements()) {
                tcpProperty = (TcpProperty)enumeration.nextElement();
                tcpProperty.close();
            }
            this.ht = null;
        }
        if (this.lastProperty != null) {
            this.lastProperty.close();
            this.lastProperty = null;
        }
        if (this.serverImpl != null) {
            this.serverImpl.close();
            this.serverImpl = null;
        }
    }

    private int hexToDec(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 <<= 8;
            n3 |= byArray[n + n4 + 2] & 0xFF;
            ++n4;
        }
        return n3;
    }

    public void open(ProtocolOptions protocolOptions) throws IOException {
        String string = null;
        if (this.serverImpl == null && ((TcpProtocolOptionsImpl)protocolOptions).getLocalPort() >= 0) {
            this.serverImpl = new TcpReceiver(((TcpProtocolOptionsImpl)protocolOptions).getLocalPort(), this.ht);
            this.serverImpl.start();
        }
        if (((TcpProtocolOptionsImpl)protocolOptions).getRemotePort() > 0) {
            this.localSocket = new Socket(((TcpProtocolOptionsImpl)protocolOptions).getRemoteHost(), ((TcpProtocolOptionsImpl)protocolOptions).getRemotePort());
            string = String.valueOf(((TcpProtocolOptionsImpl)protocolOptions).getRemoteHost()) + ((TcpProtocolOptionsImpl)protocolOptions).getRemotePort();
            this.property = new TcpProperty(this.localSocket);
            this.ht.put(string, this.property);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(SnmpTransportPacket snmpTransportPacket) throws IOException {
        Enumeration enumeration = this.ht.elements();
        while (true) {
            if (!enumeration.hasMoreElements()) return -1;
            this.lastProperty = (TcpProperty)enumeration.nextElement();
            if (this.lastProperty.data == null) {
                this.lastProperty.data = new byte[snmpTransportPacket.protocolData.length];
                this.lastProperty.index = 0;
                this.lastProperty.offset = 0;
            }
            TcpProtocolOptionsImpl tcpProtocolOptionsImpl = null;
            tcpProtocolOptionsImpl = new TcpProtocolOptionsImpl(this.lastProperty.sock.getInetAddress().getHostName(), this.lastProperty.sock.getPort(), this.lastProperty.sock.getLocalPort(), this.lastProperty.sock.getLocalAddress().getHostName());
            snmpTransportPacket.setProtocolOptions(tcpProtocolOptionsImpl);
            this.lastProperty.sock.setSoTimeout(50);
            this.is = this.lastProperty.sock.getInputStream();
            if (this.is == null) return this.lastProperty.j;
            try {
                int n;
                if (this.lastProperty.j == -2) {
                    this.lastProperty.j = this.is.read(this.lastProperty.data);
                } else if (this.lastProperty.j < this.lastProperty.dataLen && !this.lastProperty.writeFlag) {
                    n = 0;
                    n = this.is.read(this.lastProperty.data, this.lastProperty.offset, this.lastProperty.dataLen - this.lastProperty.j);
                    this.lastProperty.offset -= this.lastProperty.j;
                    if (n != -1) {
                        this.lastProperty.j += n;
                    }
                }
                if (this.lastProperty.j == -1) {
                    String string = String.valueOf(this.lastProperty.sock.getInetAddress().getHostName()) + this.lastProperty.sock.getPort();
                    this.ht.remove(string);
                    throw new IOException("End of stream reached. No data available");
                }
                n = 0;
                this.lastProperty.dataLen = 0;
                this.lastProperty.writeFlag = false;
                if ((this.lastProperty.data[this.lastProperty.index + 1] & 0x80) == 128) {
                    n = this.lastProperty.data[this.lastProperty.index + 1] & 0x7F;
                    this.lastProperty.dataLen = this.hexToDec(this.lastProperty.data, this.lastProperty.index, n);
                    this.lastProperty.dataLen += n + 2;
                } else {
                    this.lastProperty.dataLen = (this.lastProperty.data[this.lastProperty.index + 1] & 0x7F) + 2;
                }
                if (this.lastProperty.j >= this.lastProperty.dataLen) {
                    System.arraycopy(this.lastProperty.data, this.lastProperty.index, snmpTransportPacket.protocolData, 0, this.lastProperty.dataLen);
                    this.lastProperty.j -= this.lastProperty.dataLen;
                    this.lastProperty.index += this.lastProperty.dataLen;
                    this.lastProperty.offset += this.lastProperty.dataLen;
                    this.lastProperty.writeFlag = true;
                    if (this.lastProperty.j != 0) return this.lastProperty.dataLen;
                    this.lastProperty.j = -2;
                    this.lastProperty.data = null;
                    return this.lastProperty.dataLen;
                }
                this.lastProperty.offset += this.lastProperty.j;
                continue;
            }
            catch (InterruptedIOException interruptedIOException) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (IOException iOException) {
                String string = String.valueOf(this.lastProperty.sock.getInetAddress().getHostName()) + this.lastProperty.sock.getPort();
                this.ht.remove(string);
                throw new IOException(iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(((Throwable)nullPointerException).getMessage());
        }
    }

    public void write(SnmpTransportPacket snmpTransportPacket) throws IOException {
        String string = null;
        Socket socket = null;
        OutputStream outputStream = null;
        string = String.valueOf(((TcpProtocolOptionsImpl)snmpTransportPacket.protocolOptions).getRemoteHost()) + ((TcpProtocolOptionsImpl)snmpTransportPacket.protocolOptions).getRemotePort();
        if (this.ht.containsKey(string)) {
            outputStream = ((TcpProperty)this.ht.get((Object)string)).sock.getOutputStream();
            if (outputStream != null) {
                outputStream.write(snmpTransportPacket.getProtocolData());
            }
        } else {
            socket = new Socket(((TcpProtocolOptionsImpl)snmpTransportPacket.protocolOptions).getRemoteHost(), ((TcpProtocolOptionsImpl)snmpTransportPacket.protocolOptions).getRemotePort());
            this.property = new TcpProperty(socket);
            this.ht.put(string, this.property);
            outputStream = this.property.sock.getOutputStream();
            if (outputStream != null) {
                outputStream.write(snmpTransportPacket.getProtocolData());
            }
        }
    }
}

