/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpPoller;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.ui.BarGraphBean;
import com.adventnet.snmp.ui.MibBrowser;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class BarDialog
extends JFrame
implements ActionListener,
ItemListener {
    JButton close;
    JButton stop;
    JButton restart;
    JCheckBox avg;
    JCheckBox abs;
    JTextField interval;
    JComboBox scale;
    MibBrowser browser;
    SnmpPoller poller;
    BarGraphBean bar;
    Font lfont;

    /*
     * Unable to fully structure code
     */
    BarDialog(MibBrowser var1_1) {
        block9: {
            block8: {
                super(SnmpUtils.getString("Bar Chart"));
                this.close = null;
                this.stop = null;
                this.restart = null;
                this.abs = null;
                this.interval = null;
                this.scale = null;
                this.lfont = SnmpUIUtils.getFont();
                this.browser = var1_1;
                var2_2 = new JPanel();
                var3_3 = new JLabel(SnmpUtils.getString("Polling Interval (sec.)"));
                var3_3.setFont(this.lfont);
                var3_3.setForeground(Color.black);
                this.interval = new JTextField("5", 4);
                this.interval.addActionListener(this);
                this.avg = new JCheckBox(SnmpUtils.getString("Average over Interval?"));
                this.avg.setFont(this.lfont);
                this.avg.addItemListener(this);
                this.abs = new JCheckBox(SnmpUtils.getString("Show Absolute Time?"));
                this.abs.setFont(this.lfont);
                this.abs.addItemListener(this);
                this.scale = new JComboBox<E>();
                this.scale.addItem(SnmpUtils.getString("Range: 300 sec."));
                this.scale.setFont(this.lfont);
                this.scale.addItem(SnmpUtils.getString("Range: 600 sec."));
                this.scale.setFont(this.lfont);
                this.scale.addItem(SnmpUtils.getString("Range: 1000 sec."));
                this.scale.setFont(this.lfont);
                this.scale.addItem(SnmpUtils.getString("Show All Points"));
                this.scale.setFont(this.lfont);
                this.close = new JButton(SnmpUtils.getString("Close"));
                this.close.setFont(this.lfont);
                this.close.addActionListener(this);
                this.stop = new JButton(SnmpUtils.getString("Stop"));
                this.stop.setFont(this.lfont);
                this.stop.addActionListener(this);
                this.restart = new JButton(SnmpUtils.getString("Restart"));
                this.restart.setFont(this.lfont);
                this.restart.addActionListener(this);
                var4_4 = new JPanel();
                var4_4.add(this.restart);
                var4_4.add(this.stop);
                var4_4.add(this.close);
                var5_5 = new GridBagLayout();
                var6_6 = new GridBagConstraints();
                var2_2.setLayout(var5_5);
                var6_6.fill = 1;
                var6_6.gridx = 0;
                var6_6.gridy = 0;
                var6_6.insets = new Insets(10, 0, 0, 0);
                var6_6.anchor = 17;
                var5_5.setConstraints(var3_3, var6_6);
                var2_2.add(var3_3);
                var6_6.gridx = 1;
                var6_6.gridy = 0;
                var6_6.insets = new Insets(10, 5, 0, 0);
                var6_6.anchor = 17;
                var5_5.setConstraints(this.interval, var6_6);
                var2_2.add(this.interval);
                var6_6.gridx = 2;
                var6_6.gridy = 0;
                var6_6.insets = new Insets(10, 20, 0, 10);
                var6_6.anchor = 13;
                var5_5.setConstraints(this.avg, var6_6);
                var2_2.add(this.avg);
                var6_6.gridwidth = 2;
                var6_6.gridx = 0;
                var6_6.gridy = 1;
                var6_6.insets = new Insets(10, 0, 0, 0);
                var6_6.anchor = 17;
                var5_5.setConstraints(this.scale, var6_6);
                var2_2.add(this.scale);
                var6_6.gridwidth = 1;
                var6_6.gridx = 2;
                var6_6.gridy = 1;
                var6_6.insets = new Insets(10, 20, 0, 5);
                var6_6.anchor = 13;
                var5_5.setConstraints(this.abs, var6_6);
                var2_2.add(this.abs);
                var6_6.gridwidth = 3;
                var6_6.gridx = 0;
                var6_6.gridy = 2;
                var6_6.insets = new Insets(10, 0, 10, 0);
                var6_6.anchor = 17;
                var5_5.setConstraints(var4_4, var6_6);
                var2_2.add(var4_4);
                var7_7 = var1_1.display.oid.getText();
                if (var7_7.trim().equals("")) {
                    Utils.err(SnmpUtils.getString("No OID Specified"));
                    return;
                }
                if ((String)var1_1.display.host.getSelectedItem() == null || ((String)var1_1.display.host.getSelectedItem()).trim().equals("")) {
                    Utils.err(SnmpUtils.getString("No Host Specified"));
                    return;
                }
                this.bar = new BarGraphBean();
                this.bar.setAbsoluteTime(false);
                this.scale.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = 0;
                        if (((String)BarDialog.this.scale.getSelectedItem()).equals(SnmpUtils.getString("Range: 300 sec."))) {
                            n = 300;
                        } else if (((String)BarDialog.this.scale.getSelectedItem()).equals(SnmpUtils.getString("Range: 600 sec."))) {
                            n = 600;
                        } else if (((String)BarDialog.this.scale.getSelectedItem()).equals(SnmpUtils.getString("Range: 1000 sec."))) {
                            n = 1000;
                        }
                        BarDialog.this.bar.setXRange(n);
                    }
                });
                this.poller = new SnmpPoller();
                this.poller.setObjectID(var7_7);
                this.poller.setTargetPort(var1_1.snmptasks.getTargetPort());
                this.bar.setTitle(String.valueOf(SnmpUtils.getString("Graphing")) + " " + this.poller.getMibOperations().toShortString(this.poller.getSnmpOID()) + " " + " on " + " " + (String)var1_1.display.host.getSelectedItem());
                var8_8 = this.poller.getMibOperations().getMibNode(this.poller.getSnmpOID());
                if (var8_8 != null) break block8;
                this.setupPolling();
                break block9;
            }
            var9_9 = this.poller.getMibOperations().getInstanceString(this.poller.getSnmpOID(), var8_8);
            if (var9_9 != null && !var9_9.equals("")) ** GOTO lbl140
            if (var8_8.getSyntax() != null && !var8_8.isTableColumn()) {
                var7_7 = String.valueOf(var7_7) + ".0";
                this.poller.setObjectID(var7_7);
                this.setupPolling();
            } else if (var8_8.isTableColumn()) {
                var10_10 = this.poller.snmpGetAllVariableBindings();
                if (var10_10 == null) {
                    Utils.err(String.valueOf(SnmpUtils.getString("Cannot get column instances: ")) + " " + var7_7);
                    return;
                }
                var11_11 = new SnmpOID[var10_10.length];
                var12_12 = "";
                var13_13 = 0;
                while (var13_13 < var11_11.length) {
                    var11_11[var13_13] = var10_10[var13_13][0].getObjectID();
                    var12_12 = String.valueOf(var12_12) + this.poller.getMibOperations().toShortString(var11_11[var13_13]) + " ";
                    ++var13_13;
                }
                this.poller.setSnmpOIDList(var11_11);
                this.setupPolling();
            } else {
                Utils.err(String.valueOf(SnmpUtils.getString("Cannot plot the chosen variable: ")) + " " + var7_7);
                return;
lbl140:
                // 1 sources

                this.setupPolling();
            }
        }
        this.getContentPane().add("Center", this.bar);
        this.getContentPane().add("South", var2_2);
        this.setSize(475, 400);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BarDialog.this.poller.stopPolling();
                BarDialog.this.poller.removeResultListener(BarDialog.this.bar);
                JFrame jFrame = (JFrame)windowEvent.getSource();
                BarGraphBean barGraphBean = (BarGraphBean)jFrame.getContentPane().getComponent(0);
                if (barGraphBean != null) {
                    barGraphBean = null;
                }
                if (jFrame != null) {
                    jFrame.getContentPane().removeAll();
                    Container container = jFrame.getContentPane();
                    container = null;
                    jFrame.dispose();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block9: {
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Close"))) {
                this.poller.stopPolling();
                this.poller.removeResultListener(this.bar);
                ((Component)this).setVisible(false);
                this.bar = null;
                JButton jButton = (JButton)actionEvent.getSource();
                JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(jButton);
                BarGraphBean barGraphBean = (BarGraphBean)jFrame.getContentPane().getComponent(0);
                jButton = null;
                if (barGraphBean != null) {
                    barGraphBean = null;
                }
                if (jFrame != null) {
                    jFrame.getContentPane().removeAll();
                    Container container = jFrame.getContentPane();
                    container = null;
                    jFrame.dispose();
                    jFrame = null;
                }
            }
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Stop"))) {
                this.poller.stopPolling();
            }
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Restart"))) {
                try {
                    int n = Integer.parseInt(this.interval.getText());
                    this.poller.setPollInterval(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid interval value: ")) + " " + this.interval.getText());
                }
                this.poller.restartPolling();
            }
            if (!actionEvent.getSource().equals(this.interval)) break block9;
            try {
                int n = Integer.parseInt(this.interval.getText());
                this.poller.setPollInterval(n);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid interval value: ")) + " " + this.interval.getText());
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof JCheckBox) {
            String string = ((JCheckBox)object).getText();
            if (string.equals(SnmpUtils.getString("Average over Interval?"))) {
                this.bar.setTimeAverage(((JCheckBox)object).isSelected());
                this.bar.repaint();
            }
            if (string.equals(SnmpUtils.getString("Show Absolute Time?"))) {
                this.bar.setAbsoluteTime(((JCheckBox)object).isSelected());
                this.bar.repaint();
            }
            return;
        }
    }

    void setupPolling() {
        this.poller.addResultListener(this.bar);
        this.poller.setSendTimeoutEvents(true);
        String string = (String)this.browser.display.host.getSelectedItem();
        if (string == null || string.trim().equals("")) {
            Utils.err(SnmpUtils.getString("No Host Specified"));
            return;
        }
        this.poller.setTargetHost(string);
        this.poller.setCommunity(this.browser.display.community.getText());
        this.poller.setPollInterval(5);
    }
}

