/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ResultEvent;
import com.adventnet.snmp.beans.ResultListener;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.ui.GraphWrapper;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.io.Serializable;

public class BarGraphBean
extends GraphWrapper
implements ResultListener,
Serializable {
    boolean check = true;
    String result = "";

    public BarGraphBean() {
        this.setup();
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
    }

    public void setNumericResult(long l) {
        this.sg.setBarGraphResult(l);
    }

    public void setResult(long l) {
        this.sg.setBarGraphResult(l);
    }

    public void setResult(ResultEvent resultEvent) {
        if (!resultEvent.isSuccess()) {
            SnmpPDU snmpPDU = (SnmpPDU)resultEvent.getResponse();
            if (snmpPDU == null) {
                Utils.err(SnmpUtils.getString("Request timed out"));
                return;
            }
            Utils.err(resultEvent.getErrorString());
            return;
        }
    }

    public void setStringResult(String string) {
        if (!this.result.equals(string)) {
            this.check = true;
        }
        if (this.check) {
            Utils.err(String.valueOf(SnmpUtils.getString("Cannot plot string values: ")) + " " + string);
            this.check = false;
            this.result = string;
        }
    }

    public void setup() {
        this.setMaxY(10L);
        this.setXGrids(0);
        this.setYGrids(0);
        this.setTitle(SnmpUtils.getString("Bar Graph"));
        this.setBgcolor(Color.black);
        this.setBarColor(Color.red);
        this.setFgcolor(Color.white);
        this.setTimeAverage(false);
        super.barGraphSetUp();
    }
}

