/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.utils.DumpConfig;
import com.adventnet.utils.ParseConfig;
import com.adventnet.utils.ParseHolder;
import java.awt.Rectangle;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class BrowserProperty {
    private boolean firstTime;
    private final String BROWSER_CONFIG_FILE = "browser.config";
    String[] keyWords;
    private Rectangle mibPos;
    private Rectangle tablePos;
    private Rectangle mbsettingsPos;
    private Rectangle describePos;
    private Rectangle debugPos;
    private Rectangle trapPos;
    private Rectangle adlgPos;
    private Rectangle helpPos;

    public BrowserProperty() {
        block5: {
            this.firstTime = true;
            this.BROWSER_CONFIG_FILE = "browser.config";
            this.keyWords = new String[]{"browser"};
            this.mibPos = new Rectangle(200, 285, 630, 195);
            this.tablePos = new Rectangle(50, 100, 700, 400);
            this.mbsettingsPos = new Rectangle(50, 100, 700, 440);
            this.describePos = new Rectangle(150, 125, 500, 350);
            this.debugPos = new Rectangle(50, 100, 500, 500);
            this.trapPos = new Rectangle(50, 100, 700, 400);
            this.adlgPos = new Rectangle(50, 100, 775, 600);
            this.helpPos = new Rectangle(100, 50, 600, 500);
            try {
                File file = new File("browser.config");
                if (file.exists()) {
                    ParseConfig parseConfig = new ParseConfig(file.getAbsolutePath(), this.keyWords);
                    if (!parseConfig.isInited()) {
                        return;
                    }
                    Vector vector = parseConfig.getKeyWordVector(this.keyWords[0]);
                    Hashtable hashtable = (Hashtable)vector.firstElement();
                    if (hashtable != null) {
                        this.setupBrowserProperties(hashtable);
                    }
                    break block5;
                }
                return;
            }
            catch (Exception exception) {}
        }
    }

    private int atoi(String string) throws NumberFormatException {
        int n = 1;
        int n2 = 0;
        while (n2 < string.length() && Character.isSpaceChar(string.charAt(n2))) {
            ++n2;
        }
        if (n2 == string.length()) {
            throw new NumberFormatException(" No Digits ");
        }
        if (string.charAt(n2) == '-' || string.charAt(n2) == '+') {
            if (string.charAt(n2) == '-') {
                n = -1;
            }
            ++n2;
        }
        int n3 = 0;
        while (n2 < string.length() && Character.isDigit(string.charAt(n2))) {
            n3 = 10 * n3 + (string.charAt(n2) - 48);
            ++n2;
        }
        while (n2 < string.length() && Character.isSpaceChar(string.charAt(n2))) {
            ++n2;
        }
        if (n2 == string.length()) {
            return n3 * n;
        }
        throw new NumberFormatException(" No Digits ");
    }

    Rectangle getAddUserDialPos() {
        return this.adlgPos;
    }

    Rectangle getDebugWinPos() {
        return this.debugPos;
    }

    Rectangle getDescribeWinPos() {
        return this.describePos;
    }

    Rectangle getHelpWinPos() {
        return this.helpPos;
    }

    Rectangle getMbSettingsWinPos() {
        return this.mbsettingsPos;
    }

    Rectangle getMibDialPos() {
        return this.mibPos;
    }

    Rectangle getTableWinPos() {
        return this.tablePos;
    }

    Rectangle getTrapWinPos() {
        return this.trapPos;
    }

    private String rectToString(Rectangle rectangle) {
        String string = new Integer(rectangle.x).toString();
        String string2 = new Integer(rectangle.y).toString();
        String string3 = new Integer(rectangle.width).toString();
        String string4 = new Integer(rectangle.height).toString();
        String string5 = String.valueOf(string) + "," + string2 + "," + string3 + "," + string4;
        return string5;
    }

    void saveConfig(boolean bl) {
        Hashtable<String, ParseHolder> hashtable = new Hashtable<String, ParseHolder>();
        ParseHolder parseHolder = null;
        parseHolder = new ParseHolder("MibDialPos", this.rectToString(this.mibPos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        parseHolder = new ParseHolder("TablePos", this.rectToString(this.tablePos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        parseHolder = new ParseHolder("MbSettingsWinPos", this.rectToString(this.mbsettingsPos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        parseHolder = new ParseHolder("DescribeWinPos", this.rectToString(this.describePos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        parseHolder = new ParseHolder("DebugWinPos", this.rectToString(this.debugPos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        parseHolder = new ParseHolder("HelpWinPos", this.rectToString(this.helpPos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        parseHolder = new ParseHolder("TrapWinPos", this.rectToString(this.trapPos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        parseHolder = new ParseHolder("V3SettingsPos", this.rectToString(this.adlgPos));
        hashtable.put(parseHolder.propertyName, parseHolder);
        new DumpConfig(hashtable, null, null, "browser.config", this.keyWords, bl);
    }

    void setAddUserDialPos(Rectangle rectangle) {
        this.adlgPos = rectangle;
    }

    void setDebugWinPos(Rectangle rectangle) {
        this.debugPos = rectangle;
    }

    void setDescribeWinPos(Rectangle rectangle) {
        this.describePos = rectangle;
    }

    void setHelpWinPos(Rectangle rectangle) {
        this.helpPos = rectangle;
    }

    void setMbSettingsWinPos(Rectangle rectangle) {
        this.mbsettingsPos = rectangle;
    }

    void setMibDialPos(Rectangle rectangle) {
        this.mibPos = rectangle;
    }

    void setTableWinPos(Rectangle rectangle) {
        this.tablePos = rectangle;
    }

    void setTrapWinPos(Rectangle rectangle) {
        this.trapPos = rectangle;
    }

    private void setupBrowserProperties(Hashtable hashtable) {
        ParseHolder parseHolder = (ParseHolder)hashtable.get("MibDialPos");
        if (parseHolder != null) {
            this.mibPos = this.stringToRect(parseHolder.propertyValue);
        }
        if ((parseHolder = (ParseHolder)hashtable.get("TablePos")) != null) {
            this.tablePos = this.stringToRect(parseHolder.propertyValue);
        }
        if ((parseHolder = (ParseHolder)hashtable.get("MbSettingsWinPos")) != null) {
            this.mbsettingsPos = this.stringToRect(parseHolder.propertyValue);
        }
        if ((parseHolder = (ParseHolder)hashtable.get("DescribeWinPos")) != null) {
            this.describePos = this.stringToRect(parseHolder.propertyValue);
        }
        if ((parseHolder = (ParseHolder)hashtable.get("DebugWinPos")) != null) {
            this.debugPos = this.stringToRect(parseHolder.propertyValue);
        }
        if ((parseHolder = (ParseHolder)hashtable.get("HelpWinPos")) != null) {
            this.helpPos = this.stringToRect(parseHolder.propertyValue);
        }
        if ((parseHolder = (ParseHolder)hashtable.get("TrapWinPos")) != null) {
            this.trapPos = this.stringToRect(parseHolder.propertyValue);
        }
        if ((parseHolder = (ParseHolder)hashtable.get("v3SettingsPos")) != null) {
            this.adlgPos = this.stringToRect(parseHolder.propertyValue);
        }
    }

    private Rectangle stringToRect(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 1;
        int n5 = stringTokenizer.countTokens();
        Rectangle rectangle = null;
        if (n5 < 4 || n5 > 4) {
            return null;
        }
        try {
            int n6 = 0;
            while (n6 < n5) {
                switch (n6) {
                    case 0: {
                        n = this.atoi(stringTokenizer.nextToken());
                        break;
                    }
                    case 1: {
                        n2 = this.atoi(stringTokenizer.nextToken());
                        break;
                    }
                    case 2: {
                        n3 = this.atoi(stringTokenizer.nextToken());
                        break;
                    }
                    case 3: {
                        n4 = this.atoi(stringTokenizer.nextToken());
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                ++n6;
            }
            rectangle = new Rectangle(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {}
        return rectangle;
    }
}

