/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpPropertyListener;
import com.adventnet.snmp.mibs.LeafSyntax;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.ui.LoadDialog;
import com.adventnet.snmp.ui.MbDisplayPanel;
import com.adventnet.snmp.ui.MbSettingsFrame;
import com.adventnet.snmp.ui.MibBrowser;
import com.adventnet.snmp.ui.MibBrowserModel;
import com.adventnet.snmp.ui.MibBrowserUI;
import com.adventnet.snmp.ui.MibTree;
import com.adventnet.snmp.ui.NodeData;
import com.adventnet.snmp.ui.NodeSystemTreeModel;
import com.adventnet.snmp.ui.SnmpTasks;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class DefaultMibBrowserModel
implements MibBrowserModel {
    SnmpTasks snmptasks;
    MibBrowserUI browserUi = null;
    MibOperations mibOps;
    MbSettingsFrame settingsFrame = null;
    MibBrowser browser = null;
    MibTree tree = null;
    LoadDialog load = null;
    private Vector selComp = null;
    private String version = "v1";
    boolean inited = false;
    boolean hideJdbc = false;
    String[] values = null;
    int trapport = 162;
    MibModule currModule = null;
    MibModule tempModule = null;
    Vector tempModVector = new Vector();
    String searchString = null;
    Enumeration moduleEnum = null;
    boolean moduleCheck = true;
    NodeSystemTreeModel model;
    private Vector nodeNameVec = new Vector();
    private String partStr = null;
    private boolean isCaseSens = false;
    private boolean isWholeWord = false;
    MibNode remNode = null;
    String description = "";
    StringTokenizer st = null;
    StringTokenizer spaceToken = null;
    StringBuffer sb = null;

    public DefaultMibBrowserModel(SnmpTasks snmpTasks, MibBrowserUI mibBrowserUI) {
        this.snmptasks = snmpTasks;
        this.mibOps = snmpTasks.getMibOperations();
        this.browserUi = mibBrowserUI;
    }

    public Vector addPathInfo(TreePath[] treePathArray) {
        this.selComp = new Vector(1);
        int n = 0;
        while (n < treePathArray.length) {
            MibNode mibNode;
            Object object = treePathArray[n].getLastPathComponent();
            if (object instanceof NodeData && !((NodeData)object).isMibTrap() && !((NodeData)object).isMibTC() && (mibNode = ((NodeData)object).node) != null) {
                this.selComp.addElement(mibNode);
            }
            ++n;
        }
        return this.selComp;
    }

    public void addSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        this.snmptasks.addSnmpPropertyListener(snmpPropertyListener);
    }

    public void cleanUp() {
        if (this.browserUi.debugWindow != null) {
            this.browserUi.debugWindow.dispose();
        }
        if (this.browserUi.mbframe != null) {
            this.browserUi.mbframe.dispose();
        }
        if (this.snmptasks != null) {
            this.snmptasks.cleanUp();
        }
    }

    public void deleteMib(MibTree mibTree) throws Exception {
        if (mibTree.getSelectedMibModule() instanceof MibModule) {
            mibTree.deleteMib(mibTree.getSelectedMibModule().getName());
        } else if (mibTree.isGlobalView && mibTree.getSelectedMibNode() instanceof MibNode) {
            mibTree.deleteMib(" ");
        }
    }

    public void deleteMibs(MibTree mibTree) throws Exception {
        Enumeration enumeration = this.mibOps.getMibModules();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibTree.deleteMib(mibModule.getName());
        }
    }

    public boolean findNext(String string, boolean bl, boolean bl2, boolean bl3) {
        if (this.mibOps == null) {
            return false;
        }
        MibNode mibNode = null;
        if (bl) {
            mibNode = this.getMibNode(string, bl2, bl3);
        } else {
            Object object;
            MibModule mibModule = null;
            if (this.tree.isGlobalView()) {
                object = this.mibOps.getMibModules();
                while (object.hasMoreElements()) {
                    mibModule = (MibModule)object.nextElement();
                }
            } else {
                this.currModule = this.getSelectedModule();
            }
            if (this.tree.isGlobalView()) {
                if (mibModule == null) {
                    return false;
                }
                object = null;
                TreePath treePath = null;
                TreeModel treeModel = null;
                MibModule mibModule2 = null;
                int n = 0;
                Enumeration enumeration = this.mibOps.getMibModules();
                while (enumeration.hasMoreElements()) {
                    this.currModule = (MibModule)enumeration.nextElement();
                    mibNode = this.partialFind(string, this.currModule, bl2, bl3);
                    if (mibNode != null) {
                        Object object2;
                        MibNode mibNode2 = mibNode;
                        object = this.tree.getTree();
                        Vector vector = n == 0 ? this.currModule.getRootNodes() : mibModule2.getRootNodes();
                        int n2 = 2;
                        if (!vector.contains(mibNode)) {
                            while (mibNode.getParent() != null) {
                                if (vector.contains(mibNode = mibNode.getParent())) break;
                                ++n2;
                            }
                        }
                        Object[] objectArray = new Object[n2 + 1];
                        treeModel = ((JTree)object).getModel();
                        objectArray[0] = object2 = treeModel.getRoot();
                        objectArray[1] = object2 = treeModel.getChild(object2, 0);
                        mibNode = mibNode2;
                        int n3 = n2;
                        while (n3 > 1) {
                            objectArray[n3] = mibNode2;
                            mibNode2 = mibNode2.getParent();
                            --n3;
                        }
                        treePath = new TreePath(objectArray);
                        int n4 = treePath.getPathCount();
                        Object[] objectArray2 = new Object[n4];
                        objectArray2 = treePath.getPath();
                        int n5 = 0;
                        object2 = treeModel.getRoot();
                        int n6 = 1;
                        while (n6 < n4) {
                            int n7 = 0;
                            int n8 = treeModel.getChildCount(object2);
                            String string2 = objectArray2[n6].toString();
                            int n9 = 0;
                            while (n9 < n8 && !((NodeData)treeModel.getChild(object2, n9)).toString().equals(string2)) {
                                ++n9;
                            }
                            if (n9 < n8) {
                                Object object3 = object2 = treeModel.getChild(object2, n9);
                                int n10 = n5;
                                while (n10 < ((JTree)object).getRowCount()) {
                                    if (((NodeData)object2).node == null) {
                                        object2 = treeModel.getChild(object2, 0);
                                    }
                                    if (!((JTree)object).isExpanded(n10)) {
                                        ((JTree)object).expandRow(n10);
                                    }
                                    if (((JTree)object).getPathForRow(n10).getLastPathComponent().toString().equals(((NodeData)object2).toString())) {
                                        NodeData nodeData = (NodeData)((JTree)object).getPathForRow(n10).getLastPathComponent();
                                        MibNode mibNode3 = nodeData.node;
                                        if (mibNode3.getCommonAncestorWith(mibNode) == null && vector.size() > 1) {
                                            object2 = treeModel.getChild(object3, 1);
                                        } else if (mibNode3.getNumberedOIDString().equals(((NodeData)object2).node.getNumberedOIDString())) {
                                            n7 = n10;
                                            break;
                                        }
                                    }
                                    ++n10;
                                }
                                if (n6 == n4 - 1 || ((NodeData)object2).toString().equals(mibNode.getLabel())) {
                                    ((JTree)object).setSelectionRow(n7);
                                } else {
                                    ((JTree)object).expandRow(n7);
                                }
                                n5 = n7;
                            }
                            ++n6;
                        }
                        return true;
                    }
                    mibModule2 = this.currModule;
                    ++n;
                }
            } else {
                mibNode = this.currModule == null ? this.getMibNode(string, bl2, bl3) : this.partialFind(string, this.currModule, bl2, bl3);
            }
        }
        if (mibNode != null) {
            this.tree.setSelectedMibNode(mibNode);
            this.tree.getTree().scrollPathToVisible(this.tree.getTree().getSelectionPath());
            return true;
        }
        this.nodeNameVec.removeAllElements();
        this.tempModVector.removeAllElements();
        this.moduleCheck = true;
        return false;
    }

    public String getAccess(NodeData nodeData) {
        String string = nodeData.node.printAccess();
        return string;
    }

    public String getAgentPort() {
        return String.valueOf(this.snmptasks.getTargetPort());
    }

    public String getCommunity() {
        return this.browserUi.display.community.getText();
    }

    public String getDescription(NodeData nodeData) {
        String string = nodeData.node.getDescription();
        return string;
    }

    public MbDisplayPanel getDisplay() {
        return this.browserUi.display;
    }

    public String getHostname() {
        return this.getTargetHost();
    }

    public Vector getIndexNames(NodeData nodeData) {
        Vector vector = nodeData.node.getIndexNames();
        return vector;
    }

    public MibBrowser getMibBrowser() {
        return this.browser;
    }

    public String getMibModules() {
        return this.tree.getMibModule();
    }

    public MibNode getMibNode(String string, boolean bl, boolean bl2) {
        if (this.mibOps == null) {
            return null;
        }
        do {
            MibNode mibNode = null;
            mibNode = this.partialFind(string, this.currModule, bl, bl2);
            if (mibNode != null) {
                return mibNode;
            }
            this.currModule = this.getModuleFromEnum();
        } while (this.currModule != null);
        return null;
    }

    public MibOperations getMibOperations() {
        return this.snmptasks.getMibOperations();
    }

    public MibTree getMibTree() {
        return this.tree;
    }

    private MibModule getModuleFromEnum() {
        MibModule mibModule = null;
        if (this.moduleCheck) {
            this.moduleEnum = this.tree.mibOps.getMibModules();
            this.moduleCheck = false;
        }
        if (this.moduleEnum.hasMoreElements()) {
            mibModule = (MibModule)this.moduleEnum.nextElement();
        }
        return mibModule;
    }

    public String getMultipleObjectID() {
        return this.browserUi.display.oid.getText();
    }

    public Vector getMultipleOids() {
        return this.snmptasks.getMultipleOids();
    }

    private Vector getNodesVector(MibModule mibModule) {
        Vector<String> vector = null;
        if (mibModule == null) {
            return null;
        }
        Vector<MibNode> vector2 = new Vector<MibNode>();
        vector = new Vector<String>();
        Vector vector3 = mibModule.getRootNodes();
        int n = 0;
        while (n < vector3.size()) {
            MibNode mibNode = (MibNode)vector3.elementAt(n);
            vector2.addElement(mibNode);
            vector.addElement(mibNode.getLabel());
            ++n;
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            MibNode mibNode = (MibNode)vector2.elementAt(n2);
            Vector vector4 = mibNode.getChildList();
            int n3 = 0;
            while (n3 < vector4.size()) {
                MibNode mibNode2 = (MibNode)vector4.elementAt(n3);
                vector2.addElement((MibNode)vector4.elementAt(n3));
                vector.addElement(vector4.elementAt(n3).toString());
                ++n3;
            }
            ++n2;
        }
        return vector;
    }

    public String getNumberedOIDString(NodeData nodeData) {
        String string = nodeData.node.getNumberedOIDString();
        return string;
    }

    public String getNumericObjectID() {
        try {
            String string = this.browserUi.display.oid.getText();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            SnmpOID snmpOID = this.snmptasks.getMibOperations().getSnmpOID(string);
            MibNode mibNode = this.snmptasks.getMibOperations().getMibNode(snmpOID);
            String string2 = snmpOID.toString();
            if (mibNode != null && mibNode.isScalar() && !string2.endsWith(".0")) {
                string2 = String.valueOf(string2) + ".0";
            }
            return string2;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error getting OID: ")) + " " + exception.getMessage());
            return null;
        }
    }

    public String getOIDString(NodeData nodeData) {
        String string = nodeData.node.getOIDString();
        return string;
    }

    public String getObjectID() {
        return this.browserUi.display.oid.getText().trim();
    }

    public boolean getOverwriteCMI() {
        return this.snmptasks.getOverwriteCMI();
    }

    Vector getPathInfo() {
        return this.selComp;
    }

    public String getReference(NodeData nodeData) {
        String string = nodeData.node.getReference();
        return string;
    }

    public String getRetries() throws NumberFormatException {
        return String.valueOf(this.snmptasks.getRetries());
    }

    public MibModule getSelectedModule() {
        return this.tree.getSelectedMibModule();
    }

    public String getSerializedMibFileName() {
        return this.snmptasks.getSerializedMibFileName();
    }

    public String getSetValue() {
        return (String)this.browserUi.display.setval.getEditor().getItem();
    }

    public String[] getSetValues() {
        return this.snmptasks.getSetValues();
    }

    public MbSettingsFrame getSettingsFrame() {
        return this.settingsFrame;
    }

    public SnmpTasks getSnmpTasks() {
        return this.snmptasks;
    }

    public String getStatus(NodeData nodeData) {
        String string = nodeData.node.getStatus();
        return string;
    }

    public String getSyntax(NodeData nodeData) {
        LeafSyntax leafSyntax = nodeData.node.getSyntax();
        return leafSyntax.getName();
    }

    public String getTargetHost() {
        return this.snmptasks.getTargetHost();
    }

    public Vector getTargetHostNames() {
        return this.browserUi.display.hostVector;
    }

    public int getTargetPort() {
        return this.snmptasks.getTargetPort();
    }

    public String getTimeout() {
        return String.valueOf(this.snmptasks.getTimeout());
    }

    public int getTrapPort() {
        return this.trapport;
    }

    String getVersionString() {
        return this.version;
    }

    public String getWriteCommunity() {
        return this.browserUi.display.writeCommunity.getText();
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) throws ClassNotFoundException, SQLException {
        if (this.values == null) {
            this.values = new String[4];
        }
        this.values[0] = string;
        this.values[1] = string2;
        this.values[2] = string3;
        this.values[3] = string4;
        try {
            this.snmptasks.initJdbcParams(string, string2, string3, string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.inited = false;
            throw classNotFoundException;
        }
        catch (SQLException sQLException) {
            this.inited = false;
            throw sQLException;
        }
        this.inited = true;
    }

    public boolean isLoadFromCompiledMibs() {
        return this.snmptasks.isLoadFromCompiledMibs();
    }

    public boolean isLoadFromSerializedMibs() {
        return this.snmptasks.isLoadFromSerializedMibs();
    }

    public boolean isLoadMibsFromDatabase() {
        return this.snmptasks.isLoadMibsFromDatabase();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.snmptasks.isOverwriteMibsInDatabase();
    }

    public boolean isReadDesc() {
        return this.snmptasks.isReadDesc();
    }

    public boolean isSerializeMibs() {
        return this.snmptasks.isSerializeMibs();
    }

    public void loadMib(String string) {
        block7: {
            try {
                this.browserUi.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Loading MIB ")) + " " + string + "\n");
                this.tree.addMibs(string);
                this.browserUi.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Done")) + ".\n\n");
                if (string.startsWith("\"") && string.endsWith("\"")) {
                    string = string.substring(1, string.length() - 1);
                }
                if (this.browser.applet == null) {
                    string = String.valueOf(string) + "|" + this.tree.mibOps.getModuleNameDefinition(string);
                } else {
                    String string2 = this.browser.applet.getCodeBase().toString();
                    try {
                        string = String.valueOf(string) + "|" + this.browser.tree.mibOps.getModuleNameDefinition(String.valueOf(string2) + string);
                    }
                    catch (Exception exception) {
                        string = String.valueOf(string) + "|" + this.browser.tree.mibOps.getModuleNameDefinition(string);
                    }
                }
                this.updateUI(string);
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Loading MIB Failed: ")) + " " + exception.getMessage());
                if (!this.snmptasks.getDebug()) break block7;
                exception.printStackTrace();
            }
        }
    }

    public MibNode partialFind(String string, MibModule mibModule, boolean bl, boolean bl2) {
        MibNode mibNode = null;
        if (mibModule == null) {
            return null;
        }
        Vector vector = this.getNodesVector(mibModule);
        if (vector == null) {
            return null;
        }
        if (!(this.tree.getSelectedMibNode() != null && this.remNode != null && this.tree.getSelectedMibNode().getLabel().equals(this.remNode.getLabel()) && string.equals(this.partStr) && this.isWholeWord == bl2 && this.isCaseSens == bl && mibModule.getName().equals(this.tempModule.getName()))) {
            this.nodeNameVec.removeAllElements();
            this.tempModVector.removeAllElements();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().toString();
            if (bl2 && !bl) {
                if (string.toLowerCase().equals(string2.toLowerCase()) && !this.nodeNameVec.contains(string2)) {
                    mibNode = mibModule.getMibNodeByName(string2);
                }
            } else if (!bl2 && bl) {
                if (string2.indexOf(string) != -1 && !this.nodeNameVec.contains(string2)) {
                    mibNode = mibModule.getMibNodeByName(string2);
                }
            } else if (!bl2 && !bl) {
                if (string2.toLowerCase().indexOf(string.toLowerCase()) != -1 && !this.nodeNameVec.contains(string2)) {
                    mibNode = mibModule.getMibNodeByName(string2);
                }
            } else if (bl2 && bl && string2.equals(string) && !this.nodeNameVec.contains(string2)) {
                mibNode = mibModule.getMibNodeByName(string);
            }
            if (mibNode == null) continue;
            this.nodeNameVec.addElement(string2);
            this.partStr = string;
            this.isWholeWord = bl2;
            this.isCaseSens = bl;
            this.tempModule = mibModule;
            this.remNode = mibNode;
            return mibNode;
        }
        this.partStr = string;
        this.isWholeWord = bl2;
        this.isCaseSens = bl;
        this.tempModule = mibModule;
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readFile() {
        int n;
        Object object;
        if (this.browser.applet == null) {
            BufferedReader bufferedReader;
            String string = new String("");
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("DataParams.store")));
            }
            catch (Exception exception) {
                return;
            }
            this.values = new String[4];
            int n2 = 0;
            try {
                while ((string = bufferedReader.readLine()) != null) {
                    this.values[n2++] = string.trim();
                }
                if (bufferedReader == null) return;
                bufferedReader.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        String string2 = "DataParams.store";
        try {
            byte[] byArray;
            block17: {
                block16: {
                    dataOutputStream.writeInt(3);
                    dataOutputStream.writeUTF(string2);
                    byArray = null;
                    byArray = byteArrayOutputStream.toByteArray();
                    if (this.browser.applet != null && (object = this.browser.applet.getParameter("PROTOCOL")) != null && ((String)object).trim().equals("2")) {
                        return;
                    }
                    if (this.browser.browserUi.sasclient == null) break block16;
                    MibBrowserUI mibBrowserUI = this.browser.browserUi;
                    if (mibBrowserUI.sasclient.isFileReadWrite()) break block17;
                }
                if (this.browser.browserUi.sasclient != null) return;
                System.err.println(SnmpUtils.getString("Not connected to sas"));
                return;
            }
            byArray = this.browser.browserUi.sasclient.clientCall(byArray);
            if (byArray == null) {
                return;
            }
            object = new DataInputStream(new ByteArrayInputStream(byArray));
            n = ((DataInputStream)object).readInt();
            if (n != 4) return;
            string = ((DataInputStream)object).readUTF();
        }
        catch (IOException iOException) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error in opening the file : ")) + " " + iOException.getMessage());
            return;
        }
        this.values = new String[4];
        int n3 = 0;
        object = new StringTokenizer(string, "\n");
        n = ((StringTokenizer)object).countTokens();
        if (n == 1) {
            return;
        }
        int n4 = 0;
        while (n4 < n) {
            this.values[n3++] = ((StringTokenizer)object).nextToken().trim();
            if (n3 == 4) return;
            ++n4;
        }
    }

    public void removeSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        this.snmptasks.removeSnmpPropertyListener(snmpPropertyListener);
    }

    public void setAgentPort(String string) throws NumberFormatException {
        this.snmptasks.setTargetPort(Integer.parseInt(string));
    }

    public void setCommunity(String string) {
        ((JTextComponent)this.browserUi.display.community).setText(string);
    }

    public void setDebug(boolean bl) {
        this.snmptasks.setDebug(bl);
    }

    public void setHostname(String string) {
        this.setTargetHost(string);
    }

    public void setLoadFromCompiledMibs(boolean bl) {
        this.snmptasks.setLoadFromCompiledMibs(bl);
    }

    public void setLoadFromSerializedMibs(boolean bl) {
        this.snmptasks.setLoadFromSerializedMibs(bl);
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.snmptasks.setLoadMibsFromDatabase(bl);
    }

    public void setMibBrowser(MibBrowser mibBrowser) {
        this.browser = mibBrowser;
    }

    public void setMibModules(String string) {
        block14: {
            try {
                String string2;
                this.browserUi.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Loading MIBs ")) + " " + string + "\n");
                this.tree.addMibs(string);
                this.browserUi.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Done")) + ".\n\n");
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \"\t\n\r|", true);
                Vector<String> vector = new Vector<String>();
                int n = stringTokenizer.countTokens();
                int n2 = 0;
                while (n2 < n) {
                    block13: {
                        String string3 = stringTokenizer.nextToken();
                        if (string3.equals("\"")) {
                            try {
                                string3 = "";
                                string2 = stringTokenizer.nextToken();
                                ++n2;
                                if (string2.equals("\"")) break block13;
                                do {
                                    string3 = String.valueOf(string3) + string2;
                                    string2 = stringTokenizer.nextToken();
                                    ++n2;
                                } while (!string2.equals("\""));
                            }
                            catch (Exception exception) {}
                        }
                        if (!(string3.equals(" ") || string3.equals("|") || string3.equals("\"") || string3.equals("\t") || string3.equals("\n") || string3.equals("\r"))) {
                            vector.addElement(string3);
                        }
                    }
                    ++n2;
                }
                n = vector.size();
                int n3 = 0;
                while (n3 < n) {
                    String string4;
                    string2 = (String)vector.elementAt(n3);
                    if (this.browser.applet == null) {
                        string4 = String.valueOf(string2) + "|" + this.browser.tree.mibOps.getModuleNameDefinition(string2);
                        this.updateUI(string4);
                    } else {
                        String string5;
                        string4 = this.browser.applet.getCodeBase().toString();
                        try {
                            string5 = String.valueOf(string2) + "|" + this.browser.tree.mibOps.getModuleNameDefinition(String.valueOf(string4) + string2);
                            this.updateUI(string5);
                        }
                        catch (Exception exception) {
                            string5 = String.valueOf(string2) + "|" + this.browser.tree.mibOps.getModuleNameDefinition(string2);
                            this.updateUI(string5);
                        }
                    }
                    ++n3;
                }
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Loading MIBs Failed: ")) + " " + exception.getMessage());
                if (!this.snmptasks.getDebug()) break block14;
                exception.printStackTrace();
            }
        }
    }

    public void setMibTree(MibTree mibTree) {
        this.tree = mibTree;
    }

    public void setMibTreeExpandable(boolean bl) {
        this.snmptasks.expandTree = bl;
    }

    public void setMultipleObjectID(String string) {
        this.browserUi.display.oid.setText(string);
    }

    public void setObjectID(String string) {
        this.browserUi.display.oid.setText(string);
    }

    public void setOverwriteCMI(boolean bl) {
        this.snmptasks.setOverwriteCMI(bl);
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.snmptasks.setOverwriteMibsInDatabase(bl);
    }

    public void setReadDesc(boolean bl) {
        this.snmptasks.setReadDesc(bl);
    }

    public void setRetries(String string) throws NumberFormatException {
        this.snmptasks.setRetries(Integer.parseInt(string));
    }

    public void setSerializeMibs(boolean bl) {
        this.snmptasks.setSerializeMibs(bl);
    }

    public void setSerializedMibFileName(String string) {
        this.snmptasks.setSerializedMibFileName(string);
    }

    public void setSetValue(String string) {
        if (string.equals("") || string == null) {
            return;
        }
        this.browserUi.display.updateSetValue(string);
    }

    public void setSettingsFrame(MbSettingsFrame mbSettingsFrame) {
        this.settingsFrame = mbSettingsFrame;
    }

    public void setTargetHost(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.browserUi.display.updateHost(string);
        this.snmptasks.setTargetHost(string);
    }

    public void setTargetHostNames(Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.setTargetHost((String)enumeration.nextElement());
            }
        }
    }

    public void setTargetPort(int n) {
        this.snmptasks.setTargetPort(n);
    }

    public void setTimeout(String string) throws NumberFormatException {
        this.snmptasks.setTimeout(Integer.parseInt(string));
    }

    public void setTrapPort(int n) {
        this.trapport = n;
    }

    void setVersionString(String string) {
        this.version = string;
    }

    public void setWriteCommunity(String string) {
        ((JTextComponent)this.browserUi.display.writeCommunity).setText(string);
    }

    public void unloadMib(String string) {
        block2: {
            try {
                this.tree.deleteMib(string);
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Unloading MIB Failed: ")) + " " + exception.getMessage());
                if (!this.snmptasks.getDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    void updateUI(String string) {
        StringTokenizer stringTokenizer = null;
        stringTokenizer = this.browser.applet == null ? new StringTokenizer(string, "|") : new StringTokenizer(string, "|\n");
        String string2 = "";
        String string3 = "";
        if (stringTokenizer.countTokens() != 1) {
            string3 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (!this.browserUi.mibHashtable.containsKey(string2)) {
                this.browserUi.mibHashtable.put(string2, string3);
                this.browserUi.addMibMenu(string2);
            } else {
                this.browserUi.reArrangeMenu(string2);
            }
            this.browserUi.writeToConfig(string);
        }
    }

    public void v3Settings() {
    }

    public void valueChangedPassed(NodeData nodeData) {
        if (nodeData instanceof NodeData) {
            if (nodeData.isMibTrap()) {
                this.browserUi.display.nodeoid.setText(" ");
                this.browserUi.display.oid.setText(" ");
                this.browserUi.display.syntax.setText("");
                this.browserUi.display.syntax.setCaretPosition(0);
                this.browserUi.display.access.setText(" ");
                this.browserUi.display.status.setText(" ");
                this.browserUi.display.reference.setText(" ");
                this.browserUi.display.index.setText("");
                this.description = nodeData.mibTrap.getDescription();
                if (this.description != null) {
                    this.st = new StringTokenizer(this.description, "\n", true);
                    this.sb = new StringBuffer(" ");
                    while (this.st.hasMoreTokens()) {
                        this.spaceToken = new StringTokenizer(this.st.nextToken(), " \t");
                        while (this.spaceToken.hasMoreTokens()) {
                            this.sb.append(String.valueOf(this.spaceToken.nextToken()) + " ");
                        }
                    }
                }
                if (this.sb != null) {
                    this.description = new String(this.sb);
                }
                this.browserUi.display.descr.setText(this.description);
                this.browserUi.display.descr.setCaretPosition(0);
            } else if (nodeData.isMibTC()) {
                this.browserUi.display.nodeoid.setText(" ");
                this.browserUi.display.oid.setText(" ");
                this.browserUi.display.syntax.setText(nodeData.mibTC.getSyntax().getDescription());
                this.browserUi.display.syntax.setCaretPosition(0);
                this.browserUi.display.access.setText(" ");
                this.browserUi.display.status.setText(" ");
                this.browserUi.display.reference.setText(" ");
                this.browserUi.display.index.setText("");
                this.browserUi.display.descr.setText(" ");
                this.browserUi.display.descr.setCaretPosition(0);
            } else if (nodeData.node != null) {
                LeafSyntax leafSyntax;
                this.browserUi.display.nodeoid.setText(nodeData.node.getNumberedOIDString());
                MibNode mibNode = this.mibOps.getMibNode(this.mibOps.getSnmpOID(this.browserUi.display.oid.getText()));
                String string = "";
                String string2 = "";
                if (mibNode != null) {
                    string = mibNode.getLabel();
                }
                if (!string.equals(string2 = nodeData.node.getLabel())) {
                    this.browserUi.display.oid.setText(nodeData.node.getOIDString());
                }
                if ((leafSyntax = nodeData.node.getSyntax()) != null) {
                    this.browserUi.display.syntax.setText(leafSyntax.getDescription());
                    this.browserUi.display.syntax.setCaretPosition(0);
                } else {
                    this.browserUi.display.syntax.setText("");
                    this.browserUi.display.syntax.setCaretPosition(0);
                }
                this.browserUi.display.access.setText(nodeData.node.printAccess());
                this.browserUi.display.status.setText(nodeData.node.getStatus());
                this.browserUi.display.reference.setText(nodeData.node.getReference());
                Vector vector = nodeData.node.getIndexNames();
                this.browserUi.display.index.setText("");
                if (vector != null) {
                    int n = 0;
                    while (n < vector.size()) {
                        this.browserUi.display.index.setText(String.valueOf(this.browserUi.display.index.getText()) + vector.elementAt(n) + " ");
                        ++n;
                    }
                }
                this.description = nodeData.node.getDescription();
                if (this.description != null) {
                    this.st = new StringTokenizer(this.description, "\n", true);
                    this.sb = new StringBuffer(" ");
                    while (this.st.hasMoreTokens()) {
                        this.spaceToken = new StringTokenizer(this.st.nextToken(), " \t");
                        while (this.spaceToken.hasMoreTokens()) {
                            this.sb.append(String.valueOf(this.spaceToken.nextToken()) + " ");
                        }
                    }
                    if (this.sb != null) {
                        this.description = new String(this.sb);
                    }
                    this.browserUi.display.descr.setText(this.description);
                    this.browserUi.display.descr.setCaretPosition(0);
                } else {
                    this.browserUi.display.descr.setText("");
                }
            } else {
                this.browserUi.display.nodeoid.setText(" ");
                this.browserUi.display.oid.setText(" ");
                this.browserUi.display.syntax.setText("");
                this.browserUi.display.syntax.setCaretPosition(0);
                this.browserUi.display.access.setText("");
                this.browserUi.display.status.setText("");
                this.browserUi.display.reference.setText("");
                this.browserUi.display.index.setText("");
                this.browserUi.display.descr.setText("");
                this.browserUi.display.descr.setCaretPosition(0);
            }
        }
    }
}

