/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ClippedTable;
import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.beans.SnmpTable;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.ui.BaseColumnClass;
import com.adventnet.snmp.ui.MessageWindow;
import com.adventnet.snmp.ui.SnmpTablePanel;
import com.adventnet.snmp.ui.SnmpTablePanelModel;
import com.adventnet.snmp.ui.SnmpTablePanelUI;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.TextField;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;

class DefaultSnmpTablePanelModel
extends ClippedTable
implements SnmpTablePanelModel {
    private int visibleColumnCount = 5;
    private int visibleRowCount = 5;
    private boolean split = false;
    private int columnsPerGet = 0;
    private boolean isGetFromIndex = false;
    private boolean retrievalMode = false;
    private int columnIndex = 0;
    private String[] customColumnNames = null;
    private JTable table = null;
    private Vector columnNames = null;
    private Vector columnMibNodes = null;
    private boolean isRowAddAndDel = false;
    boolean isUpdateScrollBar = false;
    private int ADDandDELcol = 0;
    private boolean isEntryStatus = false;
    private String tableoid = null;
    private int hscrbarval = 0;
    private int[] displayOrder;
    private int[] tempDisplayOrder;
    private Class[] columnClass;
    private SnmpTablePanelUI panelui = null;
    private SnmpTablePanel panel = null;
    Vector namesToIndex = new Vector();

    public DefaultSnmpTablePanelModel() {
        this.init(null);
    }

    public DefaultSnmpTablePanelModel(Applet applet) {
        super(applet);
        this.init(applet);
    }

    public void addRow(boolean bl, SnmpOID[] snmpOIDArray, String[] stringArray) throws DataException {
        this.oidList = snmpOIDArray;
        super.addRow(bl, stringArray);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    public int convertColumnIndexToModel(int n) {
        if (this.tempDisplayOrder != null && this.tempDisplayOrder.length > n + this.hscrbarval) {
            return this.tempDisplayOrder[n + this.hscrbarval];
        }
        return -1;
    }

    public void deleteRows(int[] nArray) {
        String string = new String("6");
        if (this.isEntryStatus) {
            string = new String("4");
        }
        int n = 0;
        while (n < nArray.length) {
            super.setValueAt(string, this.indeces[nArray[n]], this.ADDandDELcol);
            ++n;
        }
    }

    void enumintqSort(int n, int n2) {
        if (n >= n2) {
            return;
        }
        this.swap(n, (n + n2) / 2);
        int n3 = n;
        String string = this.getStringValueAt(this.indeces[n], this.columnIndex);
        int n4 = 0;
        boolean bl = false;
        try {
            n4 = new Integer(string.substring(string.indexOf(40) + 1, string.indexOf(41)));
        }
        catch (NumberFormatException numberFormatException) {
            bl = true;
        }
        int n5 = n + 1;
        while (n5 <= n2) {
            boolean bl2 = false;
            int n6 = 0;
            String string2 = this.getStringValueAt(this.indeces[n5], this.columnIndex);
            try {
                n6 = new Integer(string2.substring(string2.indexOf(40) + 1, string2.indexOf(41)));
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = true;
            }
            if (!(bl2 && bl || bl2 && !bl || (bl2 || !bl) && n6 > n4)) {
                this.swap(++n3, n5);
            }
            ++n5;
        }
        this.swap(n, n3);
        this.enumintqSort(n, n3 - 1);
        this.enumintqSort(n3 + 1, n2);
    }

    public void fireColumnMoved(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.hscrbarval + n;
        this.tempDisplayOrder[n3] = this.tempDisplayOrder[n3] ^ this.tempDisplayOrder[this.hscrbarval + n2];
        int n4 = this.hscrbarval + n2;
        this.tempDisplayOrder[n4] = this.tempDisplayOrder[n4] ^ this.tempDisplayOrder[this.hscrbarval + n];
        int n5 = this.hscrbarval + n;
        this.tempDisplayOrder[n5] = this.tempDisplayOrder[n5] ^ this.tempDisplayOrder[this.hscrbarval + n2];
    }

    public void fireScrollBarMoved(int n) {
        this.isUpdateScrollBar = false;
        this.hscrbarval = n;
        if (this.getColumnCount() >= this.visibleColumnCount && this.getTotalColumnCount() > this.visibleColumnCount) {
            while (this.hscrbarval > this.getTotalColumnCount() - this.getColumnCount()) {
                --this.hscrbarval;
            }
        }
    }

    public Class getColumnClass(int n) {
        try {
            if (this.columnClass == null) {
                return Class.forName("java.awt.TextField");
            }
            return this.columnClass[this.displayOrder[n + this.hscrbarval]];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getColumnCount() {
        if (this.tableoid == null) {
            if (this.oidList == null) {
                return 0;
            }
            return this.oidList.length;
        }
        Vector vector = super.getColumns();
        if (vector == null) {
            return 0;
        }
        int n = vector.size();
        if (n >= this.visibleColumnCount) {
            return this.visibleColumnCount;
        }
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public int getColumnIndex(String string) {
        MibNode mibNode = this.getMibOperations().getMibNode(string);
        if (mibNode != null) {
            return mibNode.getSubid();
        }
        return this.namesToIndex.indexOf(string);
    }

    public Vector getColumnMibNodes() {
        return this.columnMibNodes;
    }

    public String getColumnName(int n) {
        if (this.getColumnCount() >= this.visibleColumnCount && this.getTotalColumnCount() >= this.visibleColumnCount) {
            if (this.customColumnNames != null && this.customColumnNames[this.displayOrder[n + this.hscrbarval]] != null) {
                return this.customColumnNames[this.displayOrder[n + this.hscrbarval]];
            }
            MibNode mibNode = this.getColumnMibNode(this.displayOrder[n + this.hscrbarval]);
            return mibNode.getLabel();
        }
        if (this.customColumnNames != null && this.customColumnNames[this.displayOrder[n]] != null) {
            return this.customColumnNames[this.displayOrder[n]];
        }
        MibNode mibNode = this.getColumnMibNode(this.displayOrder[n]);
        return mibNode.getLabel();
    }

    public Vector getColumnNames() {
        return this.columnNames;
    }

    public byte getColumnType(int n) {
        MibNode mibNode = this.getColumnMibNode(n);
        byte by = mibNode.getSyntax().getType();
        if (by == 4 || by == 6 || by == 5 || by == 64 || by == 64 || by == 68) {
            return 2;
        }
        return 1;
    }

    public int getColumnsPerGet() {
        return this.columnsPerGet;
    }

    public boolean getColumnsSplit() {
        return this.split;
    }

    public String getDecodedInstanceStr(Vector vector) {
        MibNode mibNode;
        int[] nArray = null;
        Vector vector2 = this.getIndexMibNodes();
        Vector<SnmpVar> vector3 = new Vector<SnmpVar>();
        int n = 0;
        while (n < vector2.size()) {
            mibNode = (MibNode)vector2.elementAt(n);
            try {
                vector3.addElement(mibNode.getSyntax().createVariable(vector.elementAt(n).toString()));
            }
            catch (SnmpException snmpException) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception in encoding :")) + " " + snmpException.toString());
            }
            ++n;
        }
        mibNode = (MibNode)vector2.elementAt(0);
        nArray = mibNode.getSyntax().encodeInstanceString(vector3, vector2);
        String string = "";
        if (nArray == null) {
            return vector.elementAt(0).toString();
        }
        string = String.valueOf(string) + nArray[0];
        int n2 = 1;
        while (n2 < nArray.length) {
            string = String.valueOf(string) + "." + nArray[n2];
            ++n2;
        }
        return string;
    }

    public void getEntriesFromNext() {
        this.setNext(true);
        if (this.isGetFromIndex) {
            this.setIndexInd();
        } else {
            this.setIndex();
        }
    }

    public void getEntriesFromPrev() {
        this.setNext(false);
        if (this.isGetFromIndex) {
            this.setIndexInd();
        } else {
            this.setIndex();
        }
    }

    public void getEntriesFromRefresh() {
        this.getCurrentPage();
    }

    public void getEntriesFromStart(String string) {
        if (this.isGetFromIndex) {
            this.emptyStackInd();
            this.setStringOID(string);
            this.setIndexForIndex();
        } else {
            this.indeces = null;
            this.emptyStack();
        }
    }

    public String getIndexField(int n) {
        if (this.indeces == null || this.indeces.length <= n || n < 0) {
            return this.getInstanceStr(n);
        }
        return this.getInstanceStr(this.indeces[n]);
    }

    public Vector getIndexMibNodes() {
        return super.getIndexMibNodes();
    }

    public Vector getIndexNames() {
        return super.getIndexNames();
    }

    public Vector getNotAccessIndexColumns() {
        return super.getNotAccessIndexColumns();
    }

    public String[][] getNotAccessibleIndex() {
        return super.getNotAccessibleIndex();
    }

    public String[] getObjectIDList() {
        return super.getObjectIDList();
    }

    public int getPageNumber() {
        return this.getPageSize() - 1;
    }

    public int getRowCount() {
        return super.getPolledNumRows();
    }

    public SnmpTable getSnmpTable() {
        return this;
    }

    public SnmpTablePanel getSnmpTablePanel() {
        return this.panel;
    }

    public Vector getSnmpVarVec(int n) {
        return super.getSnmpVarVec(this.indeces[n]);
    }

    public String getTableOID() {
        return this.tableoid;
    }

    public int getTableViewColumnCount() {
        return this.visibleColumnCount;
    }

    public int getTableViewRowCount() {
        return this.getNumOfVisibleRows();
    }

    public int getTotalColumnCount() {
        if (this.columnNames == null) {
            return 0;
        }
        return this.columnNames.size();
    }

    public Object getValueAt(int n, int n2) {
        try {
            if (this.getColumnCount() >= this.visibleColumnCount && this.getTotalColumnCount() > this.visibleColumnCount) {
                if (this.tableoid == null) {
                    return this.getStringValueAt(n + 1, this.displayOrder[n2 + this.hscrbarval]);
                }
                if (this.indeces != null) {
                    return this.getStringValueAt(this.indeces[n], this.displayOrder[n2 + this.hscrbarval]);
                }
                return this.getStringValueAt(n, this.displayOrder[n2 + this.hscrbarval]);
            }
            if (this.tableoid == null) {
                return this.getStringValueAt(n + 1, this.displayOrder[n2]);
            }
            if (this.indeces != null) {
                return this.getStringValueAt(this.indeces[n], this.displayOrder[n2]);
            }
            return this.getStringValueAt(n, this.displayOrder[n2]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void init(Applet applet) {
        this.setNumOfVisibleRows(this.visibleRowCount);
    }

    void intqSort(int n, int n2) {
        if (n >= n2) {
            return;
        }
        this.swap(n, (n + n2) / 2);
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            boolean bl2 = false;
            try {
                n5 = new Integer(this.getStringValueAt(this.indeces[n4], this.columnIndex));
            }
            catch (NumberFormatException numberFormatException) {
                bl2 = true;
            }
            try {
                n6 = new Integer(this.getStringValueAt(this.indeces[n], this.columnIndex));
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (!(bl2 && bl || bl2 && !bl || (bl2 || !bl) && n5 > n6)) {
                this.swap(++n3, n4);
            }
            ++n4;
        }
        this.swap(n, n3);
        this.intqSort(n, n3 - 1);
        this.intqSort(n3 + 1, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.getColumnCount() >= this.visibleColumnCount && this.getTotalColumnCount() > this.visibleColumnCount) {
            return super.isCellEditable(0, this.tempDisplayOrder[n2 + this.hscrbarval]);
        }
        return super.isCellEditable(0, this.tempDisplayOrder[n2]);
    }

    public boolean isEntryStatus() {
        return this.isEntryStatus;
    }

    public boolean isGetFromIndex() {
        return this.isGetFromIndex;
    }

    public boolean isRowAddAndDel() {
        return this.isRowAddAndDel;
    }

    public boolean isUpdateScrollBar() {
        return this.isUpdateScrollBar;
    }

    public void prepareEntries() {
        super.run();
    }

    void qSort(int n, int n2) {
        if (n >= n2) {
            return;
        }
        this.swap(n, (n + n2) / 2);
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (this.getStringValueAt(this.indeces[n4], this.columnIndex).compareTo(this.getStringValueAt(this.indeces[n], this.columnIndex)) < 0) {
                this.swap(++n3, n4);
            }
            ++n4;
        }
        this.swap(n, n3);
        this.qSort(n, n3 - 1);
        this.qSort(n3 + 1, n2);
    }

    protected void refresh() {
        if (this.panelui != null) {
            this.panelui.tableUpdate(0);
        }
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
    }

    public void setColumnNameAt(String string, int n) {
        int n2 = 0;
        if (this.columnNames != null) {
            String string2 = (String)this.columnNames.elementAt(n + this.hscrbarval);
            n2 = this.getColumnIndex(string2);
        }
        this.customColumnNames[n + this.hscrbarval] = string;
        this.namesToIndex.setSize(this.oidList.length + 1);
        this.namesToIndex.setElementAt(string, n2);
    }

    public void setColumnOrder(int n) {
        this.columnIndex = n;
        this.sortColumn(n);
    }

    public void setColumnsPerGet(int n) {
        this.columnsPerGet = n;
        super.setVarBindCount(n);
    }

    public void setColumnsSplit(boolean bl) {
        this.split = bl;
        super.setAttemptPartial(bl);
        super.setAttemptComplete(bl);
    }

    public void setGetFromIndex(boolean bl) {
        this.isGetFromIndex = bl;
        if (bl) {
            super.setModeOfGettingTable(2);
        } else {
            super.setModeOfGettingTable(1);
        }
    }

    public void setObjectIDList(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        super.setObjectIDList(stringArray);
        this.columnNames = new Vector();
        this.columnMibNodes = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && !stringArray[n].equals("")) {
                this.columnNames.addElement(stringArray[n].substring(stringArray[n].lastIndexOf(".") + 1));
            }
            ++n;
        }
        MibOperations mibOperations = super.getMibOperations();
        this.columnMibNodes = mibOperations.getNodesFromNames(this.columnNames);
        this.tableoid = ((MibNode)this.columnMibNodes.elementAt(0)).getParent().getParent().getLabel();
        this.isRowAddAndDel = false;
        int n2 = 0;
        while (n2 < this.columnMibNodes.size()) {
            String string = ((MibNode)this.columnMibNodes.elementAt(n2)).getSyntax().toString();
            if (string.equals("RowStatus") || string.equals("EntryStatus")) {
                if (string.equals("EntryStatus")) {
                    this.isEntryStatus = true;
                }
                this.isRowAddAndDel = true;
                this.ADDandDELcol = n2;
            }
            ++n2;
        }
        this.customColumnNames = new String[this.getColumnMibNodes().size()];
        this.displayOrder = new int[stringArray.length];
        this.tempDisplayOrder = new int[stringArray.length];
        int n3 = 0;
        while (n3 < this.displayOrder.length) {
            this.displayOrder[n3] = n3;
            this.tempDisplayOrder[n3] = n3;
            ++n3;
        }
    }

    public void setSnmpTablePanel(SnmpTablePanel snmpTablePanel) {
        this.panel = snmpTablePanel;
    }

    public void setTableOID(String string) throws DataException {
        try {
            super.setTableOID(string);
            this.tableoid = string;
            this.columnMibNodes = super.getColumnMibNodes();
            this.isRowAddAndDel = false;
            this.columnNames = super.getColumns();
            int n = 0;
            while (n < this.columnMibNodes.size()) {
                String string2 = ((MibNode)this.columnMibNodes.elementAt(n)).getSyntax().toString();
                if (string2.equals("RowStatus") || string2.equals("EntryStatus")) {
                    if (string2.equals("EntryStatus")) {
                        this.isEntryStatus = true;
                    }
                    this.isRowAddAndDel = true;
                    this.ADDandDELcol = n;
                }
                ++n;
            }
            this.customColumnNames = new String[this.getColumnMibNodes().size()];
            this.displayOrder = new int[this.getTotalColumnCount()];
            this.tempDisplayOrder = new int[this.getTotalColumnCount()];
            int n2 = 0;
            while (n2 < this.displayOrder.length) {
                this.displayOrder[n2] = n2;
                this.tempDisplayOrder[n2] = n2;
                ++n2;
            }
        }
        catch (DataException dataException) {
            throw new DataException(dataException.toString());
        }
    }

    public void setTablePanelUI(SnmpTablePanelUI snmpTablePanelUI) {
        this.panelui = snmpTablePanelUI;
    }

    public void setTableViewColumnCount(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Column count cannot be negative"));
            return;
        }
        this.isUpdateScrollBar = this.visibleColumnCount != n;
        this.visibleColumnCount = n <= this.getTotalColumnCount() ? n : this.getTotalColumnCount();
    }

    public void setTableViewRowCount(int n) {
        this.setNumOfVisibleRows(n);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            return;
        }
        if (!(object instanceof TextField)) {
            this.setStringValueAt(object.toString(), this.indeces[n], this.displayOrder[n2 + this.hscrbarval]);
            this.setvalue(object, this.indeces[n], this.displayOrder[n2 + this.hscrbarval]);
            this.table.repaint();
        } else {
            String string = ((TextField)object).getText();
            this.setStringValueAt(string, this.indeces[n], this.displayOrder[n2 + this.hscrbarval]);
            this.setvalue(string, this.indeces[n], this.displayOrder[n2 + this.hscrbarval]);
            this.table.repaint();
        }
    }

    public void setupCellEditor(JTable jTable) {
        this.table = jTable;
        int n = this.getColumnCount();
        if (this.getTotalColumnCount() < this.visibleColumnCount) {
            n = this.getTotalColumnCount();
        }
        int n2 = 0;
        while (n2 < n) {
            JComponent jComponent = this.getColumnCount() >= this.visibleColumnCount ? BaseColumnClass.getCellEditor(((MibNode)this.getColumnMibNodes().elementAt(n2 + this.hscrbarval)).getSyntax()) : BaseColumnClass.getCellEditor(((MibNode)this.getColumnMibNodes().elementAt(n2)).getSyntax());
            if (jComponent != null && jComponent instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)jComponent;
                jComboBox.setOpaque(true);
                jComboBox.setForeground(Color.cyan);
                jTable.getColumnModel().getColumn(n2).setCellEditor(new DefaultCellEditor(jComboBox));
            }
            ++n2;
        }
    }

    protected void showErrorMessage(String string) {
        MessageWindow.showMessage(null, SnmpUtils.getString("Error Message"), string, 6, 60);
    }

    private void sortColumn(int n) {
        if (this.getRowCount() <= 0) {
            return;
        }
        MibNode mibNode = this.getColumnMibNode(n);
        byte by = mibNode.getSyntax().getType();
        this.indeces = new int[this.getRowCount()];
        int n2 = 0;
        while (n2 < this.indeces.length) {
            this.indeces[n2] = n2;
            ++n2;
        }
        if (mibNode.getSyntax().getEnumlabels() != null) {
            this.enumintqSort(0, this.indeces.length - 1);
        } else if (mibNode.getSyntax().getType() == 2 || mibNode.getSyntax().getType() == 65) {
            this.intqSort(0, this.indeces.length - 1);
        } else {
            this.qSort(0, this.indeces.length - 1);
        }
    }

    void swap(int n, int n2) {
        int n3 = this.indeces[n];
        this.indeces[n] = this.indeces[n2];
        this.indeces[n2] = n3;
    }
}

