/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.MibTree;
import com.adventnet.snmp.ui.SearchListener;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FindDialog
extends JDialog
implements ActionListener,
KeyListener {
    String mesg = SnmpUtils.getString("Specified node was not found\nPassed the end of MIB Tree");
    String mesg1 = SnmpUtils.getString("Please enter a MibNode and press Find Next");
    String mesg2 = SnmpUtils.getString("No mibs loaded");
    static String temp = "";
    Font lfont = SnmpUIUtils.getFont();
    JTextField text = null;
    JButton findButt = null;
    JButton closeButt = null;
    JCheckBox findAll = null;
    JCheckBox matchCase = null;
    JCheckBox matchWord = null;
    MibTree tree = null;
    JFrame frm = null;
    private SearchListener listener = null;

    public FindDialog(JFrame jFrame, MibTree mibTree) {
        super(jFrame, SnmpUtils.getString("Find"), false);
        this.tree = mibTree;
        this.frm = jFrame;
        this.text = new JTextField(temp, 50);
        this.findButt = new JButton(SnmpUtils.getString("Find Next"));
        this.findButt.setFont(this.lfont);
        this.closeButt = new JButton(SnmpUtils.getString("Close"));
        this.closeButt.setFont(this.lfont);
        this.findAll = new JCheckBox(SnmpUtils.getString("Find in All"));
        this.findAll.setFont(this.lfont);
        this.matchCase = new JCheckBox(SnmpUtils.getString("Match case"));
        this.matchCase.setFont(this.lfont);
        this.matchWord = new JCheckBox(SnmpUtils.getString("Match word "));
        this.matchWord.setFont(this.lfont);
        this.findButt.setMnemonic('F');
        this.findButt.addActionListener(this);
        this.text.addActionListener(this);
        this.closeButt.addActionListener(this);
        this.closeButt.setMnemonic('l');
        this.findAll.setMnemonic('A');
        this.matchCase.setMnemonic('c');
        this.matchWord.setMnemonic('w');
        JPanel jPanel = this.initLayout();
        this.getContentPane().add(jPanel);
        ((Component)this).setSize(400, 175);
        this.setDefaultCloseOperation(2);
        this.addKeyListener(this);
        this.addWindowListener(new WindowAdap(this.text));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Find Next")) || actionEvent.getSource() instanceof JTextField) {
            if (this.frm != null) {
                ((Component)this.frm).setCursor(Cursor.getPredefinedCursor(3));
            }
            this.fireListenerEvent();
            if (this.frm != null) {
                ((Component)this.frm).setCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Close"))) {
            temp = this.text.getText();
            this.dispose();
        }
    }

    public void addSearchListener(SearchListener searchListener) {
        if (this.listener == null) {
            this.listener = searchListener;
        }
    }

    private void fireListenerEvent() {
        if (this.listener != null) {
            if (!this.tree.mibOps.getMibModules().hasMoreElements()) {
                JOptionPane.showMessageDialog(this, this.mesg2, SnmpUtils.getString("Error Message"), 0);
                return;
            }
            if (this.text.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, this.mesg1, SnmpUtils.getString("Error Message"), 0);
                return;
            }
            if (!this.listener.findNext(this.text.getText().trim(), this.findAll.isSelected(), this.matchCase.isSelected(), this.matchWord.isSelected())) {
                JOptionPane.showMessageDialog(this, this.mesg, SnmpUtils.getString("Error Message"), 0);
            }
        }
    }

    private JPanel initLayout() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(SnmpUtils.getString("Find What"));
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        jLabel.setDisplayedMnemonic('n');
        jLabel.setLabelFor(this.text);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 7.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagLayout.setConstraints(this.text, gridBagConstraints);
        jPanel.add(this.text);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        gridBagLayout.setConstraints(this.findButt, gridBagConstraints);
        jPanel.add(this.findButt);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagLayout.setConstraints(this.findAll, gridBagConstraints);
        jPanel.add(this.findAll);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 10);
        gridBagLayout.setConstraints(this.closeButt, gridBagConstraints);
        jPanel.add(this.closeButt);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        gridBagLayout.setConstraints(this.matchCase, gridBagConstraints);
        jPanel.add(this.matchCase);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 0);
        gridBagLayout.setConstraints(this.matchWord, gridBagConstraints);
        jPanel.add(this.matchWord);
        jLabel.setToolTipText(SnmpUtils.getString("Provides a space for you to type the search string"));
        this.findButt.setToolTipText(SnmpUtils.getString("Finds the next occurance of the node name in the tree"));
        this.findAll.setToolTipText(SnmpUtils.getString("Searches for the specified node name in all the loaded modules"));
        this.matchCase.setToolTipText(SnmpUtils.getString("Searches for the specified node name matching the case entered "));
        this.matchWord.setToolTipText(SnmpUtils.getString("Searches for the specified node name matching the word entered"));
        this.closeButt.setToolTipText(SnmpUtils.getString("Closes this dialog "));
        return jPanel;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            temp = this.text.getText();
            this.dispose();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeSearchListener(SearchListener searchListener) {
        if (this.listener.equals(searchListener)) {
            this.listener = null;
        }
    }

    public void setMesg(String string) {
        this.mesg = string;
    }

    public void setStringCheckOptions(boolean bl) {
        this.findAll.setEnabled(bl);
        this.matchCase.setEnabled(bl);
        this.findAll.setToolTipText(null);
        this.matchCase.setToolTipText(null);
        this.matchWord.setText(SnmpUtils.getString("Match Entire OID"));
        this.matchWord.setToolTipText(null);
        this.findButt.setToolTipText(null);
        this.closeButt.setToolTipText(null);
    }

    class WindowAdap
    extends WindowAdapter {
        JTextField text = null;

        WindowAdap(JTextField jTextField) {
            this.text = jTextField;
        }

        public void finalize() throws Throwable {
            super.finalize();
        }

        public void windowActivated(WindowEvent windowEvent) {
            this.text.requestFocus();
        }
    }
}

