/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public class Graph
extends JPanel
implements Serializable {
    protected int width = 250;
    protected int prevwid = 0;
    protected int height = 150;
    protected int prevht = 0;
    public int noOfPages = 1;
    public boolean isScrollBarEnabled = false;
    public boolean isGraphResized = false;
    public boolean isXRangeChanged = false;
    protected int maxX1 = 0;
    protected int yValueForDisplay = 0;
    protected transient Graphics g = null;
    protected transient Graphics graph = null;
    protected transient Graphics g1 = null;
    protected transient Graphics graph1 = null;
    protected transient Graphics glegend = null;
    protected transient Image dbuf = null;
    protected transient Image dbuf1 = null;
    private String title = SnmpUtils.getString("Title");
    private boolean showTitle = true;
    private int noOfValues = 100;
    private Font titleFont = SnmpUIUtils.getFont();
    private Color bgcolor = Color.black;
    private Color fgcolor = new Color(0, 210, 0);
    private Color linecolor = Color.green;
    private Color barColor = Color.white;
    private String xLabel = SnmpUtils.getString("Time in seconds");
    private boolean showxLabel = true;
    private String yLabel = "";
    private boolean showyLabel = false;
    private boolean timeAverage = false;
    private boolean absoluteTime = false;
    protected Font scaleFont = SnmpUIUtils.getFont();
    public int minX = 0;
    public int maxX = 100;
    public int xRange = 100;
    private long minY = 0L;
    private long maxY = 10L;
    private int xGrids = 5;
    private int yGrids = 5;
    protected int[] XGrids;
    protected int[] YGrids;
    private int xScalePoints = 5;
    private int yScalePoints = 5;
    protected int[] xMarks;
    protected int[] yMarks;
    protected int markLen = 5;
    protected int dotRad = 2;
    protected Vector[] data = null;
    protected Vector[] bardata = null;
    protected Vector[] filledgraphdata = null;
    protected Vector[] tempvector = null;
    protected int halfWid = 0;
    protected Date date = null;
    protected Date date1 = null;
    private int titlex = 0;
    private int titley = 0;
    private int xLabelx = 0;
    private int xLabely = 0;
    private int yLabelx = 0;
    private int yLabely = 0;
    private int x0 = 0;
    private int y0 = 0;
    private int xEnd = 0;
    private int yEnd = 0;
    private int yLabelWidth = 0;
    private int scalewidth = 0;
    private int labelHt = 0;
    private int prevTime = 0;
    private long startTime = 0L;
    private long thresholdValue = 0L;
    private Long oldval = null;
    private Long newval = null;
    private int noOfLines = 1;
    private Color[] lineColors = new Color[]{Color.red};
    private int noOfBars = 1;
    private Color[] barColors = new Color[]{Color.blue};
    private Color[] Color_array = new Color[]{Color.white, Color.magenta, Color.red, Color.blue, Color.green};
    protected Date[] timearray = new Date[2];
    protected int count3 = 0;
    protected int x = 0;
    protected int y = 0;
    protected int boxX = 0;
    protected int boxY = 0;
    protected int boxwidth = 0;
    protected int boxheight = 0;
    protected long xval = 0L;
    protected String s = null;
    private int time = 0;

    public Graph() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Rectangle rectangle = new Rectangle();
                Graph.this.computeVisibleRect(rectangle);
                Graph.this.g1 = Graph.this.getGraphics();
                Graph.this.g1.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                Graph.this.x = mouseEvent.getX();
                Graph.this.y = mouseEvent.getY();
                Graph.this.drawLegend(Graph.this.g1);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                Graph.this.dbuf = null;
                if (Graph.this.dbuf1 != null && Graph.this.getGraphics() != null) {
                    Graphics graphics = Graph.this.getGraphics();
                    Rectangle rectangle = new Rectangle();
                    Graph.this.computeVisibleRect(rectangle);
                    graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.drawImage(Graph.this.dbuf1, 0, 0, Graph.this);
                }
            }
        });
    }

    synchronized boolean addBarGraphPoint(int n, double[] dArray) {
        if (this.bardata == null) {
            return false;
        }
        int n2 = n;
        double[] dArray2 = null;
        while (this.bardata[n2].size() > this.noOfValues) {
            dArray2 = (double[])this.bardata[n2].elementAt(0);
            this.bardata[n2].removeElementAt(0);
        }
        if (dArray2 != null) {
            this.time = (int)dArray2[0];
        }
        if (dArray[0] > (double)this.minX && dArray[0] < (double)this.maxX || dArray2 != null && dArray2[0] > (double)this.minX && dArray2[0] < (double)this.maxX) {
            if (n2 < 0 && n2 >= this.bardata.length) {
                return false;
            }
            if (this.dbuf1 == null) {
                return false;
            }
            if (dArray2 != null && dArray2[0] > (double)this.minX && dArray2[0] < (double)this.maxX) {
                if (this.dbuf1 != null) {
                    this.drawSkeletenGraph();
                    if (this.dbuf != null) {
                        if (this.getGraphics() != null) {
                            Graphics graphics = this.getGraphics();
                            Rectangle rectangle = new Rectangle();
                            this.computeVisibleRect(rectangle);
                            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            this.drawLegend(graphics);
                        }
                    } else {
                        this.repaint();
                    }
                }
            } else {
                this.graph1 = this.dbuf1.getGraphics();
                this.graph1.setColor(this.barColors[n2]);
                int n3 = this.barColors[n2].getRGB();
                double[] dArray3 = null;
                int n4 = this.halfWid * (this.xEnd - this.x0) / (this.maxX - this.minX);
                if (n4 < 1) {
                    n4 = 1;
                }
                if (this.bardata[n2].size() > 0) {
                    dArray3 = (double[])this.bardata[n2].lastElement();
                }
                if (dArray3 != null) {
                    int n5 = this.computeXPoint(dArray[0]) + n2 * n4;
                    int n6 = Math.min(n4, this.xEnd - n5);
                    this.graph1.fillRect(n5, this.computeYPoint(dArray[1]), n6, this.yEnd - this.computeYPoint(dArray[1]));
                }
                if (this.getGraphics() != null) {
                    if (this.dbuf != null) {
                        Graphics graphics = this.getGraphics();
                        Rectangle rectangle = new Rectangle();
                        this.computeVisibleRect(rectangle);
                        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        this.drawLegend(graphics);
                    } else {
                        this.repaint();
                    }
                }
            }
        }
        this.bardata[n2].addElement(dArray);
        return true;
    }

    synchronized boolean addFilledGraphPoint(int n, double[] dArray) {
        if (this.filledgraphdata == null) {
            return false;
        }
        int n2 = n;
        double[] dArray2 = null;
        while (this.filledgraphdata[n2].size() > this.noOfValues) {
            dArray2 = (double[])this.filledgraphdata[n2].elementAt(0);
            this.filledgraphdata[n2].removeElementAt(0);
        }
        if (dArray2 != null) {
            this.time = (int)dArray2[0];
        }
        if (dArray[0] > (double)this.minX && dArray[0] < (double)this.maxX || dArray2 != null && dArray2[0] > (double)this.minX && dArray2[0] < (double)this.maxX) {
            if (n2 < 0 && n2 >= this.filledgraphdata.length) {
                return false;
            }
            if (this.dbuf1 == null) {
                return false;
            }
            if (dArray2 != null && dArray2[0] > (double)this.minX && dArray2[0] < (double)this.maxX) {
                if (this.dbuf1 != null) {
                    this.drawSkeletenGraph();
                    if (this.dbuf != null) {
                        if (this.getGraphics() != null) {
                            Graphics graphics = this.getGraphics();
                            Rectangle rectangle = new Rectangle();
                            this.computeVisibleRect(rectangle);
                            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            this.drawLegend(graphics);
                        }
                    } else {
                        this.repaint();
                    }
                }
            } else {
                Object object;
                Object object2;
                this.graph1 = this.dbuf1.getGraphics();
                this.graph1.setColor(this.barColor);
                double[] dArray3 = null;
                if (this.filledgraphdata[n2].size() > 0) {
                    dArray3 = (double[])this.filledgraphdata[n2].lastElement();
                }
                if (dArray3 != null) {
                    object2 = new int[]{this.computeXPoint(dArray[0]), this.computeXPoint(dArray[0]), this.computeXPoint(dArray3[0]), this.computeXPoint(dArray3[0])};
                    object = new int[]{this.computeYPoint(dArray[1]), this.yEnd, this.yEnd, this.computeYPoint(dArray3[1])};
                    this.graph1.fillPolygon((int[])object2, (int[])object, 4);
                    this.graph1.setColor(this.fgcolor);
                    this.graph1.drawLine(this.computeXPoint(dArray3[0]), this.computeYPoint(dArray3[1]), this.computeXPoint(dArray[0]), this.computeYPoint(dArray[1]));
                }
                if (this.getGraphics() != null) {
                    if (this.dbuf != null) {
                        object2 = this.getGraphics();
                        object = new Rectangle();
                        this.computeVisibleRect((Rectangle)object);
                        ((Graphics)object2).setClip(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
                        this.drawLegend((Graphics)object2);
                    } else {
                        this.repaint();
                    }
                }
            }
        }
        this.filledgraphdata[n2].addElement(dArray);
        return true;
    }

    synchronized boolean addPoint(int n, double[] dArray) {
        if (this.data == null) {
            return false;
        }
        int n2 = n;
        double[] dArray2 = null;
        while (this.data[n2].size() > this.noOfValues) {
            dArray2 = (double[])this.data[n2].elementAt(0);
            this.data[n2].removeElementAt(0);
        }
        if (dArray2 != null) {
            this.time = (int)dArray2[0];
        }
        if (dArray[0] > (double)this.minX && dArray[0] < (double)this.maxX || dArray2 != null && dArray2[0] > (double)this.minX && dArray2[0] < (double)this.maxX) {
            if (n2 < 0 && n2 >= this.data.length) {
                return false;
            }
            if (this.dbuf1 == null) {
                return false;
            }
            if (dArray2 != null && dArray2[0] > (double)this.minX && dArray2[0] < (double)this.maxX) {
                if (this.dbuf1 != null) {
                    this.drawSkeletenGraph();
                    if (this.dbuf != null) {
                        if (this.getGraphics() != null) {
                            Graphics graphics = this.getGraphics();
                            Rectangle rectangle = new Rectangle();
                            this.computeVisibleRect(rectangle);
                            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            this.drawLegend(graphics);
                        }
                    } else {
                        this.repaint();
                    }
                }
            } else {
                this.graph1 = this.dbuf1.getGraphics();
                this.graph1.setColor(this.lineColors[n2]);
                double[] dArray3 = null;
                if (this.data[n2].size() > 0) {
                    dArray3 = (double[])this.data[n2].lastElement();
                }
                if (dArray3 != null) {
                    this.graph1.drawLine(this.computeXPoint(dArray3[0]), this.computeYPoint(dArray3[1]), this.computeXPoint(dArray[0]), this.computeYPoint(dArray[1]));
                    this.graph1.fillOval(this.computeXPoint(dArray[0]) - this.dotRad, this.computeYPoint(dArray[1]) - this.dotRad, 2 * this.dotRad, 2 * this.dotRad);
                }
                if (this.getGraphics() != null) {
                    if (this.dbuf != null) {
                        Graphics graphics = this.getGraphics();
                        Rectangle rectangle = new Rectangle();
                        this.computeVisibleRect(rectangle);
                        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        this.drawLegend(graphics);
                    } else {
                        this.repaint();
                    }
                }
            }
        }
        this.data[n2].addElement(dArray);
        return true;
    }

    public void barGraphSetUp() {
        this.bardata = new Vector[this.noOfBars];
        int n = 0;
        while (n < this.noOfBars) {
            this.bardata[n] = new Vector();
            ++n;
        }
        this.date = new Date();
        this.startTime = this.date.getTime();
        this.prevTime = -1;
    }

    public void calculatePoints() {
        FontMetrics fontMetrics;
        if (this.graph == null) {
            return;
        }
        if (this.showTitle) {
            this.graph.setFont(this.titleFont);
            fontMetrics = this.graph.getFontMetrics();
            this.titlex = (this.width - fontMetrics.stringWidth(this.title)) / 2;
            this.titley = 3 + fontMetrics.getHeight();
        } else {
            this.titley = 3;
        }
        this.graph.setFont(this.scaleFont);
        fontMetrics = this.graph.getFontMetrics();
        this.labelHt = fontMetrics.getHeight();
        if (this.showxLabel) {
            this.xLabelx = (this.width - fontMetrics.stringWidth(this.xLabel)) / 2;
            this.xLabely = this.height - 3;
        } else {
            this.xLabelx = this.width / 2;
            this.xLabely = this.height;
        }
        this.yLabelx = 3;
        this.yLabely = this.height / 2;
        this.yLabelWidth = this.showyLabel ? fontMetrics.stringWidth(this.yLabel) : 0;
        this.XGrids = new int[this.xGrids];
        this.YGrids = new int[this.yGrids];
        this.xMarks = new int[this.xScalePoints];
        this.yMarks = new int[this.yScalePoints];
        this.y0 = this.titley + 3;
        this.yEnd = this.showxLabel ? this.height - this.markLen - 2 * this.labelHt - 3 : this.height - this.markLen - this.labelHt - 3;
        int n = 0;
        while (n < this.YGrids.length) {
            this.YGrids[n] = this.yEnd + n * (this.y0 - this.yEnd) / this.yGrids;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.yMarks.length) {
            this.yMarks[n2] = this.yEnd + n2 * (this.y0 - this.yEnd) / this.yScalePoints;
            ++n2;
        }
        this.scalewidth = 0;
        int n3 = 0;
        while (n3 < this.yMarks.length) {
            Float f = new Float((float)this.minY + (float)n3 * (float)(this.maxY - this.minY) / (float)this.yScalePoints);
            String string = this.roundUp(f.toString());
            int n4 = fontMetrics.stringWidth(string);
            if (n4 > this.scalewidth) {
                this.scalewidth = n4;
            }
            ++n3;
        }
        this.x0 = this.yLabelx + this.yLabelWidth + 2 + this.scalewidth + this.markLen;
        this.xEnd = this.width - 5;
        int n5 = 0;
        while (n5 < this.XGrids.length) {
            this.XGrids[n5] = this.x0 + n5 * (this.xEnd - this.x0) / this.xGrids;
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.xMarks.length) {
            this.xMarks[n6] = this.x0 + n6 * (this.xEnd - this.x0) / this.xScalePoints;
            ++n6;
        }
    }

    protected long computeX(int n) {
        return (long)((float)this.minX + (float)(n - this.x0) * (float)(this.maxX - this.minX) / (float)(this.xEnd - this.x0));
    }

    protected int computeXPoint(double d) {
        return (int)((double)this.x0 + (double)(this.xEnd - this.x0) * (d - (double)this.minX) / (double)(this.maxX - this.minX));
    }

    protected long computeY(int n) {
        return (long)((float)this.minY + (float)(n - this.y0) * (float)(this.maxY - this.minY) / (float)(this.yEnd - this.y0));
    }

    protected int computeYPoint(double d) {
        return (int)((double)this.yEnd - (double)(this.yEnd - this.y0) * (d - (double)this.minY) / (double)(this.maxY - this.minY));
    }

    protected void drawGraph() {
        if (this.dbuf1 != null) {
            this.graph = this.dbuf1.getGraphics();
            if (this.graph != null) {
                this.calculatePoints();
                this.drawSkeletenGraph();
                this.repaint();
            }
        }
    }

    public void drawLegend(Graphics graphics) {
        int n;
        int n2;
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.dbuf = this.createImage(this.width, this.height);
        this.g = this.dbuf.getGraphics();
        if (this.dbuf1 != null) {
            this.g.drawImage(this.dbuf1, 0, 0, this);
        }
        this.g.setColor(Color.lightGray);
        this.g.drawLine(this.x, 0, this.x, this.height);
        if (this.data != null) {
            this.tempvector = this.data;
        }
        if (this.bardata != null) {
            this.tempvector = this.bardata;
        }
        if (this.filledgraphdata != null) {
            this.tempvector = this.filledgraphdata;
        }
        if ((n2 = this.tempvector.length) <= 0) {
            return;
        }
        String[] stringArray = new String[n2];
        String string = "";
        int n3 = 0;
        while (n3 < n2) {
            long l = this.computeX(this.x);
            long l2 = -1L;
            n = -1;
            int n4 = -1;
            if (this.tempvector[n3] != null) {
                Enumeration enumeration = this.tempvector[n3].elements();
                double[] dArray = null;
                while (enumeration.hasMoreElements()) {
                    dArray = (double[])enumeration.nextElement();
                    if (n < 0) {
                        n4 = (int)dArray[1];
                    }
                    n = (int)dArray[1];
                    if ((double)l < dArray[0]) {
                        if (l2 == -1L) break;
                        n = n4 + (int)((l - l2) * (long)(n - n4) / ((long)dArray[0] - l2));
                        continue;
                    }
                    l2 = (long)dArray[0];
                    n4 = (int)dArray[1];
                }
                String string2 = String.valueOf(n);
                if (n == -1) {
                    string2 = " ";
                }
                stringArray[n3] = String.valueOf(SnmpUtils.getString("Value: ")) + " " + string2;
                if (string.length() < stringArray[n3].length()) {
                    string = stringArray[n3];
                }
            }
            ++n3;
        }
        String string3 = String.valueOf(SnmpUtils.getString("Time: ")) + " " + this.computeX(this.x);
        if (this.absoluteTime) {
            string3 = String.valueOf(SnmpUtils.getString("Time: ")) + " " + this.getTimeString(this.startTime + 1000L * this.computeX(this.x));
        }
        this.g.setFont(this.scaleFont);
        FontMetrics fontMetrics = this.g.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string) > fontMetrics.stringWidth(string3) ? 10 + fontMetrics.stringWidth(string) : 10 + fontMetrics.stringWidth(string3);
        int n6 = (1 + n2) * fontMetrics.getHeight() + 10;
        this.boxX = this.x + 10;
        this.boxY = this.y + 10;
        if (this.boxX + n5 > this.width) {
            this.boxX = this.width - n5;
        }
        if (this.boxY + n6 > this.height) {
            this.boxY = this.height - n6;
        }
        this.g.fillRect(this.boxX, this.boxY, n5, n6);
        this.g.setColor(Color.darkGray);
        this.g.draw3DRect(this.boxX + 2, this.boxY + 2, n5 - 4, n6 - 4, true);
        n = 0;
        while (n < n2) {
            this.g.setColor(Color.black);
            if (stringArray[n] != null) {
                if (this.data != null) {
                    this.g.setColor(this.lineColors[n]);
                }
                if (this.bardata != null) {
                    this.g.setColor(this.barColors[n]);
                }
                if (this.filledgraphdata != null) {
                    this.g.setColor(this.barColor);
                }
                this.g.drawString(stringArray[n], this.boxX + 4, this.boxY + n6 - 5 - (n2 - n) * fontMetrics.getHeight());
            }
            ++n;
        }
        this.g.setColor(Color.black);
        this.g.drawString(string3, this.boxX + 4, this.boxY + n6 - 5);
        if (graphics != null && this.dbuf != null) {
            graphics.drawImage(this.dbuf, 0, 0, this);
        }
    }

    public synchronized void drawSkeletenGraph() {
        String string;
        Object object;
        if (this.graph == null) {
            return;
        }
        this.graph.setColor(this.bgcolor);
        this.graph.fillRect(0, 0, this.width, this.height);
        this.graph.setColor(this.fgcolor);
        this.graph.draw3DRect(1, 1, this.width - 3, this.height - 3, true);
        this.graph.setFont(this.titleFont);
        if (this.showTitle) {
            this.graph.drawString(this.title, this.titlex, this.titley);
        }
        this.graph.setFont(this.scaleFont);
        if (this.showxLabel) {
            this.graph.drawString(this.xLabel, this.xLabelx, this.xLabely);
        }
        if (this.showyLabel) {
            this.graph.drawString(this.yLabel, this.yLabelx, this.yLabely);
        }
        this.graph.drawLine(this.x0, this.yEnd, this.xEnd, this.yEnd);
        this.graph.drawLine(this.x0, this.yEnd, this.x0, this.y0);
        this.graph.drawLine(this.x0, this.y0, this.xEnd, this.y0);
        this.graph.drawLine(this.xEnd, this.y0, this.xEnd, this.yEnd);
        int n = 0;
        while (n < this.XGrids.length) {
            this.graph.drawLine(this.XGrids[n], this.yEnd, this.XGrids[n], this.y0);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.YGrids.length) {
            this.graph.drawLine(this.x0, this.YGrids[n2], this.xEnd, this.YGrids[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.xMarks.length) {
            this.graph.drawLine(this.xMarks[n3], this.yEnd, this.xMarks[n3], this.yEnd + this.markLen);
            Float f = new Float((float)this.minX + (float)n3 * (float)(this.maxX - this.minX) / (float)this.xScalePoints);
            object = f.toString();
            string = this.roundUp((String)object);
            if (this.absoluteTime) {
                string = this.getTimeString(this.startTime + (long)(1000 * (this.minX + n3 * (this.maxX - this.minX) / this.xScalePoints)));
            }
            this.graph.drawString(string, this.xMarks[n3] + 2, this.yEnd + this.markLen + this.labelHt);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.yMarks.length) {
            this.graph.drawLine(this.x0, this.yMarks[n4], this.x0 - this.markLen, this.yMarks[n4]);
            object = new Float((float)this.minY + (float)n4 * (float)(this.maxY - this.minY) / (float)this.yScalePoints);
            string = ((Float)object).toString();
            String string2 = this.roundUp(string);
            this.graph.drawString(string2, this.x0 - this.markLen - this.scalewidth, this.yMarks[n4] + 2);
            ++n4;
        }
        this.graphData();
    }

    public void filledGraphSetUp() {
        this.filledgraphdata = new Vector[1];
        this.filledgraphdata[0] = new Vector();
        this.date = new Date();
        this.startTime = this.date.getTime();
        this.prevTime = -1;
    }

    public Color getBarColor() {
        return this.barColor;
    }

    public Color[] getBarColors() {
        return this.barColors;
    }

    public Color getBgcolor() {
        return this.bgcolor;
    }

    public Color getFgcolor() {
        return this.fgcolor;
    }

    public Color[] getLineColors() {
        return this.lineColors;
    }

    public Color getLinecolor() {
        return this.linecolor;
    }

    public long getMaxY() {
        return this.maxY;
    }

    public long getMinY() {
        return this.minY;
    }

    public int getNoOfBars() {
        return this.noOfBars;
    }

    public int getNoOfLines() {
        return this.noOfLines;
    }

    public int getNoOfValues() {
        return this.noOfValues;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Font getScaleFont() {
        return this.scaleFont;
    }

    public int getTime() {
        return this.time;
    }

    private String getTimeString(long l) {
        String string = String.valueOf(l);
        Date date = new Date(l);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        string = String.valueOf(this.getTwoDigitValues(calendar.get(11))) + ":" + this.getTwoDigitValues(calendar.get(12)) + ":" + this.getTwoDigitValues(calendar.get(13));
        return string;
    }

    public String getTitle() {
        return this.title;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    private String getTwoDigitValues(int n) {
        String string = String.valueOf(n);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public int getXGrids() {
        return this.xGrids;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public int getXRange() {
        return this.xRange;
    }

    public int getXScalePoints() {
        return this.xScalePoints;
    }

    public int getYGrids() {
        return this.yGrids;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public int getYScalePoints() {
        return this.yScalePoints;
    }

    public synchronized void graphData() {
        Object object;
        Enumeration enumeration;
        int n;
        double[] dArray = null;
        if (this.data != null) {
            n = 0;
            while (n < this.data.length) {
                enumeration = this.data[n].elements();
                while (enumeration.hasMoreElements()) {
                    dArray = (double[])enumeration.nextElement();
                    if (dArray[0] > (double)this.minX) break;
                }
                if (enumeration.hasMoreElements()) {
                    this.graph.setColor(this.lineColors[n]);
                    this.graph.fillOval(this.computeXPoint(dArray[0]) - this.dotRad, this.computeYPoint(dArray[1]) - this.dotRad, 2 * this.dotRad, 2 * this.dotRad);
                }
                while (enumeration.hasMoreElements()) {
                    object = (double[])enumeration.nextElement();
                    this.graph.drawLine(this.computeXPoint(dArray[0]), this.computeYPoint(dArray[1]), this.computeXPoint((double)object[0]), this.computeYPoint((double)object[1]));
                    this.graph.fillOval(this.computeXPoint((double)object[0]) - this.dotRad, this.computeYPoint(object[1]) - this.dotRad, 2 * this.dotRad, 2 * this.dotRad);
                    dArray = object;
                    if (dArray[0] > (double)this.maxX) break;
                }
                ++n;
            }
        }
        if (this.bardata != null) {
            n = this.halfWid * (this.xEnd - this.x0) / (this.maxX - this.minX);
            if (n < 1) {
                n = 1;
            }
            int n2 = 0;
            while (n2 < this.bardata.length) {
                int n3;
                object = this.bardata[n2].elements();
                while (object.hasMoreElements()) {
                    dArray = (double[])object.nextElement();
                    if (dArray[0] > (double)this.minX) break;
                }
                if (object.hasMoreElements()) {
                    this.graph.setColor(this.barColors[n2]);
                    int n4 = this.computeXPoint(dArray[0]) + n2 * n;
                    n3 = Math.min(n, this.xEnd - n4);
                    this.graph.fillRect(n4, this.computeYPoint(dArray[1]), n3, this.yEnd - this.computeYPoint(dArray[1]));
                }
                while (object.hasMoreElements()) {
                    double[] dArray2 = (double[])object.nextElement();
                    n3 = this.computeXPoint(dArray2[0]) + n2 * n;
                    int n5 = Math.min(n, this.xEnd - n3);
                    this.graph.fillRect(n3, this.computeYPoint(dArray2[1]), n5, this.yEnd - this.computeYPoint(dArray2[1]));
                    dArray = dArray2;
                    if (dArray[0] > (double)this.maxX) break;
                }
                ++n2;
            }
        }
        if (this.filledgraphdata != null) {
            n = 0;
            while (n < this.filledgraphdata.length) {
                enumeration = this.filledgraphdata[n].elements();
                while (enumeration.hasMoreElements()) {
                    dArray = (double[])enumeration.nextElement();
                    if (dArray[0] > (double)this.minX) break;
                }
                if (enumeration.hasMoreElements()) {
                    this.graph.setColor(this.barColor);
                    object = new int[]{this.computeXPoint(dArray[0]), this.computeXPoint(dArray[0]), this.x0, this.x0};
                    int[] nArray = new int[]{this.computeYPoint(dArray[1]), this.yEnd, this.yEnd, this.computeYPoint(dArray[1])};
                    this.graph.fillPolygon((int[])object, nArray, 4);
                    this.graph.setColor(this.fgcolor);
                    this.graph.drawLine(this.x0, this.computeYPoint(dArray[1]), this.computeXPoint(dArray[0]), this.computeYPoint(dArray[1]));
                }
                while (enumeration.hasMoreElements()) {
                    this.graph.setColor(this.barColor);
                    object = (double[])enumeration.nextElement();
                    int[] nArray = new int[]{this.computeXPoint((double)object[0]), this.computeXPoint((double)object[0]), this.computeXPoint(dArray[0]), this.computeXPoint(dArray[0])};
                    int[] nArray2 = new int[]{this.computeYPoint(object[1]), this.yEnd, this.yEnd, this.computeYPoint(dArray[1])};
                    this.graph.fillPolygon(nArray, nArray2, 4);
                    this.graph.setColor(this.fgcolor);
                    this.graph.drawLine(this.computeXPoint(dArray[0]), this.computeYPoint(dArray[1]), this.computeXPoint(object[0]), this.computeYPoint(object[1]));
                    dArray = object;
                    if (dArray[0] > (double)this.maxX) break;
                }
                ++n;
            }
        }
    }

    public boolean isAbsoluteTime() {
        return this.absoluteTime;
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public boolean isShowxLabel() {
        return this.showxLabel;
    }

    public boolean isShowyLabel() {
        return this.showyLabel;
    }

    public boolean isTimeAverage() {
        return this.timeAverage;
    }

    public void lineGraphSetUp() {
        this.data = new Vector[this.noOfLines];
        int n = 0;
        while (n < this.noOfLines) {
            this.data[n] = new Vector();
            ++n;
        }
        this.date = new Date();
        this.startTime = this.date.getTime();
        this.prevTime = -1;
    }

    public synchronized void paintComponent(Graphics graphics) {
        if (this.width != this.prevwid || this.height != this.prevht) {
            this.prevwid = this.width;
            this.prevht = this.height;
            this.dbuf1 = this.createImage(this.width, this.height);
            this.drawGraph();
        }
        if (this.dbuf1 != null && this.isShowing()) {
            graphics.drawImage(this.dbuf1, 0, 0, this);
        }
    }

    public double[] results(long l) {
        this.date1 = new Date();
        int n = (int)(this.date1.getTime() - this.startTime) / 1000;
        double d = l;
        if (this.timeAverage && n > 0 && n - this.prevTime > 0) {
            d = this.prevTime >= 0 ? (d /= (double)(n - this.prevTime)) : (d /= (double)n);
            this.prevTime = n;
        }
        this.oldval = this.newval = new Long((long)d);
        double[] dArray = new double[]{n, d};
        l = (long)d;
        this.yValueForDisplay = (int)d;
        if (l > this.maxY || n > this.maxX1) {
            if (l > this.maxY) {
                long l2 = l + l / 4L;
                if (l2 % 10L != 0L) {
                    l2 += 10L - l2 % 10L;
                }
                this.maxY = l2;
                if (this.graph != null) {
                    this.calculatePoints();
                    this.drawSkeletenGraph();
                    this.repaint();
                }
            }
            if (n > this.maxX1 + this.xRange) {
                this.isScrollBarEnabled = true;
                this.isGraphResized = true;
                this.noOfPages = n / this.xRange + 1;
                this.maxX1 += this.xRange;
                ++this.width;
                this.setSize(this.width, this.height);
            } else if (this.isXRangeChanged) {
                this.isGraphResized = true;
                this.noOfPages = n / this.xRange + 1;
                this.maxX1 = this.maxX1 / this.xRange * this.xRange;
                ++this.width;
                this.setSize(this.width, this.height);
                this.isXRangeChanged = false;
            }
        }
        return dArray;
    }

    public String roundUp(String string) {
        String string2 = string;
        try {
            BigDecimal bigDecimal = new BigDecimal(new Double(string));
            BigDecimal bigDecimal2 = new BigDecimal("1");
            BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 2, 4);
            String string3 = bigDecimal3.toString();
            int n = string3.indexOf(".");
            String string4 = string3.substring(n + 1, n + 3);
            string2 = string4.equals("00") ? string3.substring(0, n) : string3;
        }
        catch (Exception exception) {}
        return string2;
    }

    public void setAbsoluteTime(boolean bl) {
        this.absoluteTime = bl;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setBarColor(Color color) {
        this.barColor = color;
        this.barColors = new Color[1];
        this.barColors[0] = color;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setBarColors(Color[] colorArray) {
        this.barColors = colorArray;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setBarGraphResult(long l) {
        Date date;
        long l2 = 0L;
        this.timearray[this.count3] = date = new Date();
        ++this.count3;
        if (this.count3 > 1) {
            l2 = this.timearray[1].getTime() - this.timearray[0].getTime();
            this.timearray[0] = this.timearray[1];
            this.count3 = 1;
        }
        this.halfWid = (int)l2 / 2000;
        if (this.halfWid < 1) {
            this.halfWid = 1;
        }
        long l3 = l;
        double[] dArray = null;
        dArray = this.results(l3);
        this.addBarGraphPoint(0, dArray);
    }

    public void setBgcolor(Color color) {
        this.bgcolor = color;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setFgcolor(Color color) {
        this.fgcolor = color;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setFilledGraphResult(long l) {
        long l2 = l;
        double[] dArray = null;
        dArray = this.results(l2);
        this.addFilledGraphPoint(0, dArray);
    }

    public void setLineColors(Color[] colorArray) {
        this.lineColors = colorArray;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setLinecolor(Color color) {
        this.linecolor = color;
        this.lineColors = new Color[1];
        this.lineColors[0] = color;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setMaxY(long l) {
        this.maxY = l;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setMinY(long l) {
        this.minY = l;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public synchronized void setMultiBarGraphResult(int n, long l) {
        this.halfWid = 1;
        long l2 = l;
        double[] dArray = null;
        dArray = this.results(l2);
        int n2 = n;
        this.addBarGraphPoint(n2, dArray);
    }

    public void setNoOfBars(int n) {
        if (n <= 0) {
            return;
        }
        this.noOfBars = n;
        this.bardata = new Vector[this.noOfBars];
        this.tempvector = new Vector[this.noOfBars];
        int n2 = 0;
        while (n2 < this.noOfBars) {
            this.bardata[n2] = new Vector();
            ++n2;
        }
        if (this.getBarColors().length != n) {
            Color[] colorArray = new Color[n];
            int n3 = 0;
            while (n3 < colorArray.length) {
                if (n3 < this.Color_array.length) {
                    colorArray[n3] = this.Color_array[n3];
                } else {
                    int n4 = n3 % this.Color_array.length;
                    colorArray[n3] = this.Color_array[n4];
                }
                ++n3;
            }
            this.setBarColors(colorArray);
        }
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setNoOfLines(int n) {
        if (n <= 0) {
            return;
        }
        this.noOfLines = n;
        this.data = new Vector[this.noOfLines];
        this.tempvector = new Vector[this.noOfLines];
        int n2 = 0;
        while (n2 < this.noOfLines) {
            this.data[n2] = new Vector();
            ++n2;
        }
        if (this.getLineColors().length != n) {
            Color[] colorArray = new Color[n];
            int n3 = 0;
            while (n3 < colorArray.length) {
                if (n3 < this.Color_array.length) {
                    colorArray[n3] = this.Color_array[n3];
                } else {
                    int n4 = n3 % this.Color_array.length;
                    colorArray[n3] = this.Color_array[n4];
                }
                ++n3;
            }
            this.setLineColors(colorArray);
        }
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setNoOfValues(int n) {
        if (n <= 0) {
            return;
        }
        this.noOfValues = n;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public synchronized void setResult(int n, long l) {
        long l2 = l;
        double[] dArray = null;
        dArray = this.results(l2);
        int n2 = n;
        this.addPoint(n2, dArray);
    }

    public void setResult(long l) {
        long l2 = l;
        double[] dArray = null;
        dArray = this.results(l2);
        this.addPoint(0, dArray);
    }

    public void setScaleFont(Font font) {
        this.scaleFont = font;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setShowTitle(boolean bl) {
        this.showTitle = bl;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setShowxLabel(boolean bl) {
        this.showxLabel = bl;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setShowyLabel(boolean bl) {
        this.showyLabel = bl;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setTimeAverage(boolean bl) {
        this.timeAverage = bl;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setXGrids(int n) {
        if (n < 0) {
            return;
        }
        this.xGrids = n;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setXLabel(String string) {
        this.xLabel = string;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setXRange(int n) {
        if (n <= 0) {
            return;
        }
        this.xRange = n;
        if (!this.isScrollBarEnabled) {
            this.maxX = n;
        } else {
            this.isXRangeChanged = true;
        }
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setXScalePoints(int n) {
        if (n < 0) {
            return;
        }
        this.xScalePoints = n;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setYGrids(int n) {
        if (n < 0) {
            return;
        }
        this.yGrids = n;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setYLabel(String string) {
        this.yLabel = string;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }

    public void setYScalePoints(int n) {
        if (n < 0) {
            return;
        }
        this.yScalePoints = n;
        if (this.dbuf1 != null) {
            this.drawGraph();
        }
    }
}

