/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpPoller;
import com.adventnet.snmp.beans.SnmpTarget;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.ui.LineGraphBean;
import com.adventnet.snmp.ui.MibBrowser;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class GraphDialog
extends JFrame
implements ActionListener,
ItemListener {
    JButton close = null;
    JButton stop = null;
    JButton restart = null;
    JCheckBox avg;
    JCheckBox abs;
    JCheckBox timeSpan;
    JCheckBox graphLog;
    JCheckBox counter = null;
    JTextField interval;
    JTextField duration;
    JTextField logField = null;
    JTextField scale = null;
    MibBrowser browser;
    SnmpPoller poller;
    LineGraphBean graph;
    boolean showVal;
    boolean storeVal = false;
    Font lfont = SnmpUIUtils.getFont();

    /*
     * Unable to fully structure code
     */
    GraphDialog(MibBrowser var1_1) {
        super(SnmpUtils.getString("Line Graph"));
        this.browser = var1_1;
        var2_2 = new JPanel();
        var3_3 = new JLabel(SnmpUtils.getString("Polling Interval (sec's.)"));
        var3_3.setFont(this.lfont);
        var3_3.setForeground(Color.black);
        var4_4 = new JLabel(SnmpUtils.getString("Max Poll Duration(sec's.)"));
        var4_4.setFont(this.lfont);
        var4_4.setForeground(Color.black);
        var5_5 = new JLabel(SnmpUtils.getString("Log FileName"));
        var5_5.setFont(this.lfont);
        var5_5.setForeground(Color.black);
        var6_6 = new JLabel(SnmpUtils.getString("X-axis Scale  (>300)"));
        var6_6.setFont(this.lfont);
        var6_6.setForeground(Color.black);
        this.interval = new JTextField("5", 4);
        this.interval.addActionListener(this);
        this.duration = new JTextField("3600", 4);
        this.duration.setEnabled(false);
        this.duration.addActionListener(this);
        this.logField = new JTextField("graph.txt", 10);
        this.logField.setEnabled(false);
        this.logField.addActionListener(this);
        this.avg = new JCheckBox(SnmpUtils.getString("Average over Interval?"));
        this.avg.addItemListener(this);
        this.avg.setFont(this.lfont);
        this.abs = new JCheckBox(SnmpUtils.getString("Show Absolute Time?"));
        this.abs.addItemListener(this);
        this.abs.setFont(this.lfont);
        this.timeSpan = new JCheckBox(SnmpUtils.getString("Show Polled Values?"));
        this.timeSpan.setFont(this.lfont);
        this.timeSpan.addItemListener(this);
        this.graphLog = new JCheckBox(SnmpUtils.getString("Log Polled Values?"));
        this.graphLog.setFont(this.lfont);
        this.graphLog.addItemListener(this);
        if (var1_1.applet != null) {
            var5_5.setEnabled(false);
            this.graphLog.setEnabled(false);
        }
        this.counter = new JCheckBox(SnmpUtils.getString("Show Absolute Counters"));
        this.counter.setFont(this.lfont);
        this.counter.addItemListener(this);
        this.scale = new JTextField("300", 4);
        this.close = new JButton(SnmpUtils.getString("Close"));
        this.close.setFont(this.lfont);
        this.close.addActionListener(this);
        this.stop = new JButton(SnmpUtils.getString("Stop"));
        this.stop.setFont(this.lfont);
        this.stop.addActionListener(this);
        this.restart = new JButton(SnmpUtils.getString("Restart"));
        this.restart.setFont(this.lfont);
        this.restart.addActionListener(this);
        var7_7 = new JPanel();
        var7_7.add(this.restart);
        var7_7.add(this.stop);
        var7_7.add(this.close);
        var8_8 = new JPanel();
        var8_8.add(this.counter);
        var9_9 = new GridBagLayout();
        var10_10 = new GridBagConstraints();
        var2_2.setLayout(var9_9);
        var10_10.fill = 1;
        var10_10.gridx = 0;
        var10_10.gridy = 0;
        var10_10.insets = new Insets(10, 0, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(var3_3, var10_10);
        var2_2.add(var3_3);
        var10_10.gridx = 1;
        var10_10.gridy = 0;
        var10_10.insets = new Insets(10, 5, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(this.interval, var10_10);
        var2_2.add(this.interval);
        var10_10.gridx = 2;
        var10_10.gridy = 0;
        var10_10.insets = new Insets(10, 20, 0, 10);
        var10_10.anchor = 13;
        var9_9.setConstraints(this.avg, var10_10);
        var2_2.add(this.avg);
        var10_10.gridx = 0;
        var10_10.gridy = 1;
        var10_10.insets = new Insets(10, 0, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(var6_6, var10_10);
        var2_2.add(var6_6);
        var10_10.gridx = 1;
        var10_10.gridy = 1;
        var10_10.insets = new Insets(10, 5, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(this.scale, var10_10);
        var2_2.add(this.scale);
        var10_10.gridx = 2;
        var10_10.gridy = 1;
        var10_10.insets = new Insets(10, 20, 0, 5);
        var10_10.anchor = 13;
        var9_9.setConstraints(this.abs, var10_10);
        var2_2.add(this.abs);
        var10_10.gridx = 0;
        var10_10.gridy = 2;
        var10_10.insets = new Insets(10, 0, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(var4_4, var10_10);
        var2_2.add(var4_4);
        var10_10.gridx = 1;
        var10_10.gridy = 2;
        var10_10.insets = new Insets(10, 5, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(this.duration, var10_10);
        var2_2.add(this.duration);
        var10_10.gridx = 2;
        var10_10.gridy = 2;
        var10_10.insets = new Insets(10, 20, 0, 5);
        var10_10.anchor = 13;
        var9_9.setConstraints(this.timeSpan, var10_10);
        var2_2.add(this.timeSpan);
        var10_10.gridx = 0;
        var10_10.gridy = 3;
        var10_10.insets = new Insets(10, 0, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(var5_5, var10_10);
        var2_2.add(var5_5);
        var10_10.gridx = 1;
        var10_10.gridy = 3;
        var10_10.insets = new Insets(10, 5, 0, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(this.logField, var10_10);
        var2_2.add(this.logField);
        var10_10.gridx = 2;
        var10_10.gridy = 3;
        var10_10.insets = new Insets(10, 20, 0, 5);
        var10_10.anchor = 13;
        var9_9.setConstraints(this.graphLog, var10_10);
        var2_2.add(this.graphLog);
        var10_10.gridwidth = 3;
        var10_10.gridx = 0;
        var10_10.gridy = 4;
        var10_10.anchor = 17;
        var9_9.setConstraints(var8_8, var10_10);
        var2_2.add(var8_8);
        var10_10.gridx = 0;
        var10_10.gridy = 5;
        var10_10.insets = new Insets(10, 0, 10, 0);
        var10_10.anchor = 17;
        var9_9.setConstraints(var7_7, var10_10);
        var2_2.add(var7_7);
        var11_11 = null;
        var12_12 = var1_1.getPathInfo();
        if (var12_12 != null && var12_12.size() > 1) {
            var11_11 = new String[var12_12.size()];
            var13_13 = 0;
            while (var13_13 < var12_12.size()) {
                var11_11[var13_13] = ((MibNode)var12_12.elementAt(var13_13)).getOIDString();
                ++var13_13;
            }
        } else {
            var13_14 = var1_1.display.oid.getText();
            if (var13_14 == null || var13_14.trim().equals("")) {
                JOptionPane.showMessageDialog(var1_1, SnmpUtils.getString("OID Not Specified"), SnmpUtils.getString("Warning Message"), 0);
                return;
            }
            var11_11 = new String[]{var13_14};
        }
        if ((String)var1_1.display.host.getSelectedItem() == null || ((String)var1_1.display.host.getSelectedItem()).trim().equals("")) {
            JOptionPane.showMessageDialog(var1_1, SnmpUtils.getString("No Host Specified"), SnmpUtils.getString("Warning Message"), 0);
            return;
        }
        this.graph = new LineGraphBean();
        if (this.graph.getTitle().equals(SnmpUtils.getString("Title"))) {
            this.graph.setTitle(String.valueOf(SnmpUtils.getString("Graphing on ")) + " " + (String)var1_1.display.host.getSelectedItem());
        }
        this.graph.setAbstime(false);
        this.scale.addActionListener(this);
        this.poller = new SnmpPoller();
        this.poller.setTargetPort(var1_1.snmptasks.getTargetPort());
        this.setupPolling();
        var13_15 = new Vector<String>();
        var14_16 = "";
        var15_17 = this.poller.getMibOperations();
        var16_18 = new SnmpOID[var11_11.length];
        var17_19 = 0;
        while (var17_19 < var16_18.length) {
            var16_18[var17_19] = var15_17.getSnmpOID(var11_11[var17_19]);
            ++var17_19;
        }
        var18_20 = 0;
        while (var18_20 < var16_18.length) {
            block19: {
                block18: {
                    var19_21 = this.poller.getMibOperations().getMibNode(var16_18[var18_20]);
                    if (var19_21 != null) break block18;
                    var13_15.addElement(var11_11[var18_20]);
                    break block19;
                }
                var20_23 = this.poller.getMibOperations().getInstanceString(var16_18[var18_20], var19_21);
                if (var20_23 != null && !var20_23.equals("")) ** GOTO lbl253
                if (var19_21.getSyntax() != null && !var19_21.isTableColumn()) {
                    v0 = var18_20;
                    var11_11[v0] = String.valueOf(var11_11[v0]) + ".0";
                    var14_16 = String.valueOf(var14_16) + this.poller.getMibOperations().toShortString(var16_18[var18_20]) + ".0 ";
                    var13_15.addElement(var11_11[var18_20]);
                } else if (var19_21.isTableColumn()) {
                    this.poller.removeResultListener(this.graph);
                    this.poller.setObjectIDList(null);
                    this.poller.setObjectID(var19_21.getNumberedOIDString());
                    var21_24 = this.poller.getSnmpOID();
                    while ((var22_25 = this.poller.snmpGetNextVariableBindings()) != null && SnmpTarget.isInSubTree((SnmpOID)var21_24, var22_25[0].getObjectID())) {
                        if (var22_25 == null) {
                            this.poller.stopPolling();
                            Utils.err(String.valueOf(SnmpUtils.getString("Cannot get column instances: ")) + " " + var11_11[var18_20]);
                            return;
                        }
                        var23_28 = new SnmpOID[var22_25.length];
                        var24_29 = 0;
                        while (var24_29 < var23_28.length) {
                            var23_28[var24_29] = var22_25[var24_29].getObjectID();
                            var14_16 = String.valueOf(var14_16) + this.poller.getMibOperations().toShortString(var23_28[var24_29]) + " ";
                            var13_15.addElement(var23_28[var24_29].toString());
                            ++var24_29;
                        }
                    }
                    this.poller.setObjectIDList(null);
                    var22_26 = 0;
                    while (var22_26 < var13_15.size()) {
                        this.poller.addObjectID((String)var13_15.elementAt(var22_26));
                        ++var22_26;
                    }
                } else {
                    this.poller.stopPolling();
                    this.poller.removeResultListener(this.graph);
                    Utils.err(String.valueOf(SnmpUtils.getString("Cannot plot the chosen variable: ")) + " " + var11_11[var18_20]);
                    return;
lbl253:
                    // 1 sources

                    var13_15.addElement(var11_11[var18_20]);
                    var21_24 = var19_21.getNumberedOIDString();
                    var22_27 = new SnmpOID((String)var21_24);
                    var14_16 = String.valueOf(var14_16) + this.poller.getMibOperations().toShortString(var22_27) + var20_23 + " ";
                }
            }
            ++var18_20;
        }
        var11_11 = new String[var13_15.size()];
        var19_22 = 0;
        while (var19_22 < var13_15.size()) {
            var11_11[var19_22] = (String)var13_15.elementAt(var19_22);
            ++var19_22;
        }
        this.poller.setObjectIDList(var11_11);
        this.poller.addResultListener(this.graph);
        this.graph.setLineLabels(var14_16);
        this.graph.setValues();
        this.getContentPane().add("Center", this.graph);
        this.getContentPane().add("South", var2_2);
        this.pack();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphDialog.this.poller.stopPolling();
                GraphDialog.this.poller.removeResultListener(GraphDialog.this.graph);
                GraphDialog.this.poller.releaseResources();
                JFrame jFrame = (JFrame)windowEvent.getSource();
                LineGraphBean lineGraphBean = (LineGraphBean)jFrame.getContentPane().getComponent(0);
                if (lineGraphBean != null) {
                    lineGraphBean = null;
                }
                if (jFrame != null) {
                    jFrame.getContentPane().removeAll();
                    Container container = jFrame.getContentPane();
                    container = null;
                    jFrame.dispose();
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block34: {
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Close"))) {
                this.poller.stopPolling();
                this.poller.removeResultListener(this.graph);
                this.poller.releaseResources();
                ((Component)this).setVisible(false);
                this.graph = null;
                JButton jButton = (JButton)actionEvent.getSource();
                JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(jButton);
                LineGraphBean lineGraphBean = (LineGraphBean)jFrame.getContentPane().getComponent(0);
                jButton = null;
                if (lineGraphBean != null) {
                    lineGraphBean = null;
                }
                if (jFrame != null) {
                    jFrame.getContentPane().removeAll();
                    Container container = jFrame.getContentPane();
                    container = null;
                    jFrame.dispose();
                    jFrame = null;
                }
            }
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Stop"))) {
                this.poller.stopPolling();
                this.timeSpan.setEnabled(true);
                if (this.browser.applet == null) {
                    this.graphLog.setEnabled(true);
                }
                if (this.showVal) {
                    this.duration.setEnabled(true);
                }
                if (this.storeVal) {
                    this.logField.setEnabled(true);
                }
            }
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Restart"))) {
                this.poller.removeResultListener(this.graph);
                this.poller.stopPolling();
                if (this.showVal) {
                    try {
                        int n = Integer.parseInt(this.duration.getText());
                        this.graph.setPollDuration(n);
                        this.scale.setEnabled(true);
                        if (this.graph.jsb != null) {
                            this.graph.jsb.setEnabled(true);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.graph.setPollDuration(this.graph.getPollDuration());
                        System.err.println(String.valueOf(SnmpUtils.getString("Non Numeric value:")) + " " + this.duration.getText());
                        this.duration.setText(String.valueOf(this.graph.getPollDuration()));
                    }
                    int n = 300;
                    try {
                        n = Integer.parseInt(this.scale.getText());
                        if (n < 300) {
                            System.err.println(String.valueOf(SnmpUtils.getString("Invalid X-axis Scale value:")) + " " + n);
                            this.scale.setText(String.valueOf(this.graph.getXscale()));
                            return;
                        }
                        this.graph.setXscale(n);
                        this.graph.repaint();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.graph.setXscale(this.graph.getXscale());
                        System.err.println(SnmpUtils.getString("Scale value should be an integer"));
                        this.scale.setText(String.valueOf(this.graph.getXscale()));
                    }
                } else {
                    this.graph.setPollDuration(0);
                    if (this.graph.jsb != null) {
                        this.graph.jsb.setEnabled(false);
                    }
                    this.scale.setEnabled(false);
                }
                if (this.storeVal) {
                    try {
                        this.graph.setLogFileName(this.logField.getText());
                    }
                    catch (NullPointerException nullPointerException) {
                        this.graph.setLogFileName(this.graph.getLogFileName());
                        System.err.println(SnmpUtils.getString("FileName not specified"));
                    }
                }
                try {
                    int n = Integer.parseInt(this.interval.getText());
                    this.poller.setPollInterval(n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.poller.setPollInterval(this.poller.getPollInterval());
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid interval value: ")) + " " + this.interval.getText());
                    this.interval.setText(String.valueOf(this.poller.getPollInterval()));
                }
                this.graph.setValues();
                this.poller.addResultListener(this.graph);
                this.poller.restartPolling();
            }
            if (actionEvent.getSource().equals(this.interval)) {
                try {
                    int n = Integer.parseInt(this.interval.getText());
                    this.poller.setPollInterval(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid interval value: ")) + " " + this.interval.getText());
                    this.interval.setText(String.valueOf(this.poller.getPollInterval()));
                }
            }
            if (actionEvent.getSource().equals(this.duration)) {
                try {
                    int n = Integer.parseInt(this.duration.getText());
                    this.graph.setPollDuration(n);
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Non Numeric value:")) + " " + this.duration.getText());
                    this.duration.setText(String.valueOf(this.graph.getPollDuration()));
                    this.graph.setPollDuration(this.graph.getPollDuration());
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
            }
            if (actionEvent.getSource().equals(this.logField)) {
                try {
                    String string = this.logField.getText();
                    this.graph.setLogFileName(string);
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
                catch (Exception exception) {
                    System.err.println(SnmpUtils.getString("FileName not specified"));
                }
            }
            if (!actionEvent.getSource().equals(this.scale)) break block34;
            int n = 300;
            try {
                n = Integer.parseInt(this.scale.getText());
                if (n < 300) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid X-axis Scale value:")) + " " + n);
                    this.scale.setText(String.valueOf(this.graph.getXscale()));
                    return;
                }
                this.graph.setXscale(n);
                this.graph.repaint();
                this.poller.restartPolling();
            }
            catch (NumberFormatException numberFormatException) {
                this.graph.setXscale(this.graph.getXscale());
                System.err.println(SnmpUtils.getString("Scale value should be an integer"));
                this.scale.setText(String.valueOf(this.graph.getXscale()));
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof JCheckBox) {
            String string = ((JCheckBox)object).getText();
            if (string.equals(SnmpUtils.getString("Show Absolute Counters"))) {
                this.graph.setAbsoluteCounters(((JCheckBox)object).isSelected());
                this.graph.repaint();
            }
            if (string.equals(SnmpUtils.getString("Average over Interval?"))) {
                this.graph.setTimeavg(((JCheckBox)object).isSelected());
                this.graph.repaint();
            }
            if (string.equals(SnmpUtils.getString("Show Absolute Time?"))) {
                this.graph.setAbstime(((JCheckBox)object).isSelected());
                this.graph.repaint();
            }
            if (string.equals(SnmpUtils.getString("Show Polled Values?"))) {
                if (((JCheckBox)object).isSelected()) {
                    this.duration.setEnabled(true);
                    try {
                        int n = Integer.parseInt(this.duration.getText());
                        this.graph.setPollDuration(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(String.valueOf(SnmpUtils.getString("Non Numeric value:")) + " " + this.duration.getText());
                    }
                    if (this.graph.jsb != null) {
                        this.graph.jsb.setEnabled(true);
                    }
                    this.scale.setEnabled(true);
                    this.showVal = true;
                    this.graph.setValues();
                    this.poller.restartPolling();
                } else {
                    this.duration.setEnabled(false);
                    this.scale.setEnabled(false);
                    this.showVal = false;
                    if (this.graph.jsb != null) {
                        this.graph.jsb.setEnabled(false);
                    }
                    this.graph.setPollDuration(0);
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
            }
            if (string.equals(SnmpUtils.getString("Log Polled Values?"))) {
                if (((JCheckBox)object).isSelected()) {
                    this.graph.setLogEnabled(true);
                    this.logField.setEnabled(true);
                    this.poller.restartPolling();
                    this.storeVal = true;
                } else {
                    this.graph.setLogEnabled(false);
                    this.logField.setEnabled(false);
                    this.poller.restartPolling();
                    this.storeVal = false;
                }
            }
            return;
        }
    }

    void setupPolling() {
        if (((String)this.browser.display.host.getSelectedItem()).trim().equals("")) {
            JOptionPane.showMessageDialog(this.browser, SnmpUtils.getString("No Host Specified"), SnmpUtils.getString("Warning Message"), 0);
            return;
        }
        this.poller.setTargetHost((String)this.browser.display.host.getSelectedItem());
        this.poller.setCommunity(this.browser.display.community.getText());
        this.poller.setPollInterval(5);
        this.poller.setSendTimeoutEvents(true);
    }
}

