/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.Graph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class GraphWrapper
extends JPanel
implements Serializable {
    protected Graph sg = null;
    protected JScrollBar jsb = null;
    protected JPanel jp = null;
    protected GridBagLayout gb = new GridBagLayout();
    protected GridBagConstraints gbc = new GridBagConstraints();

    public GraphWrapper() {
        this.setLayout(this.gb);
        this.jp = new JPanel();
        this.jp.setLayout(null);
        this.sg = new Graph();
        this.sg.setLayout(null);
        this.sg.setLocation(0, 0);
        this.jp.setBackground(this.sg.getBgcolor());
        this.setBackground(this.sg.getBgcolor());
        this.sg.addComponentListener(new ComponentAdapter(){
            int sbmax = 0;
            int sbvalue = 0;
            int sbextent = 0;
            int sbMinimum = 0;

            public void componentResized(ComponentEvent componentEvent) {
                if (GraphWrapper.this.sg.isGraphResized) {
                    GraphWrapper.this.sg.isGraphResized = false;
                    --GraphWrapper.this.sg.width;
                    GraphWrapper.this.sg.setSize(GraphWrapper.this.sg.width, GraphWrapper.this.sg.height);
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    n = GraphWrapper.this.sg.width * GraphWrapper.this.sg.noOfPages;
                    int n5 = GraphWrapper.this.sg.getTime() / GraphWrapper.this.sg.getXRange() * GraphWrapper.this.sg.getXRange();
                    n4 = n5 * GraphWrapper.this.sg.width / GraphWrapper.this.sg.xRange;
                    n3 = GraphWrapper.this.sg.width;
                    n2 = n - GraphWrapper.this.sg.width;
                    if (GraphWrapper.this.jsb == null) {
                        GraphWrapper.this.jsb = new JScrollBar(0, 0, 0, 0, 0);
                        GraphWrapper.this.jsb.addAdjustmentListener(new adlist());
                        GraphWrapper.this.jsb.setBlockIncrement(GraphWrapper.this.sg.width);
                        GraphWrapper.this.jsb.setUnitIncrement(GraphWrapper.this.sg.width);
                        GraphWrapper.this.gbc.weightx = 0.0;
                        GraphWrapper.this.gbc.weighty = 0.0;
                        GraphWrapper.this.gbc.fill = 2;
                        GraphWrapper.this.gb.setConstraints(GraphWrapper.this.jsb, GraphWrapper.this.gbc);
                        GraphWrapper.this.invalidate();
                        GraphWrapper.this.add(GraphWrapper.this.jsb);
                        GraphWrapper.this.validate();
                    }
                    GraphWrapper.this.jsb.setValues(n2, n3, n4, n);
                }
            }
        });
        this.sg.setSize(this.sg.width, this.sg.height);
        this.jp.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GraphWrapper.this.sg.width = componentEvent.getComponent().getSize().width;
                GraphWrapper.this.sg.height = componentEvent.getComponent().getSize().height;
                GraphWrapper.this.sg.setSize(GraphWrapper.this.sg.width, GraphWrapper.this.sg.height);
            }
        });
        this.jp.add(this.sg);
        this.gbc.gridwidth = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 1;
        this.gb.setConstraints(this.jp, this.gbc);
        this.add(this.jp);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.sg.addMouseListener(mouseListener);
    }

    public void barGraphSetUp() {
        this.sg.barGraphSetUp();
    }

    public void filledGraphSetUp() {
        this.sg.filledGraphSetUp();
    }

    public Color getBarColor() {
        return this.sg.getBarColor();
    }

    public Color[] getBarColors() {
        return this.sg.getBarColors();
    }

    public Color getBgcolor() {
        return this.sg.getBgcolor();
    }

    public Color getFgcolor() {
        return this.sg.getFgcolor();
    }

    public Color[] getLineColors() {
        return this.sg.getLineColors();
    }

    public Color getLinecolor() {
        return this.sg.getLinecolor();
    }

    public long getMaxY() {
        return this.sg.getMaxY();
    }

    public long getMinY() {
        return this.sg.getMinY();
    }

    public int getNoOfBars() {
        return this.sg.getNoOfBars();
    }

    public int getNoOfLines() {
        return this.sg.getNoOfLines();
    }

    public int getNoOfValues() {
        return this.sg.getNoOfValues();
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 150);
    }

    public Font getScaleFont() {
        return this.sg.getScaleFont();
    }

    public String getTitle() {
        return this.sg.getTitle();
    }

    public Font getTitleFont() {
        return this.sg.getTitleFont();
    }

    public int getXGrids() {
        return this.sg.getXGrids();
    }

    public String getXLabel() {
        return this.sg.getXLabel();
    }

    public int getXRange() {
        return this.sg.getXRange();
    }

    public int getXScalePoints() {
        return this.sg.getXScalePoints();
    }

    public int getYGrids() {
        return this.sg.getYGrids();
    }

    public String getYLabel() {
        return this.sg.getYLabel();
    }

    public int getYScalePoints() {
        return this.sg.getYScalePoints();
    }

    public boolean isAbsoluteTime() {
        return this.sg.isAbsoluteTime();
    }

    public boolean isShowTitle() {
        return this.sg.isShowTitle();
    }

    public boolean isShowxLabel() {
        return this.sg.isShowxLabel();
    }

    public boolean isShowyLabel() {
        return this.sg.isShowyLabel();
    }

    public boolean isTimeAverage() {
        return this.sg.isTimeAverage();
    }

    public void lineGraphSetUp() {
        this.sg.lineGraphSetUp();
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.sg.removeMouseListener(mouseListener);
    }

    public void setAbsoluteTime(boolean bl) {
        this.sg.setAbsoluteTime(bl);
    }

    public void setBarColor(Color color) {
        this.sg.setBarColor(color);
    }

    public void setBarColors(Color[] colorArray) {
        this.sg.setBarColors(colorArray);
    }

    public void setBgcolor(Color color) {
        this.sg.setBgcolor(color);
        this.setBackground(this.sg.getBgcolor());
        this.jp.setBackground(this.sg.getBgcolor());
    }

    public void setFgcolor(Color color) {
        this.sg.setFgcolor(color);
    }

    public void setLineColors(Color[] colorArray) {
        this.sg.setLineColors(colorArray);
    }

    public void setLinecolor(Color color) {
        this.sg.setLinecolor(color);
    }

    public void setMaxY(long l) {
        this.sg.setMaxY(l);
    }

    public void setMinY(long l) {
        this.sg.setMinY(l);
    }

    public void setNoOfBars(int n) {
        this.sg.setNoOfBars(n);
    }

    public void setNoOfLines(int n) {
        this.sg.setNoOfLines(n);
    }

    public void setNoOfValues(int n) {
        this.sg.setNoOfValues(n);
    }

    public void setResult(int n, long l) {
        this.sg.setResult(n, l);
    }

    public void setResult(long l) {
        this.sg.setResult(l);
    }

    public void setScaleFont(Font font) {
        this.sg.setScaleFont(font);
    }

    public void setShowTitle(boolean bl) {
        this.sg.setShowTitle(bl);
    }

    public void setShowxLabel(boolean bl) {
        this.sg.setShowxLabel(bl);
    }

    public void setShowyLabel(boolean bl) {
        this.sg.setShowyLabel(bl);
    }

    public void setTimeAverage(boolean bl) {
        this.sg.setTimeAverage(bl);
    }

    public void setTitle(String string) {
        this.sg.setTitle(string);
    }

    public void setTitleFont(Font font) {
        this.sg.setTitleFont(font);
    }

    public void setXGrids(int n) {
        this.sg.setXGrids(n);
    }

    public void setXLabel(String string) {
        this.sg.setXLabel(string);
    }

    public void setXRange(int n) {
        this.sg.setXRange(n);
    }

    public void setXScalePoints(int n) {
        this.sg.setXScalePoints(n);
    }

    public void setYGrids(int n) {
        this.sg.setYGrids(n);
    }

    public void setYLabel(String string) {
        this.sg.setYLabel(string);
    }

    public void setYScalePoints(int n) {
        this.sg.setYScalePoints(n);
    }

    class adlist
    implements AdjustmentListener {
        adlist() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            GraphWrapper.this.sg.maxX = GraphWrapper.this.sg.xRange * (adjustmentEvent.getValue() + GraphWrapper.this.sg.width) / GraphWrapper.this.sg.width;
            GraphWrapper.this.sg.minX = GraphWrapper.this.sg.maxX - GraphWrapper.this.sg.xRange;
            GraphWrapper.this.sg.drawGraph();
        }
    }
}

