/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.snmp2.SnmpInt;
import com.adventnet.snmp.snmp2.SnmpUnsignedInt;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.ui.SnmpTablePanelModel;
import com.adventnet.snmp.ui.SnmpTablePanelUI;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class IndexEditor
extends JFrame {
    SnmpTablePanelUI panel = null;
    SnmpTablePanelModel model = null;
    JTextField[] indNametxt = null;
    int numberOfIndex = 0;
    Font lfont = SnmpUIUtils.getFont();

    IndexEditor(SnmpTablePanelUI snmpTablePanelUI) {
        Object object;
        this.setTitle(String.valueOf(SnmpUtils.getString("Index Editor ")) + " ");
        this.panel = snmpTablePanelUI;
        this.model = snmpTablePanelUI.getTableModel();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("  " + SnmpUtils.getString("OK") + "  ");
        jButton.setFont(this.lfont);
        JButton jButton2 = new JButton(SnmpUtils.getString("Cancel"));
        jButton2.setFont(this.lfont);
        this.numberOfIndex = this.model.getIndexNames().size();
        Vector vector = this.model.getIndexMibNodes();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        Vector vector2 = this.model.getSnmpVarVec(snmpTablePanelUI.table.getSelectedRow());
        this.indNametxt = new JTextField[this.numberOfIndex];
        int n = 0;
        while (n < this.numberOfIndex) {
            gridBagConstraints.gridy = n + 1;
            object = ((MibNode)vector.elementAt(n)).getSyntax().toString();
            JLabel jLabel = new JLabel(String.valueOf((String)this.model.getIndexNames().elementAt(n)) + " (" + (String)object + ")");
            jLabel.setFont(this.lfont);
            jLabel.setForeground(Color.black);
            String string = "";
            string = vector2.elementAt(n) instanceof SnmpInt || vector2.elementAt(n) instanceof SnmpUnsignedInt ? ((SnmpVar)vector2.elementAt(n)).toValue().toString() : ((SnmpVar)vector2.elementAt(n)).toString();
            this.indNametxt[n] = new JTextField(10);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.indNametxt[n], gridBagConstraints);
            jPanel.add(jLabel);
            jPanel.add(this.indNametxt[n]);
            this.indNametxt[n].setText(string);
            if (!this.model.isGetFromIndex()) {
                this.indNametxt[n].setEditable(false);
            }
            ++n;
        }
        jButton.addActionListener(new okadapter(this));
        jButton2.addActionListener(new canceladapter(this));
        this.getContentPane().add("Center", jPanel);
        object = new JPanel();
        ((Container)object).add(jButton);
        ((Container)object).add(jButton2);
        this.getContentPane().add("South", (Component)object);
        ((Component)this).setSize(350, this.numberOfIndex * 25 + 85);
        ((Component)this).setVisible(true);
    }

    void updateEditor(SnmpTablePanelUI snmpTablePanelUI) {
        Vector vector = this.model.getSnmpVarVec(snmpTablePanelUI.table.getSelectedRow());
        int n = 0;
        while (n < this.numberOfIndex) {
            String string = "";
            string = vector.elementAt(n) instanceof SnmpInt || vector.elementAt(n) instanceof SnmpUnsignedInt ? ((SnmpVar)vector.elementAt(n)).toValue().toString() : ((SnmpVar)vector.elementAt(n)).toString();
            this.indNametxt[n].setText(string);
            if (!this.model.isGetFromIndex()) {
                this.indNametxt[n].setEditable(false);
            } else {
                this.indNametxt[n].setEditable(true);
            }
            ((Component)this).setVisible(true);
            ++n;
        }
    }

    class canceladapter
    implements ActionListener {
        IndexEditor ia = null;

        canceladapter(IndexEditor indexEditor2) {
            this.ia = indexEditor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)this.ia).setVisible(false);
        }
    }

    class okadapter
    implements ActionListener {
        IndexEditor ia = null;

        okadapter(IndexEditor indexEditor2) {
            this.ia = indexEditor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < IndexEditor.this.indNametxt.length) {
                if (IndexEditor.this.indNametxt[n].getText().equals("")) {
                    JOptionPane.showMessageDialog(null, SnmpUtils.getString("Value should be entered in IndexEditor "), SnmpUtils.getString("Error Message"), 0);
                    ((Component)this.ia).setVisible(false);
                    return;
                }
                vector.addElement(IndexEditor.this.indNametxt[n].getText());
                ++n;
            }
            IndexEditor.this.panel.indBox.setText(IndexEditor.this.model.getDecodedInstanceStr(vector));
            ((Component)this.ia).setVisible(false);
        }
    }
}

