/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ResultEvent;
import com.adventnet.snmp.beans.ResultListener;
import com.adventnet.snmp.snmp2.SnmpCounter;
import com.adventnet.snmp.snmp2.SnmpNull;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpString;
import com.adventnet.snmp.snmp2.SnmpVar;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

class LineGraphBeanWrapper
extends JPanel
implements ResultListener,
MouseListener,
MouseMotionListener {
    int wid = 250;
    int ht = 250;
    int prevwid = 0;
    int prevht = 0;
    byte labelType = 0;
    boolean isGraphResized = false;
    boolean isXRangeChanged = false;
    boolean isScrollBarEnabled = false;
    boolean timeSpan = false;
    boolean storeValues = false;
    int noOfValues = 3600;
    int maxX1 = 0;
    byte YEAR = 1;
    byte MONTH = (byte)2;
    final byte DAY = (byte)3;
    final byte HOUR = (byte)4;
    final byte MINUTE = (byte)5;
    final byte SECONDS = (byte)6;
    final byte WEEK = (byte)7;
    String Title = SnmpUtils.getString("Title");
    boolean showTitle = true;
    String tfontName = SnmpUIUtils.getFont().getFamily();
    String tfontStyle = "BOLD";
    int tfontSize = 12;
    Font tfont = SnmpUIUtils.getFont();
    int titleX;
    int titleY;
    private String[] fonts;
    private Toolkit toolkit;
    Color bgColor = Color.black;
    Color fgColor = Color.yellow;
    Color lineColor = Color.red;
    String xLabel = SnmpUtils.getString("Time in seconds");
    boolean isAutoSetXLabel = true;
    String yLabel = "";
    boolean showXLabel = true;
    boolean showYLabel = false;
    byte xUnits = 0;
    String yUnits = "";
    String lfontName = SnmpUIUtils.getFont().getFamily();
    String lfontStyle = "PLAIN";
    int lfontSize = 10;
    Font lfont = SnmpUIUtils.getFont();
    int xLabelx;
    int xLabely;
    int yLabelx;
    int yLabely;
    int yLabelWid;
    int labelHt;
    int xMax = 300;
    int xMax1 = 300;
    int xMin = 0;
    int xMin1 = 0;
    boolean absTime = true;
    int xDiffMax = 300;
    int xDiffMax1 = 300;
    long yMax = 100L;
    long yMin = 0L;
    int x0 = 0;
    int y0 = 0;
    int xEnd = 0;
    int yEnd = 0;
    boolean timeAvg = false;
    int xGrid = 5;
    int yGrid = 5;
    int[] xGrids;
    int[] yGrids;
    int xMark = 5;
    int yMark = 5;
    int[] xMarks;
    int[] yMarks;
    int xMarkOff = 15;
    int yMarkOff = 30;
    int markLen = 5;
    int dotRad = 2;
    int maxScaleYWid = 0;
    Vector[] data = null;
    private boolean isLineLabel = false;
    String[] olabels = null;
    String lineLabels = "";
    Color lcolor = Color.red;
    Color[] lineColors = new Color[]{Color.red, Color.green, Color.blue, Color.yellow, Color.cyan, Color.pink, Color.orange, Color.magenta};
    int c_index = 0;
    String linecolors = "";
    boolean check = true;
    boolean absoluteCounters = false;
    long lastValue = 0L;
    long[] lastValues = null;
    private SnmpPDU pdu = null;
    boolean inComp = false;
    Image dbuf = null;
    Graphics graph = null;
    Graphics graph1 = null;
    Date date;
    long startTime = 0L;
    Vector line1 = null;
    int prevTime = -1;
    int noofpages = 1;
    static int count = 0;
    boolean reset = false;
    private static String graphFile = "graph.txt";
    boolean readGraphFile = false;
    BufferedWriter os;
    BufferedReader is;
    boolean valuesLegendOpen = false;
    int lastx = 0;
    int lasty = 0;
    Image dbuf2;
    int time1 = 1;

    public LineGraphBeanWrapper() {
        this.setup();
    }

    public LineGraphBeanWrapper(int n, int n2) {
        this.resize(n, n2);
        this.setup();
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
    }

    boolean addPoint(int n, double[] dArray) {
        block21: {
            if (this.data == null) {
                return false;
            }
            int n2 = n;
            if (n2 < 0 || n2 >= this.data.length) {
                return false;
            }
            if (this.dbuf == null) {
                return false;
            }
            this.graph = this.dbuf.getGraphics();
            if (this.data.length == 1) {
                this.graph.setColor(this.lcolor);
            } else {
                this.graph.setColor(this.lineColors[n2 % this.lineColors.length]);
            }
            double[] dArray2 = null;
            if (this.data[n2].size() > 0) {
                dArray2 = (double[])this.data[n2].lastElement();
            }
            if (dArray2 != null) {
                this.graph.drawLine(this.getX(dArray2[0]), this.getY(dArray2[1]) - n2, this.getX(dArray[0]), this.getY(dArray[1]) - n2);
                this.graph.fillOval(this.getX(dArray[0]) - this.dotRad, this.getY(dArray[1]) - this.dotRad - n2, 2 * this.dotRad, 2 * this.dotRad);
            }
            Vector[] vectorArray = this.data;
            synchronized (vectorArray) {
                this.data[n2].addElement(dArray);
            }
            if (this.dbuf != null) {
                this.repaint();
            }
            if (!this.storeValues) break block21;
            int n3 = 0;
            try {
                String string = null;
                if (this.isLineLabel) {
                    string = this.olabels[n];
                } else {
                    n3 = n;
                }
                String string2 = new Double(dArray[0]).toString();
                String string3 = new Double(dArray[1]).toString();
                if (this.isLineLabel) {
                    if ((count + this.olabels.length) % this.olabels.length == 0) {
                        this.os.write(10);
                        this.os.write(string2);
                        this.os.write(9);
                    }
                } else if (n == 0) {
                    this.os.write(10);
                    this.os.flush();
                }
                if (this.isLineLabel) {
                    this.os.write(string);
                } else {
                    this.os.write(n3);
                }
                this.os.write(9);
                this.os.write(string3);
                this.os.write(9);
                ++count;
                this.os.flush();
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Error : ")) + " " + exception);
                exception.printStackTrace();
            }
        }
        return true;
    }

    void calculateGrid() {
        int n;
        FontMetrics fontMetrics;
        if (this.graph == null) {
            return;
        }
        if (this.showTitle) {
            this.tfont = new Font(this.tfontName, this.getStyleNo(this.tfontStyle), this.tfontSize);
            this.graph.setFont(this.tfont);
            fontMetrics = this.graph.getFontMetrics();
            this.titleX = this.wid / 2 - fontMetrics.stringWidth(this.Title) / 2;
            this.titleY = 2 + fontMetrics.getHeight();
        } else {
            this.titleY = 2;
        }
        this.lfont = new Font(this.lfontName, this.getStyleNo(this.lfontStyle), this.lfontSize);
        if (this.lfont != null) {
            this.graph.setFont(this.lfont);
        }
        fontMetrics = this.graph.getFontMetrics();
        int n2 = 0;
        if (this.olabels != null) {
            n = 0;
            while (n < this.olabels.length) {
                int n3;
                if (this.olabels[n] != null && (n3 = fontMetrics.stringWidth(this.olabels[n])) > n2) {
                    n2 = n3;
                }
                ++n;
            }
        }
        this.labelHt = fontMetrics.getHeight();
        if (this.showXLabel) {
            this.xLabelx = this.wid / 2 - fontMetrics.stringWidth(this.xLabel) / 2;
            this.xLabely = this.ht - 3;
        } else {
            this.xLabelx = this.wid / 2;
            this.xLabelx = this.ht;
        }
        this.yLabelx = 3;
        this.yLabely = this.ht / 2;
        this.yLabelWid = this.showYLabel ? fontMetrics.stringWidth(this.yLabel) : 0;
        this.xGrids = new int[this.xGrid];
        this.yGrids = new int[this.yGrid];
        this.xMarks = new int[this.xMark];
        this.yMarks = new int[this.yMark];
        Date date = new Date(this.startTime);
        Date date2 = new Date(this.startTime + 1000L * (long)this.xMax);
        if (this.xUnits == 7) {
            this.labelType = (byte)7;
            if (this.isAutoSetXLabel) {
                this.xLabel = this.getXlabel();
            }
        } else if (date2.getYear() - date.getYear() != 0) {
            this.labelType = this.YEAR;
            if (this.isAutoSetXLabel) {
                this.xLabel = this.getXlabel();
            }
        } else if (date2.getMonth() - date.getMonth() != 0) {
            this.labelType = this.MONTH;
            if (this.isAutoSetXLabel) {
                this.xLabel = this.getXlabel();
            }
        } else if (date2.getDate() - date.getDate() != 0) {
            this.labelType = (byte)3;
            if (this.isAutoSetXLabel) {
                this.xLabel = this.getXlabel();
            }
        } else if (date2.getHours() - date.getHours() != 0) {
            this.labelType = (byte)4;
            if (this.isAutoSetXLabel) {
                this.xLabel = this.getXlabel();
            }
        } else if (date2.getMinutes() - date.getMinutes() != 0) {
            this.labelType = (byte)5;
            if (this.isAutoSetXLabel) {
                this.xLabel = this.getXlabel();
            }
        } else if (date2.getSeconds() - date.getSeconds() != 0) {
            this.labelType = (byte)6;
            if (this.isAutoSetXLabel) {
                this.xLabel = this.getXlabel();
            }
        }
        this.y0 = this.titleY + 3;
        this.yEnd = this.showXLabel ? this.ht - this.markLen - 2 * this.labelHt - 5 : this.ht - this.markLen - this.labelHt - 5;
        n = 0;
        while (n < this.yGrids.length) {
            this.yGrids[n] = this.yEnd + n * (this.y0 - this.yEnd) / this.yGrid;
            ++n;
        }
        n = 0;
        while (n < this.yMarks.length) {
            this.yMarks[n] = this.yEnd + n * (this.y0 - this.yEnd) / this.yMark;
            ++n;
        }
        n = 1;
        while (n < this.yMarks.length) {
            Float f = new Float((float)this.yMin + (float)n * (float)(this.yMax - this.yMin) / (float)this.yMark);
            int n4 = fontMetrics.stringWidth(f.toString());
            if (n4 > this.maxScaleYWid) {
                this.maxScaleYWid = n4;
            }
            ++n;
        }
        this.x0 = this.yLabelx + this.yLabelWid + 2 + this.maxScaleYWid + this.markLen;
        this.xEnd = this.wid - 5 - n2;
        n = 0;
        while (n < this.xGrids.length) {
            this.xGrids[n] = this.x0 + n * (this.xEnd - this.x0) / this.xGrid;
            ++n;
        }
        n = 0;
        while (n < this.xMarks.length) {
            this.xMarks[n] = this.x0 + n * (this.xEnd - this.x0) / this.xMark;
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    void drawGraph() {
        block31: {
            if (this.graph == null) {
                return;
            }
            this.graph.setColor(this.bgColor);
            this.graph.fillRect(0, 0, this.wid, this.ht);
            this.graph.setColor(this.fgColor);
            this.graph.draw3DRect(1, 1, this.size().width - 3, this.size().height - 3, true);
            this.graph.setColor(this.fgColor);
            this.tfont = new Font(this.tfontName, this.getStyleNo(this.tfontStyle), this.tfontSize);
            this.graph.setFont(this.tfont);
            if (this.showTitle) {
                this.graph.drawString(this.Title, this.titleX, this.titleY);
            }
            this.lfont = new Font(this.lfontName, this.getStyleNo(this.lfontStyle), this.lfontSize);
            this.graph.setFont(this.lfont);
            if (this.showXLabel) {
                this.graph.drawString(this.xLabel, this.xLabelx, this.xLabely);
            }
            if (this.showYLabel) {
                this.graph.drawString(this.yLabel, this.yLabelx, this.yLabely);
            }
            this.graph.drawLine(this.x0, this.yEnd, this.xEnd, this.yEnd);
            this.graph.drawLine(this.x0, this.yEnd, this.x0, this.y0);
            this.graph.drawLine(this.xEnd, this.yEnd, this.xEnd, this.y0);
            this.graph.drawLine(this.x0, this.y0, this.xEnd, this.y0);
            this.graph.setColor(this.fgColor);
            var1_1 = 0;
            while (var1_1 < this.xGrids.length) {
                this.graph.drawLine(this.xGrids[var1_1], this.yEnd, this.xGrids[var1_1], this.y0);
                ++var1_1;
            }
            var1_1 = 0;
            while (var1_1 < this.yGrids.length) {
                this.graph.drawLine(this.x0, this.yGrids[var1_1], this.xEnd, this.yGrids[var1_1]);
                ++var1_1;
            }
            if (this.timeSpan) {
                var1_1 = 0;
                while (var1_1 < this.xMarks.length) {
                    this.graph.drawLine(this.xMarks[var1_1], this.yEnd, this.xMarks[var1_1], this.yEnd + this.markLen);
                    var2_2 = new Float((float)this.xMin + (float)var1_1 * (float)(this.xMax - this.xMin) / (float)this.xMark);
                    var3_5 = var2_2.toString();
                    if (this.absTime) {
                        var3_5 = this.getTimeStr(this.startTime + 1000L * (long)(this.xMin + var1_1 * (this.xMax - this.xMin) / this.xMark));
                    }
                    this.graph.drawString((String)var3_5, this.xMarks[var1_1] + 2, this.yEnd + this.labelHt + this.markLen);
                    ++var1_1;
                }
            } else {
                var1_1 = 0;
                while (var1_1 < this.xMarks.length) {
                    this.graph.drawLine(this.xMarks[var1_1], this.yEnd, this.xMarks[var1_1], this.yEnd + this.markLen);
                    var2_2 = new Float((float)this.xMin1 + (float)var1_1 * (float)(this.xMax1 - this.xMin1) / (float)this.xMark);
                    var3_5 = var2_2.toString();
                    if (this.absTime) {
                        var3_5 = this.getTimeStr(this.startTime + 1000L * (long)(this.xMin1 + var1_1 * (this.xMax1 - this.xMin1) / this.xMark));
                    }
                    this.graph.drawString((String)var3_5, this.xMarks[var1_1] + 2, this.yEnd + this.labelHt + this.markLen);
                    ++var1_1;
                }
            }
            var1_1 = 0;
            while (var1_1 < this.yMarks.length) {
                this.graph.drawLine(this.x0, this.yMarks[var1_1], this.x0 - this.markLen, this.yMarks[var1_1]);
                var2_2 = new Float((float)this.yMin + (float)var1_1 * (float)(this.yMax - this.yMin) / (float)this.yMark);
                this.graph.drawString(var2_2.toString(), this.yLabelx + this.yLabelWid + 2, this.yMarks[var1_1]);
                ++var1_1;
            }
            if (this.olabels != null) {
                var2_3 = 0;
                while (var2_3 < this.olabels.length) {
                    if (this.olabels[var2_3] != null) {
                        if (this.data.length == 1) {
                            this.graph.setColor(this.lcolor);
                        } else {
                            this.graph.setColor(this.lineColors[var2_3 % this.lineColors.length]);
                        }
                        this.lfont = new Font(this.lfontName, this.getStyleNo(this.lfontStyle), this.lfontSize);
                        this.graph.setFont(this.lfont);
                        var3_5 = this.graph.getFontMetrics();
                        var4_6 = this.y0 + 10 + var2_3 * var3_5.getHeight();
                        var5_8 = this.wid - 2 - var3_5.stringWidth(this.olabels[var2_3]);
                        this.graph.drawString(this.olabels[var2_3], var5_8, var4_6);
                    }
                    ++var2_3;
                }
            }
            if (this.data == null) break block31;
            var2_4 = 0;
            while (var2_4 < this.data.length) {
                block32: {
                    if (this.data.length == 1) {
                        this.graph.setColor(this.lcolor);
                    } else {
                        this.graph.setColor(this.lineColors[var2_4 % this.lineColors.length]);
                    }
                    if (this.data[var2_4] == null) break block32;
                    var3_5 = this.data[var2_4].elements();
                    var4_7 = null;
                    var5_9 = this.data;
                    synchronized (var5_9) {
                        block30: {
                            if (!this.timeSpan) ** GOTO lbl110
                            while (var3_5.hasMoreElements()) {
                                var4_7 = (double[])var3_5.nextElement();
                                if (!(var4_7[0] >= (double)this.xMin)) continue;
                                this.graph.fillOval(this.getX(var4_7[0]) - this.dotRad, this.getY(var4_7[1]) - this.dotRad - var2_4, 2 * this.dotRad, 2 * this.dotRad);
                                break;
                            }
                            while (var3_5.hasMoreElements()) {
                                var7_10 = (double[])var3_5.nextElement();
                                this.graph.drawLine(this.getX(var4_7[0]), this.getY(var4_7[1]) - var2_4, this.getX(var7_10[0]), this.getY(var7_10[1]) - var2_4);
                                this.graph.fillOval(this.getX(var7_10[0]) - this.dotRad, this.getY(var7_10[1]) - this.dotRad - var2_4, 2 * this.dotRad, 2 * this.dotRad);
                                var4_7 = var7_10;
                                if (!(var4_7[0] >= (double)this.xMax)) {
                                    continue;
                                }
                                break block30;
                            }
                            break block30;
lbl-1000:
                            // 1 sources

                            {
                                var4_7 = (double[])var3_5.nextElement();
                                if (!(var4_7[0] >= (double)this.xMin1)) continue;
                                this.graph.fillOval(this.getX1(var4_7[0]) - this.dotRad, this.getY(var4_7[1]) - this.dotRad - var2_4, 2 * this.dotRad, 2 * this.dotRad);
                                break;
lbl110:
                                // 2 sources

                                ** while (var3_5.hasMoreElements())
                            }
lbl111:
                            // 3 sources

                            while (var3_5.hasMoreElements()) {
                                var7_10 = (double[])var3_5.nextElement();
                                this.graph.drawLine(this.getX1(var4_7[0]), this.getY(var4_7[1]) - var2_4, this.getX1(var7_10[0]), this.getY(var7_10[1]) - var2_4);
                                this.graph.fillOval(this.getX1(var7_10[0]) - this.dotRad, this.getY(var7_10[1]) - this.dotRad - var2_4, 2 * this.dotRad, 2 * this.dotRad);
                                var4_7 = var7_10;
                                if (!(var4_7[0] >= (double)this.xMax1)) {
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }
                ++var2_4;
            }
        }
    }

    void drawValuesLegend(int n, int n2, Graphics graphics) {
        int n3;
        int n4;
        Graphics graphics2;
        if (this.isPopupExists()) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (this.dbuf == null) {
            return;
        }
        if (this.dbuf2 == null) {
            this.dbuf2 = this.createImage(this.wid, this.ht);
        }
        if ((graphics2 = this.dbuf2.getGraphics()) == null) {
            return;
        }
        graphics2.drawImage(this.dbuf, 0, 0, this);
        graphics2.setColor(Color.lightGray);
        graphics2.drawLine(n, 0, n, this.ht);
        int n5 = this.data.length;
        if (n5 <= 0) {
            return;
        }
        String[] stringArray = new String[n5];
        String string = "";
        int n6 = 0;
        while (n6 < n5) {
            long l = 0L;
            long l2 = -1L;
            l = this.timeSpan ? this.getFromX(n) : this.getFromX1(n);
            n4 = -1;
            n3 = -1;
            if (this.data[n6] != null) {
                Enumeration enumeration = this.data[n6].elements();
                double[] dArray = null;
                int n7 = -1;
                while (enumeration.hasMoreElements()) {
                    dArray = (double[])enumeration.nextElement();
                    if (n4 < 0) {
                        n3 = (int)dArray[1];
                    }
                    n4 = (int)dArray[1];
                    if ((double)l < dArray[0]) {
                        if (l2 == -1L) break;
                        n4 = n3 + (int)((l - l2) * (long)(n4 - n3) / ((long)dArray[0] - l2));
                        if (n7 != -1) continue;
                        n7 = n4;
                        continue;
                    }
                    l2 = (long)dArray[0];
                    n3 = (int)dArray[1];
                }
                String string2 = null;
                string2 = n7 == -1 ? String.valueOf(n4) : String.valueOf(n7);
                if (n4 == -1) {
                    string2 = " ";
                }
                stringArray[n6] = String.valueOf(SnmpUtils.getString("Value: ")) + " " + string2;
                if (string.length() < stringArray[n6].length()) {
                    string = stringArray[n6];
                }
            }
            ++n6;
        }
        String string3 = null;
        string3 = this.timeSpan ? String.valueOf(SnmpUtils.getString("Time: ")) + " " + this.getFromX(n) : String.valueOf(SnmpUtils.getString("Time: ")) + " " + this.getFromX1(n);
        if (this.absTime) {
            string3 = this.timeSpan ? String.valueOf(SnmpUtils.getString("Time: ")) + " " + this.getTimeStr(this.startTime + 1000L * this.getFromX(n)) : String.valueOf(SnmpUtils.getString("Time: ")) + " " + this.getTimeStr(this.startTime + 1000L * this.getFromX1(n));
        }
        if (string.length() < string3.length()) {
            string = string3;
        }
        this.lfont = new Font(this.lfontName, this.getStyleNo(this.lfontStyle), this.lfontSize);
        graphics2.setFont(this.lfont);
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        int n8 = 10 + fontMetrics.stringWidth(string);
        int n9 = (1 + n5) * fontMetrics.getHeight() + 10;
        n4 = n + 10;
        n3 = n2 + 10;
        if (n4 + n8 > this.wid) {
            n4 = this.wid - n8;
        }
        if (n3 + n9 > this.ht) {
            n3 = this.ht - n9;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        graphics2.fillRect(n4, n3, n8, n9);
        graphics2.setColor(Color.darkGray);
        graphics2.draw3DRect(n4 + 2, n3 + 2, n8 - 4, n9 - 4, true);
        if (n5 == 1) {
            graphics2.setColor(this.lcolor);
            graphics2.drawString(stringArray[0], n4 + 4, n3 + n9 - 5 - n5 * fontMetrics.getHeight());
        } else {
            int n10 = 0;
            while (n10 < n5) {
                graphics2.setColor(this.lineColors[n10 % this.lineColors.length]);
                if (stringArray[n10] != null) {
                    graphics2.drawString(stringArray[n10], n4 + 4, n3 + n9 - 5 - (n5 - n10) * fontMetrics.getHeight());
                }
                ++n10;
            }
        }
        graphics2.setColor(Color.black);
        graphics2.drawString(string3, n4 + 4, n3 + n9 - 5);
        this.valuesLegendOpen = true;
        this.lastx = n;
        this.lasty = n2;
        graphics.drawImage(this.dbuf2, 0, 0, this);
    }

    String fmt(int n) {
        String string = String.valueOf(n);
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    boolean getAbsoluteCounters() {
        return this.absoluteCounters;
    }

    boolean getAbstime() {
        return this.absTime;
    }

    boolean getAutoXlabel() {
        return this.isAutoSetXLabel;
    }

    Color getBgcolor() {
        return this.bgColor;
    }

    Color getFgcolor() {
        return this.fgColor;
    }

    long getFromX(int n) {
        return this.xMin + (this.xMax - this.xMin) * (n - this.x0) / (this.xEnd - this.x0);
    }

    long getFromX1(int n) {
        return this.xMin1 + (this.xMax1 - this.xMin1) * (n - this.x0) / (this.xEnd - this.x0);
    }

    Color getLcolor() {
        return this.lcolor;
    }

    String getLfontname() {
        return this.lfontName;
    }

    int getLfontsize() {
        return this.lfontSize;
    }

    String getLfontstyle() {
        return this.lfontStyle;
    }

    Color[] getLineColors() {
        return this.lineColors;
    }

    String getLineLabels() {
        return this.lineLabels;
    }

    Color getLinecolor() {
        return this.lcolor;
    }

    String getLinecolors() {
        return this.linecolors;
    }

    String getLogFileName() {
        return graphFile;
    }

    int getPollDuration() {
        return this.noOfValues;
    }

    boolean getShowtitle() {
        return this.showTitle;
    }

    boolean getShowxlabel() {
        return this.showXLabel;
    }

    boolean getShowylabel() {
        return this.showYLabel;
    }

    int getStyleNo(String string) {
        int n;
        if (string.equals("PLAIN")) {
            n = 0;
        }
        if (string.equals("BOLD")) {
            n = 1;
        }
        n = string.equals("ITALIC") ? 2 : 0;
        return n;
    }

    String getTfontname() {
        return this.tfontName;
    }

    int getTfontsize() {
        return this.tfontSize;
    }

    String getTfontstyle() {
        return this.tfontStyle;
    }

    int getTime() {
        return this.time1;
    }

    String getTimeStr(long l) {
        String string = String.valueOf(l);
        Date date = new Date(l);
        if (date != null) {
            if (this.labelType == this.YEAR) {
                if (this.absTime) {
                    this.setXlabel(SnmpUtils.getString("Time in Years"));
                }
                string = String.valueOf(this.fmt(date.getYear())) + ":" + this.fmt(date.getMonth()) + ":" + this.fmt(date.getDate()) + ":" + this.fmt(date.getHours()) + ":" + this.fmt(date.getMinutes()) + ":" + this.fmt(date.getSeconds());
            } else if (this.labelType == 7) {
                if (this.absTime) {
                    this.setXlabel(SnmpUtils.getString("Time in weeks"));
                }
                string = String.valueOf(this.fmt(date.getMonth())) + ":" + this.fmt(date.getDate()) + ":" + this.fmt(date.getHours()) + ":" + this.fmt(date.getMinutes()) + ":" + this.fmt(date.getSeconds());
            } else if (this.labelType == this.MONTH) {
                if (this.absTime) {
                    this.setXlabel(SnmpUtils.getString("Time in months"));
                }
                string = String.valueOf(this.fmt(date.getMonth())) + ":" + this.fmt(date.getDate()) + ":" + this.fmt(date.getHours()) + ":" + this.fmt(date.getMinutes()) + ":" + this.fmt(date.getSeconds());
            } else if (this.labelType == 3) {
                if (this.absTime) {
                    this.setXlabel(SnmpUtils.getString("Time in days"));
                }
                string = String.valueOf(this.fmt(date.getDate())) + ":" + this.fmt(date.getHours()) + ":" + this.fmt(date.getMinutes()) + ":" + this.fmt(date.getSeconds());
            } else if (this.labelType == 4) {
                if (this.absTime) {
                    this.setXlabel(SnmpUtils.getString("Time in hours"));
                }
                string = String.valueOf(this.fmt(date.getHours())) + ":" + this.fmt(date.getMinutes()) + ":" + this.fmt(date.getSeconds());
            } else if (this.labelType == 5) {
                if (this.absTime) {
                    this.setXlabel(SnmpUtils.getString("Time in minutes"));
                }
                string = String.valueOf(this.fmt(date.getMinutes())) + ":" + this.fmt(date.getSeconds());
            } else {
                if (this.absTime) {
                    this.setXlabel(SnmpUtils.getString("Time in seconds"));
                }
                string = this.fmt(date.getSeconds());
            }
        }
        return string;
    }

    boolean getTimeavg() {
        return this.isTimeavg();
    }

    String getTitle() {
        return this.Title;
    }

    int getX(double d) {
        return (int)((double)this.x0 + (double)(this.xEnd - this.x0) * (d - (double)this.xMin) / (double)(this.xMax - this.xMin));
    }

    int getX1(double d) {
        return (int)((double)this.x0 + (double)(this.xEnd - this.x0) * (d - (double)this.xMin1) / (double)(this.xMax1 - this.xMin1));
    }

    int getXdiffmax() {
        if (this.timeSpan) {
            return this.xDiffMax;
        }
        return this.xDiffMax1;
    }

    int getXgrid() {
        return this.xGrid;
    }

    String getXlabel() {
        return this.xLabel;
    }

    int getXmark() {
        return this.xMark;
    }

    int getXmax() {
        if (this.timeSpan) {
            return this.xMax;
        }
        return this.xMax1;
    }

    int getXmin() {
        if (this.timeSpan) {
            return this.xMin;
        }
        return this.xMin1;
    }

    int getXscale() {
        if (this.timeSpan) {
            return this.xDiffMax;
        }
        return this.xMax1;
    }

    byte getXunits() {
        return this.xUnits;
    }

    int getY(double d) {
        return (int)((double)this.yEnd - (double)(this.yEnd - this.y0) * (d - (double)this.yMin) / (double)(this.yMax - this.yMin));
    }

    int getYgrid() {
        return this.yGrid;
    }

    String getYlabel() {
        return this.yLabel;
    }

    int getYmark() {
        return this.yMark;
    }

    long getYmax() {
        return this.yMax;
    }

    long getYmin() {
        return this.yMin;
    }

    String getYunits() {
        return this.yUnits;
    }

    boolean isLogEnabled() {
        return this.storeValues;
    }

    boolean isPopupExists() {
        boolean bl = false;
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        Rectangle rectangle = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), jRootPane);
        if (jRootPane != null) {
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            Component[] componentArray = jLayeredPane.getComponentsInLayer(JLayeredPane.POPUP_LAYER);
            int n = 0;
            while (n < componentArray.length) {
                Rectangle rectangle2 = SwingUtilities.convertRectangle(componentArray[n].getParent(), componentArray[n].getBounds(), jRootPane);
                if (rectangle.intersects(rectangle2)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    boolean isTimeavg() {
        return this.timeAvg;
    }

    public Dimension minimumSize() {
        return new Dimension(100, 100);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.inComp = true;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.inComp = false;
        this.valuesLegendOpen = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.inComp) {
            this.drawValuesLegend(mouseEvent.getX(), mouseEvent.getY(), this.getGraphics());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.inComp = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        this.updateComponent(graphics);
    }

    public Dimension preferredSize() {
        return new Dimension(200, 200);
    }

    public void readPollDataFromFile(String string) {
        Thread thread = new Thread(new StaticPolling());
        graphFile = string;
        thread.start();
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
    }

    void restartGraph() {
        this.setup();
        this.repaint();
    }

    void setAbsoluteCounters(boolean bl) {
        this.absoluteCounters = bl;
    }

    void setAbstime(boolean bl) {
        this.absTime = bl;
    }

    void setAutoXlabel(boolean bl) {
        this.isAutoSetXLabel = bl;
    }

    void setBgcolor(Color color) {
        this.bgColor = color;
        this.drawGraph();
    }

    void setDataSize(int n) {
        if (this.data == null || this.data.length < n) {
            this.data = new Vector[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.data[n2] = new Vector();
            ++n2;
        }
    }

    void setFgcolor(Color color) {
        this.fgColor = color;
        this.drawGraph();
    }

    void setFont(Font font, Font font2) {
        this.tfont = font;
        this.lfont = font2;
    }

    void setLcolor(Color color) {
        this.lcolor = color;
        this.drawGraph();
    }

    void setLfontname(String string) {
        this.lfontName = string;
    }

    void setLfontsize(int n) {
        this.lfontSize = n;
    }

    void setLfontstyle(String string) {
        this.lfontStyle = string;
    }

    void setLineColors(Color[] colorArray) {
        this.lineColors = colorArray;
        this.drawGraph();
    }

    void setLineLabels(String string) {
        this.isLineLabel = true;
        this.lineLabels = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " |");
        int n = stringTokenizer.countTokens();
        this.olabels = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.olabels[n2] = stringTokenizer.nextToken();
            ++n2;
        }
    }

    void setLinecolor(Color color) {
        this.lcolor = color;
        this.drawGraph();
    }

    void setLinecolors(String string) {
        this.linecolors = string;
        this.drawGraph();
    }

    void setLogEnabled(boolean bl) {
        this.storeValues = bl;
        this.setValues();
    }

    void setLogFileName(String string) {
        graphFile = string;
        this.setValues();
    }

    public void setNumericResult(long l) {
        if (this.absoluteCounters) {
            if (this.pdu != null) {
                SnmpVar snmpVar = this.pdu.getVariable(0);
                if (snmpVar instanceof SnmpCounter) {
                    Object object = snmpVar.toValue();
                    l = (Long)object;
                }
                this.setResult(l);
            } else {
                this.setResult(l);
            }
        } else {
            this.setResult(l);
        }
    }

    void setPollDuration(int n) {
        if (n < 0) {
            return;
        }
        this.noOfValues = n;
        this.timeSpan = n != 0;
    }

    /*
     * Unable to fully structure code
     */
    void setResult(int var1_1, long var2_2) {
        block26: {
            block27: {
                block25: {
                    this.date = new Date();
                    var4_3 = (int)(this.date.getTime() - this.startTime) / 1000;
                    var5_4 = var2_2;
                    var7_5 = 1;
                    var8_6 = 1;
                    if (this.timeAvg) {
                        if (this.prevTime >= 0) {
                            var8_6 = var4_3 - this.prevTime;
                            if (var8_6 == 0) {
                                var8_6 = var7_5;
                            }
                            var5_4 /= (double)var8_6;
                            var7_5 = var4_3 - this.prevTime;
                        } else {
                            var5_4 /= (double)var4_3;
                        }
                        if (var1_1 == this.data.length - 1) {
                            this.prevTime = var4_3;
                        }
                    }
                    var9_7 = new double[]{var4_3, var5_4};
                    var2_2 = (long)var5_4;
                    if (!this.timeSpan) break block25;
                    if (var4_3 < this.noOfValues) {
                        if (var2_2 > this.yMax || var4_3 > this.maxX1 + this.xDiffMax || var2_2 < this.yMin) {
                            if (var2_2 > this.yMax) {
                                var10_8 = var2_2 + var2_2 / 4L;
                                if (var10_8 % 10L != 0L) {
                                    var10_8 += 10L - var10_8 % 10L;
                                }
                                this.yMax = var10_8;
                            }
                            if (var2_2 < this.yMin) {
                                var10_8 = var2_2 + var2_2 / 4L;
                                if (var10_8 % 10L != 0L) {
                                    var10_8 += -10L - var10_8 % 10L;
                                }
                                this.yMin = var10_8;
                            }
                            if (var4_3 > this.maxX1 + this.xDiffMax) {
                                this.isScrollBarEnabled = true;
                                this.isGraphResized = true;
                                this.noofpages = var4_3 / this.xDiffMax + 1;
                                this.maxX1 += this.xDiffMax;
                                ++this.wid;
                                this.setSize(this.wid, this.ht);
                            } else if (this.isXRangeChanged) {
                                this.isGraphResized = true;
                                this.noofpages = var4_3 / this.xDiffMax + 1;
                                this.maxX1 = this.maxX1 / this.xDiffMax * this.xDiffMax;
                                ++this.wid;
                                this.setSize(this.wid, this.ht);
                                this.isXRangeChanged = false;
                            }
                            if (this.graph != null) {
                                this.calculateGrid();
                            }
                            this.repaint();
                        }
                        this.addPoint(var1_1, var9_7);
                    }
                    break block26;
                }
                this.timeSpan = false;
                if (var2_2 <= this.yMax && var4_3 <= this.xMax1 && var2_2 >= this.yMin) break block27;
                if (var2_2 > this.yMax) {
                    var10_9 = var2_2 + var2_2 / 4L;
                    if (var10_9 % 10L != 0L) {
                        var10_9 += 10L - var10_9 % 10L;
                    }
                    this.yMax = var10_9;
                }
                if (var2_2 < this.yMin) {
                    var10_9 = var2_2 + var2_2 / 4L;
                    if (var10_9 % 10L != 0L) {
                        var10_9 += -10L - var10_9 % 10L;
                    }
                    this.yMin = var10_9;
                }
                while (var4_3 > this.xMax1) {
                    block28: {
                        this.xMax1 += this.xMax1 - this.xMin1;
                        if (this.xDiffMax1 <= 0 || this.xMax1 - this.xMin1 <= this.xDiffMax1) continue;
                        if (this.isScrollBarEnabled) {
                            this.xMax1 = this.xMax;
                            this.xMin1 = this.xMin;
                            this.isScrollBarEnabled = false;
                        } else {
                            this.xMin1 += this.xDiffMax1 / 2;
                            this.xMax1 = this.xMin1 + this.xDiffMax1;
                        }
                        var10_10 = 0;
                        break block28;
                        while (((double[])this.data[var10_10].firstElement())[0] < (double)this.xMin1) {
                            this.data[var10_10].removeElementAt(0);
lbl80:
                            // 2 sources

                            ** while (this.data[var10_10].size() <= 0)
lbl81:
                            // 1 sources

                        }
lbl82:
                        // 2 sources

                        ++var10_10;
                    }
                    if (var10_10 < this.data.length) ** GOTO lbl80
                }
                if (this.graph != null) {
                    this.calculateGrid();
                }
                this.repaint();
            }
            this.addPoint(var1_1, var9_7);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setResult(long var1_1) {
        block25: {
            block26: {
                block24: {
                    this.date = new Date();
                    var3_2 = (int)(this.date.getTime() - this.startTime) / 1000;
                    var4_3 = var1_1;
                    var6_4 = 1;
                    var7_5 = 1;
                    if (this.timeAvg) {
                        if (this.prevTime >= 0) {
                            var7_5 = var3_2 - this.prevTime;
                            if (var7_5 == 0) {
                                var7_5 = var6_4;
                            }
                            var4_3 /= (double)var7_5;
                            var6_4 = var3_2 - this.prevTime;
                        } else {
                            var4_3 /= (double)var3_2;
                        }
                        this.prevTime = var3_2;
                    }
                    var8_6 = new double[]{var3_2, var4_3};
                    var1_1 = (long)var4_3;
                    if (!this.timeSpan) break block24;
                    if (var3_2 < this.noOfValues) {
                        if (var1_1 > this.yMax || var3_2 > this.maxX1 + this.xDiffMax || var1_1 < this.yMin) {
                            if (var1_1 > this.yMax) {
                                var9_7 = var1_1 + var1_1 / 4L;
                                if (var9_7 % 10L != 0L) {
                                    var9_7 += 10L - var9_7 % 10L;
                                }
                                this.yMax = var9_7;
                            }
                            if (var1_1 < this.yMin) {
                                var9_7 = var1_1 + var1_1 / 4L;
                                if (var9_7 % 10L != 0L) {
                                    var9_7 += -10L - var9_7 % 10L;
                                }
                                this.yMin = var9_7;
                            }
                            if (var3_2 > this.maxX1 + this.xDiffMax) {
                                this.isScrollBarEnabled = true;
                                this.isGraphResized = true;
                                this.noofpages = var3_2 / this.xDiffMax + 1;
                                this.maxX1 += this.xDiffMax;
                                ++this.wid;
                                this.setSize(this.wid, this.ht);
                            } else if (this.isXRangeChanged) {
                                this.isGraphResized = true;
                                this.noofpages = var3_2 / this.xDiffMax + 1;
                                this.maxX1 = this.maxX1 / this.xDiffMax * this.xDiffMax;
                                ++this.wid;
                                this.setSize(this.wid, this.ht);
                                this.isXRangeChanged = false;
                            }
                            if (this.graph != null) {
                                this.calculateGrid();
                            }
                            this.repaint();
                        }
                        this.addPoint(0, var8_6);
                    }
                    break block25;
                }
                this.timeSpan = false;
                if (var1_1 <= this.yMax && var3_2 <= this.xMax1 && var1_1 >= this.yMin) break block26;
                if (var1_1 > this.yMax) {
                    var9_8 = var1_1 + var1_1 / 4L;
                    if (var9_8 % 10L != 0L) {
                        var9_8 += 10L - var9_8 % 10L;
                    }
                    this.yMax = var9_8;
                }
                if (var1_1 < this.yMin) {
                    var9_8 = var1_1 + var1_1 / 4L;
                    if (var9_8 % 10L != 0L) {
                        var9_8 += -10L - var9_8 % 10L;
                    }
                    this.yMin = var9_8;
                }
                while (var3_2 > this.xMax1) {
                    block27: {
                        this.xMax1 += this.xMax1 - this.xMin1;
                        if (this.xDiffMax1 <= 0 || this.xMax1 - this.xMin1 <= this.xDiffMax1) continue;
                        if (this.isScrollBarEnabled) {
                            this.xMax1 = this.xMax;
                            this.xMin1 = this.xMin;
                            this.isScrollBarEnabled = false;
                        } else {
                            this.xMin1 += this.xDiffMax1 / 2;
                            this.xMax1 = this.xMin1 + this.xDiffMax1;
                        }
                        var9_9 = 0;
                        break block27;
                        while (((double[])this.data[var9_9].firstElement())[0] < (double)this.xMin1) {
                            this.data[var9_9].removeElementAt(0);
lbl79:
                            // 2 sources

                            ** while (this.data[var9_9].size() <= 0)
lbl80:
                            // 1 sources

                        }
lbl81:
                        // 2 sources

                        ++var9_9;
                    }
                    if (var9_9 < this.data.length) ** GOTO lbl79
                }
                if (this.graph != null) {
                    this.calculateGrid();
                }
                this.repaint();
            }
            this.addPoint(0, var8_6);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setResult(ResultEvent var1_1) {
        try {
            this.pdu = (SnmpPDU)var1_1.getResponse();
            if (!var1_1.isSuccess()) {
                if (this.pdu == null) {
                    Utils.err(SnmpUtils.getString("Request timed out"));
                    return;
                }
                Utils.err(var1_1.getErrorString());
                return;
            }
            var2_2 = var1_1.getNumericValues();
            var3_4 = var1_1.getStringValues();
            var4_5 = new StringBuffer("");
            if (var2_2.length <= 1) {
                return;
            }
            if (this.data == null || this.data.length < var2_2.length) {
                this.data = new Vector[var2_2.length];
                var5_6 = 0;
                while (var5_6 < var2_2.length) {
                    this.data[var5_6] = new Vector<E>();
                    ++var5_6;
                }
                if (!this.absoluteCounters) {
                    this.lastValues = new long[var2_2.length];
                    var6_7 = 0;
                    while (var6_7 < var2_2.length) {
                        this.lastValues[var6_7] = -1L;
                        ++var6_7;
                    }
                }
            }
            var5_6 = 0;
            var6_7 = 0;
            var7_8 = 0;
            while (var7_8 < var2_2.length) {
                var5_6 = 0;
                var8_9 = this.pdu.getVariable(var7_8);
                if (!(var8_9 instanceof SnmpCounter) || this.absoluteCounters) ** GOTO lbl-1000
                var9_10 = this.lastValues[var7_8];
                this.lastValues[var7_8] = var2_2[var7_8];
                v0 = var7_8;
                var2_2[v0] = var2_2[v0] - var9_10;
                if (var9_10 == -1L) {
                    if (var7_8 == var2_2.length - 1) {
                        return;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    if (var8_9 instanceof SnmpString || var8_9 instanceof SnmpOID || var8_9 instanceof SnmpNull) {
                        var5_6 = 1;
                    }
                    if (var5_6 == 0) {
                        this.setResult(var7_8, var2_2[var7_8]);
                    } else if (this.check) {
                        var6_7 = 1;
                        var4_5.append(String.valueOf(String.valueOf(this.pdu.getObjectID(var7_8))) + "   : " + var3_4[var7_8] + "\n");
                    }
                }
                ++var7_8;
            }
            if (this.check && var6_7 != 0) {
                Utils.err(String.valueOf(SnmpUtils.getString("LineGraphBean Error: cannot plot these values ")) + "\n" + var4_5);
                this.check = false;
            }
        }
        catch (Exception var2_3) {
            Utils.err(String.valueOf(SnmpUtils.getString("LineGraphBean Error: cannot plot value. ")) + " " + var2_3);
        }
    }

    void setShowtitle(boolean bl) {
        this.showTitle = bl;
    }

    void setShowxlabel(boolean bl) {
        this.showXLabel = bl;
    }

    void setShowylabel(boolean bl) {
        this.showYLabel = bl;
    }

    public void setStringResult(String string) {
        if (this.check) {
            Utils.err(String.valueOf(SnmpUtils.getString("LineGraphBean Error: cannot plot string value ")) + " " + string);
            this.check = false;
        }
    }

    void setTfontname(String string) {
        this.tfontName = string;
    }

    void setTfontsize(int n) {
        this.tfontSize = n;
    }

    void setTfontstyle(String string) {
        this.tfontStyle = string;
    }

    void setTimeavg(boolean bl) {
        this.timeAvg = bl;
    }

    void setTitle(String string) {
        this.Title = string;
    }

    void setValues() {
        block7: {
            StringTokenizer stringTokenizer = new StringTokenizer(this.lineLabels, " |");
            int n = stringTokenizer.countTokens();
            this.olabels = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.olabels[n2] = stringTokenizer.nextToken();
                ++n2;
            }
            if (this.graph != null) {
                this.calculateGrid();
            }
            this.check = true;
            if (!this.storeValues) break block7;
            try {
                String string = this.getLogFileName();
                this.os = new BufferedWriter(new FileWriter(string));
                String string2 = new String(SnmpUtils.getString("OID LABEL"));
                String string3 = new String(SnmpUtils.getString("Xval"));
                String string4 = new String(SnmpUtils.getString("Poll.Val"));
                this.os.write(35);
                this.os.write(string3);
                int n3 = 0;
                while (n3 < this.olabels.length) {
                    try {
                        this.os.write(string2);
                        this.os.write(9);
                        this.os.write(string4);
                        this.os.write(9);
                    }
                    catch (Exception exception) {
                        System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception);
                    }
                    ++n3;
                }
                this.os.write(10);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Error : ")) + " " + exception);
            }
        }
    }

    void setXdiffmax(int n) {
        if (!this.timeSpan) {
            this.xDiffMax1 = n;
        } else if (n > 0) {
            this.xDiffMax = n;
        }
    }

    void setXgrid(int n) {
        if (n >= 0) {
            this.xGrid = n;
        }
    }

    void setXlabel(String string) {
        this.xLabel = string;
    }

    void setXmark(int n) {
        if (n >= 0) {
            this.xMark = n;
        }
    }

    void setXmax(int n) {
        this.setXscale(n);
        if (n == this.xMark * 60 * 60 * 60 * 24 * 7 / 5) {
            this.xUnits = (byte)7;
        }
        if (n == this.xMark * 60 * 60 * 60 * 24 / 5) {
            this.xUnits = (byte)3;
        }
        if (n == this.xMark * 60 * 60 * 60 / 5) {
            this.xUnits = (byte)4;
        }
        if (n == this.xMark * 60 * 60 / 5) {
            this.xUnits = (byte)5;
        }
        if (n == this.xMark * 60 / 5) {
            this.xUnits = (byte)6;
        }
    }

    void setXmin(int n) {
        if (this.timeSpan) {
            this.xMin = n;
        } else {
            this.xMin1 = n;
        }
    }

    void setXscale(int n) {
        if (this.timeSpan) {
            if (this.xDiffMax <= 0) {
                return;
            }
            this.xDiffMax = n;
            if (!this.isScrollBarEnabled) {
                this.xMax = this.xDiffMax;
            } else {
                this.isXRangeChanged = true;
            }
            if (this.graph != null) {
                this.calculateGrid();
                this.drawGraph();
                this.repaint();
            }
        } else {
            this.xMax1 = n;
            if (this.graph != null) {
                this.calculateGrid();
                this.drawGraph();
                this.repaint();
            }
        }
    }

    void setXunits(byte by) {
        this.xUnits = by;
        if (this.xUnits == 6) {
            this.xMax = this.xMark;
        } else if (this.xUnits == 5) {
            this.xMax = this.xMark * 60;
        } else if (this.xUnits == 4) {
            this.xMax = this.xMark * 60 * 60;
        } else if (this.xUnits == 3) {
            this.xMax = this.xMark * 60 * 60 * 24;
        } else if (this.xUnits == 7) {
            this.xMax = this.xMark * 60 * 60 * 24 * 7;
        }
    }

    void setYgrid(int n) {
        if (n >= 0) {
            this.yGrid = n;
        }
    }

    void setYlabel(String string) {
        this.yLabel = string;
    }

    void setYmark(int n) {
        if (n >= 0) {
            this.yMark = n;
        }
    }

    void setYmax(long l) {
        this.yMax = l;
    }

    void setYmin(long l) {
        this.yMin = l;
    }

    void setYunits(String string) {
        this.yUnits = string;
    }

    void setup() {
        this.yMax = 10L;
        this.xMax = 300;
        this.xMax1 = 300;
        this.line1 = new Vector();
        this.data = new Vector[1];
        this.data[0] = this.line1;
        this.date = new Date();
        this.startTime = this.date.getTime();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void updateComponent(Graphics graphics) {
        if (this.wid != this.size().width || this.ht != this.size().height) {
            this.wid = this.size().width;
            this.ht = this.size().height;
            if (this.wid < 100 || this.ht < 100) {
                if (this.wid < 100 && this.ht >= 100) {
                    this.resize(100, this.ht);
                } else if (this.wid >= 100 && this.ht < 100) {
                    this.resize(this.wid, 100);
                } else {
                    this.resize(100, 100);
                }
                this.repaint();
                return;
            }
            this.dbuf = this.createImage(this.wid, this.ht);
            this.graph = this.dbuf.getGraphics();
            this.dbuf2 = null;
            if (this.graph != null) {
                this.calculateGrid();
                this.drawGraph();
            }
            graphics.drawImage(this.dbuf, 0, 0, this);
            this.repaint();
        } else {
            if (this.dbuf == null) {
                this.dbuf = this.createImage(this.wid, this.ht);
                this.graph = this.dbuf.getGraphics();
                if (this.graph != null) {
                    this.calculateGrid();
                }
            }
            if (this.graph != null) {
                this.drawGraph();
            }
            graphics.drawImage(this.dbuf, 0, 0, this);
            if (this.valuesLegendOpen) {
                this.drawValuesLegend(this.lastx, this.lasty, graphics);
            }
        }
    }

    class StaticPolling
    implements Runnable {
        String buff = "";
        boolean first;
        boolean first1 = true;
        String[] tempOid;
        String[] tempy = null;
        int temp;
        int temptemp = 0;
        int tempTime = 1;

        StaticPolling() {
        }

        public void run() {
            try {
                LineGraphBeanWrapper.this.is = new BufferedReader(new FileReader(graphFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(SnmpUtils.getString("File not found"));
            }
            LineGraphBeanWrapper.this.setLfontsize(10);
            LineGraphBeanWrapper.this.setLfontstyle("PLAIN");
            while (true) {
                try {
                    this.buff = LineGraphBeanWrapper.this.is.readLine();
                }
                catch (Exception exception) {
                    System.out.println(String.valueOf(SnmpUtils.getString("Error Reading")) + " " + exception.getMessage());
                }
                if (this.buff == null) break;
                if (this.buff.trim().startsWith(" ") || this.buff.trim().equals("") || this.buff.trim().startsWith("#")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(this.buff);
                if (this.first) {
                    this.first = false;
                    continue;
                }
                int n = stringTokenizer.countTokens();
                int n2 = (n - 1) / 2;
                if (this.first1) {
                    LineGraphBeanWrapper.this.setDataSize(n2);
                    this.first1 = false;
                    continue;
                }
                this.tempy = new String[n2];
                this.tempOid = new String[n2];
                this.temptemp = this.temp;
                this.temp = Double.valueOf(stringTokenizer.nextToken()).intValue();
                if (this.temptemp != 0) {
                    this.tempTime = this.temp - this.temptemp;
                }
                int n3 = 0;
                while (n3 < n2) {
                    this.tempOid[n3] = stringTokenizer.nextToken();
                    this.tempy[n3] = stringTokenizer.nextToken();
                    ++n3;
                }
                int n4 = 0;
                while (n4 < n2) {
                    LineGraphBeanWrapper.this.setResult(n4, Double.valueOf(this.tempy[n4]).longValue());
                    ++n4;
                }
                try {
                    Thread.sleep(this.tempTime * 1000);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                }
            }
        }
    }
}

