/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.MbSettingsFrame;
import com.adventnet.snmp.ui.MibBrowser;
import com.adventnet.snmp.ui.MibBrowserUI;
import com.adventnet.snmp.ui.MibSettingsPanel;
import com.adventnet.snmp.ui.MibTree;
import com.adventnet.snmp.ui.SasFileDialog;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

class LoadDialog
extends JDialog
implements ActionListener {
    JLabel label = new JLabel(SnmpUtils.getString("Enter the URL or filename for MIB file"));
    Font lfont = SnmpUIUtils.getFont();
    JButton ok = new JButton("  " + SnmpUtils.getString("OK") + "  ");
    JButton ok1 = new JButton("   " + SnmpUtils.getString("OK") + "   ");
    JButton close = new JButton(SnmpUtils.getString("Close"));
    JButton browse = new JButton(SnmpUtils.getString("Browse"));
    JTextField fileTF = new JTextField(40);
    String[] loadmib = null;
    boolean loading = false;
    MibBrowser mibbrowser;
    MibTree tree;
    String prevdir = "/mibs";
    JFileChooser openDlg = null;
    SasFileDialog fdialog = null;
    MibSettingsPanel settingPanel = null;
    MbSettingsFrame browserFrame = null;
    JFrame frame = null;
    JButton option = null;
    private String currDir = "." + File.separator + "mibs";
    private String currFile = "";

    public LoadDialog(Object object, Frame frame, String string) {
        super(frame, string);
        String string2;
        if (object instanceof MibBrowser) {
            this.mibbrowser = (MibBrowser)object;
        } else if (object instanceof MibTree) {
            this.tree = (MibTree)object;
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.ok.setFont(this.lfont);
        this.ok1.setFont(this.lfont);
        this.close.setFont(this.lfont);
        this.browse.setFont(this.lfont);
        this.label.setFont(this.lfont);
        this.label.setForeground(Color.black);
        this.getContentPane().add("North", this.label);
        this.fileTF.setMinimumSize(new Dimension(300, 23));
        this.fileTF.setPreferredSize(new Dimension(300, 23));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.fileTF, gridBagConstraints);
        jPanel.add(this.fileTF);
        gridBagConstraints.weightx = 0.0;
        this.option = new JButton(SnmpUtils.getString("Load Options"));
        this.option.setFont(this.lfont);
        if (this.mibbrowser != null && this.mibbrowser.browserUi.sasclient != null) {
            MibBrowserUI mibBrowserUI = this.mibbrowser.browserUi;
            if (!mibBrowserUI.sasclient.isFileReadWrite()) {
                this.option.setEnabled(false);
            }
        }
        this.option.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.option);
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.browse, gridBagConstraints);
        jPanel.add(this.browse);
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel2.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(Color.white, Color.gray), ""));
        jPanel.add(jPanel2);
        this.getContentPane().add("Center", jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.ok);
        jPanel3.add(this.close);
        this.getContentPane().add("South", jPanel3);
        this.getContentPane().setSize(650, 125);
        this.ok.addActionListener(this);
        this.ok1.addActionListener(this);
        this.fileTF.addActionListener(this);
        this.close.addActionListener(this);
        if (this.mibbrowser != null && this.mibbrowser.applet != null && (string2 = this.mibbrowser.applet.getParameter("PROTOCOL")) != null && string2.trim().equals("2")) {
            this.browse.setEnabled(false);
        }
        if (this.mibbrowser != null && this.mibbrowser.browserUi.sasclient != null) {
            MibBrowserUI mibBrowserUI = this.mibbrowser.browserUi;
            if (!mibBrowserUI.sasclient.isFileReadWrite()) {
                this.browse.setEnabled(false);
            }
        }
        this.browse.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block59: {
            if (actionEvent.getActionCommand().equals("  " + SnmpUtils.getString("OK") + "  ") || actionEvent.getSource().equals(this.fileTF)) {
                block58: {
                    if (this.loading) {
                        return;
                    }
                    URL uRL = null;
                    this.loading = true;
                    ((Component)this).setCursor(new Cursor(3));
                    try {
                        if (this.fileTF.getText().trim().equals("")) {
                            Utils.err("\n" + SnmpUtils.getString("Enter the file Name of MibModule"));
                            ((Component)this).setCursor(new Cursor(0));
                            this.loading = false;
                            return;
                        }
                        if (this.mibbrowser != null) {
                            String string;
                            String string2 = this.fileTF.getText();
                            this.mibbrowser.browserUi.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Loading MIBs ")) + " " + string2 + "\n");
                            this.mibbrowser.tree.addMibs(string2);
                            this.mibbrowser.browserUi.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Done")) + "\n");
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \"\t\n\r|", true);
                            Vector<String> vector = new Vector<String>();
                            int n = stringTokenizer.countTokens();
                            int n2 = 0;
                            while (n2 < n) {
                                block57: {
                                    String string3 = stringTokenizer.nextToken();
                                    if (string3.equals("\"")) {
                                        try {
                                            string3 = "";
                                            string = stringTokenizer.nextToken();
                                            ++n2;
                                            if (string.equals("\"")) break block57;
                                            do {
                                                string3 = String.valueOf(string3) + string;
                                                string = stringTokenizer.nextToken();
                                                ++n2;
                                            } while (!string.equals("\""));
                                        }
                                        catch (Exception exception) {}
                                    }
                                    if (!(string3.equals(" ") || string3.equals("|") || string3.equals("\"") || string3.equals("\t") || string3.equals("\n") || string3.equals("\r"))) {
                                        vector.addElement(string3);
                                    }
                                }
                                ++n2;
                            }
                            n = vector.size();
                            this.loadmib = new String[n];
                            int n3 = 0;
                            while (n3 < n) {
                                string = (String)vector.elementAt(n3);
                                if (this.mibbrowser.applet == null) {
                                    this.loadmib[n3] = String.valueOf(string) + "|" + this.mibbrowser.tree.mibOps.getModuleNameDefinition(string);
                                } else {
                                    try {
                                        uRL = new URL(this.mibbrowser.applet.getDocumentBase().getProtocol(), this.mibbrowser.applet.getDocumentBase().getHost(), this.mibbrowser.applet.getDocumentBase().getPort(), "");
                                    }
                                    catch (Exception exception) {
                                        System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
                                    }
                                    String string4 = uRL.toString();
                                    try {
                                        this.loadmib[n3] = String.valueOf(string) + "|" + this.mibbrowser.tree.mibOps.getModuleNameDefinition(String.valueOf(string4) + string);
                                    }
                                    catch (Exception exception) {
                                        this.loadmib[n3] = String.valueOf(string) + "|" + this.mibbrowser.tree.mibOps.getModuleNameDefinition(string);
                                    }
                                }
                                ++n3;
                            }
                            this.mibbrowser.tree.repaint();
                            break block58;
                        }
                        if (this.tree != null) {
                            this.tree.addMibs(this.fileTF.getText());
                            this.tree.repaint();
                        }
                    }
                    catch (Exception exception) {
                        if (this.mibbrowser != null) {
                            if (this.mibbrowser.mibOps.isLoadFromSerializedMibs()) {
                                Utils.err(String.valueOf(SnmpUtils.getString("Error loading MIB:")) + " " + this.fileTF.getText() + "\n" + exception);
                            } else {
                                Utils.err(String.valueOf(SnmpUtils.getString("Error loading MIB: ")) + " " + this.fileTF.getText() + "\n" + exception);
                            }
                        } else if (this.tree != null) {
                            if (this.tree.mibOps.isLoadFromSerializedMibs()) {
                                Utils.err(String.valueOf(SnmpUtils.getString("Error loading MIB: ")) + " " + this.fileTF.getText() + "\n" + exception);
                            } else {
                                Utils.err(String.valueOf(SnmpUtils.getString("Error loading MIB: ")) + " " + this.fileTF.getText() + "\n" + exception);
                            }
                        }
                        ((Component)this).setCursor(new Cursor(0));
                        this.loading = false;
                        return;
                    }
                }
                ((Component)this).setCursor(new Cursor(0));
                this.setVisible(false);
            } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Browse"))) {
                if (this.loading) {
                    return;
                }
                if (actionEvent.getSource() == this.browse) {
                    if (this.mibbrowser == null) {
                        this.fileDialog();
                    } else if (this.mibbrowser.applet == null) {
                        this.fileDialog();
                    } else {
                        try {
                            String string = System.getProperty("browser");
                            if (string.equals("sun.applet.AppletViewer")) {
                                this.fileDialog();
                                break block59;
                            }
                            this.sasDialog();
                        }
                        catch (Exception exception) {
                            String string = this.mibbrowser.applet.getParameter("PROTOCOL");
                            if (string != null && string.trim().equals("2")) {
                                JOptionPane.showMessageDialog(this.mibbrowser, SnmpUtils.getString("Browse Option is not supported with HTTP protocol. Enter the filename"), SnmpUtils.getString("Message"), 1);
                                break block59;
                            }
                            this.sasDialog();
                        }
                    }
                }
            } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Close"))) {
                if (this.loading) {
                    return;
                }
                this.setVisible(false);
            } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Load Options"))) {
                if (this.mibbrowser != null) {
                    this.browserFrame = this.mibbrowser.browserModel.getSettingsFrame();
                    if (this.browserFrame == null) {
                        this.browserFrame = new MbSettingsFrame(SnmpUtils.getString("MibBrowser Settings"), this.mibbrowser.snmptasks);
                        this.mibbrowser.browserModel.setSettingsFrame(this.browserFrame);
                        this.browserFrame.tabpanel.setSelectedIndex(1);
                        this.browserFrame.addComponentListener(this.mibbrowser.browserUi.getComponentAdapter());
                        ((Component)this.browserFrame).setBounds(this.mibbrowser.browserUi.browserProperty.getMbSettingsWinPos());
                    } else {
                        this.browserFrame.updateParams();
                        this.browserFrame.tabpanel.setSelectedIndex(1);
                        this.browserFrame.mibPanel.updateList();
                    }
                    ((Component)this.browserFrame).setVisible(true);
                } else if (this.tree != null) {
                    if (this.settingPanel == null) {
                        this.settingPanel = new MibSettingsPanel(this.tree);
                        this.frame = new JFrame();
                        this.frame.setTitle(SnmpUtils.getString("Mib Settings"));
                        JPanel jPanel = new JPanel();
                        jPanel.add(this.ok1);
                        this.frame.getContentPane().setLayout(new BorderLayout());
                        this.frame.getContentPane().add((Component)this.settingPanel, "North");
                        this.frame.getContentPane().add((Component)jPanel, "South");
                        this.frame.pack();
                        ((Component)this.frame).setVisible(true);
                    } else {
                        ((Component)this.frame).setVisible(true);
                    }
                }
            } else if (actionEvent.getActionCommand().equals("   " + SnmpUtils.getString("OK") + "   ")) {
                if (this.tree != null && this.settingPanel.enabled) {
                    String string = this.settingPanel.getDriverName();
                    String string5 = this.settingPanel.getUrl();
                    if (string.equals("") || string5.equals("")) {
                        JOptionPane.showMessageDialog(this.settingPanel, SnmpUtils.getString("Enter the Database Parameters"), SnmpUtils.getString("Error Message"), 0);
                        return;
                    }
                    string5 = string5.replace('\\', '/');
                    String string6 = this.settingPanel.getUserName();
                    String string7 = this.settingPanel.getPassword();
                    try {
                        this.tree.initJdbcParams(string, string5, string6, string7);
                    }
                    catch (Exception exception) {
                        System.err.println(String.valueOf(SnmpUtils.getString("Error in getting Database connection. Please check the Jdbc Params: ")) + " " + exception);
                        return;
                    }
                    this.tree.mibOps.setLoadFromDatabase(true);
                }
                ((Component)this.frame).setVisible(false);
            }
        }
    }

    private void fileDialog() {
        if (this.openDlg == null) {
            this.openDlg = new JFileChooser();
            this.openDlg.setDialogTitle(SnmpUtils.getString("Load MIB File"));
            if (this.currDir != null) {
                File file;
                if ((this.currDir.equals("./mibs") || this.currDir.equals(".\\mibs")) && !(file = new File(this.currDir)).exists()) {
                    this.currDir = ".." + File.separator + "mibs";
                }
                if ((file = new File(this.currDir)).exists()) {
                    this.openDlg.setCurrentDirectory(file);
                } else {
                    this.openDlg.setCurrentDirectory(new File("."));
                }
            } else {
                this.openDlg.setCurrentDirectory(new File("."));
            }
            this.openDlg.addChoosableFileFilter(this.openDlg.getAcceptAllFileFilter());
        } else {
            this.openDlg.setVisible(true);
        }
        this.openDlg.setMultiSelectionEnabled(true);
        int n = this.openDlg.showOpenDialog(this);
        if (n == 0) {
            File[] fileArray = this.openDlg.getSelectedFiles();
            if (fileArray == null) {
                return;
            }
            if (fileArray.length == 0) {
                fileArray = new File[]{this.openDlg.getSelectedFile()};
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string = "";
            int n2 = 0;
            while (n2 < fileArray.length) {
                this.currFile = fileArray[n2].getName();
                this.currDir = this.openDlg.getCurrentDirectory().toString();
                if (this.currDir != null && this.currFile != null) {
                    if (!this.currDir.endsWith(File.separator)) {
                        this.currDir = String.valueOf(this.currDir.trim()) + File.separator;
                    }
                    if ((string = String.valueOf(this.currDir) + this.currFile).indexOf(" ") != -1) {
                        string = "\"" + string + "\"";
                    }
                }
                stringBuffer.append(String.valueOf(string) + " ");
                ++n2;
            }
            this.fileTF.setText(new String(stringBuffer));
        }
    }

    public String[] loadedMib() {
        if (this.loadmib != null) {
            return this.loadmib;
        }
        return null;
    }

    private void sasDialog() {
        if (this.mibbrowser != null) {
            this.fdialog = new SasFileDialog(this.mibbrowser.applet, (LoadDialog)this.browse.getTopLevelAncestor());
            this.fdialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    LoadDialog.this.fdialog = null;
                }
            });
            this.fdialog.init();
            ((Component)this.fdialog).setSize(new Dimension(500, 380));
            this.fdialog.setDirectory(this.prevdir);
            Utils.centerWindow(this.fdialog);
            this.fdialog.show();
        }
    }

    public synchronized void setVisible(boolean bl) {
        this.loading = false;
        super.setVisible(bl);
    }
}

