/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.MibBrowserUI;
import com.adventnet.snmp.ui.MibSettingsPanel;
import com.adventnet.snmp.ui.SnmpTasks;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;

class MbSettingsFrame
extends JDialog
implements ActionListener {
    SnmpTasks reqServer;
    MibSettingsPanel mibPanel;
    JTextField snmpPort;
    JTextField trapPort;
    JTextField timeout;
    JTextField retries;
    JComboBox graphChoice;
    JComboBox version;
    JComboBox encBox;
    DefaultComboBoxModel encModel;
    Vector encVector;
    boolean hideCommunity = false;
    String graphType = SnmpUtils.getString("Line Graph");
    String versionType = SnmpUtils.getString("Snmp_Version1");
    String snmpport;
    String trapport;
    String time;
    String tries;
    String graph;
    String versionBefore;
    String browserPath;
    String encString;
    boolean hide;
    String mibsdriver = "";
    String mibsurl = "";
    String mibsuser = "";
    String mibspass = "";
    JRadioButton resultbutton;
    JRadioButton mibdescrbutton;
    JRadioButton multivarbutton;
    Font lfont = SnmpUIUtils.getFont();
    JTabbedPane tabpanel = null;

    MbSettingsFrame(String string, SnmpTasks snmpTasks) {
        super((JFrame)SwingUtilities.windowForComponent(snmpTasks.browser), string, true);
        ((Component)this).setBackground(Color.cyan);
        this.reqServer = snmpTasks;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.snmpPort = new JTextField(String.valueOf(this.reqServer.getTargetPort()), 10);
        this.snmpport = this.snmpPort.getText();
        this.trapPort = new JTextField(String.valueOf(this.reqServer.browser.getTrapPort()), 10);
        this.trapport = this.trapPort.getText();
        this.timeout = new JTextField(String.valueOf(this.reqServer.getTimeout()), 10);
        this.time = this.timeout.getText();
        this.retries = new JTextField(String.valueOf(this.reqServer.getRetries()), 10);
        this.tries = this.retries.getText();
        this.version = new JComboBox();
        this.version.setFont(this.lfont);
        this.version.setActionCommand("Version");
        this.version.addItem(SnmpUtils.getString("Snmp_Version1"));
        this.graphChoice = new JComboBox();
        this.graphChoice.setFont(this.lfont);
        this.graphChoice.setActionCommand("GraphChoice");
        this.graphChoice.addItem(SnmpUtils.getString("Line Graph"));
        this.graphChoice.addItem(SnmpUtils.getString("Bar Chart"));
        this.graph = SnmpUtils.getString("Line Graph");
        this.addDouble(jPanel, gridBagLayout, gridBagConstraints, SnmpUtils.getString("Snmp Version"), SnmpUtils.getString("Graph Type"), this.version, this.graphChoice);
        this.addDouble(jPanel, gridBagLayout, gridBagConstraints, SnmpUtils.getString("Snmp Port"), SnmpUtils.getString("Trap Port"), this.snmpPort, this.trapPort);
        this.addDouble(jPanel, gridBagLayout, gridBagConstraints, SnmpUtils.getString("Timeout"), SnmpUtils.getString("Retries"), this.timeout, this.retries);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(Color.white, Color.gray), SnmpUtils.getString("Display"), 1, 2, this.lfont, Color.black));
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        this.resultbutton = new JRadioButton(SnmpUtils.getString("Result Display"), false);
        this.mibdescrbutton = new JRadioButton(SnmpUtils.getString("MIB Description"), true);
        this.multivarbutton = new JRadioButton(SnmpUtils.getString("Multi-Varbind"), false);
        this.resultbutton.setFont(this.lfont);
        this.mibdescrbutton.setFont(this.lfont);
        this.multivarbutton.setFont(this.lfont);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.resultbutton);
        buttonGroup.add(this.mibdescrbutton);
        buttonGroup.add(this.multivarbutton);
        gridBagConstraints.insets = new Insets(0, 50, 0, 75);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.resultbutton, gridBagConstraints);
        jPanel2.add(this.resultbutton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.mibdescrbutton, gridBagConstraints);
        jPanel2.add(this.mibdescrbutton);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.multivarbutton, gridBagConstraints);
        jPanel2.add(this.multivarbutton);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(SnmpUtils.getString("Apply"));
        jButton.setFont(this.lfont);
        JButton jButton2 = new JButton(SnmpUtils.getString("Cancel"));
        jButton2.setFont(this.lfont);
        JButton jButton3 = new JButton("  " + SnmpUtils.getString("OK") + "  ");
        jButton3.setFont(this.lfont);
        JButton[] jButtonArray = new JButton[]{jButton, jButton2, jButton3};
        jPanel3.add(jButtonArray[0]);
        jPanel3.add(jButtonArray[1]);
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel(String.valueOf(SnmpUtils.getString("Encoding ")) + " ");
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        jPanel4.add(jLabel);
        this.encString = this.reqServer.getCharacterEncoding();
        this.encVector = new Vector();
        this.encVector.addElement(this.encString);
        this.encModel = new DefaultComboBoxModel(this.encVector);
        this.encBox = new JComboBox(this.encModel);
        this.encBox.setFont(this.lfont);
        this.encBox.setMinimumSize(new Dimension(100, 23));
        this.encBox.setEditable(true);
        this.encBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)MbSettingsFrame.this.encBox.getSelectedItem();
                if (string != null) {
                    MbSettingsFrame.this.updateEnc(string);
                }
            }
        });
        jPanel4.add(this.encBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel5.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel5.add(jPanel2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel5.add(jPanel4);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel5.add(jPanel3);
        this.reqServer.browser.browserModel.readFile();
        this.mibPanel = new MibSettingsPanel(this.reqServer.browser);
        this.tabpanel = new JTabbedPane();
        this.tabpanel.setFont(this.lfont);
        this.tabpanel.addTab(SnmpUtils.getString("General"), jPanel5);
        boolean bl = false;
        if (this.reqServer.browser.browserUi.sasclient != null) {
            MibBrowserUI mibBrowserUI = this.reqServer.browser.browserUi;
            bl = mibBrowserUI.sasclient.isFileReadWrite();
        } else {
            bl = true;
        }
        if (bl) {
            this.tabpanel.addTab(SnmpUtils.getString("Mib Settings"), this.mibPanel);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.tabpanel, gridBagConstraints);
        this.getContentPane().add(this.tabpanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(jButtonArray[2], gridBagConstraints);
        this.getContentPane().add(jButtonArray[2]);
        this.pack();
        jButtonArray[0].addActionListener(this);
        jButtonArray[1].addActionListener(this);
        jButtonArray[2].addActionListener(this);
        this.graphChoice.addActionListener(this);
        this.version.addActionListener(this);
        this.restore();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Apply"))) {
            this.updateParameters();
            this.display();
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Cancel"))) {
            this.restore();
            if (!this.reqServer.browser.display.cardPanel1.isVisible()) {
                this.resultbutton.setSelected(true);
            } else {
                if (this.reqServer.browser.display.descrPanel.isShowing()) {
                    this.mibdescrbutton.setSelected(true);
                }
                if (this.reqServer.browser.display.bottomPanel.isShowing()) {
                    this.multivarbutton.setSelected(true);
                }
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("  " + SnmpUtils.getString("OK") + "  ")) {
            int n;
            if (!this.reqServer.browser.browserModel.hideJdbc && this.mibPanel.enabled && (n = this.updateJdbcParams()) == 0) {
                return;
            }
            this.updateParameters();
            this.updateLoadDialog();
            this.display();
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("GraphChoice")) {
            this.graphType = (String)this.graphChoice.getSelectedItem();
        } else if (actionEvent.getActionCommand().equals("Version")) {
            this.versionType = (String)this.version.getSelectedItem();
        }
    }

    void addDouble(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, String string2, JComponent jComponent, JComponent jComponent2) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(string2);
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jPanel.add(jComponent2);
    }

    private void display() {
        if (this.resultbutton.isSelected()) {
            this.resultbutton.addItemListener(this.reqServer.browser.browserUi);
            this.resultbutton.setSelected(true);
            this.resultbutton.removeItemListener(this.reqServer.browser.browserUi);
        } else if (this.mibdescrbutton.isSelected()) {
            this.mibdescrbutton.addItemListener(this.reqServer.browser.browserUi);
            this.mibdescrbutton.setSelected(true);
            this.mibdescrbutton.removeItemListener(this.reqServer.browser.browserUi);
        } else if (this.multivarbutton.isSelected()) {
            this.multivarbutton.addItemListener(this.reqServer.browser.browserUi);
            this.multivarbutton.setSelected(true);
            this.multivarbutton.removeItemListener(this.reqServer.browser.browserUi);
        }
    }

    void restore() {
        this.snmpPort.setText(this.snmpport);
        this.trapPort.setText(this.trapport);
        this.timeout.setText(this.time);
        this.retries.setText(this.tries);
        this.versionType = SnmpUtils.getString("Snmp_Version1");
        this.version.setSelectedItem(this.versionType);
        this.graphChoice.setSelectedItem(this.graph);
        this.graphType = this.graph;
        this.encBox.setSelectedItem(this.encString);
        this.reqServer.setCharacterEncoding(this.encString);
    }

    private void updateEnc(String string) {
        if (string.trim().length() != 0) {
            if (this.encVector.contains(string)) {
                this.encModel.setSelectedItem(string);
                return;
            }
            this.encModel.addElement(string);
            this.encModel.setSelectedItem(string);
        }
    }

    int updateJdbcParams() {
        String string = this.mibPanel.getDriverName().trim();
        String string2 = this.mibPanel.getUrl().trim();
        if (string.equals("") || string2.equals("")) {
            JOptionPane.showMessageDialog(this, SnmpUtils.getString("Enter the Database Parameters"), SnmpUtils.getString("Error Message"), 0);
            return 0;
        }
        string2 = string2.replace('\\', '/');
        String string3 = this.mibPanel.getUserName().trim();
        String string4 = this.mibPanel.getPassword().trim();
        if (this.mibsdriver.equals(string) && this.mibsurl.equals(string2) && this.mibsuser.equals(string3) && this.mibspass.equals(string4)) {
            this.reqServer.setLoadMibsFromDatabase(true);
            return 1;
        }
        Enumeration enumeration = this.reqServer.browser.mibOps.getMibModules();
        if (enumeration.hasMoreElements()) {
            Object[] objectArray = new Object[]{SnmpUtils.getString("Yes"), SnmpUtils.getString("No")};
            int n = JOptionPane.showOptionDialog(this, " " + SnmpUtils.getString("Mibs has been loaded from other Database .\n Do you want to change to this database.\n All the Mibs already loaded will be unloaded"), SnmpUtils.getString("Warning Message"), 0, 2, null, objectArray, objectArray[0]);
            if (n == 0) {
                try {
                    this.reqServer.browser.browserModel.deleteMibs(this.reqServer.browser.browserUi.tree);
                }
                catch (Exception exception) {}
            } else if (n == 1) {
                return 0;
            }
        }
        try {
            this.reqServer.browser.mibOps.initJdbcParams(string, string2, string3, string4);
        }
        catch (Exception exception) {
            Utils.err(String.valueOf(SnmpUtils.getString("Error in getting Database Connection.Please check the Jdbc Parameters")) + ":\n " + exception);
            return 0;
        }
        this.reqServer.setLoadMibsFromDatabase(true);
        this.mibsdriver = string;
        this.mibsurl = string2;
        this.mibsuser = string3;
        this.mibspass = string4;
        return 1;
    }

    void updateLoadDialog() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.mibPanel.loadListModel.isEmpty()) {
            Object[] objectArray = this.mibPanel.fileList.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                String string = (String)objectArray[n];
                if (string.indexOf(" ") != -1) {
                    string = "\"" + string + "\"";
                }
                stringBuffer.append(String.valueOf(string) + " ");
                ++n;
            }
        } else {
            Enumeration enumeration = this.mibPanel.loadListModel.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.indexOf(" ") != -1) {
                    string = "\"" + string + "\"";
                }
                stringBuffer.append(String.valueOf(string) + " ");
            }
        }
        if (this.reqServer.browser.browserUi.load != null && stringBuffer.length() != 0) {
            this.reqServer.browser.browserUi.load.fileTF.setText(new String(stringBuffer));
        }
    }

    void updateParameters() {
        String string = null;
        string = this.snmpPort.getText();
        if (string != null) {
            try {
                this.reqServer.setTargetPort(Integer.parseInt(string));
                this.snmpport = this.snmpPort.getText();
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid SnmpPort Parameter: ")) + " " + string);
            }
        }
        if ((string = this.trapPort.getText()) != null) {
            try {
                this.reqServer.browser.setTrapPort(Integer.parseInt(string));
                this.trapport = this.trapPort.getText();
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid TrapPort Parameter: ")) + " " + string);
            }
        }
        if ((string = this.timeout.getText()) != null) {
            try {
                this.reqServer.setTimeout(Integer.parseInt(string));
                this.time = this.timeout.getText();
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid Timeout Parameter: ")) + " " + string);
            }
        }
        if ((string = this.retries.getText()) != null) {
            try {
                this.reqServer.setRetries(Integer.parseInt(string));
                this.tries = this.retries.getText();
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Invalid Retries Parameter: ")) + " " + string);
            }
        }
        this.hide = this.hideCommunity;
        this.reqServer.browser.setGraphType(this.graphType);
        this.graph = this.graphType;
        string = (String)this.encBox.getSelectedItem();
        if (string != null && !string.equals("")) {
            this.reqServer.setCharacterEncoding(string);
            this.encString = string;
        }
        this.writeToFile();
    }

    void updateParams() {
        this.snmpPort.setText(String.valueOf(this.reqServer.getTargetPort()));
        this.trapPort.setText(String.valueOf(this.reqServer.browser.getTrapPort()));
    }

    private void writeToFile() {
        block15: {
            String[] stringArray = new String[4];
            if (!this.reqServer.browser.browserModel.hideJdbc && this.mibPanel.enabled) {
                if (this.reqServer.browser.browserModel.values == null) {
                    this.reqServer.browser.browserModel.values = new String[4];
                }
                stringArray[0] = this.reqServer.browser.browserModel.values[0] = String.valueOf(this.mibPanel.getDriverName()) + " ";
                stringArray[1] = this.reqServer.browser.browserModel.values[1] = String.valueOf(this.mibPanel.getUrl()) + " ";
                stringArray[2] = this.reqServer.browser.browserModel.values[2] = String.valueOf(this.mibPanel.getUserName()) + " ";
                stringArray[3] = this.reqServer.browser.browserModel.values[3] = String.valueOf(this.mibPanel.getPassword()) + " ";
            } else if (this.reqServer.browser.browserModel.values != null && this.reqServer.browser.browserModel.values.length == 4 && this.reqServer.browser.browserModel.values[0] != null) {
                stringArray[0] = String.valueOf(this.reqServer.browser.browserModel.values[0]) + " ";
                stringArray[1] = String.valueOf(this.reqServer.browser.browserModel.values[1]) + " ";
                stringArray[2] = String.valueOf(this.reqServer.browser.browserModel.values[2]) + " ";
                stringArray[3] = String.valueOf(this.reqServer.browser.browserModel.values[3]) + " ";
            } else {
                stringArray[0] = " ";
                stringArray[1] = " ";
                stringArray[2] = " ";
                stringArray[3] = " ";
            }
            if (this.reqServer.browser.applet == null) {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("DataParams.store")));
                    int n = 0;
                    while (n < stringArray.length) {
                        bufferedWriter.write(stringArray[n], 0, stringArray[n].length());
                        bufferedWriter.newLine();
                        bufferedWriter.flush();
                        ++n;
                    }
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            } else {
                StringBuffer stringBuffer = new StringBuffer("");
                int n = 0;
                while (n < stringArray.length) {
                    stringBuffer.append(stringArray[n]);
                    stringBuffer.append("\n");
                    ++n;
                }
                String string = stringBuffer.toString();
                byte[] byArray = new byte[string.length()];
                try {
                    byArray = string.getBytes();
                    String string2 = this.reqServer.browser.applet.getParameter("PROTOCOL");
                    if (string2 != null && string2.trim().equals("2")) {
                        return;
                    }
                    if (this.reqServer.browser.browserUi.sasclient == null) break block15;
                    MibBrowserUI mibBrowserUI = this.reqServer.browser.browserUi;
                    if (mibBrowserUI.sasclient.isFileReadWrite()) {
                        this.reqServer.browser.browserUi.sasclient.saveFile("DataParams.store", byArray);
                    }
                }
                catch (Exception exception) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Error : ")) + " " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }
}

