/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

final class MessageWindow
extends JDialog
implements ActionListener,
WindowListener {
    JTextArea messageTA = new JTextArea();
    JScrollPane messageJsp = new JScrollPane(this.messageTA);
    JButton okBttn = new JButton("  " + SnmpUtils.getString("OK") + "  ");
    private Point screenCenter;
    Font lfont = SnmpUIUtils.getFont();
    private static MessageWindow defaultMessageWindow;

    private MessageWindow(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.setDefaultCloseOperation(0);
        this.setUpGui();
        this.okBttn.addActionListener(this);
        this.okBttn.setFont(this.lfont);
        this.addWindowListener(this);
        this.okBttn.requestDefaultFocus();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenCenter = new Point(dimension.width / 2, dimension.height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setVisible(false);
    }

    private void setUpGui() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.messageTA.setLineWrap(true);
        this.messageTA.setWrapStyleWord(true);
        this.messageTA.setEditable(false);
        this.messageTA.setOpaque(false);
        this.messageTA.setBackground(((Component)this).getBackground());
        this.messageJsp.setBorder(new CompoundBorder(new TitledBorder(""), new EmptyBorder(5, 5, 2, 5)));
        this.getContentPane().add((Component)this.messageJsp, "Center");
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "South");
        this.okBttn.setMnemonic('O');
        jPanel.add(this.okBttn);
    }

    private void showMessage(String string, String string2, int n, int n2) {
        this.setTitle(string);
        this.messageTA.setRows(n);
        this.messageTA.setColumns(n2);
        this.messageTA.setText(string2);
        this.messageTA.setRequestFocusEnabled(false);
        this.pack();
        ((Component)this).setSize(650, 200);
        ((Component)this).setLocation(this.screenCenter.x - this.getSize().width / 2, this.screenCenter.y - this.getSize().height / 2);
        ((Component)this).setVisible(true);
    }

    public static void showMessage(JFrame jFrame, String string, String string2, int n, int n2) {
        if (defaultMessageWindow == null) {
            defaultMessageWindow = new MessageWindow(jFrame);
        }
        defaultMessageWindow.showMessage(string, string2, n, n2);
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.okBttn.requestFocus();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

