/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpPropertyListener;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.ui.DefaultMibBrowserModel;
import com.adventnet.snmp.ui.LineGraphBean;
import com.adventnet.snmp.ui.MbDisplayPanel;
import com.adventnet.snmp.ui.MibBrowserUI;
import com.adventnet.snmp.ui.MibTree;
import com.adventnet.snmp.ui.SnmpTasks;
import com.adventnet.snmp.ui.ToolBar;
import com.adventnet.snmp.ui.TrapViewer;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.net.URL;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class MibBrowser
extends JPanel {
    MbDisplayPanel display = null;
    MibBrowserUI browserUi = null;
    DefaultMibBrowserModel browserModel = null;
    SnmpTasks snmptasks;
    MibTree tree = null;
    MibOperations mibOps = null;
    Applet applet = null;
    LineGraphBean lineGraphBean = null;

    public MibBrowser() {
        this.snmptasks = new SnmpTasks(this);
        this.setup();
    }

    public MibBrowser(MibTree mibTree) {
        this.tree = mibTree;
        this.snmptasks = new SnmpTasks(this);
        this.setup();
    }

    public MibBrowser(Applet applet) {
        if (SnmpUtils.INTERNATIONALIZE) {
            SnmpUtils.setApplet(applet);
        }
        this.applet = applet;
        this.snmptasks = new SnmpTasks(this, applet);
        this.setup();
    }

    public MibBrowser(Applet applet, MibTree mibTree) {
        this.tree = mibTree;
        this.applet = applet;
        this.snmptasks = new SnmpTasks(this, applet);
        this.setup();
    }

    public void addSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        this.browserModel.addSnmpPropertyListener(snmpPropertyListener);
    }

    void appendDebugText(String string) {
        this.browserUi.appendDebugText(string);
    }

    public void cleanUp() {
        this.browserModel.cleanUp();
    }

    ImageIcon[] createImageIcon(String[] stringArray) {
        return this.browserUi.createImageIcon(stringArray);
    }

    public boolean findNext(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.browserModel.findNext(string, bl, bl2, bl3);
    }

    public String getAgentPort() {
        return this.browserModel.getAgentPort();
    }

    JButton getButtonAt(int n) {
        return this.browserUi.getButtonAt(n);
    }

    public String getCharacterEncoding() {
        return this.snmptasks.getCharacterEncoding();
    }

    public String getCommunity() {
        return this.browserModel.getCommunity();
    }

    JTextArea getDebugText() {
        return this.browserUi.getDebugText();
    }

    String getGraphType() {
        return this.browserUi.getGraphType();
    }

    public String getHostname() {
        return this.browserModel.getHostname();
    }

    public LineGraphBean getLineGraphBean() {
        return this.lineGraphBean;
    }

    public MbDisplayPanel getMbDisplayPanel() {
        return this.browserUi.getMbDisplayPanel();
    }

    public JMenuBar getMenuBar() {
        return this.browserUi.getMenuBar();
    }

    public Font getMenuFont() {
        return this.browserUi.getMenuFont();
    }

    public int getMibBrowserDisplayView() {
        return this.browserUi.getMibBrowserDisplayView();
    }

    public String getMibModules() {
        return this.browserModel.getMibModules();
    }

    public MibOperations getMibOperations() {
        return this.browserModel.getMibOperations();
    }

    public MibTree getMibTree() {
        return this.browserModel.getMibTree();
    }

    public Dimension getMinimumSize() {
        return this.browserUi.getMinimumSize();
    }

    public String getMultipleObjectID() {
        return this.browserModel.getMultipleObjectID();
    }

    Vector getMultipleOids() {
        return this.browserModel.getMultipleOids();
    }

    public String getNumericObjectID() {
        return this.browserModel.getNumericObjectID();
    }

    public String getObjectID() {
        return this.browserModel.getObjectID();
    }

    public boolean getOverwriteCMI() {
        return this.browserModel.getOverwriteCMI();
    }

    Vector getPathInfo() {
        return this.browserModel.getPathInfo();
    }

    public Dimension getPreferredSize() {
        return this.browserUi.getPreferredSize();
    }

    public String getRetries() throws NumberFormatException {
        return this.browserModel.getRetries();
    }

    public MibModule getSelectedModule() {
        return this.browserModel.getSelectedModule();
    }

    public String getSerializedMibFileName() {
        return this.browserModel.getSerializedMibFileName();
    }

    public String getSetValue() {
        return this.browserModel.getSetValue();
    }

    String[] getSetValues() {
        return this.browserModel.getSetValues();
    }

    public SnmpTasks getSnmpTasks() {
        return this.browserModel.getSnmpTasks();
    }

    public String getTargetHost() {
        return this.browserModel.getTargetHost();
    }

    public Vector getTargetHostNames() {
        return this.browserModel.getTargetHostNames();
    }

    public int getTargetPort() {
        return this.browserModel.getTargetPort();
    }

    public String getTimeout() {
        return this.browserModel.getTimeout();
    }

    public ToolBar getToolBar() {
        return this.browserUi.getToolBar();
    }

    public int getTrapPort() {
        return this.browserModel.getTrapPort();
    }

    public TrapViewer getTrapViewer() {
        return this.browserUi.getTrapViewer();
    }

    String getVersionString() {
        return this.browserModel.getVersionString();
    }

    public String getWriteCommunity() {
        return this.browserModel.getWriteCommunity();
    }

    public void hideJdbc(boolean bl) {
        this.browserModel.hideJdbc = bl;
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) throws ClassNotFoundException, SQLException {
        this.browserModel.initJdbcParams(string, string2, string3, string4);
    }

    public static void internationalize(Locale locale, Font font) {
        SnmpUIUtils.setFont(font);
        SnmpUtils.INTERNATIONALIZE = true;
        SnmpUtils.locale = locale;
    }

    public boolean isLoadFromCompiledMibs() {
        return this.browserModel.isLoadFromCompiledMibs();
    }

    public boolean isLoadFromSerializedMibs() {
        return this.browserModel.isLoadFromSerializedMibs();
    }

    public boolean isLoadMibsFromDatabase() {
        return this.browserModel.isLoadMibsFromDatabase();
    }

    public boolean isMenuBarVisible() {
        return this.browserUi.isMenuBarVisible();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.browserModel.isOverwriteMibsInDatabase();
    }

    public boolean isReadDesc() {
        return this.browserModel.isReadDesc();
    }

    public boolean isSerializeMibs() {
        return this.browserModel.isSerializeMibs();
    }

    public boolean isToolBarVisible() {
        return this.browserUi.isToolBarVisible();
    }

    public void loadMib(String string) {
        this.browserModel.loadMib(string);
    }

    public void releaseResources() {
        this.getSnmpTasks().releaseResources();
    }

    public void removeSnmpPropertyListener(SnmpPropertyListener snmpPropertyListener) {
        this.browserModel.removeSnmpPropertyListener(snmpPropertyListener);
    }

    public void setAgentPort(String string) throws NumberFormatException {
        this.browserModel.setAgentPort(string);
    }

    public void setCharacterEncoding(String string) {
        this.snmptasks.setCharacterEncoding(string);
    }

    public void setCommunity(String string) {
        this.browserModel.setCommunity(string);
    }

    public void setDebug(boolean bl) {
        this.browserModel.setDebug(bl);
    }

    void setGraphType(String string) {
        this.browserUi.setGraphType(string);
    }

    public void setHelpURL(URL uRL) {
        this.browserUi.helpurl = uRL;
    }

    public void setHostname(String string) {
        this.browserModel.setHostname(string);
    }

    public void setLineGraphBean(LineGraphBean lineGraphBean) {
        this.lineGraphBean = lineGraphBean;
    }

    public void setLoadFromCompiledMibs(boolean bl) {
        this.browserModel.setLoadFromCompiledMibs(bl);
    }

    public void setLoadFromSerializedMibs(boolean bl) {
        this.browserModel.setLoadFromSerializedMibs(bl);
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.browserModel.setLoadMibsFromDatabase(bl);
    }

    public void setMenuBarVisible(boolean bl) {
        this.browserUi.setMenuBarVisible(bl);
    }

    public void setMenuFont(Font font) {
        this.browserUi.setMenuFont(font);
    }

    public void setMibBrowserDisplayView(int n) {
        this.browserUi.setMibBrowserDisplayView(n);
    }

    public void setMibModules(String string) {
        this.browserModel.setMibModules(string);
    }

    public void setMibOperations(MibOperations mibOperations) {
        this.snmptasks.setMibOperations(mibOperations);
        this.browserModel.tree.mibOps = mibOperations;
    }

    public void setMibTreeExpandable(boolean bl) {
        this.browserModel.setMibTreeExpandable(bl);
    }

    public void setMultipleObjectID(String string) {
        this.browserModel.setMultipleObjectID(string);
    }

    public void setObjectID(String string) {
        this.browserModel.setObjectID(string);
    }

    public void setOverwriteCMI(boolean bl) {
        this.browserModel.setOverwriteCMI(bl);
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.browserModel.setOverwriteMibsInDatabase(bl);
    }

    public void setReadDesc(boolean bl) {
        this.browserModel.setReadDesc(bl);
    }

    public void setRetries(String string) throws NumberFormatException {
        this.browserModel.setRetries(string);
    }

    public void setSerializeMibs(boolean bl) {
        this.browserModel.setSerializeMibs(bl);
    }

    public void setSerializedMibFileName(String string) {
        this.browserModel.setSerializedMibFileName(string);
    }

    public void setSetValue(String string) {
        this.browserModel.setSetValue(string);
    }

    public void setSettingsTitle(String string) {
        this.browserUi.setSettingsTitle(string);
    }

    public void setTargetHost(String string) {
        this.browserModel.setTargetHost(string);
    }

    public void setTargetHostNames(Vector vector) {
        this.browserModel.setTargetHostNames(vector);
    }

    public void setTargetPort(int n) {
        this.browserModel.setTargetPort(n);
    }

    public void setTimeout(String string) throws NumberFormatException {
        this.browserModel.setTimeout(string);
    }

    public void setToolBarVisible(boolean bl) {
        this.browserUi.setToolBarVisible(bl);
    }

    public void setTrapPort(int n) {
        this.browserModel.setTrapPort(n);
    }

    ToolBar setUpDebugToolBar() {
        return this.browserUi.setUpDebugToolBar();
    }

    ToolBar setUpToolBar() {
        return this.browserUi.setUpToolBar();
    }

    void setVersionString(String string) {
        this.browserModel.setVersionString(string);
    }

    public void setWriteCommunity(String string) {
        this.browserModel.setWriteCommunity(string);
    }

    void setup() {
        this.browserUi = this.applet == null ? new MibBrowserUI() : new MibBrowserUI(this.applet);
        this.browserModel = new DefaultMibBrowserModel(this.snmptasks, this.browserUi);
        this.browserUi.setModel(this.browserModel, this.snmptasks);
        this.browserModel.setMibBrowser(this);
        this.mibOps = this.browserModel.getMibOperations();
        this.display = this.browserModel.getDisplay();
        if (this.tree == null) {
            this.tree = this.applet != null ? new MibTree(this.mibOps, this.applet) : new MibTree(this.mibOps);
        }
        this.tree.setMinimumSize(new Dimension(100, 100));
        this.browserModel.setMibTree(this.tree);
        this.browserUi.setup();
        this.setLayout(new BorderLayout());
        this.add("Center", this.browserUi);
    }

    public void unloadMib(String string) {
        this.browserModel.unloadMib(string);
    }
}

