/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpServer;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.ui.BarDialog;
import com.adventnet.snmp.ui.BrowserAction;
import com.adventnet.snmp.ui.BrowserProperty;
import com.adventnet.snmp.ui.DebugInterface;
import com.adventnet.snmp.ui.DefaultMibBrowserModel;
import com.adventnet.snmp.ui.FindDialog;
import com.adventnet.snmp.ui.GraphDialog;
import com.adventnet.snmp.ui.LoadDialog;
import com.adventnet.snmp.ui.MbDisplayPanel;
import com.adventnet.snmp.ui.MbSettingsFrame;
import com.adventnet.snmp.ui.MibDescription;
import com.adventnet.snmp.ui.MibTree;
import com.adventnet.snmp.ui.NodeData;
import com.adventnet.snmp.ui.NodeSystemTreeModel;
import com.adventnet.snmp.ui.SearchListener;
import com.adventnet.snmp.ui.SnmpTablePanel;
import com.adventnet.snmp.ui.SnmpTasks;
import com.adventnet.snmp.ui.TextPrinter;
import com.adventnet.snmp.ui.TextWriter;
import com.adventnet.snmp.ui.ToolBar;
import com.adventnet.snmp.ui.TrapParserBean;
import com.adventnet.snmp.ui.TrapViewer;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.snmp.utils.SnmpDecoder;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import com.sun.jimi.core.component.JimiCanvas;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

class MibBrowserUI
extends JPanel
implements ActionListener,
DebugInterface,
SearchListener,
VetoableChangeListener,
TreeSelectionListener,
ItemListener,
MouseListener {
    BrowserProperty browserProperty = null;
    JSplitPane splitPane = null;
    DefaultMibBrowserModel browserModel = null;
    MibDescription mibdescr = null;
    MbDisplayPanel display = new MbDisplayPanel();
    SnmpTasks snmptasks;
    Hashtable mibHashtable = null;
    Vector moduleVector = null;
    Vector pathModuleVector = null;
    TrapViewer trap = null;
    MibTree tree = null;
    FindDialog findDialog = null;
    Applet applet = null;
    static int GET_FILE_REQ = 3;
    static int GET_FILE_RESP = 4;
    SASClient sasclient = null;
    LoadDialog load = null;
    URL helpurl = null;
    Vector selComp = null;
    BufferedWriter be = null;
    BufferedReader br = null;
    boolean descriptionOpen = false;
    Font lfont = SnmpUIUtils.getFont();
    String settingsTitle = SnmpUtils.getString("MibBrowser Settings");
    JMenuBar menuBar = null;
    ToolBar toolbar = null;
    public static final int SHOW_MIB_DESCRIPTION = 0;
    public static final int SHOW_RESULT_DISPLAY = 1;
    public static final int SHOW_MULTI_VARBIND = 2;
    int view = 0;
    JDialog adlg = null;
    JFrame debugWindow = null;
    JPanel debugPanel = null;
    JPanel decodePanel = null;
    JScrollPane scrollPanel1 = null;
    JTextField fileField = null;
    JTextArea hexArea = null;
    SnmpDecoder decoder = null;
    JTextArea debugText = null;
    JTextArea decodeText = null;
    JFrame describeWindow = null;
    JTextArea describeText = null;
    MbSettingsFrame mbframe = null;
    String graphType = SnmpUtils.getString("Line Graph");
    String tempOid = "";
    String tempVal = "";
    JFileChooser saveDlg = null;
    private String m_sCurrFile = "";
    private String m_sCurrDir = "";
    JDialog trapParserFrame;
    TrapParserBean trapParser = null;
    private ImageIcon debugIcon = null;
    private ImageIcon decoderIcon = null;
    JMenu fileMenu = null;
    JMenuItem loadItem = null;
    JMenuItem unloadItem = null;
    JMenuItem unloadallItem = null;
    JMenuItem saveItem = null;
    JMenuItem printItem = null;
    JMenuItem mibmenu = null;
    JMenuItem loadallItem = null;
    int mibcount = 0;
    JMenu editMenu = null;
    JMenuItem generalsettingsItem = null;
    JMenuItem findItem = null;
    JMenu viewMenu = null;
    JMenu displayMenu = null;
    JRadioButtonMenuItem resultItem = null;
    JRadioButtonMenuItem mibdescrItem = null;
    JRadioButtonMenuItem multivarItem = null;
    JCheckBoxMenuItem toolbarItem = null;
    JMenuItem trapItem = null;
    JMenuItem linegraphItem = null;
    JMenuItem bargraphItem = null;
    JMenuItem tableItem = null;
    JMenuItem descrItem = null;
    JMenuItem debugItem = null;
    JMenu operationsMenu = null;
    JMenuItem getItem = null;
    JMenuItem getnextItem = null;
    JMenuItem setItem = null;
    JMenuItem stopItem = null;
    JMenuItem clearItem = null;
    JMenu helpMenu = null;
    JMenuItem helpItem = null;
    JMenuItem aboutItem = null;
    JButton[] buttons = null;
    JButton[] dbuttons = new JButton[3];
    NodeData selectedNode = null;
    Vector tempModVector = new Vector();
    String searchString = null;
    NodeSystemTreeModel model;
    private Vector nodeNameVec = new Vector();
    private String partStr = null;
    private boolean isCaseSens = false;
    private boolean isWholeWord = false;
    TreePath selPath;
    JPopupMenu menu = null;
    static /* synthetic */ Class class$java$awt$Frame;

    MibBrowserUI() {
        if (this.mibHashtable == null) {
            this.mibHashtable = new Hashtable();
        }
    }

    MibBrowserUI(Applet applet) {
        if (this.mibHashtable == null) {
            this.mibHashtable = new Hashtable();
        }
        this.applet = applet;
        try {
            this.sasclient = SnmpAPI.getSASClient();
            if (this.sasclient == null) {
                this.sasclient = new SASClient(applet, true);
                this.sasclient.start();
            }
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Load MIB"))) {
            if (this.load == null) {
                void var2_4;
                Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = MibBrowserUI.class$("java.awt.Frame")), this);
                if (frame == null) {
                    Frame frame2 = new Frame();
                }
                this.load = new LoadDialog(this.browserModel.getMibBrowser(), (Frame)var2_4, SnmpUtils.getString("Load Mib Dialog"));
                this.load.addComponentListener(new LocalComponentAdapter());
                this.load.addWindowListener(new WindowAdapter(){

                    public void windowDeactivated(WindowEvent windowEvent) {
                        String[] stringArray = MibBrowserUI.this.load.loadedMib();
                        if (stringArray != null && stringArray.length != 0) {
                            int n = 0;
                            while (n < stringArray.length) {
                                if (stringArray[n] == null) {
                                    return;
                                }
                                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "|");
                                if (stringTokenizer.countTokens() == 2) {
                                    String string = stringTokenizer.nextToken();
                                    String string2 = stringTokenizer.nextToken();
                                    if (!MibBrowserUI.this.mibHashtable.containsKey(string2)) {
                                        MibBrowserUI.this.mibHashtable.put(string2, string);
                                        MibBrowserUI.this.addMibMenu(string2);
                                    } else {
                                        MibBrowserUI.this.reArrangeMenu(string2);
                                    }
                                    MibBrowserUI.this.writeToConfig(stringArray[n]);
                                }
                                ++n;
                            }
                        }
                    }
                });
                ((Component)this.load).setBounds(this.browserProperty.getMibDialPos());
            }
            this.load.setVisible(true);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Load All MIBs"))) {
            void var2_9;
            String string;
            this.mbframe = this.browserModel.getSettingsFrame();
            if (this.mbframe == null) {
                this.mbframe = new MbSettingsFrame(this.settingsTitle, this.snmptasks);
                this.browserModel.setSettingsFrame(this.mbframe);
                this.mbframe.addComponentListener(new LocalComponentAdapter());
                ((Component)this.mbframe).setBounds(this.browserProperty.getMbSettingsWinPos());
            } else {
                this.mbframe.mibPanel.updateList();
            }
            Object var2_5 = null;
            if (this.applet != null) {
                string = this.applet.getParameter("PROTOCOL");
                if (string != null && string.trim().equals("2")) {
                    Enumeration enumeration = this.mibHashtable.elements();
                } else {
                    Enumeration enumeration = this.mbframe.mibPanel.getMibList();
                }
            } else {
                Enumeration enumeration = this.mbframe.mibPanel.getMibList();
            }
            if (var2_9 == null) return;
            while (var2_9.hasMoreElements()) {
                string = (String)var2_9.nextElement();
                if (string.indexOf(" ") != -1) {
                    string = "\"" + string + "\"";
                }
                try {
                    this.tree.addMibs(string);
                }
                catch (Exception exception) {
                    Utils.err("Loading Mibs Failed " + exception);
                }
                String string2 = null;
                Enumeration enumeration = this.mibHashtable.keys();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    String string3 = (String)this.mibHashtable.get(string2);
                    if (string3.equals(string)) break;
                }
                if (string2 != null) {
                    this.reArrangeMenu(string2);
                }
                this.reWriteConfig(String.valueOf(string) + "|" + string2);
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("UnLoad MIB"))) {
            if (this.tree == null) return;
            try {
                if (this.tree.getSelectedMibModule() != null) {
                    void var2_13;
                    boolean bl = true;
                    if (this.tree.getSelectedMibModule() instanceof MibModule) {
                        int n = JOptionPane.showConfirmDialog(this, String.valueOf(SnmpUtils.getString("Do you want to unload ")) + " " + this.tree.getSelectedMibModule().getName() + "?", SnmpUtils.getString("Confirm Unload"), 0);
                    } else if (this.tree.isGlobalView && this.tree.getSelectedMibNode() instanceof MibNode) {
                        int n = JOptionPane.showConfirmDialog(this, SnmpUtils.getString("Do you want to unload the MIBs?"), SnmpUtils.getString("Confirm Unload"), 0);
                    }
                    if (var2_13 != false) return;
                    this.browserModel.deleteMib(this.tree);
                    this.display.oid.setText("");
                    this.selectedNode = null;
                    this.removeMibDescription();
                    return;
                }
                if (!this.tree.mibOps.getMibModules().hasMoreElements()) {
                    JOptionPane.showMessageDialog(this, SnmpUtils.getString("No MIBs loaded"), SnmpUtils.getString("Warning Message"), 1);
                    return;
                }
                int n = JOptionPane.showConfirmDialog(this, SnmpUtils.getString("Do you want to unload the MIBs?"), SnmpUtils.getString("Confirm Unload"), 0);
                if (n != 0) return;
                this.browserModel.deleteMibs(this.tree);
                this.display.oid.setText("");
                this.removeMibDescription();
                return;
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Unloading MibModule(s) Failed: ")) + " " + exception.getMessage());
                if (!this.snmptasks.getDebug()) return;
                exception.printStackTrace();
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("UnLoad All MIBs"))) {
            if (this.tree == null) return;
            if (!this.tree.mibOps.getMibModules().hasMoreElements()) {
                JOptionPane.showMessageDialog(this, SnmpUtils.getString("No MIBs loaded"), SnmpUtils.getString("Warning Message"), 1);
                return;
            }
            try {
                int n = JOptionPane.showConfirmDialog(this, SnmpUtils.getString("Do you want to unload the MIBs?"), SnmpUtils.getString("Confirm Unload"), 0);
                if (n != 0) return;
                this.browserModel.deleteMibs(this.tree);
                this.display.oid.setText("");
                this.removeMibDescription();
                return;
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Unloading MibModules Failed: ")) + " " + exception.getMessage());
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Save Results As..."))) {
            File file;
            block144: {
                int n;
                if (this.applet != null) {
                    JOptionPane.showMessageDialog(this, SnmpUtils.getString("MibBrowser Applet does not save\n MibBrowser results into files"), SnmpUtils.getString("Warning Message"), 1);
                    return;
                }
                if (this.saveDlg == null) {
                    this.saveDlg = new JFileChooser();
                    this.saveDlg.setDialogTitle(SnmpUtils.getString("Save MibBrowser Results As..."));
                    this.saveDlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
                    this.saveDlg.setSelectedFile(new File("Results.txt"));
                }
                this.saveDlg.setDialogTitle(SnmpUtils.getString("Save MibBrowser Results As..."));
                this.saveDlg.setVisible(true);
                file = null;
                while ((n = this.saveDlg.showSaveDialog(this)) == 0) {
                    File file2 = this.saveDlg.getSelectedFile();
                    if (file2 == null) {
                        return;
                    }
                    this.m_sCurrFile = file2.getName();
                    this.m_sCurrDir = this.saveDlg.getCurrentDirectory().toString();
                    file = new File(this.m_sCurrDir, this.m_sCurrFile);
                    if (file.exists()) {
                        Object[] objectArray = new String[]{"Yes", "No"};
                        int n2 = JOptionPane.showOptionDialog(this, SnmpUtils.getString("File already exists.\nDo you want to replace it?"), SnmpUtils.getString("Warning Message"), -1, 1, null, objectArray, objectArray[0]);
                        if (n2 != 0) continue;
                    }
                    break block144;
                }
                return;
            }
            TextWriter textWriter = new TextWriter(file, this.display.statusDisplay.getDocument());
            textWriter.start();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Print Results..."))) {
            try {
                Graphics graphics;
                void var2_22;
                PrintJob printJob;
                void var2_20;
                Object var2_18 = null;
                try {
                    JFrame jFrame = (JFrame)this.getTopLevelAncestor();
                }
                catch (Exception exception) {}
                if (var2_20 == null) {
                    JFrame jFrame = new JFrame();
                }
                if ((printJob = this.getToolkit().getPrintJob((Frame)var2_22, SnmpUtils.getString("Print MibBrowser Results"), null)) == null || (graphics = printJob.getGraphics()) == null) return;
                TextPrinter textPrinter = new TextPrinter(graphics, printJob, this.display.statusDisplay.getDocument());
                textPrinter.start();
                return;
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Print error: ")) + " " + exception.getMessage());
                if (!this.snmptasks.getDebug()) return;
                exception.printStackTrace();
                return;
            }
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Description"))) {
            this.showMibDescription();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Get"))) {
            this.snmptasks.get();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("GetNext"))) {
            this.snmptasks.getnext();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Set"))) {
            this.snmptasks.set();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Trap Viewer"))) {
            JFrame jFrame = new JFrame();
            ((Frame)jFrame).setIconImage(this.createImageIcon("trapviewer.png").getImage());
            jFrame.setTitle(SnmpUtils.getString("TrapViewer"));
            this.trap = new TrapViewer(this.applet);
            this.trap.setMibOperations(this.browserModel.getMibOperations());
            this.trap.setDebugInterface(this);
            jFrame.getContentPane().add(this.trap);
            jFrame.pack();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Object object;
                    JFrame jFrame = (JFrame)windowEvent.getSource();
                    TrapViewer trapViewer = (TrapViewer)jFrame.getContentPane().getComponent(0);
                    if (trapViewer != null) {
                        trapViewer.stop();
                        object = new Object();
                        trapViewer.actionPerformed(new ActionEvent(object, 1001, "Exit All"));
                        trapViewer.removeAll();
                        trapViewer = null;
                    }
                    jFrame.getContentPane().removeAll();
                    object = jFrame.getContentPane();
                    object = null;
                    jFrame.dispose();
                    jFrame = null;
                }
            });
            ((Component)jFrame).setVisible(true);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Graph"))) {
            if (this.tree.getSelectedMibNode() == null && this.display.oid.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this, SnmpUtils.getString("OID Not Specified"), SnmpUtils.getString("Warning Message"), 0);
                return;
            }
            if (this.tree.mibOps.getSnmpOID(this.display.oid.getText().trim()) == null) {
                Utils.err("Error . Invalid OID Format : " + this.display.oid.getText().trim());
                return;
            }
            Object var2_25 = null;
            BarDialog barDialog = null;
            if (this.graphType == SnmpUtils.getString("Line Graph")) {
                GraphDialog graphDialog = new GraphDialog(this.browserModel.getMibBrowser());
                ((Frame)graphDialog).setIconImage(this.createImageIcon("graph.png").getImage());
                return;
            } else {
                barDialog = new BarDialog(this.browserModel.getMibBrowser());
                ((Frame)barDialog).setIconImage(this.createImageIcon("graph.png").getImage());
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Line Graph"))) {
            GraphDialog graphDialog = new GraphDialog(this.browserModel.getMibBrowser());
            ((Frame)graphDialog).setIconImage(this.createImageIcon("graph.png").getImage());
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Bar Graph"))) {
            BarDialog barDialog = new BarDialog(this.browserModel.getMibBrowser());
            ((Frame)barDialog).setIconImage(this.createImageIcon("graph.png").getImage());
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Snmp Table"))) {
            void var2_31;
            MibNode mibNode;
            JFrame jFrame;
            JButton jButton;
            SnmpTablePanel snmpTablePanel;
            block145: {
                Object var2_29 = null;
                Vector vector = this.browserModel.getPathInfo();
                if (vector != null && vector.size() > 1) {
                    String[] stringArray = new String[vector.size()];
                    int n = 0;
                    while (n < vector.size()) {
                        stringArray[n] = ((MibNode)vector.elementAt(n)).getOIDString();
                        ++n;
                    }
                }
                if ((String)this.display.host.getSelectedItem() == null || ((String)this.display.host.getSelectedItem()).trim().equals("")) {
                    JOptionPane.showMessageDialog(this, SnmpUtils.getString("HostName should be entered"), SnmpUtils.getString("Warning Message"), 0);
                    return;
                }
                snmpTablePanel = new SnmpTablePanel(this.applet);
                jButton = new JButton("  " + SnmpUtils.getString("Close") + "  ");
                jButton.setFont(this.lfont);
                snmpTablePanel.tablebeanui.buttonpanel1.addButton(jButton);
                jFrame = new JFrame(SnmpUtils.getString("SNMP Table"));
                ((Frame)jFrame).setIconImage(this.createImageIcon("table.png").getImage());
                jFrame.getContentPane().setLayout(new GridLayout(1, 0));
                jFrame.getContentPane().add(snmpTablePanel);
                ((Component)jFrame).setBounds(this.browserProperty.getTableWinPos());
                snmpTablePanel.setTargetHost((String)this.display.host.getSelectedItem());
                snmpTablePanel.setCommunity(this.display.community.getText());
                if (this.display.writeCommunity.getText().equals("")) {
                    snmpTablePanel.setWriteCommunity("public");
                } else {
                    snmpTablePanel.setWriteCommunity(this.display.writeCommunity.getText());
                }
                snmpTablePanel.setTargetPort(this.snmptasks.getTargetPort());
                snmpTablePanel.setRetries(this.snmptasks.getRetries());
                snmpTablePanel.setTimeout(this.snmptasks.getTimeout());
                mibNode = null;
                if (this.display.oid.getText().trim().equals("")) {
                    JOptionPane.showMessageDialog(this, SnmpUtils.getString("Table OID should be specified"), SnmpUtils.getString("Warning Message"), 0);
                    jFrame.dispose();
                    return;
                }
                try {
                    mibNode = this.tree.mibOps.getMibNode(this.tree.mibOps.getSnmpOID(this.display.oid.getText().trim()));
                    if (mibNode != null) {
                        if (mibNode.isTable()) {
                            snmpTablePanel.setTableOID(this.display.oid.getText().trim());
                        } else if (mibNode.getParent().getParent() != null && mibNode.getParent().getParent().isTable()) {
                            snmpTablePanel.setTableOID(mibNode.getParent().getParent().toString());
                        } else {
                            snmpTablePanel.setTableOID(mibNode.toString());
                        }
                        break block145;
                    }
                    Utils.err(SnmpUtils.getString("Error . Invalid Table OID "));
                    return;
                }
                catch (Exception exception) {
                    if (exception.toString().indexOf("com.") != -1) {
                        String string = exception.toString().substring(exception.toString().lastIndexOf("com."));
                        Utils.err(String.valueOf(SnmpUtils.getString("Error: ")) + " " + string);
                    } else {
                        Utils.err(String.valueOf(SnmpUtils.getString("Error: ")) + " " + exception.getMessage());
                    }
                    jFrame.dispose();
                    return;
                }
            }
            if (var2_31 != null && !mibNode.isTable() && mibNode.getParent().getParent().isTable()) {
                if (((void)var2_31).length < 5) {
                    snmpTablePanel.setTableViewColumnCount(((void)var2_31).length);
                }
                snmpTablePanel.setObjectIDList((String[])var2_31);
            } else {
                String[] stringArray = new String[1];
                MibNode mibNode2 = this.tree.mibOps.getMibNode(this.tree.mibOps.getSnmpOID(this.display.oid.getText().trim()));
                if (mibNode2 != null && mibNode2.getParent().getParent().isTable()) {
                    stringArray[0] = this.display.oid.getText().trim();
                    snmpTablePanel.setTableViewColumnCount(1);
                    snmpTablePanel.setObjectIDList(stringArray);
                }
            }
            jFrame.setTitle(String.valueOf(SnmpUtils.getString("SNMP Table - ")) + " " + snmpTablePanel.getTableOID());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    Serializable serializable;
                    JFrame jFrame = (JFrame)windowEvent.getSource();
                    SnmpTablePanel snmpTablePanel = (SnmpTablePanel)jFrame.getContentPane().getComponent(0);
                    if (snmpTablePanel != null) {
                        if (snmpTablePanel.tablebeanui.mibdescr != null && snmpTablePanel.tablebeanui.mibdescr.descrui != null) {
                            snmpTablePanel.tablebeanui.mibdescr.descrui.dispose();
                            snmpTablePanel.tablebeanui.mibdescr.descrui = null;
                            snmpTablePanel.tablebeanui.mibdescr = null;
                        }
                        serializable = snmpTablePanel.getSnmpTable();
                        serializable.releaseResources();
                        snmpTablePanel.removeAll();
                        serializable = null;
                        snmpTablePanel = null;
                    }
                    if (jFrame != null) {
                        jFrame.getContentPane().removeAll();
                        serializable = jFrame.getContentPane();
                        serializable = null;
                        jFrame.dispose();
                        jFrame = null;
                    }
                }
            });
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Serializable serializable;
                    JButton jButton = (JButton)actionEvent.getSource();
                    JFrame jFrame = (JFrame)SwingUtilities.windowForComponent(jButton);
                    SnmpTablePanel snmpTablePanel = (SnmpTablePanel)jFrame.getContentPane().getComponent(0);
                    if (snmpTablePanel != null) {
                        if (snmpTablePanel.tablebeanui.mibdescr != null && snmpTablePanel.tablebeanui.mibdescr.descrui != null) {
                            snmpTablePanel.tablebeanui.mibdescr.descrui.dispose();
                            snmpTablePanel.tablebeanui.mibdescr.descrui = null;
                            snmpTablePanel.tablebeanui.mibdescr = null;
                        }
                        serializable = snmpTablePanel.getSnmpTable();
                        ((SnmpServer)serializable).releaseResources();
                        snmpTablePanel.removeAll();
                        serializable = null;
                        snmpTablePanel = null;
                    }
                    serializable = jFrame.getContentPane();
                    serializable = null;
                    jFrame.getContentPane().removeAll();
                    jFrame.dispose();
                    jFrame = null;
                }
            });
            ((Component)jFrame).setVisible(true);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Stop"))) {
            this.snmptasks.stopPoll();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Clear Result Display"))) {
            this.display.statusDisplay.setText("");
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Set MIB Browser Parameters")) || actionEvent.getActionCommand().equals(SnmpUtils.getString("Settings"))) {
            this.mbframe = this.browserModel.getSettingsFrame();
            if (this.mbframe == null) {
                this.mbframe = new MbSettingsFrame(this.settingsTitle, this.snmptasks);
                this.browserModel.setSettingsFrame(this.mbframe);
                this.mbframe.addComponentListener(new LocalComponentAdapter());
                ((Component)this.mbframe).setBounds(this.browserProperty.getMbSettingsWinPos());
            } else {
                this.mbframe.updateParams();
                this.mbframe.mibPanel.updateList();
            }
            ((Component)this.mbframe).setVisible(true);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Find Node"))) {
            if (this.findDialog == null) {
                this.findDialog = new FindDialog((JFrame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = MibBrowserUI.class$("java.awt.Frame")), this), this.tree);
            }
            this.findDialog.addSearchListener(this);
            Utils.centerWindow(this.findDialog);
            this.findDialog.show();
            this.findDialog.requestFocus();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Debug"))) {
            if (this.debugWindow == null) {
                JComponent jComponent;
                JLabel jLabel;
                this.debugWindow = new JFrame(SnmpUtils.getString("Debug"));
                ((Frame)this.debugWindow).setIconImage(this.debugIcon.getImage());
                this.debugWindow.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        MibBrowserUI.this.browserModel.setDebug(false);
                        MibBrowserUI.this.debugText.setText("");
                    }
                });
                this.debugWindow.addComponentListener(new LocalComponentAdapter());
                ((Component)this.debugWindow).setBounds(this.browserProperty.getDebugWinPos());
                this.debugWindow.toFront();
                ToolBar toolBar = this.setUpDebugToolBar();
                this.decodePanel = new JPanel();
                GridBagLayout gridBagLayout = new GridBagLayout();
                this.decodePanel.setLayout(gridBagLayout);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 1;
                if (this.applet == null) {
                    jLabel = new JLabel(String.valueOf(SnmpUtils.getString("File URL ")) + " ");
                    jLabel.setFont(this.lfont);
                    jLabel.setForeground(Color.black);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.insets = new Insets(5, 0, 0, 0);
                    gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                    this.decodePanel.add(jLabel);
                    this.fileField = new JTextField();
                    this.fileField.addActionListener(this);
                    this.fileField.setActionCommand("FileField");
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.insets = new Insets(5, 0, 0, 5);
                    gridBagLayout.setConstraints(this.fileField, gridBagConstraints);
                    this.decodePanel.add(this.fileField);
                    jComponent = new JButton(SnmpUtils.getString("Browse"));
                    ((AbstractButton)jComponent).addActionListener(this);
                    jComponent.setFont(this.lfont);
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.gridx = 2;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.insets = new Insets(5, 0, 0, 0);
                    gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                    this.decodePanel.add(jComponent);
                }
                jLabel = new JLabel(String.valueOf(SnmpUtils.getString("Hex PDU ")) + " ");
                jLabel.setFont(this.lfont);
                jLabel.setForeground(Color.black);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(5, 0, 5, 0);
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.decodePanel.add(jLabel);
                this.hexArea = new JTextArea();
                jComponent = new JScrollPane(this.hexArea);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.insets = new Insets(5, 0, 5, 5);
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                this.decodePanel.add(jComponent);
                JButton jButton = new JButton(SnmpUtils.getString("Decode"));
                jButton.addActionListener(this);
                jButton.setFont(this.lfont);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(5, 0, 5, 0);
                gridBagLayout.setConstraints(jButton, gridBagConstraints);
                this.decodePanel.add(jButton);
                this.decodePanel.setBorder(BorderFactory.createBevelBorder(1));
                this.decodeText = new JTextArea();
                this.decodeText.setEditable(false);
                this.decodeText.setBackground(new Color(220, 220, 220));
                this.decodeText.setLineWrap(true);
                JScrollPane jScrollPane = new JScrollPane(this.decodeText);
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 4.0;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 3;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
                this.decodePanel.add(jScrollPane);
                this.debugText = new JTextArea();
                this.debugText.setEditable(false);
                this.debugText.setBackground(new Color(220, 220, 220));
                this.debugText.setBorder(BorderFactory.createBevelBorder(1));
                this.debugText.setLineWrap(true);
                this.scrollPanel1 = new JScrollPane(this.debugText);
                this.debugPanel = new JPanel();
                this.debugPanel.setLayout(new CardLayout());
                this.debugPanel.add((Component)this.scrollPanel1, "scrollPanel1");
                this.debugPanel.add((Component)this.decodePanel, "decodePanel");
                JButton jButton2 = new JButton(SnmpUtils.getString("Clear"));
                JButton jButton3 = new JButton(SnmpUtils.getString("Close"));
                jButton2.addActionListener(this);
                jButton2.setFont(this.lfont);
                jButton3.addActionListener(this);
                jButton3.setFont(this.lfont);
                JPanel jPanel = new JPanel();
                jPanel.add(jButton2);
                jPanel.add(jButton3);
                this.debugWindow.getContentPane().add("North", toolBar);
                this.debugWindow.getContentPane().add("Center", Utils.minSize(this.debugPanel, 400, 500));
                this.debugWindow.getContentPane().add("South", jPanel);
            }
            this.browserModel.setDebug(true);
            ((Component)this.debugWindow).setVisible(true);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Save Debug Messages As..."))) {
            File file;
            block146: {
                int n;
                if (this.applet != null) {
                    JOptionPane.showMessageDialog(this, SnmpUtils.getString("MibBrowser Applet does not save\n MibBrowser Debug Messages into files"), SnmpUtils.getString("Warning Message"), 1);
                    return;
                }
                if (this.saveDlg == null) {
                    this.saveDlg = new JFileChooser();
                    this.saveDlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
                }
                if (this.debugText.isShowing()) {
                    this.saveDlg.setDialogTitle(SnmpUtils.getString("Save MibBrowser Debug Messages As..."));
                } else {
                    this.saveDlg.setDialogTitle(SnmpUtils.getString("Save SNMP Decoder Messages As..."));
                }
                this.saveDlg.setVisible(true);
                file = null;
                while ((n = this.saveDlg.showSaveDialog(this)) == 0) {
                    File file3 = this.saveDlg.getSelectedFile();
                    if (file3 == null) {
                        return;
                    }
                    this.m_sCurrFile = file3.getName();
                    this.m_sCurrDir = this.saveDlg.getCurrentDirectory().toString();
                    file = new File(this.m_sCurrDir, this.m_sCurrFile);
                    if (file.exists()) {
                        Object[] objectArray = new String[]{"Yes", "No"};
                        int n3 = JOptionPane.showOptionDialog(this, SnmpUtils.getString("File already exists.\nDo you want to replace it?"), SnmpUtils.getString("Warning Message"), -1, 1, null, objectArray, objectArray[0]);
                        if (n3 != 0) continue;
                    }
                    break block146;
                }
                return;
            }
            TextWriter textWriter = this.debugText.isShowing() ? new TextWriter(file, this.debugText.getDocument()) : new TextWriter(file, this.decodeText.getDocument());
            textWriter.start();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Print Debug Messages..."))) {
            try {
                Graphics graphics;
                void var2_38;
                PrintJob printJob;
                void var2_36;
                Object var2_34 = null;
                try {
                    JFrame jFrame = (JFrame)this.getTopLevelAncestor();
                }
                catch (Exception exception) {}
                if (var2_36 == null) {
                    JFrame jFrame = new JFrame();
                }
                if ((printJob = this.getToolkit().getPrintJob((Frame)var2_38, SnmpUtils.getString("Print"), null)) == null || (graphics = printJob.getGraphics()) == null) return;
                TextPrinter textPrinter = this.debugText.isShowing() ? new TextPrinter(graphics, printJob, this.debugText.getDocument()) : new TextPrinter(graphics, printJob, this.decodeText.getDocument());
                textPrinter.start();
                return;
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Print error: ")) + " " + exception.getMessage());
                if (!this.snmptasks.getDebug()) return;
                exception.printStackTrace();
                return;
            }
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Snmp Decoder"))) {
            ((CardLayout)this.debugPanel.getLayout()).last(this.debugPanel);
            this.debugWindow.setTitle(SnmpUtils.getString("Snmp Decoder"));
            if (this.applet == null) {
                this.dbuttons[0].setToolTipText(SnmpUtils.getString("Save MibBrowser Decoder Results"));
                this.dbuttons[1].setToolTipText(SnmpUtils.getString("Print MibBrowser Decoder Results"));
            }
            this.dbuttons[2].setIcon(this.debugIcon);
            this.dbuttons[2].setActionCommand("Debug Panel");
            this.dbuttons[2].setToolTipText(SnmpUtils.getString("Debug"));
            if (this.decoder != null) return;
            this.decoder = new SnmpDecoder();
            return;
        }
        if (actionEvent.getActionCommand().equals("Debug Panel")) {
            ((CardLayout)this.debugPanel.getLayout()).first(this.debugPanel);
            this.debugWindow.setTitle(SnmpUtils.getString("Debug"));
            if (this.applet == null) {
                this.dbuttons[0].setToolTipText(SnmpUtils.getString("Save MibBrowser Debug Results"));
                this.dbuttons[1].setToolTipText(SnmpUtils.getString("Print MibBrowser Debug Results"));
            }
            this.dbuttons[2].setIcon(this.decoderIcon);
            this.dbuttons[2].setActionCommand(SnmpUtils.getString("Snmp Decoder"));
            this.dbuttons[2].setToolTipText(SnmpUtils.getString("Snmp Decoder"));
            return;
        }
        if (actionEvent.getActionCommand().equals("Decode File")) {
            if (this.fileField.getText().trim().equals("")) return;
            this.decodeFile();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("FileField"))) {
            this.decodeFile();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Browse"))) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(SnmpUtils.getString("Load Debug File"));
            jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
            jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.setVisible(true);
            int n = jFileChooser.showOpenDialog(this);
            if (n != 0) return;
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String string = file.getName();
            String string4 = jFileChooser.getCurrentDirectory().toString();
            if (string4 != null && string != null) {
                string4 = String.valueOf(string4.trim()) + File.separator;
                if (string.indexOf(" ") >= 0) {
                    string = "\"" + string + "\"";
                }
                this.fileField.setText(String.valueOf(string4) + string);
            }
            this.decodeFile();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Decode"))) {
            this.decodeString(this.hexArea.getText());
            return;
        }
        if (actionEvent.getActionCommand().equals("Help")) {
            Object var2_41 = null;
            if (this.applet == null) {
                if (this.helpurl != null) {
                    BrowserAction browserAction = new BrowserAction(this.helpurl);
                    browserAction.start();
                    return;
                } else {
                    BrowserAction browserAction = new BrowserAction("../help/mibbrowser/mibbrowser_contents.html");
                    browserAction.start();
                }
                return;
            } else {
                URL uRL = null;
                if (this.helpurl == null) {
                    String string = this.applet.getDocumentBase().toString();
                    int n = (string = string.replace('\\', '/')).lastIndexOf("MibBrowser/");
                    if (n != -1) {
                        string = string.substring(0, n);
                    }
                    try {
                        uRL = new URL(String.valueOf(string) + "help/mibbrowser/mibbrowser_contents.html");
                    }
                    catch (Exception exception) {}
                } else {
                    uRL = this.helpurl;
                }
                this.applet.getAppletContext().showDocument(uRL, "_blank");
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("About..."))) {
            JLabel jLabel = new JLabel(new ImageIcon(this.getClass().getResource("images/about.jpg")));
            JDialog jDialog = new JDialog();
            jDialog.setModal(true);
            jDialog.setTitle(SnmpUtils.getString("About"));
            jDialog.getContentPane().add(jLabel);
            jDialog.setLocationRelativeTo(this);
            ((Component)jDialog).setBackground(Color.white);
            jDialog.setResizable(false);
            jDialog.pack();
            jDialog.show();
            jDialog.setDefaultCloseOperation(2);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Add"))) {
            this.snmptasks.addVarBindList();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Edit"))) {
            if (this.display.varbindList.isSelectionEmpty()) return;
            if (this.snmptasks.multiOids.size() == 0) {
                return;
            }
            int n = this.display.varbindList.getSelectedIndex();
            this.tempOid = this.display.oid.getText().trim();
            this.tempVal = (String)this.display.setval.getSelectedItem();
            this.display.oid.setText(this.snmptasks.multiOids.elementAt(n).toString());
            if (this.snmptasks.values.elementAt(n) != null) {
                this.display.setval.setSelectedItem(this.snmptasks.values.elementAt(n).toString());
            }
            ((CardLayout)this.display.cardPanel2.getLayout()).show(this.display.cardPanel2, "butt2Panel");
            return;
        }
        if (actionEvent.getActionCommand().equals("   " + SnmpUtils.getString("OK") + "   ")) {
            this.snmptasks.editVarBindList();
            ((CardLayout)this.display.cardPanel2.getLayout()).show(this.display.cardPanel2, "butt1Panel");
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Cancel"))) {
            this.display.oid.setText(this.tempOid);
            this.display.setval.setSelectedItem(this.tempVal);
            ((CardLayout)this.display.cardPanel2.getLayout()).show(this.display.cardPanel2, "butt1Panel");
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Delete"))) {
            if (this.snmptasks.multiOids.size() == 0) {
                return;
            }
            this.snmptasks.removeVarBindList();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Clear"))) {
            if (this.debugText.isShowing()) {
                this.debugText.setText("");
                return;
            } else {
                this.decodeText.setText("");
                this.hexArea.setText("");
            }
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Close"))) {
            ((Component)this.debugWindow).setSize(this.debugWindow.getSize());
            this.debugWindow.dispose();
            this.browserModel.setDebug(false);
            this.debugText.setText("");
            this.decodeText.setText("");
            this.hexArea.setText("");
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("ToolBar"))) {
            if (this.toolbarItem.getState()) {
                this.toolbar.setVisible(true);
            } else {
                this.toolbar.setVisible(false);
            }
            this.validate();
            this.invalidate();
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Result Display"))) {
            this.setMibBrowserDisplayView(1);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("MIB Description"))) {
            this.setMibBrowserDisplayView(0);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Multi-Varbind"))) {
            this.setMibBrowserDisplayView(2);
            return;
        }
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("DescriptionClose"))) {
            this.descriptionOpen = false;
            if (this.mibdescr == null) return;
            this.mibdescr.descrui.dispose();
            this.mibdescr.descrui = null;
            this.mibdescr = null;
            return;
        }
        String string = actionEvent.getActionCommand();
        String string5 = (String)this.mibHashtable.get(string);
        if (string5 == null) return;
        if (!string5.equals("")) {
            if (string5.indexOf(" ") != -1) {
                string5 = "\"" + string5 + "\"";
            }
            try {
                this.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Loading MIBs")) + " " + string5 + "\n");
                this.tree.addMibs(string5);
                this.display.statusDisplay.append(String.valueOf(SnmpUtils.getString("Done")) + "\n");
            }
            catch (FileNotFoundException fileNotFoundException) {
                Utils.err(String.valueOf(SnmpUtils.getString("Could not find the Specified Mib")) + " " + fileNotFoundException);
            }
            catch (IOException iOException) {
                Utils.err(String.valueOf(SnmpUtils.getString("IOException occured:")) + " " + iOException);
            }
            catch (MibException mibException) {
                Utils.err(String.valueOf(SnmpUtils.getString("Error loading Mib: ")) + " " + string5 + "\n" + mibException);
            }
            catch (Exception exception) {
                Utils.err(String.valueOf(SnmpUtils.getString("Exception: ")) + " " + exception);
            }
            this.reArrangeMenu(string);
            this.reWriteConfig(String.valueOf(string5) + "|" + string);
            return;
        }
        System.err.println("Action: " + actionEvent.getActionCommand());
    }

    public void addMibMenu(String string) {
        if (this.mibcount == 0) {
            this.fileMenu.insertSeparator(7);
        }
        if (this.mibcount == 5) {
            this.mibmenu = this.fileMenu.getItem(8 + this.mibcount - 1);
            String string2 = this.mibmenu.getText();
            this.mibHashtable.remove(string2);
            this.fileMenu.remove(this.mibmenu);
            --this.mibcount;
        }
        this.mibmenu = new JMenuItem(string);
        this.mibmenu.setFont(this.getMenuFont());
        this.fileMenu.insert(this.mibmenu, 8);
        ++this.mibcount;
        this.mibmenu.addActionListener(this);
    }

    void appendDebugText(String string) {
        this.debugText.append(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    ImageIcon createImageIcon(String string) {
        String string2 = "images/";
        JimiCanvas jimiCanvas = new JimiCanvas();
        jimiCanvas.setImageLocation(this.getClass().getResource(String.valueOf(string2) + string));
        return new ImageIcon(jimiCanvas.getImage());
    }

    ImageIcon[] createImageIcon(String[] stringArray) {
        ImageIcon[] imageIconArray = new ImageIcon[stringArray.length];
        String string = "images/";
        JimiCanvas jimiCanvas = new JimiCanvas();
        int n = 0;
        while (n < stringArray.length) {
            jimiCanvas.setImageLocation(this.getClass().getResource(String.valueOf(string) + stringArray[n]));
            imageIconArray[n] = new ImageIcon(jimiCanvas.getImage());
            ++n;
        }
        return imageIconArray;
    }

    public void debugPrint(String string) {
        if (this.getDebugText() != null) {
            this.appendDebugText(String.valueOf(string) + "\n");
        }
    }

    private void decodeFile() {
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.fileField.getText());
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            string = new String(byArray);
            fileInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error in Reading the File: ")) + " " + exception);
        }
        this.decodeString(string);
    }

    private void decodeString(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            Vector<Byte> vector = new Vector<Byte>();
            boolean bl = false;
            while (stringTokenizer.hasMoreElements()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), " ");
                while (stringTokenizer2.hasMoreElements()) {
                    try {
                        byte by = (byte)(Integer.parseInt(stringTokenizer2.nextToken(), 16) & 0xFF);
                        vector.addElement(new Byte(by));
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                        break;
                    }
                }
                if (!bl && (bl || stringTokenizer.hasMoreElements()) || vector.size() <= 0) continue;
                byte[] byArray = new byte[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    byArray[n] = (Byte)vector.elementAt(n);
                    ++n;
                }
                bl = false;
                vector.removeAllElements();
                if (this.decoder == null) {
                    this.decoder = new SnmpDecoder();
                }
                if (this.decoder.decode(byArray)) {
                    this.decodeText.append(String.valueOf(this.decoder.getResultString()) + "\n");
                    continue;
                }
                this.decodeText.append(String.valueOf(this.decoder.getErrorString()) + "\n");
            }
        }
    }

    public boolean findNext(String string, boolean bl, boolean bl2, boolean bl3) {
        return this.browserModel.findNext(string, bl, bl2, bl3);
    }

    JButton getButtonAt(int n) {
        return this.buttons[n];
    }

    public LocalComponentAdapter getComponentAdapter() {
        return new LocalComponentAdapter();
    }

    JTextArea getDebugText() {
        return this.debugText;
    }

    String getGraphType() {
        return this.graphType;
    }

    public MbDisplayPanel getMbDisplayPanel() {
        return this.display;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public Font getMenuFont() {
        JMenu jMenu = this.getMenuBar().getMenu(0);
        return jMenu.getFont();
    }

    public int getMibBrowserDisplayView() {
        if (this.view <= 2) {
            return this.view;
        }
        return 0;
    }

    public MibTree getMibTree() {
        return this.tree;
    }

    public Dimension getMinimumSize() {
        return new Dimension(730, 500);
    }

    public Dimension getPreferredSize() {
        return new Dimension(730, 500);
    }

    public ToolBar getToolBar() {
        return this.toolbar;
    }

    public TrapViewer getTrapViewer() {
        return this.trap;
    }

    public boolean isMenuBarVisible() {
        return this.menuBar.isVisible();
    }

    public boolean isToolBarVisible() {
        return this.toolbar.isVisible();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.mbframe = this.browserModel.getSettingsFrame();
        if (itemEvent.getItem().equals(this.mbframe.resultbutton)) {
            this.snmptasks.multiOids.removeAllElements();
            this.display.newModel.removeAllElements();
            this.display.multiVar.setSelected(false);
            this.display.cardPanel1.setVisible(false);
            this.resultItem.setSelected(true);
        } else if (itemEvent.getItem().equals(this.mbframe.mibdescrbutton)) {
            this.snmptasks.multiOids.removeAllElements();
            this.display.newModel.removeAllElements();
            this.display.multiVar.setSelected(false);
            this.display.cardPanel1.setVisible(true);
            ((CardLayout)this.display.cardPanel1.getLayout()).show(this.display.cardPanel1, "descrPanel");
            this.mibdescrItem.setSelected(true);
        } else if (itemEvent.getItem().equals(this.mbframe.multivarbutton)) {
            this.display.cardPanel1.setVisible(true);
            ((CardLayout)this.display.cardPanel1.getLayout()).show(this.display.cardPanel1, "bottomPanel");
            this.multivarItem.setSelected(true);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.tree.getTree().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        this.selPath = this.tree.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n != -1 && mouseEvent.getModifiers() == 4) {
            this.menu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem(SnmpUtils.getString("View MIB Description"));
            this.menu.add(jMenuItem);
            this.menu.show(this.tree.getTree(), mouseEvent.getX(), mouseEvent.getY());
            jMenuItem.setActionCommand(SnmpUtils.getString("Description"));
            jMenuItem.addActionListener(this);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void reArrangeMenu(String string) {
        int n = this.fileMenu.getItemCount();
        boolean bl = false;
        int n2 = 6;
        while (n2 < n) {
            this.mibmenu = this.fileMenu.getItem(n2);
            if (this.mibmenu != null && this.mibmenu.getText().equals(string)) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.fileMenu.remove(this.mibmenu);
            this.fileMenu.insert(this.mibmenu, 8);
            this.fileMenu.validate();
        }
    }

    public void reWriteConfig(String string) {
        if (this.pathModuleVector == null && this.pathModuleVector.isEmpty()) {
            return;
        }
        if (!this.pathModuleVector.contains(string) || this.pathModuleVector.lastElement().equals(string)) {
            return;
        }
        this.pathModuleVector.removeElement(string);
        this.pathModuleVector.addElement(string);
        if (this.pathModuleVector.contains("Cannot get. File does not exist.")) {
            this.pathModuleVector.removeElement("Cannot get. File does not exist.");
        }
        int n = this.pathModuleVector.size();
        if (this.applet == null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("MibFiles.store", false));
                int n2 = 0;
                while (n2 < n) {
                    String string2 = (String)this.pathModuleVector.elementAt(n2);
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                    bufferedWriter.flush();
                    ++n2;
                }
                bufferedWriter.close();
                bufferedWriter = null;
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception: ")) + " " + exception);
            }
        } else {
            String string3 = "";
            StringBuffer stringBuffer = new StringBuffer("");
            int n3 = 0;
            while (n3 < n) {
                string3 = (String)this.pathModuleVector.elementAt(n3);
                stringBuffer.append(string3);
                stringBuffer.append("\n");
                ++n3;
            }
            string3 = stringBuffer.toString();
            byte[] byArray = new byte[string3.length()];
            try {
                String string4;
                byArray = string3.getBytes();
                if (this.applet != null && (string4 = this.applet.getParameter("PROTOCOL")) != null && string4.trim().equals("2")) {
                    return;
                }
                if (this.sasclient != null && SASClient.isFileReadWrite()) {
                    this.sasclient.saveFile("MibFiles.store", byArray);
                }
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(SnmpUtils.getString("Error : ")) + " " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    void readAppletConfig() {
        Object object;
        String string;
        block17: {
            string = null;
            if (this.moduleVector == null) {
                this.moduleVector = new Vector();
            }
            if (this.pathModuleVector == null) {
                this.pathModuleVector = new Vector();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            String string2 = "MibFiles.store";
            try {
                dataOutputStream.writeInt(GET_FILE_REQ);
                dataOutputStream.writeUTF(string2);
                byte[] byArray = null;
                byArray = byteArrayOutputStream.toByteArray();
                if (this.applet != null && (object = this.applet.getParameter("PROTOCOL")) != null && ((String)object).trim().equals("2")) {
                    return;
                }
                if (this.sasclient == null || !SASClient.isFileReadWrite()) {
                    if (this.sasclient == null) {
                        System.err.println(SnmpUtils.getString("Not connected to sas"));
                    }
                    return;
                }
                byArray = this.sasclient.clientCall(byArray);
                if (byArray == null) {
                    return;
                }
                object = new DataInputStream(new ByteArrayInputStream(byArray));
                int n = ((DataInputStream)object).readInt();
                if (n == GET_FILE_RESP) {
                    string = ((DataInputStream)object).readUTF();
                    break block17;
                }
                System.err.println(SnmpUtils.getString("Not able to get the file"));
                return;
            }
            catch (IOException iOException) {
                System.err.println(String.valueOf(SnmpUtils.getString("Error in opening the file : ")) + " " + iOException.getMessage());
                return;
            }
        }
        boolean bl = true;
        object = null;
        String string3 = null;
        String string4 = null;
        while (bl) {
            try {
                if (string == null) {
                    bl = false;
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    if (this.pathModuleVector.contains(string5)) continue;
                    this.pathModuleVector.addElement(string5);
                }
                if (this.pathModuleVector.contains("Cannot get. File does not exist.")) {
                    this.pathModuleVector.removeElement("Cannot get. File does not exist.");
                }
                object = new StringTokenizer(string, "|\n");
                while (((StringTokenizer)object).countTokens() >= 2) {
                    string3 = ((StringTokenizer)object).nextToken();
                    string4 = ((StringTokenizer)object).nextToken();
                    if (!this.moduleVector.contains(string4)) {
                        this.moduleVector.addElement(string4);
                    }
                    this.mibHashtable.put(string4, string3);
                    this.addMibMenu(string4);
                }
                bl = false;
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(SnmpUtils.getString("Error in Reading the File: ")) + " " + exception);
                bl = false;
            }
        }
    }

    void readFromConfig() {
        try {
            if (this.br == null) {
                this.br = new BufferedReader(new FileReader("MibFiles.store"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        boolean bl = true;
        String string = null;
        StringTokenizer stringTokenizer = null;
        String string2 = null;
        String string3 = null;
        if (this.moduleVector == null) {
            this.moduleVector = new Vector();
        }
        if (this.pathModuleVector == null) {
            this.pathModuleVector = new Vector();
        }
        while (bl) {
            try {
                string = this.br.readLine();
                if (string == null) {
                    bl = false;
                    return;
                }
                stringTokenizer = new StringTokenizer(string, "|");
                if (stringTokenizer.countTokens() != 2) continue;
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                if (!this.moduleVector.contains(string2)) {
                    this.moduleVector.addElement(string2);
                    this.pathModuleVector.addElement(string);
                }
                this.mibHashtable.put(string2, string3);
                this.addMibMenu(string2);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Error in Reading the File: ")) + " " + exception);
            }
        }
    }

    public void removeMibDescription() {
        this.display.descr.setText("");
        this.display.syntax.setText("");
        this.display.access.setText("");
        this.display.status.setText("");
        this.display.reference.setText("");
        this.display.nodeoid.setText("");
        this.display.index.setText("");
    }

    void setGraphType(String string) {
        this.graphType = string;
    }

    public void setMenuBarVisible(boolean bl) {
        this.menuBar.setVisible(bl);
        this.validate();
        this.invalidate();
    }

    public void setMenuFont(Font font) {
        JMenuBar jMenuBar = this.getMenuBar();
        int n = jMenuBar.getMenuCount();
        int n2 = 0;
        while (n2 < n) {
            JMenu jMenu = jMenuBar.getMenu(n2);
            jMenu.setFont(font);
            int n3 = jMenu.getItemCount();
            int n4 = 0;
            while (n4 < n3) {
                JMenuItem jMenuItem = jMenu.getItem(n4);
                if (jMenuItem instanceof JMenuItem) {
                    jMenuItem.setFont(font);
                }
                if (jMenuItem instanceof JMenu) {
                    jMenu = (JMenu)jMenuItem;
                    int n5 = jMenu.getItemCount();
                    int n6 = 0;
                    while (n6 < n5) {
                        jMenuItem = jMenu.getItem(n6);
                        if (jMenuItem instanceof JMenuItem) {
                            jMenuItem.setFont(font);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void setMibBrowserDisplayView(int n) {
        this.view = n;
        this.mbframe = this.browserModel.getSettingsFrame();
        if (this.mbframe == null) {
            this.mbframe = new MbSettingsFrame(this.settingsTitle, this.snmptasks);
            this.browserModel.setSettingsFrame(this.mbframe);
            this.mbframe.addComponentListener(new LocalComponentAdapter());
            ((Component)this.mbframe).setBounds(this.browserProperty.getMbSettingsWinPos());
        }
        switch (n) {
            default: {
                this.view = 0;
            }
            case 0: {
                ((CardLayout)this.display.cardPanel1.getLayout()).show(this.display.cardPanel1, "descrPanel");
                this.display.cardPanel1.setVisible(true);
                this.mbframe.mibdescrbutton.setSelected(true);
                break;
            }
            case 1: {
                this.display.cardPanel1.setVisible(false);
                this.mbframe.resultbutton.setSelected(true);
                break;
            }
            case 2: {
                this.display.cardPanel1.setVisible(true);
                ((CardLayout)this.display.cardPanel1.getLayout()).show(this.display.cardPanel1, "bottomPanel");
                this.mbframe.multivarbutton.setSelected(true);
            }
        }
        this.display.validate();
        this.display.invalidate();
    }

    void setModel(DefaultMibBrowserModel defaultMibBrowserModel, SnmpTasks snmpTasks) {
        this.browserModel = defaultMibBrowserModel;
        this.snmptasks = snmpTasks;
    }

    public void setSettingsTitle(String string) {
        Component component = null;
        if (this.toolbar != null) {
            component = this.toolbar.getComponent(this.settingsTitle);
        }
        this.settingsTitle = string;
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(this.settingsTitle);
        }
    }

    public void setToolBarVisible(boolean bl) {
        this.toolbar.setVisible(bl);
        this.validate();
        this.invalidate();
    }

    ToolBar setUpDebugToolBar() {
        String[] stringArray = new String[]{SnmpUtils.getString("Save Debug Messages As..."), SnmpUtils.getString("Print Debug Messages..."), SnmpUtils.getString("Snmp Decoder")};
        String[] stringArray2 = new String[]{SnmpUtils.getString("Save MibBrowser Debug Results"), SnmpUtils.getString("Print MibBrowser Debug Results"), SnmpUtils.getString("Snmp Decoder")};
        String[] stringArray3 = new String[]{"save.png", "printresult.png", "decoder.png"};
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] blArray2 = blArray;
        ImageIcon[] imageIconArray = this.createImageIcon(stringArray3);
        ToolBar toolBar = new ToolBar(false);
        int n = 0;
        while (n < imageIconArray.length) {
            if (this.applet == null && !blArray2[n]) {
                toolBar.addLineSeparator();
            }
            if (this.applet == null || stringArray[n] != SnmpUtils.getString("Save Debug Messages As...") && stringArray[n] != SnmpUtils.getString("Print Debug Messages...")) {
                this.dbuttons[n] = toolBar.addButton(stringArray[n], imageIconArray[n], stringArray2[n]);
                this.dbuttons[n].addActionListener(this);
            }
            ++n;
        }
        return toolBar;
    }

    private JMenuBar setUpMenuBar() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu(SnmpUtils.getString("File"));
        this.menuBar.add(this.fileMenu);
        this.editMenu = new JMenu(SnmpUtils.getString("Edit"));
        this.menuBar.add(this.editMenu);
        this.viewMenu = new JMenu(SnmpUtils.getString("View"));
        this.menuBar.add(this.viewMenu);
        this.operationsMenu = new JMenu(SnmpUtils.getString("Operations"));
        this.menuBar.add(this.operationsMenu);
        this.helpMenu = new JMenu(SnmpUtils.getString("Help"));
        this.menuBar.add(this.helpMenu);
        this.helpMenu.setActionCommand("Help");
        this.fileMenu.setMnemonic('F');
        this.loadItem = new JMenuItem(SnmpUtils.getString("Load MIB"), 111);
        this.fileMenu.add(this.loadItem);
        this.loadItem.addActionListener(this);
        this.loadItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.unloadItem = new JMenuItem(SnmpUtils.getString("UnLoad MIB"), 100);
        this.fileMenu.add(this.unloadItem);
        this.unloadItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.unloadItem.addActionListener(this);
        this.loadallItem = new JMenuItem(SnmpUtils.getString("Load All MIBs"), 97);
        this.fileMenu.add(this.loadallItem);
        this.loadallItem.addActionListener(this);
        this.loadallItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.unloadallItem = new JMenuItem(SnmpUtils.getString("UnLoad All MIBs"), 85);
        this.fileMenu.add(this.unloadallItem);
        this.unloadallItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        this.unloadallItem.addActionListener(this);
        this.fileMenu.addSeparator();
        this.saveItem = new JMenuItem(SnmpUtils.getString("Save Results As..."), 83);
        this.fileMenu.add(this.saveItem);
        if (this.applet != null) {
            this.saveItem.setEnabled(false);
        }
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveItem.addActionListener(this);
        this.printItem = new JMenuItem(SnmpUtils.getString("Print Results..."), 80);
        this.fileMenu.add(this.printItem);
        this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.printItem.addActionListener(this);
        if (this.applet != null) {
            this.printItem.setEnabled(false);
        }
        this.editMenu.setMnemonic('E');
        this.generalsettingsItem = new JMenuItem(SnmpUtils.getString("Settings"), 83);
        this.editMenu.add(this.generalsettingsItem);
        this.generalsettingsItem.addActionListener(this);
        this.generalsettingsItem.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.editMenu.addSeparator();
        this.findItem = new JMenuItem(SnmpUtils.getString("Find Node"), 70);
        this.editMenu.add(this.findItem);
        this.findItem.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.findItem.addActionListener(this);
        this.viewMenu.setMnemonic('V');
        this.trapItem = new JMenuItem(SnmpUtils.getString("Trap Viewer"), 112);
        this.viewMenu.add(this.trapItem);
        this.trapItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.trapItem.addActionListener(this);
        this.linegraphItem = new JMenuItem(SnmpUtils.getString("Line Graph"), 76);
        this.viewMenu.add(this.linegraphItem);
        this.linegraphItem.setAccelerator(KeyStroke.getKeyStroke(76, 8));
        this.linegraphItem.addActionListener(this);
        this.bargraphItem = new JMenuItem(SnmpUtils.getString("Bar Graph"), 66);
        this.viewMenu.add(this.bargraphItem);
        this.bargraphItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        this.bargraphItem.addActionListener(this);
        this.tableItem = new JMenuItem(SnmpUtils.getString("Snmp Table"), 84);
        this.viewMenu.add(this.tableItem);
        this.tableItem.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        this.tableItem.addActionListener(this);
        this.descrItem = new JMenuItem(SnmpUtils.getString("Description"), 115);
        this.viewMenu.add(this.descrItem);
        this.descrItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.descrItem.addActionListener(this);
        this.debugItem = new JMenuItem(SnmpUtils.getString("Debug"), 103);
        this.viewMenu.add(this.debugItem);
        this.debugItem.setAccelerator(KeyStroke.getKeyStroke(68, 8));
        this.debugItem.addActionListener(this);
        this.viewMenu.addSeparator();
        this.toolbarItem = new JCheckBoxMenuItem(SnmpUtils.getString("ToolBar"), true);
        this.viewMenu.add(this.toolbarItem);
        this.toolbarItem.setMnemonic('r');
        this.toolbarItem.addActionListener(this);
        this.viewMenu.addSeparator();
        this.displayMenu = new JMenu(SnmpUtils.getString("Display"));
        this.viewMenu.add(this.displayMenu);
        this.displayMenu.setMnemonic('D');
        this.displayMenu.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.resultItem = new JRadioButtonMenuItem(SnmpUtils.getString("Result Display"), false);
        buttonGroup.add(this.resultItem);
        this.resultItem.setMnemonic('u');
        this.resultItem.addActionListener(this);
        this.mibdescrItem = new JRadioButtonMenuItem(SnmpUtils.getString("MIB Description"), true);
        buttonGroup.add(this.mibdescrItem);
        this.mibdescrItem.setMnemonic('I');
        this.mibdescrItem.addActionListener(this);
        this.multivarItem = new JRadioButtonMenuItem(SnmpUtils.getString("Multi-Varbind"), false);
        buttonGroup.add(this.multivarItem);
        this.multivarItem.setMnemonic('V');
        this.multivarItem.addActionListener(this);
        this.displayMenu.add(this.resultItem);
        this.displayMenu.add(this.mibdescrItem);
        this.displayMenu.add(this.multivarItem);
        this.operationsMenu.setMnemonic('O');
        this.getItem = new JMenuItem(SnmpUtils.getString("Get"), 71);
        this.operationsMenu.add(this.getItem);
        this.getItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.getItem.addActionListener(this);
        this.getnextItem = new JMenuItem(SnmpUtils.getString("GetNext"), 78);
        this.operationsMenu.add(this.getnextItem);
        this.getnextItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.getnextItem.addActionListener(this);
        this.setItem = new JMenuItem(SnmpUtils.getString("Set"), 83);
        this.operationsMenu.add(this.setItem);
        this.setItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.setItem.addActionListener(this);
        this.operationsMenu.addSeparator();
        this.stopItem = new JMenuItem(SnmpUtils.getString("Stop"), 112);
        this.operationsMenu.add(this.stopItem);
        this.stopItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.stopItem.addActionListener(this);
        this.clearItem = new JMenuItem(SnmpUtils.getString("Clear"), 108);
        this.operationsMenu.add(this.clearItem);
        this.clearItem.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.clearItem.setActionCommand("Clear Result Display");
        this.clearItem.addActionListener(this);
        this.helpMenu.setMnemonic('H');
        this.helpItem = new JMenuItem(SnmpUtils.getString("Help"));
        this.helpMenu.add(this.helpItem);
        this.helpItem.setActionCommand("Help");
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpItem.addActionListener(this);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem(SnmpUtils.getString("About..."), 65);
        this.helpMenu.add(this.aboutItem);
        this.aboutItem.addActionListener(this);
        this.setMenuFont(this.lfont);
        return this.menuBar;
    }

    ToolBar setUpToolBar() {
        String[] stringArray = new String[]{SnmpUtils.getString("Load MIB"), SnmpUtils.getString("UnLoad MIB"), SnmpUtils.getString("Description"), SnmpUtils.getString("Find Node"), SnmpUtils.getString("Save Results As..."), SnmpUtils.getString("Print Results..."), SnmpUtils.getString("Get"), SnmpUtils.getString("GetNext"), SnmpUtils.getString("Set"), SnmpUtils.getString("Set MIB Browser Parameters"), SnmpUtils.getString("Trap Viewer"), SnmpUtils.getString("Graph"), SnmpUtils.getString("Snmp Table"), SnmpUtils.getString("Debug"), SnmpUtils.getString("Clear Result Display"), SnmpUtils.getString("Stop"), SnmpUtils.getString("Help")};
        String[] stringArray2 = new String[]{SnmpUtils.getString("Load MIB Module"), SnmpUtils.getString("UnLoad MIB Module(s)"), SnmpUtils.getString("Description"), SnmpUtils.getString("Find MIB Node"), SnmpUtils.getString("Save MibBrowser Results"), SnmpUtils.getString("Print MibBrowser Results"), SnmpUtils.getString("Get SNMP variable"), SnmpUtils.getString("Get Next SNMP variable"), SnmpUtils.getString("Set SNMP variable"), this.settingsTitle, SnmpUtils.getString("Trap Viewer"), SnmpUtils.getString("View real-time graph"), SnmpUtils.getString("View SNMP data table"), SnmpUtils.getString("Debug"), SnmpUtils.getString("Clear Result Display"), SnmpUtils.getString("Stop query in progress"), SnmpUtils.getString("Open Help")};
        String[] stringArray3 = new String[]{"loadmib.png", "unloadmib.png", "describe.png", "find.png", "save.png", "printresult.png", "get.png", "getnext.png", "set.png", "settings.png", "trapviewer.png", "graph.png", "table.png", "debug.png", "clear.png", "stop.png", "help.png"};
        boolean[] blArray = new boolean[17];
        blArray[0] = true;
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[5] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[14] = true;
        blArray[15] = true;
        boolean[] blArray2 = blArray;
        this.debugIcon = this.createImageIcon("debug.png");
        this.decoderIcon = this.createImageIcon("decoder.png");
        ImageIcon[] imageIconArray = this.createImageIcon(stringArray3);
        this.buttons = new JButton[stringArray.length];
        ToolBar toolBar = new ToolBar(false);
        int n = 0;
        while (n < imageIconArray.length) {
            if (!blArray2[n]) {
                toolBar.addLineSeparator();
            }
            this.buttons[n] = toolBar.addButton(stringArray[n], imageIconArray[n], stringArray2[n]);
            if (stringArray[n].equals(SnmpUtils.getString("Help"))) {
                this.buttons[n].setActionCommand("Help");
            }
            this.buttons[n].addActionListener(this);
            if (this.applet != null && (stringArray[n] == SnmpUtils.getString("Save Results As...") || stringArray[n] == SnmpUtils.getString("Print Results..."))) {
                this.buttons[n].setEnabled(false);
            }
            ++n;
        }
        return toolBar;
    }

    void setup() {
        this.browserProperty = new BrowserProperty();
        this.menuBar = this.setUpMenuBar();
        this.toolbar = this.setUpToolBar();
        this.tree = this.browserModel.getMibTree();
        this.snmptasks = this.browserModel.getSnmpTasks();
        this.tree.getTree().addTreeSelectionListener(this);
        this.tree.getTree().addMouseListener(this);
        this.tree.setMinimumSize(new Dimension(100, 100));
        this.display.multiVar.addItemListener(this.snmptasks);
        this.display.addButton.addActionListener(this);
        this.display.editButton.addActionListener(this);
        this.display.delButton.addActionListener(this);
        this.display.okButton.addActionListener(this);
        this.display.cancelButton.addActionListener(this);
        this.display.setMinimumSize(new Dimension(100, 100));
        this.splitPane = new JSplitPane(1, this.tree, this.display);
        this.splitPane.setDividerLocation(165);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", this.menuBar);
        jPanel.add("West", this.toolbar);
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
        this.add("Center", this.splitPane);
        Utils.centerWindow(this);
        this.setToolBarVisible(true);
        this.setMenuBarVisible(false);
        if (this.applet == null) {
            this.readFromConfig();
        } else {
            this.readAppletConfig();
        }
    }

    public void showMibDescription() {
        if (this.selectedNode == null) {
            MibNode mibNode = null;
            if (this.display.oid.getText().trim() != "" && this.tree.mibOps.getSnmpOID(this.display.oid.getText().trim()) != null) {
                mibNode = this.tree.mibOps.getMibNode(this.tree.mibOps.getSnmpOID(this.display.oid.getText().trim()));
                if (mibNode == null) {
                    JOptionPane.showMessageDialog(this, SnmpUtils.getString("MibNode Unavailable for OID."), SnmpUtils.getString("Error Message"), 0);
                    return;
                }
                if (this.mibdescr == null) {
                    this.mibdescr = new MibDescription();
                }
                this.mibdescr.descrui.closebutton.setActionCommand("DescriptionClose");
                this.mibdescr.descrui.closebutton.addActionListener(this);
                this.mibdescr.descrui.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        MibBrowserUI.this.descriptionOpen = false;
                        if (MibBrowserUI.this.mibdescr != null) {
                            MibBrowserUI.this.mibdescr.descrui.dispose();
                            MibBrowserUI.this.mibdescr.descrui = null;
                            MibBrowserUI.this.mibdescr = null;
                        }
                    }
                });
                this.descriptionOpen = true;
                this.mibdescr.setMibOperations(this.tree.mibOps);
                this.mibdescr.setMibNodeDescription(mibNode);
                return;
            }
        } else {
            if (this.selectedNode.getUserObject() != null) {
                if (this.mibdescr == null) {
                    this.mibdescr = new MibDescription();
                }
                this.mibdescr.descrui.closebutton.setActionCommand("DescriptionClose");
                this.mibdescr.descrui.closebutton.addActionListener(this);
                this.mibdescr.descrui.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        MibBrowserUI.this.descriptionOpen = false;
                        if (MibBrowserUI.this.mibdescr != null) {
                            MibBrowserUI.this.mibdescr.descrui.dispose();
                            MibBrowserUI.this.mibdescr.descrui = null;
                            MibBrowserUI.this.mibdescr = null;
                        }
                    }
                });
                this.mibdescr.setMibOperations(this.tree.mibOps);
                this.descriptionOpen = true;
                this.mibdescr.setMibNodeDescription(this.selectedNode.getUserObject());
                return;
            }
            if (this.selectedNode.isMibTrap() || this.selectedNode.isMibTC()) {
                if (this.mibdescr == null) {
                    this.mibdescr = new MibDescription();
                }
                this.mibdescr.descrui.closebutton.setActionCommand("DescriptionClose");
                this.mibdescr.descrui.closebutton.addActionListener(this);
                this.mibdescr.descrui.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        MibBrowserUI.this.descriptionOpen = false;
                        if (MibBrowserUI.this.mibdescr != null) {
                            MibBrowserUI.this.mibdescr.descrui.dispose();
                            MibBrowserUI.this.mibdescr.descrui = null;
                            MibBrowserUI.this.mibdescr = null;
                        }
                    }
                });
                this.mibdescr.setMibOperations(this.tree.mibOps);
                this.descriptionOpen = true;
                this.mibdescr.setMibNodeDescription(this.selectedNode);
                return;
            }
            JOptionPane.showMessageDialog(this, SnmpUtils.getString("No Description for the item selected"), SnmpUtils.getString("Information"), 1);
            return;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.mibdescr != null) {
            this.mibdescr.selectionChanged = true;
        }
        this.selComp = new Vector();
        TreePath[] treePathArray = this.tree.getTree().getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        this.selComp = this.browserModel.addPathInfo(treePathArray);
        Object object = treeSelectionEvent.getPath().getLastPathComponent();
        this.browserModel.valueChangedPassed((NodeData)object);
        this.selectedNode = (NodeData)object;
        if (this.descriptionOpen) {
            this.showMibDescription();
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getOldValue();
        Hashtable hashtable = (Hashtable)propertyChangeEvent.getNewValue();
        if (string.equals("OLD INSTANCE")) {
            int n;
            String string2 = (String)hashtable.get("HOST");
            if (!string2.equals("")) {
                this.browserModel.setTargetHost(string2);
            }
            if ((n = Integer.parseInt((String)hashtable.get("PORT"))) != -999) {
                this.browserModel.setTargetPort(n);
            }
            if (!(string2 = (String)hashtable.get("RETRIES")).equals("-999")) {
                this.browserModel.setRetries(string2);
            }
            if (!(string2 = (String)hashtable.get("TIMEOUT")).equals("-999")) {
                this.browserModel.setTimeout(string2);
            }
        }
    }

    void writeToConfig(String string) {
        if (this.moduleVector == null) {
            this.moduleVector = new Vector();
        }
        if (this.pathModuleVector == null) {
            this.pathModuleVector = new Vector();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = "";
        if (stringTokenizer.countTokens() == 2) {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
        }
        if (this.moduleVector.contains(string2)) {
            this.reWriteConfig(string);
            return;
        }
        this.moduleVector.addElement(string2);
        this.pathModuleVector.addElement(string);
        if (this.applet == null) {
            try {
                if (this.be == null) {
                    this.be = new BufferedWriter(new FileWriter("MibFiles.store", true));
                }
                this.be.write(string);
                this.be.newLine();
                this.be.flush();
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception: ")) + " " + exception);
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append("\n");
            string = stringBuffer.toString();
            byte[] byArray = new byte[string.length()];
            try {
                String string3;
                byArray = string.getBytes();
                if (this.applet != null && (string3 = this.applet.getParameter("PROTOCOL")) != null && string3.trim().equals("2")) {
                    return;
                }
                if (this.sasclient != null && SASClient.isFileReadWrite()) {
                    this.sasclient.appendFile("MibFiles.store", byArray);
                }
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(SnmpUtils.getString("Error : ")) + " " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    class LocalComponentAdapter
    implements ComponentListener {
        LocalComponentAdapter() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (MibBrowserUI.this.applet == null) {
                MibBrowserUI.this.browserProperty.saveConfig(true);
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Component component = (Component)componentEvent.getSource();
            Rectangle rectangle = component.getBounds();
            if (component == MibBrowserUI.this.load) {
                MibBrowserUI.this.browserProperty.setMibDialPos(rectangle);
            } else if (component == MibBrowserUI.this.mbframe) {
                MibBrowserUI.this.browserProperty.setMbSettingsWinPos(rectangle);
            } else if (component == MibBrowserUI.this.debugWindow) {
                MibBrowserUI.this.browserProperty.setDebugWinPos(rectangle);
            } else if (component == MibBrowserUI.this.describeWindow) {
                MibBrowserUI.this.browserProperty.setDescribeWinPos(rectangle);
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.componentMoved(componentEvent);
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }
}

