/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.ui.MibDescriptionUI;
import com.adventnet.snmp.ui.NodeData;
import com.sun.jimi.core.component.JimiCanvas;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MibDescription
implements ItemListener {
    MibDescriptionUI descrui;
    boolean state = false;
    MibOperations mibOperations = null;
    String description = "";
    StringTokenizer st = null;
    StringTokenizer spaceToken = null;
    StringBuffer sb = null;
    Vector siblings = null;
    boolean selectionChanged = false;

    public MibDescription() {
        if (this.descrui == null) {
            this.descrui = new MibDescriptionUI();
        }
        ((Frame)this.descrui).setIconImage(this.createImageIcon(this.getClass().getResource("images/describe.png")).getImage());
        this.descrui.setVisible(true);
        this.descrui.JComboBox1.addItemListener(this);
    }

    ImageIcon createImageIcon(URL uRL) {
        JimiCanvas jimiCanvas = new JimiCanvas();
        jimiCanvas.setImageLocation(uRL);
        return new ImageIcon(jimiCanvas.getImage());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.state) {
            this.state = false;
            this.setMibNodeDescription((MibNode)this.descrui.JComboBox1.getSelectedItem());
            this.state = true;
        }
    }

    public void setMibNodeDescription(MibNode mibNode) {
        this.descrui.nodetxt.setText(mibNode.toString());
        this.descrui.pathtxt.setText(mibNode.getOIDString());
        this.descrui.pathtxt.setCaretPosition(0);
        this.descrui.objectidtxt.setText(mibNode.getNumberedOIDString());
        this.descrui.objectidtxt.setCaretPosition(0);
        this.descrui.moduletxt.setText(mibNode.getModuleName());
        if (mibNode.getSyntax() != null) {
            this.descrui.syntaxtxt.setText(mibNode.getSyntax().getDescription());
            this.descrui.syntaxtxt.setCaretPosition(0);
        } else {
            this.descrui.syntaxtxt.setText("");
        }
        this.descrui.statustxt.setText(mibNode.getStatus());
        this.descrui.accesstxt.setText(mibNode.printAccess());
        this.descrui.macrotxt.setText(mibNode.getMacroType());
        this.descrui.referencetxt.setText(mibNode.getReference());
        this.descrui.defvaltxt.setText(mibNode.getDefval());
        MibNode mibNode2 = null;
        mibNode2 = mibNode.isTableEntry() || mibNode.isTable() ? mibNode.getNextLeafNode() : (mibNode.isTableColumn() ? mibNode : null);
        if (mibNode2 != null) {
            Vector vector = mibNode2.getIndexes(this.mibOperations);
            if (vector != null) {
                String string = "";
                if (vector.size() > 0) {
                    this.descrui.indextxt.setText(vector.elementAt(0).toString());
                    int n = 1;
                    while (n < vector.size()) {
                        string = String.valueOf(string) + "   " + vector.elementAt(n).toString();
                        ++n;
                    }
                    this.descrui.indextxt.setText(String.valueOf(this.descrui.indextxt.getText()) + string);
                    this.descrui.indextxt.setCaretPosition(0);
                }
            }
        } else {
            this.descrui.indextxt.setText("");
        }
        if (mibNode.isLeaf()) {
            this.siblings = new Vector();
            this.siblings = mibNode.getParent().getChildList();
            if (this.selectionChanged) {
                this.state = false;
            }
            if (!this.state) {
                if (this.descrui.JComboBox1.getItemCount() != 0) {
                    this.descrui.JComboBox1.removeAllItems();
                }
                int n = 0;
                while (n < this.siblings.size()) {
                    this.descrui.JComboBox1.addItem(this.siblings.elementAt(n));
                    ++n;
                }
                this.descrui.JComboBox1.setSelectedItem(mibNode);
                this.state = true;
            }
        } else {
            this.state = false;
            if (this.descrui.JComboBox1.getItemCount() != 0) {
                this.descrui.JComboBox1.removeAllItems();
            }
        }
        this.description = mibNode.getDescription();
        if (this.description == null) {
            this.descrui.descrtxt.setText("");
        } else if (this.description != null) {
            this.st = new StringTokenizer(this.description, "\n", true);
            this.sb = new StringBuffer(" ");
            while (this.st.hasMoreTokens()) {
                this.spaceToken = new StringTokenizer(this.st.nextToken(), " \t");
                while (this.spaceToken.hasMoreTokens()) {
                    this.sb.append(String.valueOf(this.spaceToken.nextToken()) + " ");
                }
            }
            if (this.sb != null) {
                this.description = new String(this.sb);
            }
            this.descrui.descrtxt.setText(" ");
            this.descrui.descrtxt.append(this.description);
            this.descrui.descrtxt.setCaretPosition(0);
        }
    }

    public void setMibNodeDescription(NodeData nodeData) {
        if (nodeData.isMibTC()) {
            if (this.descrui.JComboBox1.getItemCount() != 0) {
                this.descrui.JComboBox1.removeAllItems();
            }
            this.descrui.nodetxt.setText(" ");
            this.descrui.pathtxt.setText(" ");
            this.descrui.macrotxt.setText(" ");
            this.descrui.moduletxt.setText(" ");
            this.descrui.defvaltxt.setText(" ");
            this.descrui.objectidtxt.setText(" ");
            this.descrui.syntaxtxt.setText(nodeData.mibTC.getSyntax().getDescription());
            this.descrui.syntaxtxt.setCaretPosition(0);
            this.descrui.accesstxt.setText(" ");
            this.descrui.statustxt.setText(" ");
            this.descrui.referencetxt.setText(" ");
            this.descrui.indextxt.setText("");
            this.descrui.descrtxt.setText(" ");
        } else if (nodeData.isMibTrap()) {
            if (this.descrui.JComboBox1.getItemCount() != 0) {
                this.descrui.JComboBox1.removeAllItems();
            }
            this.descrui.nodetxt.setText(" ");
            this.descrui.pathtxt.setText(" ");
            this.descrui.moduletxt.setText(" ");
            this.descrui.macrotxt.setText(" ");
            this.descrui.defvaltxt.setText(" ");
            this.descrui.objectidtxt.setText(" ");
            this.descrui.syntaxtxt.setText("");
            this.descrui.accesstxt.setText(" ");
            this.descrui.statustxt.setText(" ");
            this.descrui.referencetxt.setText(" ");
            this.descrui.indextxt.setText("");
            this.description = nodeData.mibTrap.getDescription();
            if (this.description != null) {
                this.st = new StringTokenizer(this.description, "\n", true);
                this.sb = new StringBuffer(" ");
                while (this.st.hasMoreTokens()) {
                    this.spaceToken = new StringTokenizer(this.st.nextToken(), " \t");
                    while (this.spaceToken.hasMoreTokens()) {
                        this.sb.append(String.valueOf(this.spaceToken.nextToken()) + " ");
                    }
                }
                if (this.sb != null) {
                    this.description = new String(this.sb);
                }
                this.descrui.descrtxt.setText(this.description);
                this.descrui.descrtxt.setCaretPosition(0);
            } else {
                this.descrui.descrtxt.setText("");
            }
        }
    }

    public void setMibOperations(MibOperations mibOperations) {
        this.mibOperations = mibOperations;
    }
}

