/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.ui.MibBrowser;
import com.adventnet.snmp.ui.MibBrowserUI;
import com.adventnet.snmp.ui.MibTree;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.text.JTextComponent;

class MibSettingsPanel
extends JPanel
implements ActionListener,
Runnable {
    MibBrowser mibbrowser;
    MibTree tree;
    boolean check = true;
    boolean enabled = false;
    boolean firsttime = true;
    JRadioButton loadFromDatabase;
    JRadioButton overwriteDatabase;
    JRadioButton loadCmiMibBox;
    JRadioButton overwriteCmiBox;
    JRadioButton loadDirectly;
    JScrollPane fileScrollPane;
    JScrollPane listScrollPane;
    JList fileList;
    DefaultListModel fileListModel;
    JList loadList;
    DefaultListModel loadListModel;
    Object[] selected;
    static int GET_FILE_REQ = 3;
    static int GET_FILE_RESP = 4;
    JButton move;
    JButton delete;
    JTextField driverName;
    JTextField urlField;
    JTextField userName;
    JPasswordField passWord;
    GridBagLayout gb = new GridBagLayout();
    GridBagConstraints gc = new GridBagConstraints();
    Font lfont = SnmpUIUtils.getFont();

    public MibSettingsPanel(Object object) {
        if (object instanceof MibBrowser) {
            this.mibbrowser = (MibBrowser)object;
        } else if (object instanceof MibTree) {
            this.tree = (MibTree)object;
            this.check = false;
        }
        this.constructPanel();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Load MIBs From Database"))) {
            if (this.mibbrowser != null) {
                int n;
                if (this.mibbrowser.snmptasks.isLoadMibsFromDatabase()) {
                    return;
                }
                Enumeration enumeration = this.mibbrowser.getMibOperations().getMibModules();
                if (enumeration.hasMoreElements() && (n = this.showError()) == 0) {
                    this.restore();
                    return;
                }
            } else if (this.tree != null) {
                int n;
                if (this.tree.mibOps.isLoadFromDatabase()) {
                    return;
                }
                Enumeration enumeration = this.tree.mibOps.getMibModules();
                if (enumeration.hasMoreElements() && (n = this.showError()) == 0) {
                    this.restore();
                    return;
                }
            }
            this.enabled = true;
            this.enableField(this.enabled);
            if (this.mibbrowser != null) {
                if (this.mibbrowser.browserModel.values != null && !this.mibbrowser.browserModel.hideJdbc && this.firsttime) {
                    if (this.mibbrowser.browserModel.values.length == 10 && this.mibbrowser.browserModel.values[6] != null) {
                        this.driverName.setText(this.mibbrowser.browserModel.values[6].trim());
                        this.urlField.setText(this.mibbrowser.browserModel.values[7].trim());
                        this.userName.setText(this.mibbrowser.browserModel.values[8].trim());
                        ((JTextComponent)this.passWord).setText(this.mibbrowser.browserModel.values[9].trim());
                    } else if (this.mibbrowser.browserModel.values.length == 4 && this.mibbrowser.browserModel.values[0] != null) {
                        this.driverName.setText(this.mibbrowser.browserModel.values[0].trim());
                        this.urlField.setText(this.mibbrowser.browserModel.values[1].trim());
                        this.userName.setText(this.mibbrowser.browserModel.values[2].trim());
                        ((JTextComponent)this.passWord).setText(this.mibbrowser.browserModel.values[3].trim());
                    }
                    this.firsttime = false;
                }
                if (this.mibbrowser.browserModel.hideJdbc) {
                    this.mibbrowser.snmptasks.setLoadMibsFromDatabase(true);
                }
                this.mibbrowser.snmptasks.setLoadFromCompiledMibs(false);
                if (this.mibbrowser.snmptasks.isOverwriteMibsInDatabase()) {
                    this.overwriteDatabase.setSelected(true);
                } else {
                    this.overwriteDatabase.setSelected(false);
                }
            } else if (this.tree != null) {
                this.tree.mibOps.setLoadFromCompiledMibs(false);
                if (this.tree.mibOps.isOverwriteDatabase()) {
                    this.overwriteDatabase.setSelected(true);
                } else {
                    this.overwriteDatabase.setSelected(false);
                }
            }
            this.overwriteCmiBox.setSelected(false);
            this.overwriteCmiBox.setEnabled(false);
            this.overwriteDatabase.setEnabled(true);
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Overwrite MIBs in Database"))) {
            if (this.overwriteDatabase.isSelected()) {
                if (this.mibbrowser != null) {
                    this.mibbrowser.snmptasks.setOverwriteMibsInDatabase(true);
                } else if (this.tree != null) {
                    this.tree.mibOps.setOverwriteDatabase(true);
                }
            } else if (this.mibbrowser != null) {
                this.mibbrowser.snmptasks.setOverwriteMibsInDatabase(false);
            } else if (this.tree != null) {
                this.tree.mibOps.setOverwriteDatabase(false);
            }
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Load MIBs From Compiled File"))) {
            if (this.mibbrowser != null) {
                int n;
                if (this.mibbrowser.snmptasks.isLoadFromCompiledMibs()) {
                    return;
                }
                Enumeration enumeration = this.mibbrowser.getMibOperations().getMibModules();
                if (enumeration.hasMoreElements() && (n = this.showError()) == 0) {
                    this.restore();
                    return;
                }
            } else if (this.tree != null) {
                int n;
                if (this.tree.mibOps.isLoadFromCompiledMibs()) {
                    return;
                }
                Enumeration enumeration = this.tree.mibOps.getMibModules();
                if (enumeration.hasMoreElements() && (n = this.showError()) == 0) {
                    this.restore();
                    return;
                }
            }
            this.enabled = false;
            this.enableField(this.enabled);
            if (this.mibbrowser != null) {
                this.mibbrowser.snmptasks.setLoadMibsFromDatabase(false);
                this.mibbrowser.snmptasks.setLoadFromCompiledMibs(true);
                if (this.mibbrowser.snmptasks.getOverwriteCMI()) {
                    this.overwriteCmiBox.setSelected(true);
                } else {
                    this.overwriteCmiBox.setSelected(false);
                }
            } else if (this.tree != null) {
                this.tree.mibOps.setLoadFromCompiledMibs(true);
                this.tree.mibOps.setLoadFromDatabase(false);
                if (this.tree.mibOps.getOverwriteCMI()) {
                    this.overwriteCmiBox.setSelected(true);
                } else {
                    this.overwriteCmiBox.setSelected(false);
                }
            }
            this.overwriteCmiBox.setEnabled(true);
            this.overwriteDatabase.setSelected(false);
            this.overwriteDatabase.setEnabled(false);
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Overwrite existing Compiled MIB Files"))) {
            if (this.overwriteCmiBox.isSelected()) {
                if (this.mibbrowser != null) {
                    this.mibbrowser.snmptasks.setOverwriteCMI(true);
                } else if (this.tree != null) {
                    this.tree.mibOps.setOverwriteCMI(true);
                }
            } else if (this.mibbrowser != null) {
                this.mibbrowser.snmptasks.setOverwriteCMI(false);
            } else if (this.tree != null) {
                this.tree.mibOps.setOverwriteCMI(false);
            }
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Load MIBs directly"))) {
            if (this.mibbrowser != null) {
                int n;
                if (!this.mibbrowser.snmptasks.isLoadFromCompiledMibs() && this.loadFromDatabase.isSelected()) {
                    return;
                }
                Enumeration enumeration = this.mibbrowser.getMibOperations().getMibModules();
                if (enumeration.hasMoreElements() && (n = this.showError()) == 0) {
                    this.restore();
                    return;
                }
            } else if (this.tree != null) {
                int n;
                if (!this.tree.mibOps.isLoadFromCompiledMibs() && this.loadFromDatabase.isSelected()) {
                    return;
                }
                Enumeration enumeration = this.tree.mibOps.getMibModules();
                if (enumeration.hasMoreElements() && (n = this.showError()) == 0) {
                    this.restore();
                    return;
                }
            }
            this.enabled = false;
            this.enableField(this.enabled);
            this.overwriteDatabase.setSelected(false);
            this.overwriteDatabase.setEnabled(false);
            this.overwriteCmiBox.setSelected(false);
            this.overwriteCmiBox.setEnabled(false);
            if (this.mibbrowser != null) {
                this.mibbrowser.snmptasks.setLoadFromCompiledMibs(false);
                this.mibbrowser.snmptasks.setLoadMibsFromDatabase(false);
            } else if (this.tree != null) {
                this.tree.mibOps.setLoadFromCompiledMibs(false);
                this.tree.mibOps.setLoadFromDatabase(false);
            }
        } else if (actionEvent.getActionCommand().equals("-->")) {
            this.selected = this.fileList.getSelectedValues();
            int n = 0;
            while (n < this.selected.length) {
                if (!this.loadListModel.contains(this.selected[n])) {
                    this.loadListModel.addElement(this.selected[n]);
                }
                ++n;
            }
            if (!this.loadListModel.isEmpty()) {
                this.delete.setEnabled(true);
            }
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Delete"))) {
            this.selected = this.loadList.getSelectedValues();
            int n = 0;
            while (n < this.selected.length) {
                if (this.loadListModel.contains(this.selected[n])) {
                    this.loadListModel.removeElement(this.selected[n]);
                }
                ++n;
            }
            if (this.loadListModel.isEmpty()) {
                this.delete.setEnabled(false);
            }
        } else {
            System.out.println("Command: " + actionEvent.getActionCommand());
        }
    }

    void addDouble(JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, String string, String string2, JComponent jComponent, JComponent jComponent2, int n) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel(string2);
        jLabel.setForeground(Color.black);
        jLabel.setFont(this.lfont);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jPanel.add(jComponent2);
    }

    private void constructPanel() {
        Object object;
        this.loadFromDatabase = new JRadioButton(SnmpUtils.getString("Load MIBs From Database"));
        this.loadFromDatabase.addActionListener(this);
        this.loadFromDatabase.setFont(this.lfont);
        this.overwriteDatabase = new JRadioButton(SnmpUtils.getString("Overwrite MIBs in Database"));
        this.overwriteDatabase.addActionListener(this);
        this.overwriteDatabase.setFont(this.lfont);
        if (this.mibbrowser != null && this.mibbrowser.applet != null && (object = this.mibbrowser.applet.getParameter("PROTOCOL")) != null && ((String)object).trim().equals("2")) {
            this.loadFromDatabase.setEnabled(false);
            this.overwriteDatabase.setEnabled(false);
        }
        this.loadCmiMibBox = new JRadioButton(SnmpUtils.getString("Load MIBs From Compiled File"));
        this.loadCmiMibBox.addActionListener(this);
        this.loadCmiMibBox.setFont(this.lfont);
        this.overwriteCmiBox = new JRadioButton(SnmpUtils.getString("Overwrite existing Compiled MIB Files"));
        this.overwriteCmiBox.addActionListener(this);
        this.overwriteCmiBox.setFont(this.lfont);
        this.loadDirectly = new JRadioButton(SnmpUtils.getString("Load MIBs directly"));
        this.loadDirectly.addActionListener(this);
        this.loadDirectly.setFont(this.lfont);
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.loadFromDatabase);
        ((ButtonGroup)object).add(this.loadCmiMibBox);
        ((ButtonGroup)object).add(this.loadDirectly);
        this.setLayout(this.gb);
        this.gc.weightx = 0.0;
        this.gc.anchor = 17;
        this.gb.setConstraints(this.loadDirectly, this.gc);
        this.add(this.loadDirectly);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gb);
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gb.setConstraints(this.loadCmiMibBox, this.gc);
        jPanel.add(this.loadCmiMibBox);
        this.gc.gridx = 1;
        this.gb.setConstraints(this.overwriteCmiBox, this.gc);
        if (this.mibbrowser != null && this.mibbrowser.applet == null || this.tree != null && this.tree.applet == null) {
            jPanel.add(this.overwriteCmiBox);
        }
        this.gc.gridx = 0;
        this.gc.gridy = 1;
        this.gb.setConstraints(jPanel, this.gc);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(this.gb);
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gb.setConstraints(this.loadFromDatabase, this.gc);
        jPanel.add(this.loadFromDatabase);
        this.gc.gridx = 1;
        this.gb.setConstraints(this.overwriteDatabase, this.gc);
        jPanel.add(this.overwriteDatabase);
        this.gc.gridx = 0;
        this.gc.gridy = 2;
        this.gb.setConstraints(jPanel, this.gc);
        this.add(jPanel);
        if (this.check) {
            jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(Color.white, Color.gray), ""));
            jPanel.setLayout(this.gb);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(this.gb);
            JLabel jLabel = new JLabel(SnmpUtils.getString("Recently Loaded MIBs"));
            jLabel.setFont(this.lfont);
            jLabel.setForeground(Color.black);
            this.gc.gridx = 0;
            this.gc.gridy = 0;
            this.gc.weightx = 0.0;
            this.gc.fill = 0;
            this.gb.setConstraints(jLabel, this.gc);
            jPanel2.add(jLabel);
            this.fileListModel = new DefaultListModel();
            this.fileList = new JList(this.fileListModel);
            this.fileList.setSelectionMode(2);
            this.fileList.setVisibleRowCount(5);
            JScrollPane jScrollPane = new JScrollPane(this.fileList);
            jScrollPane.setPreferredSize(new Dimension(300, 200));
            this.gc.gridy = 1;
            this.gc.weightx = 1.0;
            this.gc.weighty = 1.0;
            this.gc.fill = 1;
            this.gb.setConstraints(jScrollPane, this.gc);
            jPanel2.add(jScrollPane);
            this.gc.gridx = 0;
            this.gc.gridy = 0;
            this.gc.fill = 1;
            this.gb.setConstraints(jPanel2, this.gc);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(this.gb);
            this.move = new JButton("-->");
            this.move.addActionListener(this);
            this.move.setFont(this.lfont);
            this.gc.gridx = 0;
            this.gc.weightx = 0.0;
            this.gc.weighty = 0.0;
            this.gc.fill = 2;
            this.gb.setConstraints(this.move, this.gc);
            jPanel3.add(this.move);
            this.delete = new JButton(SnmpUtils.getString("Delete"));
            this.delete.addActionListener(this);
            this.delete.setFont(this.lfont);
            this.gc.gridy = 1;
            this.gb.setConstraints(this.delete, this.gc);
            jPanel3.add(this.delete);
            this.gc.gridx = 1;
            this.gc.gridy = 0;
            this.gc.fill = 1;
            this.gb.setConstraints(jPanel3, this.gc);
            jPanel.add(jPanel3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(this.gb);
            jLabel = new JLabel(SnmpUtils.getString("Updated List"));
            jLabel.setFont(this.lfont);
            jLabel.setForeground(Color.black);
            this.gc.gridx = 0;
            this.gc.gridy = 0;
            this.gc.fill = 0;
            this.gc.weightx = 0.0;
            this.gb.setConstraints(jLabel, this.gc);
            jPanel4.add(jLabel);
            this.loadListModel = new DefaultListModel();
            this.loadList = new JList(this.loadListModel);
            this.loadList.setSelectionMode(2);
            this.loadList.setVisibleRowCount(5);
            jScrollPane = new JScrollPane(this.loadList);
            jScrollPane.setPreferredSize(new Dimension(300, 200));
            this.gc.gridy = 1;
            this.gc.fill = 1;
            this.gc.weightx = 1.0;
            this.gc.weighty = 1.0;
            this.gb.setConstraints(jScrollPane, this.gc);
            jPanel4.add(jScrollPane);
            this.gc.gridx = 2;
            this.gc.gridy = 0;
            this.gc.anchor = 10;
            this.gb.setConstraints(jPanel4, this.gc);
            jPanel.add(jPanel4);
            this.gc.gridx = 0;
            this.gc.gridy = 3;
            this.gc.fill = 1;
            this.gc.weightx = 1.0;
            this.gb.setConstraints(jPanel, this.gc);
            this.add(jPanel);
            if (this.mibbrowser != null && !this.mibbrowser.browserModel.hideJdbc) {
                jPanel = this.getDatabasePanel();
                this.gc.gridx = 0;
                this.gc.gridy = 4;
                this.gc.weightx = 0.0;
                this.gc.weighty = 0.0;
                this.gb.setConstraints(jPanel, this.gc);
                this.add(jPanel);
            }
            Thread thread = new Thread(this);
            thread.start();
            if (this.loadListModel.isEmpty()) {
                this.delete.setEnabled(false);
            }
            this.fileList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = MibSettingsPanel.this.fileList.locationToIndex(mouseEvent.getPoint());
                    if (n == -1) {
                        return;
                    }
                    Object e = MibSettingsPanel.this.fileListModel.elementAt(n);
                    if (mouseEvent.getClickCount() == 1) {
                        if (MibSettingsPanel.this.loadListModel.contains(e)) {
                            MibSettingsPanel.this.loadList.setSelectedValue(e, true);
                        } else {
                            MibSettingsPanel.this.loadList.clearSelection();
                        }
                    }
                    if (mouseEvent.getClickCount() == 2 && !MibSettingsPanel.this.loadListModel.contains(e)) {
                        MibSettingsPanel.this.loadListModel.addElement(e);
                        MibSettingsPanel.this.delete.setEnabled(true);
                    }
                }
            });
        } else {
            jPanel = this.getDatabasePanel();
            this.gc.gridx = 0;
            this.gc.gridy = 3;
            this.gc.weightx = 1.0;
            this.gc.anchor = 10;
            this.gb.setConstraints(jPanel, this.gc);
            this.add(jPanel);
        }
        if (this.mibbrowser != null) {
            if (this.mibbrowser.snmptasks.isLoadFromCompiledMibs()) {
                this.enabled = false;
                this.loadCmiMibBox.setSelected(true);
                this.overwriteCmiBox.setEnabled(true);
            } else {
                this.overwriteCmiBox.setEnabled(false);
            }
            if (this.mibbrowser.applet == null && this.mibbrowser.snmptasks.getOverwriteCMI()) {
                this.overwriteCmiBox.setSelected(true);
            }
            if (this.mibbrowser.snmptasks.isLoadMibsFromDatabase()) {
                this.enabled = true;
                this.enableField(this.enabled);
                this.loadFromDatabase.setSelected(true);
                this.overwriteDatabase.setEnabled(true);
                if (this.mibbrowser.browserModel.values != null) {
                    if (this.mibbrowser.browserModel.values.length == 10) {
                        this.driverName.setText(this.mibbrowser.browserModel.values[6].trim());
                        this.urlField.setText(this.mibbrowser.browserModel.values[7].trim());
                        this.userName.setText(this.mibbrowser.browserModel.values[8].trim());
                        ((JTextComponent)this.passWord).setText(this.mibbrowser.browserModel.values[9].trim());
                    } else if (this.mibbrowser.browserModel.values.length == 4) {
                        this.driverName.setText(this.mibbrowser.browserModel.values[0].trim());
                        this.urlField.setText(this.mibbrowser.browserModel.values[1].trim());
                        this.userName.setText(this.mibbrowser.browserModel.values[2].trim());
                        ((JTextComponent)this.passWord).setText(this.mibbrowser.browserModel.values[3].trim());
                    }
                }
                this.firsttime = false;
            } else {
                this.overwriteDatabase.setEnabled(false);
            }
            if (this.mibbrowser.snmptasks.isOverwriteMibsInDatabase()) {
                this.overwriteDatabase.setSelected(true);
            }
            if (!this.mibbrowser.snmptasks.isLoadFromCompiledMibs() && !this.mibbrowser.snmptasks.isLoadMibsFromDatabase()) {
                this.enabled = false;
                this.loadDirectly.setSelected(true);
                this.overwriteCmiBox.setEnabled(false);
                this.overwriteDatabase.setEnabled(false);
            }
        }
        if (this.tree != null) {
            if (this.tree.mibOps.isLoadFromCompiledMibs()) {
                this.enabled = false;
                this.loadCmiMibBox.setSelected(true);
                this.overwriteCmiBox.setEnabled(true);
            } else {
                this.overwriteCmiBox.setEnabled(false);
            }
            if (this.tree.applet == null && this.tree.mibOps.getOverwriteCMI()) {
                this.overwriteCmiBox.setSelected(true);
            }
            if (this.tree.mibOps.isLoadFromDatabase()) {
                this.enabled = true;
                this.loadFromDatabase.setSelected(true);
                this.overwriteDatabase.setEnabled(true);
            } else {
                this.overwriteDatabase.setEnabled(false);
            }
            if (this.tree.mibOps.isOverwriteDatabase()) {
                this.overwriteDatabase.setSelected(true);
            }
            if (!this.tree.mibOps.isLoadFromCompiledMibs() && !this.tree.mibOps.isLoadFromDatabase()) {
                this.enabled = false;
                this.loadDirectly.setSelected(true);
                this.overwriteCmiBox.setEnabled(false);
                this.overwriteDatabase.setEnabled(false);
            }
        }
        this.enableField(this.enabled);
    }

    private void enableField(boolean bl) {
        if (this.mibbrowser != null && !this.mibbrowser.browserModel.hideJdbc) {
            if (bl) {
                this.driverName.setEnabled(true);
                this.driverName.setBackground(Color.white);
                this.urlField.setEnabled(true);
                this.urlField.setBackground(Color.white);
                this.userName.setEnabled(true);
                this.userName.setBackground(Color.white);
                this.passWord.setEnabled(true);
                this.passWord.setBackground(Color.white);
            } else {
                this.driverName.setEnabled(false);
                this.driverName.setBackground(Color.lightGray);
                this.urlField.setEnabled(false);
                this.urlField.setBackground(Color.lightGray);
                this.userName.setEnabled(false);
                this.userName.setBackground(Color.lightGray);
                this.passWord.setEnabled(false);
                this.passWord.setBackground(Color.lightGray);
            }
        }
    }

    private JPanel getDatabasePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(Color.white, Color.gray), SnmpUtils.getString("JDBCParams"), 1, 2, this.lfont, Color.black));
        this.driverName = new JTextField(25);
        this.urlField = new JTextField(25);
        this.userName = new JTextField(25);
        this.passWord = new JPasswordField(25);
        jPanel.setLayout(this.gb);
        this.addDouble(jPanel, this.gb, this.gc, SnmpUtils.getString("Drivername"), SnmpUtils.getString("URL"), this.driverName, this.urlField, 0);
        this.addDouble(jPanel, this.gb, this.gc, SnmpUtils.getString("UserName"), SnmpUtils.getString("Password"), this.userName, this.passWord, 1);
        return jPanel;
    }

    public String getDriverName() {
        return this.driverName.getText();
    }

    public Enumeration getMibList() {
        if (!this.loadListModel.isEmpty()) {
            return this.loadListModel.elements();
        }
        return this.fileListModel.elements();
    }

    public String getPassword() {
        return this.passWord.getText();
    }

    public String getUrl() {
        return this.urlField.getText();
    }

    public String getUserName() {
        return this.userName.getText();
    }

    private void restore() {
        if (this.mibbrowser != null) {
            if (this.mibbrowser.snmptasks.isLoadFromCompiledMibs()) {
                this.loadFromDatabase.setSelected(false);
                this.loadCmiMibBox.setSelected(true);
                this.overwriteCmiBox.setEnabled(true);
                this.overwriteDatabase.setEnabled(false);
                this.loadDirectly.setSelected(false);
            } else if (this.mibbrowser.snmptasks.isLoadMibsFromDatabase()) {
                this.loadFromDatabase.setSelected(true);
                this.loadCmiMibBox.setSelected(false);
                this.overwriteCmiBox.setEnabled(false);
                this.overwriteDatabase.setEnabled(true);
                this.loadDirectly.setSelected(false);
            } else if (!this.mibbrowser.snmptasks.isLoadFromCompiledMibs() && !this.mibbrowser.snmptasks.isLoadMibsFromDatabase()) {
                this.loadFromDatabase.setSelected(false);
                this.loadCmiMibBox.setSelected(false);
                this.overwriteCmiBox.setEnabled(false);
                this.overwriteDatabase.setEnabled(false);
                this.loadDirectly.setSelected(true);
            }
        } else if (this.tree != null) {
            if (this.tree.mibOps.isLoadFromCompiledMibs()) {
                this.loadFromDatabase.setSelected(false);
                this.loadCmiMibBox.setSelected(true);
                this.overwriteCmiBox.setEnabled(true);
                this.overwriteDatabase.setEnabled(false);
                this.loadDirectly.setSelected(false);
            } else if (this.tree.mibOps.isLoadFromDatabase()) {
                this.loadFromDatabase.setSelected(true);
                this.loadCmiMibBox.setSelected(false);
                this.overwriteCmiBox.setEnabled(false);
                this.overwriteDatabase.setEnabled(true);
                this.loadDirectly.setSelected(false);
            } else if (!this.tree.mibOps.isLoadFromDatabase() && !this.tree.mibOps.isLoadFromCompiledMibs()) {
                this.loadFromDatabase.setSelected(false);
                this.loadCmiMibBox.setSelected(false);
                this.overwriteCmiBox.setEnabled(false);
                this.overwriteDatabase.setEnabled(false);
                this.loadDirectly.setSelected(true);
            }
        }
    }

    public void run() {
        this.updateList();
    }

    private int showError() {
        int n = JOptionPane.showConfirmDialog(this, " " + SnmpUtils.getString("Mibs has been loaded in Other modes.\n Do you want to Change to this Mode.\n All the Mibs already loaded will be unloaded"), SnmpUtils.getString("Confirm Message"), 0);
        if (n == 0) {
            if (this.mibbrowser != null) {
                try {
                    this.mibbrowser.browserModel.deleteMibs(this.mibbrowser.browserUi.tree);
                }
                catch (Exception exception) {}
                return 1;
            }
            if (this.tree != null) {
                Enumeration enumeration = this.tree.mibOps.getMibModules();
                while (enumeration.hasMoreElements()) {
                    try {
                        MibModule mibModule = (MibModule)enumeration.nextElement();
                        this.tree.deleteMib(mibModule.getName());
                    }
                    catch (Exception exception) {}
                }
                return 1;
            }
        } else if (n == 1) {
            return 0;
        }
        return 0;
    }

    public void updateList() {
        block24: {
            Object object;
            String string;
            block22: {
                block23: {
                    if (this.mibbrowser.applet != null) break block23;
                    BufferedReader bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new FileReader("MibFiles.store"));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return;
                    }
                    boolean bl = true;
                    String string2 = null;
                    StringTokenizer stringTokenizer = null;
                    String string3 = null;
                    this.fileListModel.clear();
                    while (bl) {
                        try {
                            string2 = bufferedReader.readLine();
                            if (string2 == null) {
                                this.check = false;
                                return;
                            }
                            stringTokenizer = new StringTokenizer(string2, "|");
                            if (stringTokenizer.countTokens() != 2 || this.fileListModel.contains(string3 = stringTokenizer.nextToken())) continue;
                            this.fileListModel.insertElementAt(string3, 0);
                        }
                        catch (Exception exception) {
                            System.err.println(String.valueOf(SnmpUtils.getString("Error in Reading the File: ")) + " " + exception);
                        }
                    }
                    break block24;
                }
                if (this.mibbrowser.applet == null) break block24;
                string = null;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                String string4 = "MibFiles.store";
                try {
                    byte[] byArray;
                    block26: {
                        block25: {
                            dataOutputStream.writeInt(GET_FILE_REQ);
                            dataOutputStream.writeUTF(string4);
                            byArray = null;
                            byArray = byteArrayOutputStream.toByteArray();
                            if (this.mibbrowser.applet != null && (object = this.mibbrowser.applet.getParameter("PROTOCOL")) != null && ((String)object).trim().equals("2")) {
                                return;
                            }
                            if (this.mibbrowser.browserUi.sasclient == null) break block25;
                            MibBrowserUI mibBrowserUI = this.mibbrowser.browserUi;
                            if (mibBrowserUI.sasclient.isFileReadWrite()) break block26;
                        }
                        if (this.mibbrowser.browserUi.sasclient == null) {
                            System.err.println(SnmpUtils.getString("Not connected to sas"));
                        }
                        return;
                    }
                    byArray = this.mibbrowser.browserUi.sasclient.clientCall(byArray);
                    if (byArray == null) {
                        return;
                    }
                    object = new DataInputStream(new ByteArrayInputStream(byArray));
                    int n = ((DataInputStream)object).readInt();
                    if (n == GET_FILE_RESP) {
                        string = ((DataInputStream)object).readUTF();
                        break block22;
                    }
                    System.err.println(SnmpUtils.getString("Not able to get the file"));
                    return;
                }
                catch (IOException iOException) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Error in opening the file : ")) + " " + iOException.getMessage());
                    return;
                }
            }
            boolean bl = true;
            object = null;
            String string5 = null;
            this.fileListModel.clear();
            while (bl) {
                try {
                    if (string == null) {
                        bl = false;
                        return;
                    }
                    object = new StringTokenizer(string, "|\n");
                    while (((StringTokenizer)object).countTokens() >= 2) {
                        string5 = ((StringTokenizer)object).nextToken();
                        String string6 = ((StringTokenizer)object).nextToken();
                        if (this.fileListModel.contains(string5)) continue;
                        this.fileListModel.insertElementAt(string5, 0);
                    }
                    if (this.fileListModel.contains("Cannot get. File does not exist.")) {
                        this.fileListModel.removeElement("Cannot get. File does not exist.");
                    }
                    bl = false;
                }
                catch (Exception exception) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Error in Reading the File: ")) + " " + exception);
                    bl = false;
                }
            }
        }
    }
}

