/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpTarget;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.ui.NodeData;
import com.adventnet.snmp.ui.NodeIconRenderer;
import com.adventnet.snmp.ui.NodeSystemTreeModel;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import com.sun.jimi.core.component.JimiCanvas;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class MibTree
extends JPanel
implements ItemListener,
ActionListener {
    public JTree tree = null;
    MibNode mno = null;
    JButton expand = null;
    JButton collapse = null;
    String currentMib = null;
    boolean isGlobalView;
    JCheckBox viewBox = new JCheckBox();
    MibOperations mibOps;
    Applet applet;
    public String mibs = "";
    MibModule module = null;
    NodeSystemTreeModel model = null;
    NodeIconRenderer nodeRend = null;
    NodeData data = null;
    MibNode root = null;
    Font f = null;
    Vector mibNameVector = null;

    public MibTree() {
        this(null, null);
    }

    public MibTree(MibOperations mibOperations) {
        this(mibOperations, null);
    }

    public MibTree(MibOperations mibOperations, Applet applet) {
        this.tree = new JTree();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(SnmpUtils.getString("Global View"));
        jLabel.setFont(SnmpUIUtils.getFont());
        jLabel.setForeground(Color.black);
        jPanel.add("West", jLabel);
        jPanel.add("East", this.viewBox);
        this.tree.setBackground(Color.white);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        JimiCanvas jimiCanvas = new JimiCanvas();
        jimiCanvas.setImageLocation(this.getClass().getResource("images/expandit.png"));
        this.expand = new JButton(new ImageIcon(jimiCanvas.getImage()));
        this.expand.setToolTipText(SnmpUtils.getString("Expand the Tree"));
        this.expand.setBorderPainted(false);
        this.expand.setMargin(new Insets(0, 1, 0, 1));
        this.expand.addActionListener(this);
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.expand, gridBagConstraints);
        jPanel2.add(this.expand);
        jimiCanvas = new JimiCanvas();
        jimiCanvas.setImageLocation(this.getClass().getResource("images/collapseit.png"));
        this.collapse = new JButton(new ImageIcon(jimiCanvas.getImage()));
        this.collapse.setBorderPainted(false);
        this.collapse.setMargin(new Insets(0, 1, 0, 1));
        this.collapse.addActionListener(this);
        this.collapse.setToolTipText(SnmpUtils.getString("Collapse the Tree"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagLayout.setConstraints(this.collapse, gridBagConstraints);
        jPanel2.add(this.collapse);
        jPanel2.setBorder(new LineBorder(Color.gray, 1));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                AbstractButton abstractButton;
                Object object = mouseEvent.getSource();
                if (object instanceof AbstractButton && (abstractButton = (AbstractButton)object).isEnabled()) {
                    abstractButton.setBorderPainted(true);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                AbstractButton abstractButton;
                Object object = mouseEvent.getSource();
                if (object instanceof AbstractButton && (abstractButton = (AbstractButton)object).isEnabled()) {
                    abstractButton.setBorderPainted(false);
                }
            }
        };
        this.expand.addMouseListener(mouseAdapter);
        this.collapse.addMouseListener(mouseAdapter);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)jPanel, "South");
        this.add("Center", new JScrollPane(this.tree));
        this.add("South", jPanel3);
        this.viewBox.addItemListener(this);
        this.mibOps = mibOperations != null ? mibOperations : new SnmpTarget(applet).getMibOperations();
        this.applet = applet;
        this.updateMibTree();
    }

    public MibTree(Applet applet) {
        this(null, applet);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.expand) {
            TreePath treePath = null;
            int n = 0;
            while ((treePath = this.tree.getPathForRow(n)) != null) {
                this.tree.expandRow(n);
                this.tree.scrollRowToVisible(n++);
            }
        } else if (object == this.collapse) {
            TreePath treePath = null;
            int n = this.tree.getRowCount() - 1;
            while ((treePath = this.tree.getPathForRow(n--)) != null) {
                this.tree.collapseRow(n);
            }
            this.tree.expandRow(0);
        }
        if (actionEvent.getActionCommand().equals("Description")) {
            System.out.println("action performed");
        }
    }

    void addAllChildren(MibModule mibModule, MibNode mibNode, DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector vector = mibNode.getChildList();
        if (vector == null || vector.size() == 0) {
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            MibNode mibNode2 = (MibNode)enumeration.nextElement();
            if (mibModule.getMibNodeByName(mibNode2.getLabel()) == null) continue;
            this.addSubTree(mibModule, mibNode2, defaultMutableTreeNode);
        }
    }

    DefaultMutableTreeNode addLeafNode(Object object, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object, false);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    public void addMib(String string) throws MibException, IOException, FileNotFoundException {
        MibModule mibModule = null;
        MibNode mibNode = this.getSelectedMibNode();
        if (this.applet != null) {
            String string2 = string.replace(File.separatorChar, '/');
            URL uRL = null;
            try {
                uRL = this.applet.getClass().getResource(string2);
                if (uRL == null) {
                    uRL = new URL(this.applet.getDocumentBase().getProtocol(), this.applet.getDocumentBase().getHost(), this.applet.getDocumentBase().getPort(), "/" + string2);
                }
                if (uRL == null) {
                    uRL = new URL(this.applet.getDocumentBase(), string2);
                }
            }
            catch (Exception exception) {
                try {
                    uRL = new URL(this.applet.getDocumentBase().getProtocol(), this.applet.getDocumentBase().getHost(), this.applet.getDocumentBase().getPort(), "/" + string2);
                }
                catch (Exception exception2) {
                    uRL = new URL(this.applet.getDocumentBase(), string2);
                }
            }
            this.mibOps.loadMibModule(this.applet, uRL);
        } else {
            mibModule = this.mibOps.loadMibModule(string);
        }
        this.mibs = String.valueOf(this.mibs) + string + " ";
        this.currentMib = string;
        this.updateMibTree();
        this.setSelectedMibNode(mibNode);
    }

    public void addMibs(String string) throws MibException, IOException, FileNotFoundException {
        MibNode mibNode = this.getSelectedMibNode();
        try {
            if (this.applet != null) {
                this.mibOps.loadMibModules(this.applet, string);
            } else {
                this.mibOps.loadMibModules(string);
            }
        }
        catch (MibException mibException) {
            this.mibs = String.valueOf(this.mibs) + string + " ";
            this.currentMib = string;
            this.updateMibTree();
            throw new MibException(mibException.getMessage());
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.mibs = String.valueOf(this.mibs) + string + " ";
            this.currentMib = string;
            this.updateMibTree();
            throw new FileNotFoundException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            this.mibs = String.valueOf(this.mibs) + string + " ";
            this.currentMib = string;
            this.updateMibTree();
            throw new IOException(iOException.getMessage());
        }
        this.mibs = String.valueOf(this.mibs) + string + " ";
        this.currentMib = string;
        this.updateMibTree();
        this.setSelectedMibNode(mibNode);
    }

    void addSubTree(MibModule mibModule, MibNode mibNode, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (mibNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = this.addTreeNode(mibNode, defaultMutableTreeNode);
        if (mibNode.getSyntax() == null) {
            this.addAllChildren(mibModule, mibNode, defaultMutableTreeNode2);
        }
    }

    DefaultMutableTreeNode addTreeNode(Object object, DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public void deleteMib(String string) throws MibException, IOException, FileNotFoundException {
        if (this.isGlobalView) {
            this.mibNameVector = new Vector();
            this.mibNameVector.addElement("Loaded Mibs");
            String string2 = "";
            this.data = new NodeData(this.f, Color.red, null, "Loaded MibModules                               ", false);
            Enumeration enumeration = this.mibOps.getMibModules();
            while (enumeration.hasMoreElements()) {
                MibModule mibModule = (MibModule)enumeration.nextElement();
                this.mibOps.unloadMibModule(mibModule.getName());
            }
            this.model = new NodeSystemTreeModel(this.data, this.mibNameVector, this.mibOps);
            this.tree.setModel(this.model);
        } else {
            MibModule mibModule = this.mibOps.unloadMibModule(string);
            this.mibNameVector = new Vector();
            this.mibNameVector.addElement("Loaded Mibs");
            String string3 = "";
            Enumeration enumeration = this.mibOps.getMibModules();
            while (enumeration.hasMoreElements()) {
                MibModule mibModule2 = (MibModule)enumeration.nextElement();
                this.mibNameVector.addElement(mibModule2.getName());
            }
            if (this.mibs == null || this.mibs.equals("")) {
                this.mibs = string3;
            }
            this.data = new NodeData(this.f, Color.red, null, "Loaded MibModules                               ", false);
            this.model = new NodeSystemTreeModel(this.data, this.mibNameVector, this.mibOps);
            if (this.isGlobalView) {
                this.model.setView(true);
            } else {
                this.model.setView(false);
            }
            this.tree.setModel(this.model);
            this.nodeRend = new NodeIconRenderer();
            this.tree.setCellRenderer(this.nodeRend);
        }
    }

    Object getChildObject(Object[] objectArray, Object object, int n) {
        if (n < 1) {
            return object;
        }
        NodeSystemTreeModel nodeSystemTreeModel = (NodeSystemTreeModel)this.tree.getModel();
        try {
            int n2 = 0;
            while (n2 < nodeSystemTreeModel.getChildCount(objectArray[n - 1])) {
                if (nodeSystemTreeModel.getChild(objectArray[n - 1], n2).toString().equals(object.toString())) {
                    return nodeSystemTreeModel.getChild(objectArray[n - 1], n2);
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return object;
    }

    public String getMibModule() {
        return this.currentMib;
    }

    public String getMibModules() {
        return this.mibs;
    }

    public boolean getOverwriteCMI() {
        return this.mibOps.getOverwriteCMI();
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 400);
    }

    public int getRowHeight() {
        return this.tree.getRowHeight();
    }

    public MibModule getSelectedMibModule() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object[] objectArray = treePath.getPath();
        if (objectArray != null && objectArray.length > 1) {
            return this.mibOps.getMibModule(objectArray[1].toString());
        }
        return null;
    }

    public MibModule[] getSelectedMibModules() {
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        MibModule[] mibModuleArray = new MibModule[treePathArray.length];
        if (treePathArray == null) {
            return null;
        }
        int n = 0;
        while (n < treePathArray.length) {
            Object[] objectArray = treePathArray[n].getPath();
            if (objectArray != null) {
                if (objectArray.length > 1) {
                    mibModuleArray[n] = this.mibOps.getMibModule(objectArray[1].toString());
                }
            } else {
                return null;
            }
            ++n;
        }
        return mibModuleArray;
    }

    public MibNode getSelectedMibNode() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof NodeData) {
            MibNode mibNode = ((NodeData)object).getUserObject();
            if (mibNode instanceof MibNode) {
                return mibNode;
            }
            return null;
        }
        return null;
    }

    public String getSerializedMibFileName() {
        return this.mibOps.getSerializedMibFileName();
    }

    public boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    public String getToolTipText() {
        return this.tree.getToolTipText();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) throws MibException {
        this.mibOps.initJdbcParams(string, string2, string3, string4);
    }

    void initialization() {
        this.f = new Font("Arial", 0, 12);
        this.tree.setFont(this.f);
        this.update();
    }

    public boolean isEditable() {
        return this.tree.isEditable();
    }

    public boolean isGlobalView() {
        return this.isGlobalView;
    }

    public boolean isLargeModel() {
        return this.tree.isLargeModel();
    }

    public boolean isLoadFromCompiledMibs() {
        return this.mibOps.isLoadFromCompiledMibs();
    }

    public boolean isLoadFromSerializedMibs() {
        return this.mibOps.isLoadFromSerializedMibs();
    }

    public boolean isLoadMibsFromDatabase() {
        return this.mibOps.isLoadFromDatabase();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.mibOps.isOverwriteDatabase();
    }

    public boolean isReadDesc() {
        return this.mibOps.isReadDesc();
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public boolean isSerializeMibs() {
        return this.mibOps.isSerializeMibs();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        block6: {
            if (this.viewBox.isSelected()) {
                this.mno = this.getSelectedMibNode();
                this.isGlobalView = true;
            } else {
                this.isGlobalView = false;
            }
            if (this.mibNameVector.size() == 1) break block6;
            try {
                this.data = new NodeData(this.f, Color.red, null, "Loaded MibModules                               ", false);
                this.model = new NodeSystemTreeModel(this.data, this.mibNameVector, this.mibOps);
                if (this.isGlobalView) {
                    this.model.setView(true);
                } else {
                    this.model.setView(false);
                }
                this.tree.setModel(this.model);
                this.setSelectedMibNode(this.mno);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.tree.removeTreeSelectionListener(treeSelectionListener);
    }

    public void setEditable(boolean bl) {
        this.tree.setEditable(bl);
    }

    public void setLargeModel(boolean bl) {
        this.tree.setLargeModel(bl);
    }

    public void setLoadFromCompiledMibs(boolean bl) {
        this.mibOps.setLoadFromCompiledMibs(bl);
    }

    public void setLoadFromSerializedMibs(boolean bl) {
        this.mibOps.setLoadFromSerializedMibs(bl);
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.mibOps.setLoadFromDatabase(bl);
    }

    public void setMibModule(String string) {
        try {
            this.addMibs(string);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error loading MIB: ")) + " " + exception);
            exception.printStackTrace();
        }
    }

    public void setOverwriteCMI(boolean bl) {
        this.mibOps.setOverwriteCMI(bl);
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.mibOps.setOverwriteDatabase(bl);
    }

    public void setReadDesc(boolean bl) {
        this.mibOps.setReadDesc(bl);
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    public void setRowHeight(int n) {
        this.tree.setRowHeight(n);
    }

    public void setSelectedMibNode(MibNode mibNode) {
        if (mibNode == null) {
            return;
        }
        MibModule mibModule = this.mibOps.getMibModule(mibNode.getModuleName());
        if (mibModule == null) {
            return;
        }
        Vector vector = mibModule.getRootNodes();
        int n = 2;
        MibNode mibNode2 = mibNode;
        if (!vector.contains(mibNode2)) {
            while (mibNode2.getParent() != null) {
                if (vector.contains(mibNode2 = mibNode2.getParent())) break;
                ++n;
            }
        }
        Object[] objectArray = new Object[n + 1];
        NodeSystemTreeModel nodeSystemTreeModel = (NodeSystemTreeModel)this.tree.getModel();
        objectArray[0] = nodeSystemTreeModel.getRoot();
        objectArray[1] = !this.isGlobalView() ? this.getChildObject(objectArray, mibModule, 1) : nodeSystemTreeModel.getChild(objectArray[0], 0);
        mibNode2 = mibNode;
        int n2 = n;
        while (n2 > 1) {
            objectArray[n2] = mibNode2;
            mibNode2 = mibNode2.getParent();
            --n2;
        }
        int n3 = 2;
        while (n3 < n + 1) {
            objectArray[n3] = this.getChildObject(objectArray, objectArray[n3], n3);
            ++n3;
        }
        TreePath treePath = new TreePath(objectArray);
        int n4 = treePath.getPathCount();
        Object[] objectArray2 = new Object[n4];
        objectArray2 = treePath.getPath();
        int n5 = 0;
        Object object = nodeSystemTreeModel.getRoot();
        int n6 = 1;
        while (n6 < n4) {
            int n7 = 0;
            int n8 = nodeSystemTreeModel.getChildCount(object);
            String string = objectArray2[n6].toString();
            int n9 = 0;
            while (n9 < n8 && !((NodeData)nodeSystemTreeModel.getChild(object, n9)).toString().equals(string)) {
                ++n9;
            }
            if (n9 < n8) {
                Object object2 = object = nodeSystemTreeModel.getChild(object, n9);
                int n10 = n5;
                while (n10 < this.tree.getRowCount()) {
                    if (((NodeData)object).node == null) {
                        object = nodeSystemTreeModel.getChild(object, 0);
                    }
                    if (this.mibOps.getMibModule(this.tree.getPathForRow(n10).getLastPathComponent().toString()) != null && this.tree.getPathForRow(n10).getLastPathComponent().toString().equals(mibModule.getName()) && !this.tree.isExpanded(n10)) {
                        this.tree.expandRow(n10);
                    }
                    if (this.tree.getPathForRow(n10).getLastPathComponent().toString().equals(((NodeData)object).toString())) {
                        NodeData nodeData = (NodeData)this.tree.getPathForRow(n10).getLastPathComponent();
                        MibNode mibNode3 = nodeData.node;
                        if (mibNode3.getCommonAncestorWith(mibNode) == null && vector.size() > 1) {
                            object = nodeSystemTreeModel.getChild(object2, 1);
                        } else if (mibNode3.getNumberedOIDString().equals(((NodeData)object).node.getNumberedOIDString()) && mibNode3.getModuleName().equals(mibModule.getName())) {
                            n7 = n10;
                            break;
                        }
                    }
                    ++n10;
                }
                if (n6 == n4 - 1 || ((NodeData)object).toString().equals(mibNode.getLabel())) {
                    this.tree.setSelectionRow(n7);
                } else {
                    this.tree.expandRow(n7);
                }
                n5 = n7;
            }
            ++n6;
        }
    }

    public void setSerializeMibs(boolean bl) {
        this.mibOps.setSerializeMibs(bl);
    }

    public void setSerializedMibFileName(String string) {
        this.mibOps.setSerializedMibFileName(string);
    }

    public void setShowsRootHandles(boolean bl) {
        this.tree.setShowsRootHandles(bl);
    }

    public void setToolTipText(String string) {
        this.tree.setToolTipText(string);
    }

    public void setTree(JTree jTree) {
        this.tree = jTree;
    }

    void update() {
        this.mibNameVector = new Vector();
        this.mibNameVector.addElement("Loaded Mibs");
        String string = "";
        Enumeration enumeration = this.mibOps.getMibModules();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            this.mibNameVector.addElement(mibModule.getName());
        }
        if (this.mibs == null || this.mibs.equals("")) {
            this.mibs = string;
        }
        this.data = new NodeData(this.f, Color.red, null, "Loaded MibModules                               ", false);
        this.model = new NodeSystemTreeModel(this.data, this.mibNameVector, this.mibOps);
        if (this.isGlobalView) {
            this.model.setView(true);
        } else {
            this.model.setView(false);
        }
        this.tree.setModel(this.model);
        this.nodeRend = new NodeIconRenderer();
        this.tree.setCellRenderer(this.nodeRend);
    }

    void updateMibTree() {
        if (this.mibOps == null) {
            return;
        }
        this.initialization();
    }

    void updateMibTree(MibModule mibModule) {
        if (this.mibOps == null) {
            return;
        }
        this.initialization();
        this.tree.expandRow(0);
    }
}

