/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.ui.LoadDialog;
import com.adventnet.snmp.ui.MibTree;
import com.adventnet.snmp.ui.NodeData;
import com.adventnet.snmp.ui.ToolBar;
import com.sun.jimi.core.component.JimiCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class MibTreeComponent
extends JPanel
implements ActionListener {
    JTextArea text;
    JTextField oidField;
    JTextField stroidField;
    ToolBar toolbar = null;
    MibTree tree = null;
    JButton[] buttons = new JButton[2];
    LoadDialog load = null;
    static /* synthetic */ Class class$java$awt$Frame;

    public MibTreeComponent(String string) {
        JPanel jPanel = new JPanel();
        this.toolbar = this.setUpToolBar();
        this.tree = new MibTree();
        this.tree.setMinimumSize(new Dimension(140, 100));
        this.tree.setPreferredSize(new Dimension(200, 300));
        JSplitPane jSplitPane = new JSplitPane(1, this.tree, jPanel);
        jSplitPane.setDividerSize(7);
        jSplitPane.setDividerLocation(165);
        this.text = new JTextArea("We'll display MIB node information here", 16, 70);
        this.text.setEditable(false);
        this.text.setLineWrap(true);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel("OID ");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.oidField = new JTextField();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints(this.oidField, gridBagConstraints);
        jPanel2.add(this.oidField);
        JLabel jLabel2 = new JLabel("String OID");
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        this.stroidField = new JTextField();
        this.stroidField.setEditable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints(this.stroidField, gridBagConstraints);
        jPanel2.add(this.stroidField);
        JScrollPane jScrollPane = new JScrollPane(this.text, 20, 30);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setMinimumSize(new Dimension(300, 300));
        jPanel.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.add((Component)jSplitPane, "Center");
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                block3: {
                    MibNode mibNode;
                    Object object = treeSelectionEvent.getPath().getLastPathComponent();
                    if (!(object instanceof NodeData) || !((mibNode = ((NodeData)object).getUserObject()) instanceof MibNode)) break block3;
                    MibTreeComponent.this.text.setText(mibNode.toTagString());
                    MibTreeComponent.this.oidField.setText(mibNode.getNumberedOIDString());
                    MibTreeComponent.this.stroidField.setText(mibNode.getOIDString());
                    try {
                        MibTreeComponent.this.text.setCaretPosition(1);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.tree.tree.addTreeSelectionListener(treeSelectionListener);
        this.tree.tree.expandRow(0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            block5: {
                if (!actionEvent.getActionCommand().equals("Load MIB")) break block5;
                if (this.load == null) {
                    Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame != null ? class$java$awt$Frame : (class$java$awt$Frame = MibTreeComponent.class$("java.awt.Frame")), this);
                    if (frame == null) {
                        frame = new Frame();
                    }
                    this.load = new LoadDialog(this.tree, frame, "Load Mib Dialog");
                    ((Component)this.load).setBounds(50, 50, 450, 200);
                }
                this.load.setVisible(true);
                break block6;
            }
            if (!actionEvent.getActionCommand().equals("UnLoad MIB") || this.tree == null) break block6;
            try {
                if (this.tree.getSelectedMibModule() != null) {
                    this.tree.deleteMib(this.tree.getSelectedMibModule().getName());
                }
                this.text.setText("");
                this.oidField.setText("");
                this.stroidField.setText("");
            }
            catch (Exception exception) {
                System.out.println("Unloading MibModule(s) Failed: " + exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    ImageIcon[] createImageIcon(String[] stringArray) {
        JimiCanvas jimiCanvas = new JimiCanvas();
        ImageIcon[] imageIconArray = new ImageIcon[stringArray.length];
        String string = "images/";
        int n = 0;
        while (n < stringArray.length) {
            jimiCanvas.setImageLocation(this.getClass().getResource(String.valueOf(string) + stringArray[n]));
            imageIconArray[n] = new ImageIcon(jimiCanvas.getImage());
            ++n;
        }
        return imageIconArray;
    }

    public String getMibModules() {
        return this.tree.getMibModules();
    }

    public String getNumericObjectID() {
        try {
            String string = this.oidField.getText();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            SnmpOID snmpOID = this.tree.mibOps.getSnmpOID(string);
            MibNode mibNode = this.tree.mibOps.getMibNode(snmpOID);
            String string2 = snmpOID.toString();
            if (mibNode != null && mibNode.isScalar() && !string2.endsWith(".0")) {
                string2 = String.valueOf(string2) + ".0";
            }
            return string2;
        }
        catch (Exception exception) {
            System.err.println("Error getting OID: " + exception);
            return null;
        }
    }

    public MibModule getSelectedModule() {
        return this.tree.getSelectedMibModule();
    }

    public MibModule[] getSelectedModules() {
        return this.tree.getSelectedMibModules();
    }

    public String getStringObjectID() {
        try {
            String string = this.stroidField.getText();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            boolean bl = false;
            SnmpOID snmpOID = this.tree.mibOps.getSnmpOID(string);
            MibNode mibNode = this.tree.mibOps.getMibNode(snmpOID);
            if (mibNode != null && mibNode.isScalar() && !string.endsWith(".0")) {
                bl = true;
            }
            if (bl) {
                string = String.valueOf(string) + ".0";
                return string;
            }
            return string;
        }
        catch (Exception exception) {
            System.out.println("Error getting OID: " + exception);
            return null;
        }
    }

    public MibTree getTree() {
        return this.tree;
    }

    ToolBar setUpToolBar() {
        String[] stringArray = new String[]{"Load MIB", "UnLoad MIB"};
        String[] stringArray2 = new String[]{"Load MIB Module", "UnLoad MIB Module(s)"};
        String[] stringArray3 = new String[]{"loadmib.png", "unloadmib.png"};
        boolean[] blArray = new boolean[]{true, true};
        ImageIcon[] imageIconArray = this.createImageIcon(stringArray3);
        ToolBar toolBar = new ToolBar(false);
        int n = 0;
        while (n < imageIconArray.length) {
            if (!blArray[n]) {
                toolBar.addLineSeparator();
            }
            this.buttons[n] = toolBar.addButton(stringArray[n], imageIconArray[n], stringArray2[n]);
            this.buttons[n].addActionListener(this);
            ++n;
        }
        return toolBar;
    }
}

