/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.MibTC;
import com.adventnet.snmp.mibs.MibTrap;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;

public class NodeData {
    protected Font font;
    Applet applet = null;
    protected Color color;
    protected String string;
    Vector childrenVector = new Vector();
    Vector oidVector = new Vector();
    protected MibNode node;
    protected ImageIcon collapsedIcon;
    protected ImageIcon expandedIcon;
    protected static final Color selectedBackgroundColor = Color.blue;
    protected boolean isRootNode = false;
    public static String IMAGE_FILE_DIR_FRAME = "";
    public static String IMAGE_FILE_DIR_APPLET = "";
    protected String mibName = null;
    boolean isRoot = false;
    Vector childList = null;
    boolean mibTrapList = false;
    MibTrap mibTrap = null;
    boolean isTCList = false;
    MibTC mibTC = null;
    protected boolean externalIndex = false;

    public NodeData(Font font, Color color, MibNode mibNode, String string, boolean bl) {
        this.mibName = string;
        this.applet = this.applet;
        this.font = font;
        this.color = color;
        this.node = mibNode;
        this.mibName = string;
        this.isRootNode = bl;
        ImageIcon[] imageIconArray = this.getImageIcon();
        this.expandedIcon = imageIconArray[0];
        this.collapsedIcon = imageIconArray[1];
    }

    ImageIcon convertImage_to_Icon(String string) {
        try {
            URL uRL = this.getClass().getResource(String.valueOf(IMAGE_FILE_DIR_APPLET) + string);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            return new ImageIcon(toolkit.createImage((ImageProducer)uRL.getContent()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    Vector getChildList(MibOperations mibOperations) {
        if (this.childList != null) {
            return this.childList;
        }
        if (this.node == null) {
            return null;
        }
        Vector vector = this.node.getChildList();
        if (vector != null) {
            this.childList = (Vector)vector.clone();
        }
        if (this.mibName != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MibNode mibNode = (MibNode)enumeration.nextElement();
                if (mibOperations.getMibNode(mibNode.getLabel(), this.mibName) != null) continue;
                this.childList.removeElement(mibNode);
            }
        }
        return this.childList;
    }

    public ImageIcon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public Color getColor() {
        return this.color;
    }

    public ImageIcon getExpandedIcon() {
        return this.expandedIcon;
    }

    public boolean getExternalIndex() {
        return this.externalIndex;
    }

    public Font getFont() {
        return this.font;
    }

    private ImageIcon[] getImageIcon() {
        ImageIcon[] imageIconArray = new ImageIcon[2];
        if (this.isMibTrapList()) {
            imageIconArray[0] = imageIconArray[1] = this.convertImage_to_Icon("traplist.jpg");
            return imageIconArray;
        }
        if (this.isMibTrap()) {
            return imageIconArray;
        }
        if (this.isMibTCList()) {
            imageIconArray[0] = imageIconArray[1] = this.convertImage_to_Icon("tclist.jpg");
            return imageIconArray;
        }
        if (this.isMibTC()) {
            return imageIconArray;
        }
        if (this.node == null) {
            imageIconArray[0] = this.convertImage_to_Icon("origin.jpg");
            imageIconArray[1] = imageIconArray[0];
            return imageIconArray;
        }
        if (this.isRootNode) {
            imageIconArray[0] = this.convertImage_to_Icon("file.jpg");
            imageIconArray[1] = imageIconArray[0];
            return imageIconArray;
        }
        if (this.node.getTableSequence() != null) {
            imageIconArray[0] = this.convertImage_to_Icon("table.jpg");
        } else if (this.node.isTableEntry()) {
            imageIconArray[0] = this.convertImage_to_Icon("entry.jpg");
        } else if (this.externalIndex) {
            imageIconArray[0] = this.convertImage_to_Icon("extindex.jpg");
        } else if (this.isIndex(this.node)) {
            imageIconArray[0] = this.convertImage_to_Icon("index.jpg");
        } else if ((this.node.isScalar() || this.node.isTableColumn()) && this.node.printAccess() != null && this.node.printAccess().equals("read-create")) {
            imageIconArray[0] = this.convertImage_to_Icon("rcreate.jpg");
        } else if (!this.node.isWriteable() && (this.node.isScalar() || this.node.isTableColumn())) {
            imageIconArray[0] = this.convertImage_to_Icon("noaccess.jpg");
        } else if (this.node.isScalar() || this.node.isTableColumn()) {
            imageIconArray[0] = this.convertImage_to_Icon("leaf.jpg");
        } else if (this.node.getChildList().size() > 0) {
            imageIconArray[0] = this.convertImage_to_Icon("foldero.jpg");
            imageIconArray[1] = this.convertImage_to_Icon("folderc.jpg");
            return imageIconArray;
        }
        imageIconArray[1] = imageIconArray[0];
        return imageIconArray;
    }

    public MibTC getMibTC() {
        return this.mibTC;
    }

    public MibTrap getMibTrap() {
        return this.mibTrap;
    }

    public MibNode getUserObject() {
        return this.node;
    }

    private boolean isIndex(MibNode mibNode) {
        if (!mibNode.isTableColumn()) {
            return false;
        }
        MibNode mibNode2 = mibNode.getParent();
        Vector vector = mibNode2.getIndexNames();
        if (vector == null) {
            return false;
        }
        boolean bl = false;
        bl = vector.contains(mibNode.getLabel());
        if (!bl) {
            bl = vector.contains("IMPLIED " + mibNode.getLabel());
        }
        return bl;
    }

    public boolean isMibTC() {
        return this.mibTC != null;
    }

    public boolean isMibTCList() {
        return this.isTCList;
    }

    public boolean isMibTrap() {
        return this.mibTrap != null;
    }

    public boolean isMibTrapList() {
        return this.mibTrapList;
    }

    public void setCollapsedIcon(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.collapsedIcon = imageIcon;
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setExpandedIcon(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.expandedIcon = imageIcon;
        }
    }

    public void setExternalIndex(boolean bl) {
        this.externalIndex = bl;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setImageIcons() {
        ImageIcon[] imageIconArray = this.getImageIcon();
        this.expandedIcon = imageIconArray[0];
        this.collapsedIcon = imageIconArray[1];
    }

    public void setMibTC(MibTC mibTC) {
        this.mibTC = mibTC;
    }

    public void setMibTCList(boolean bl) {
        this.isTCList = bl;
    }

    public void setMibTrap(MibTrap mibTrap) {
        this.mibTrap = mibTrap;
    }

    public void setMibTrapList(boolean bl) {
        this.mibTrapList = bl;
    }

    public void setString(String string) {
    }

    public String string() {
        if (this.isMibTrapList()) {
            if (this.mibName == null) {
                return null;
            }
            return "TRAPS";
        }
        if (this.isMibTrap()) {
            return this.mibTrap.getName();
        }
        if (this.isMibTCList()) {
            if (this.mibName == null) {
                return null;
            }
            return "TEXTUAL CONVENTIONS";
        }
        if (this.isMibTC()) {
            return this.mibTC.toString();
        }
        if (this.node != null) {
            return this.node.getLabel();
        }
        if (this.mibName != null) {
            return this.mibName;
        }
        return null;
    }

    public String toString() {
        return this.string();
    }
}

