/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.MibTC;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.ui.NodeData;
import java.applet.Applet;
import java.awt.Font;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class NodeSystemTreeModel
implements TreeModel {
    protected NodeData root;
    boolean globalView = false;
    boolean multipleRoot = false;
    protected Vector listeners;
    protected Hashtable nodeDataHash = new Hashtable();
    MibOperations mibOps;
    Vector mibNameVector;
    private Vector indexNodeVector;
    Applet applet = null;
    private Font italicFont = new Font("Helvetica", 2, 12);
    String[] str = new String[]{"INTEGER", "OCTET STRING", "OBJECT IDENTIFIER", "NetworkAddress", "IpAddress"};
    Vector rNodesCCITT = null;
    Vector rNodesISO = null;

    public NodeSystemTreeModel(NodeData nodeData, Vector vector, MibOperations mibOperations) {
        this.mibOps = mibOperations;
        this.root = nodeData;
        this.applet = this.applet;
        this.listeners = new Vector();
        this.mibNameVector = vector;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null && !this.listeners.contains(treeModelListener)) {
            this.listeners.addElement(treeModelListener);
        }
    }

    public Object getChild(Object object, int n) {
        if (object instanceof NodeData) {
            NodeData nodeData = (NodeData)object;
            if (nodeData.node == null && nodeData.mibName == null) {
                return null;
            }
            if (this.globalView) {
                Object object2;
                Object object3;
                if (nodeData.node == null && nodeData.mibName != null) {
                    if (nodeData.isMibTrapList()) {
                        MibTrap mibTrap;
                        if (nodeData.isMibTrap()) {
                            return null;
                        }
                        NodeData nodeData2 = null;
                        if (!nodeData.childrenVector.isEmpty() && (mibTrap = (MibTrap)nodeData.childrenVector.elementAt(n)) != null) {
                            nodeData2 = new NodeData(this.root.getFont(), this.root.getColor(), null, "trap", false);
                            nodeData2.setMibTrap(mibTrap);
                            nodeData2.setImageIcons();
                        }
                        return nodeData2;
                    }
                    if (nodeData.isMibTCList()) {
                        MibTC mibTC;
                        if (nodeData.isMibTC()) {
                            return null;
                        }
                        NodeData nodeData3 = null;
                        if (!nodeData.childrenVector.isEmpty() && (mibTC = (MibTC)nodeData.childrenVector.elementAt(n)) != null) {
                            nodeData3 = new NodeData(this.root.getFont(), this.root.getColor(), null, "tc", false);
                            nodeData3.setMibTC(mibTC);
                            nodeData3.setImageIcons();
                        }
                        return nodeData3;
                    }
                    if (this.multipleRoot) {
                        if (n == 0) {
                            object3 = null;
                            if (!this.rNodesISO.isEmpty()) {
                                object3 = (MibNode)this.rNodesISO.elementAt(0);
                                int n2 = 1;
                                while (n2 < this.rNodesISO.size()) {
                                    if (((MibNode)object3).isDescendentOf((MibNode)this.rNodesISO.elementAt(n2))) {
                                        object3 = (MibNode)this.rNodesISO.elementAt(n2);
                                    }
                                    ++n2;
                                }
                                NodeData nodeData4 = new NodeData(this.root.getFont(), this.root.getColor(), (MibNode)object3, null, true);
                                nodeData4.isRoot = true;
                                return nodeData4;
                            }
                        } else if (n == 1) {
                            object3 = null;
                            if (!this.rNodesCCITT.isEmpty()) {
                                object3 = (MibNode)this.rNodesCCITT.elementAt(0);
                                int n3 = 1;
                                while (n3 < this.rNodesCCITT.size()) {
                                    if (((MibNode)object3).isDescendentOf((MibNode)this.rNodesCCITT.elementAt(n3))) {
                                        object3 = (MibNode)this.rNodesCCITT.elementAt(n3);
                                    }
                                    ++n3;
                                }
                                NodeData nodeData5 = new NodeData(this.root.getFont(), this.root.getColor(), (MibNode)object3, null, true);
                                nodeData5.isRoot = true;
                                return nodeData5;
                            }
                        } else if (n == 2 || n == 3) {
                            Enumeration enumeration = this.mibOps.getMibModules();
                            while (enumeration.hasMoreElements()) {
                                MibModule mibModule = (MibModule)enumeration.nextElement();
                                if (n == 2) {
                                    if (!mibModule.getDefinedTraps().hasMoreElements()) continue;
                                    return this.getNodeDataForMibTrapList(nodeData.mibName);
                                }
                                if (!mibModule.getDefinedTCs().hasMoreElements()) continue;
                                return this.getNodeDataForMibTCList(nodeData.mibName);
                            }
                            return this.getNodeDataForMibTCList(nodeData.mibName);
                        }
                    } else if (n == 0) {
                        object3 = new Vector();
                        ((Vector)object3).setSize(1000);
                        object2 = new Vector();
                        if (this.mibOps.getMibModule(nodeData.mibName) == null) {
                            Object object4;
                            Enumeration enumeration = this.mibOps.getMibModules();
                            while (enumeration.hasMoreElements()) {
                                object4 = (MibModule)enumeration.nextElement();
                                MibNode mibNode = ((MibModule)object4).getRootNode();
                                if (mibNode == null || ((Vector)(object2 = mibNode.getOIDVector())).size() >= ((Vector)object3).size()) continue;
                                object3 = object2;
                            }
                            object4 = (String)((Vector)object3).elementAt(((Vector)object3).size() - 1);
                            MibNode mibNode = this.mibOps.getMibNode((String)object4);
                            NodeData nodeData6 = new NodeData(this.root.getFont(), this.root.getColor(), mibNode, null, true);
                            nodeData6.isRoot = true;
                            return nodeData6;
                        }
                    } else if (n == 1 || n == 2) {
                        Enumeration enumeration = this.mibOps.getMibModules();
                        while (enumeration.hasMoreElements()) {
                            MibModule mibModule = (MibModule)enumeration.nextElement();
                            if (n == 1) {
                                if (!mibModule.getDefinedTraps().hasMoreElements()) continue;
                                return this.getNodeDataForMibTrapList(nodeData.mibName);
                            }
                            if (!mibModule.getDefinedTCs().hasMoreElements()) continue;
                            return this.getNodeDataForMibTCList(nodeData.mibName);
                        }
                        return this.getNodeDataForMibTCList(nodeData.mibName);
                    }
                }
                if (nodeData.node != null) {
                    if (nodeData.node.isTableEntry()) {
                        object3 = nodeData.node.getChildList();
                        if (n < this.indexNodeVector.size()) {
                            object2 = (MibNode)this.indexNodeVector.elementAt(n);
                            NodeData nodeData7 = new NodeData(this.italicFont, this.root.getColor(), (MibNode)object2, null, false);
                            nodeData7.setExternalIndex(true);
                            nodeData7.setImageIcons();
                            return nodeData7;
                        }
                        object2 = (MibNode)nodeData.childrenVector.elementAt(n - this.indexNodeVector.size());
                        return new NodeData(this.root.getFont(), this.root.getColor(), (MibNode)object2, null, false);
                    }
                    object3 = (MibNode)nodeData.childrenVector.elementAt(n);
                    object2 = new NodeData(this.root.getFont(), this.root.getColor(), (MibNode)object3, null, false);
                    return object2;
                }
            } else {
                Object object5;
                Serializable serializable;
                Serializable serializable2;
                if (nodeData.node == null && nodeData.mibName != null) {
                    if (this.mibOps.getMibModule(nodeData.mibName) == null) {
                        MibModule mibModule = this.mibOps.getMibModule((String)this.mibNameVector.elementAt(n + 1));
                        NodeData nodeData8 = new NodeData(this.root.getFont(), this.root.getColor(), null, mibModule.getName(), false);
                        return nodeData8;
                    }
                    if (nodeData.isMibTrapList()) {
                        return this.getNodeDataForMibTrap(nodeData, n);
                    }
                    if (nodeData.isMibTCList()) {
                        return this.getNodeDataForMibTC(nodeData, n);
                    }
                    if (this.mibOps.getMibModule(nodeData.mibName) != null) {
                        serializable2 = this.mibOps.getMibModule(nodeData.mibName);
                        serializable = ((MibModule)serializable2).getRootNodes();
                        object5 = null;
                        if (n < ((Vector)serializable).size()) {
                            object5 = (MibNode)((Vector)serializable).elementAt(n);
                        }
                        if (((MibModule)serializable2).getRootNode() != null) {
                            object5 = ((MibModule)serializable2).getRootNode();
                            if (n == 0) {
                                NodeData nodeData9 = new NodeData(this.root.getFont(), this.root.getColor(), (MibNode)object5, null, true);
                                nodeData9.isRoot = true;
                                return nodeData9;
                            }
                            boolean bl = false;
                            boolean bl2 = false;
                            bl = ((MibModule)serializable2).getDefinedTraps().hasMoreElements();
                            bl2 = ((MibModule)serializable2).getDefinedTCs().hasMoreElements();
                            if (n == 1 && bl && bl2) {
                                return this.getNodeDataForMibTrapList(nodeData.mibName);
                            }
                            if (n == 2 && bl && bl2) {
                                return this.getNodeDataForMibTCList(nodeData.mibName);
                            }
                            if (bl) {
                                return this.getNodeDataForMibTrapList(nodeData.mibName);
                            }
                            if (bl2) {
                                return this.getNodeDataForMibTCList(nodeData.mibName);
                            }
                        } else if (n >= ((Vector)serializable).size()) {
                            boolean bl = false;
                            boolean bl3 = false;
                            bl = ((MibModule)serializable2).getDefinedTraps().hasMoreElements();
                            bl3 = ((MibModule)serializable2).getDefinedTCs().hasMoreElements();
                            if (n == ((Vector)serializable).size() && bl && bl3) {
                                return this.getNodeDataForMibTrapList(nodeData.mibName);
                            }
                            if (n == ((Vector)serializable).size() + 1 && bl && bl3) {
                                return this.getNodeDataForMibTCList(nodeData.mibName);
                            }
                            if (bl) {
                                return this.getNodeDataForMibTrapList(nodeData.mibName);
                            }
                            if (bl3) {
                                return this.getNodeDataForMibTCList(nodeData.mibName);
                            }
                        } else {
                            NodeData nodeData10 = new NodeData(this.root.getFont(), this.root.getColor(), (MibNode)object5, null, true);
                            nodeData10.isRoot = true;
                            return nodeData10;
                        }
                    }
                }
                if ((object = nodeData.node) == null || ((MibNode)object).getChildList() == null) {
                    return null;
                }
                if (nodeData.node.isTableEntry()) {
                    serializable2 = nodeData.node.getChildList();
                    if (n < this.indexNodeVector.size()) {
                        serializable = (MibNode)this.indexNodeVector.elementAt(n);
                        object5 = new NodeData(this.italicFont, this.root.getColor(), (MibNode)serializable, null, false);
                        ((NodeData)object5).setExternalIndex(true);
                        ((NodeData)object5).setImageIcons();
                        return object5;
                    }
                    MibNode mibNode = (MibNode)((MibNode)object).getChildList().elementAt(n - this.indexNodeVector.size());
                    return new NodeData(this.root.getFont(), this.root.getColor(), mibNode, null, false);
                }
                if (n > ((MibNode)object).getChildList().size()) {
                    return null;
                }
                MibNode mibNode = (MibNode)((MibNode)object).getChildList().elementAt(n);
                return new NodeData(this.root.getFont(), this.root.getColor(), mibNode, null, false);
            }
        }
        return null;
    }

    public int getChildCount(Object object) {
        int n = 0;
        if (this.indexNodeVector == null) {
            this.indexNodeVector = new Vector();
        } else {
            this.indexNodeVector.removeAllElements();
        }
        if (object instanceof NodeData) {
            NodeData nodeData = (NodeData)object;
            if (this.globalView) {
                if (nodeData.node == null && nodeData.mibName != null && nodeData.mibName.startsWith("Loaded MibModules")) {
                    if (nodeData.isMibTrapList()) {
                        int n2 = 0;
                        Enumeration enumeration = this.mibOps.getMibModules();
                        while (enumeration.hasMoreElements()) {
                            MibModule mibModule = (MibModule)enumeration.nextElement();
                            n2 += this.getTrapChildCount(mibModule);
                            Enumeration enumeration2 = mibModule.getDefinedTraps();
                            while (enumeration2.hasMoreElements()) {
                                nodeData.childrenVector.addElement(enumeration2.nextElement());
                            }
                        }
                        return n2;
                    }
                    if (nodeData.isMibTCList()) {
                        int n3 = 0;
                        Enumeration enumeration = this.mibOps.getMibModules();
                        while (enumeration.hasMoreElements()) {
                            MibModule mibModule = (MibModule)enumeration.nextElement();
                            n3 += this.getTCChildCount(mibModule);
                            Enumeration enumeration3 = mibModule.getDefinedTCs();
                            while (enumeration3.hasMoreElements()) {
                                nodeData.childrenVector.addElement(enumeration3.nextElement());
                            }
                        }
                        return n3;
                    }
                    int n4 = 1;
                    boolean bl = false;
                    boolean bl2 = false;
                    this.mibNameVector = new Vector();
                    this.mibNameVector.addElement("Loaded Mibs");
                    this.rNodesISO = new Vector();
                    this.rNodesCCITT = new Vector();
                    this.multipleRoot = false;
                    Enumeration enumeration = this.mibOps.getMibModules();
                    while (enumeration.hasMoreElements()) {
                        MibModule mibModule = (MibModule)enumeration.nextElement();
                        this.mibNameVector.addElement(mibModule.getName());
                        ++n;
                        MibNode mibNode = mibModule.getRootNode();
                        if (mibNode == null) {
                            Vector vector = mibModule.getRootNodes();
                            Enumeration enumeration4 = vector.elements();
                            while (enumeration4.hasMoreElements()) {
                                MibNode mibNode2 = (MibNode)enumeration4.nextElement();
                                if (mibNode2.getNumberedOIDString().startsWith(".0")) {
                                    this.rNodesCCITT.addElement(mibNode2);
                                    continue;
                                }
                                this.rNodesISO.addElement(mibNode2);
                            }
                            if (!vector.isEmpty()) {
                                this.multipleRoot = true;
                                n4 = 2;
                            }
                        } else {
                            if (mibNode.getNumberedOIDString().startsWith(".0")) {
                                this.rNodesCCITT.addElement(mibNode);
                            } else {
                                this.rNodesISO.addElement(mibNode);
                            }
                            if (!this.rNodesISO.isEmpty() && !this.rNodesCCITT.isEmpty()) {
                                this.multipleRoot = true;
                                n4 = 2;
                            }
                        }
                        if (mibModule.getDefinedTraps().hasMoreElements()) {
                            bl = true;
                        }
                        if (!mibModule.getDefinedTCs().hasMoreElements()) continue;
                        bl2 = true;
                    }
                    if (bl) {
                        ++n4;
                    }
                    if (bl2) {
                        ++n4;
                    }
                    return n4;
                }
                if (nodeData.node != null) {
                    int n5;
                    int n6;
                    Object object2;
                    Object object3;
                    Enumeration enumeration = this.mibOps.getMibModules();
                    while (enumeration.hasMoreElements()) {
                        MibModule mibModule = (MibModule)enumeration.nextElement();
                        object3 = null;
                        object3 = mibModule.getMibNode(nodeData.node.getOID());
                        if (object3 == null) continue;
                        int n7 = 0;
                        while (n7 < ((MibNode)object3).getChildList().size()) {
                            if (!nodeData.oidVector.contains(((MibNode)((MibNode)object3).getChildList().elementAt(n7)).getOIDString())) {
                                object2 = ((MibNode)((MibNode)object3).getChildList().elementAt(n7)).getOID();
                                boolean bl = false;
                                n6 = ((Object)object2).length - 1;
                                n5 = 0;
                                while (n5 < nodeData.childrenVector.size()) {
                                    int[] nArray = ((MibNode)nodeData.childrenVector.elementAt(n5)).getOID();
                                    bl = false;
                                    if (object2[n6] < nArray[n6]) {
                                        bl = true;
                                        nodeData.childrenVector.insertElementAt(((MibNode)object3).getChildList().elementAt(n7), n5);
                                        nodeData.oidVector.insertElementAt(((MibNode)((MibNode)object3).getChildList().elementAt(n7)).getOIDString(), n5);
                                        break;
                                    }
                                    ++n5;
                                }
                                if (!bl) {
                                    nodeData.childrenVector.addElement(((MibNode)object3).getChildList().elementAt(n7));
                                    nodeData.oidVector.addElement(((MibNode)((MibNode)object3).getChildList().elementAt(n7)).getOIDString());
                                }
                            }
                            ++n7;
                        }
                    }
                    if (nodeData.node.isTableEntry()) {
                        int n8 = nodeData.childrenVector.size();
                        object3 = nodeData.node.getIndexNames().elements();
                        while (object3.hasMoreElements()) {
                            String string = (String)object3.nextElement();
                            object2 = this.mibOps.getMibNode(string);
                            if (object2 == null) {
                                boolean bl = false;
                                n6 = 0;
                                while (n6 < 5) {
                                    if (string.equals(this.str[n6])) {
                                        bl = true;
                                        break;
                                    }
                                    ++n6;
                                }
                                if (bl) continue;
                            }
                            String string2 = "";
                            if (object2 != null) {
                                string2 = ((MibNode)object2).getLabel();
                            }
                            n6 = nodeData.childrenVector.size();
                            n5 = 0;
                            while (n5 < n6) {
                                if (((MibNode)nodeData.childrenVector.elementAt(n5)).getLabel().equals(string2)) break;
                                ++n5;
                            }
                            if (n5 != n6 || string2.equals("")) continue;
                            this.indexNodeVector.addElement(object2);
                            ++n8;
                        }
                        return n8;
                    }
                    return nodeData.childrenVector.size();
                }
            } else if (nodeData.node == null && nodeData.mibName != null) {
                if (this.mibOps.getMibModule(nodeData.mibName) == null) {
                    this.mibNameVector = new Vector();
                    this.mibNameVector.addElement("Loaded Mibs");
                    Enumeration enumeration = this.mibOps.getMibModules();
                    while (enumeration.hasMoreElements()) {
                        MibModule mibModule = (MibModule)enumeration.nextElement();
                        this.mibNameVector.addElement(mibModule.getName());
                        ++n;
                    }
                    return n;
                }
                if (nodeData.isMibTrapList()) {
                    return this.getTrapChildCount(this.mibOps.getMibModule(nodeData.mibName));
                }
                if (nodeData.isMibTCList()) {
                    return this.getTCChildCount(this.mibOps.getMibModule(nodeData.mibName));
                }
                if (this.mibOps.getMibModule(nodeData.mibName) != null) {
                    MibModule mibModule = this.mibOps.getMibModule(nodeData.mibName);
                    int n9 = 0;
                    if (mibModule.getRootNode() != null) {
                        n9 = 1;
                    } else {
                        Vector vector = mibModule.getRootNodes();
                        n9 = vector.size();
                    }
                    if (this.mibOps.getMibModule(nodeData.mibName).getDefinedTraps().hasMoreElements()) {
                        ++n9;
                    }
                    if (this.mibOps.getMibModule(nodeData.mibName).getDefinedTCs().hasMoreElements()) {
                        ++n9;
                    }
                    return n9;
                }
            } else {
                object = nodeData.node;
                if (object == null || ((MibNode)object).getChildList() == null) {
                    return 0;
                }
                if (nodeData.node.isTableEntry()) {
                    Vector vector = nodeData.node.getChildList();
                    int n10 = vector.size();
                    Enumeration enumeration = nodeData.node.getIndexNames().elements();
                    while (enumeration.hasMoreElements()) {
                        int n11;
                        String string = (String)enumeration.nextElement();
                        MibNode mibNode = this.mibOps.getMibNode(string);
                        if (mibNode == null) {
                            boolean bl = false;
                            n11 = 0;
                            while (n11 < 5) {
                                if (string.equals(this.str[n11])) {
                                    bl = true;
                                    break;
                                }
                                ++n11;
                            }
                            if (bl) continue;
                        }
                        String string3 = "";
                        if (mibNode != null) {
                            string3 = mibNode.getLabel();
                        }
                        n11 = vector.size();
                        int n12 = 0;
                        while (n12 < n11) {
                            if (((MibNode)vector.elementAt(n12)).getLabel().equals(string3)) break;
                            ++n12;
                        }
                        if (n12 != n11 || string3.equals("")) continue;
                        this.indexNodeVector.addElement(mibNode);
                        ++n10;
                    }
                    vector = null;
                    return n10;
                }
                return nodeData.node.getChildList().size();
            }
            if (nodeData.getChildList(this.mibOps) == null) {
                return 0;
            }
            return nodeData.getChildList(this.mibOps).size();
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        int n = -1;
        if (object instanceof NodeData) {
            NodeData nodeData = (NodeData)object;
            object = nodeData.node;
        }
        if (object2 instanceof NodeData) {
            object2 = ((NodeData)object2).node;
        }
        if (object == null || ((MibNode)object).getChildList() == null || object2 == null) {
            return -1;
        }
        if (((MibNode)object).getChildList() == null) {
            return -1;
        }
        if (object2 == null) {
            return -1;
        }
        return ((MibNode)object).getChildList().indexOf(object2);
    }

    private MibTC getMibTCAt(MibModule mibModule, int n) {
        if (mibModule == null) {
            return null;
        }
        int n2 = 0;
        Enumeration enumeration = mibModule.getDefinedTCs();
        while (enumeration.hasMoreElements()) {
            MibTC mibTC = (MibTC)enumeration.nextElement();
            if (n == n2) {
                return mibTC;
            }
            ++n2;
        }
        return null;
    }

    private MibTrap getMibTrapAt(MibModule mibModule, int n) {
        if (mibModule == null) {
            return null;
        }
        int n2 = 0;
        Enumeration enumeration = mibModule.getDefinedTraps();
        while (enumeration.hasMoreElements()) {
            MibTrap mibTrap = (MibTrap)enumeration.nextElement();
            if (n == n2) {
                return mibTrap;
            }
            ++n2;
        }
        return null;
    }

    private NodeData getNodeDataForMibTC(NodeData nodeData, int n) {
        if (!this.mibNameVector.contains(nodeData.mibName)) {
            return null;
        }
        MibModule mibModule = this.mibOps.getMibModule(nodeData.mibName);
        MibTC mibTC = this.getMibTCAt(mibModule, n);
        NodeData nodeData2 = null;
        if (mibTC != null && (nodeData2 = (NodeData)this.nodeDataHash.get(mibTC)) == null) {
            nodeData2 = new NodeData(this.root.getFont(), this.root.getColor(), null, mibModule.getName(), false);
            nodeData2.setMibTC(mibTC);
            nodeData2.setImageIcons();
            this.nodeDataHash.put(mibTC, nodeData2);
        }
        return nodeData2;
    }

    private NodeData getNodeDataForMibTCList(String string) {
        String string2 = string;
        NodeData nodeData = (NodeData)this.nodeDataHash.get(string2 = String.valueOf(string2) + "TC");
        if (nodeData == null) {
            nodeData = new NodeData(this.root.getFont(), this.root.getColor(), null, string, false);
            nodeData.setMibTCList(true);
            nodeData.setImageIcons();
            this.nodeDataHash.put(string2, nodeData);
        }
        return nodeData;
    }

    private NodeData getNodeDataForMibTrap(NodeData nodeData, int n) {
        if (!this.mibNameVector.contains(nodeData.mibName)) {
            return null;
        }
        MibModule mibModule = this.mibOps.getMibModule(nodeData.mibName);
        MibTrap mibTrap = this.getMibTrapAt(mibModule, n);
        NodeData nodeData2 = null;
        if (mibTrap != null && (nodeData2 = (NodeData)this.nodeDataHash.get(mibTrap)) == null) {
            nodeData2 = new NodeData(this.root.getFont(), this.root.getColor(), null, mibModule.getName(), false);
            nodeData2.setMibTrap(mibTrap);
            nodeData2.setImageIcons();
            this.nodeDataHash.put(mibTrap, nodeData2);
        }
        return nodeData2;
    }

    private NodeData getNodeDataForMibTrapList(String string) {
        String string2 = string;
        NodeData nodeData = (NodeData)this.nodeDataHash.get(string2 = String.valueOf(string2) + "TRAP");
        if (nodeData == null) {
            nodeData = new NodeData(this.root.getFont(), this.root.getColor(), null, string, false);
            nodeData.setMibTrapList(true);
            nodeData.setImageIcons();
            this.nodeDataHash.put(string2, nodeData);
        }
        return nodeData;
    }

    public Object getRoot() {
        return this.root;
    }

    private int getTCChildCount(MibModule mibModule) {
        if (mibModule == null) {
            return 0;
        }
        if (!mibModule.getDefinedTCs().hasMoreElements()) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = mibModule.getDefinedTCs();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    private int getTrapChildCount(MibModule mibModule) {
        if (mibModule == null) {
            return 0;
        }
        if (!mibModule.getDefinedTraps().hasMoreElements()) {
            return 0;
        }
        int n = 0;
        Enumeration enumeration = mibModule.getDefinedTraps();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        return n;
    }

    public boolean isLeaf(Object object) {
        boolean bl = false;
        if (object instanceof NodeData) {
            MibNode mibNode = ((NodeData)object).node;
            if (((NodeData)object).isMibTrap()) {
                return true;
            }
            if (((NodeData)object).isMibTC()) {
                return true;
            }
            if (mibNode == null && ((NodeData)object).mibName != null) {
                return bl;
            }
            if (mibNode == null || mibNode.getChildList() == null) {
                return true;
            }
            if (!this.globalView) {
                if (mibNode.getChildList().size() == 0) {
                    bl = true;
                }
            } else {
                boolean bl2 = false;
                Enumeration enumeration = this.mibOps.getMibModules();
                while (enumeration.hasMoreElements()) {
                    MibModule mibModule = (MibModule)enumeration.nextElement();
                    MibNode mibNode2 = mibModule.getMibNode(mibNode.getOID());
                    if (mibNode2 == null) continue;
                    if (mibNode2.getChildList().isEmpty()) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    break;
                }
                return bl2;
            }
        }
        return bl;
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.removeElement(treeModelListener);
    }

    public void setView(boolean bl) {
        this.globalView = bl;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }
}

