/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.DieInterface;
import com.adventnet.snmp.ui.PropertyCombinerEvent;
import com.adventnet.snmp.ui.PropertyCombinerListener;
import java.util.Hashtable;
import java.util.Vector;

public class PropertyCombiner
implements DieInterface {
    private String group = "";
    private String oldgroup = "";
    private static Hashtable groupTable = new Hashtable();
    private Vector ListenerList = new Vector(1, 1);

    public void addPropertyCombinerListener(PropertyCombinerListener propertyCombinerListener) {
        this.ListenerList.addElement(propertyCombinerListener);
    }

    protected void finalize() {
        if (groupTable.get(this.group) != null) {
            Vector vector = (Vector)groupTable.get(this.group);
            vector.removeElement(this);
        }
        this.ListenerList.removeAllElements();
        this.ListenerList = null;
    }

    public String getGroup() {
        if (this.group == "") {
            System.err.println("Error : No group set previously");
            return null;
        }
        return this.group;
    }

    private void invokePropertyCombinerEvent(PropertyCombiner propertyCombiner, Object object) {
        Vector vector = (Vector)propertyCombiner.ListenerList.clone();
        int n = 0;
        while (n < vector.size()) {
            PropertyCombinerListener propertyCombinerListener = (PropertyCombinerListener)vector.elementAt(n);
            propertyCombinerListener.objectPassed(new PropertyCombinerEvent(propertyCombiner, object));
            ++n;
        }
    }

    public void passObject(Object object) {
        if (groupTable.get(this.group) == null) {
            this.passToMembers(null, object);
        } else {
            Vector vector = (Vector)groupTable.get(this.group);
            Vector vector2 = (Vector)vector.clone();
            this.passToMembers(vector2, object);
        }
    }

    private void passToMembers(Vector vector, Object object) {
        if (vector == null) {
            this.invokePropertyCombinerEvent(this, object);
        } else {
            int n = 0;
            while (n < vector.size()) {
                this.invokePropertyCombinerEvent((PropertyCombiner)vector.elementAt(n), object);
                ++n;
            }
        }
    }

    public void prepareToDie() {
        if (groupTable.get(this.group) != null) {
            Vector vector = (Vector)groupTable.get(this.group);
            vector.removeElement(this);
        }
        this.ListenerList.removeAllElements();
        this.ListenerList = null;
    }

    public void removePropertyCombinerListener(PropertyCombinerListener propertyCombinerListener) {
        if (!this.ListenerList.contains(propertyCombinerListener)) {
            System.out.println("Error :No such Listener available");
        }
        this.ListenerList.removeElement(propertyCombinerListener);
    }

    public void setGroup(String string) {
        Vector vector;
        this.group = string;
        if (groupTable.get(this.oldgroup) != null && (vector = (Vector)groupTable.get(this.oldgroup)) != null) {
            vector.removeElement(this);
        }
        if (groupTable.get(this.group) == null) {
            vector = new Vector(1, 1);
            vector.addElement(this);
            groupTable.put(this.group, vector);
        } else {
            vector = (Vector)groupTable.get(this.group);
            vector.addElement(this);
        }
        this.oldgroup = this.group;
    }
}

