/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.ui.SasFileDialog;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUtils;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SasClientFunction {
    SasFileDialog sasBrowser = null;
    SASClient sasClient;
    String PrevDir = null;
    JFrame fra = new JFrame(SnmpUtils.getString("Choose the file you want to save in the Webserver"));
    static int LIST_DIR_REQ = 1;
    static int LIST_DIR_RESP = 2;
    static int GET_FILE_REQ = 3;
    static int GET_FILE_RESP = 4;
    String prevItem = "/";
    boolean state = false;

    public SasClientFunction(SasFileDialog sasFileDialog) {
        this.sasBrowser = sasFileDialog;
        try {
            this.sasClient = SnmpAPI.getSASClient();
            if (this.sasClient == null) {
                this.sasClient = new SASClient(this.sasBrowser.applet, false);
                this.sasClient.start();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.sasBrowser, String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
        }
    }

    void appendFile() {
        FileDialog fileDialog = new FileDialog((Frame)this.fra, SnmpUtils.getString("Save File"), 1);
        Utils.centerWindow(fileDialog);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(string) + string2);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[fileInputStream.available()];
            dataInputStream.readFully(byArray);
            if (this.sasClient != null) {
                this.sasClient.appendFile(string2, byArray);
            } else {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Not connected to SAS server"));
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    void createDir(String string) {
        try {
            if (this.sasClient == null) {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Not connected to SAS server"));
                return;
            }
            this.sasClient.createDir(string);
            this.listFiles(this.sasBrowser.DirectoryBox.getSelectedItem().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void deleteDir() {
        String string = this.sasBrowser.DirList.getSelectedValue().toString();
        try {
            if (this.sasClient == null) {
                JOptionPane.showMessageDialog(this.sasBrowser, "Not connected to SAS server");
                return;
            }
            this.sasClient.deleteDir(string);
            this.listFiles(this.sasBrowser.DirectoryBox.getSelectedItem().toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void deleteFile() {
    }

    void downTree(String string) {
        String string2;
        if (string == null) {
            return;
        }
        if (string.equals(".." + File.separator)) {
            string2 = new String("/");
            int n = 0;
            while (n < this.sasBrowser.DirectoryBox.getItemCount()) {
                string2 = String.valueOf(string2) + this.sasBrowser.DirectoryBox.getItemAt(n).toString() + "/";
                ++n;
            }
            string2 = this.sasBrowser.getPrevDir(string2);
        } else {
            string2 = new String("/");
            int n = 0;
            while (n < this.sasBrowser.DirectoryBox.getItemCount()) {
                string2 = String.valueOf(string2) + this.sasBrowser.DirectoryBox.getItemAt(n).toString() + "/";
                ++n;
            }
            string2 = String.valueOf(string2) + "/" + string;
        }
        if (string2.equals("")) {
            string2 = String.valueOf(string2) + "/";
        }
        this.listFiles(string2);
    }

    void getFile() {
        String string = new String(String.valueOf(this.sasBrowser.DirectoryBox.getSelectedItem().toString()) + File.separator + this.sasBrowser.childList.getSelectedValue());
        byte[] byArray = null;
        String string2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(GET_FILE_REQ);
            dataOutputStream.writeUTF(string);
            byArray = byteArrayOutputStream.toByteArray();
            if (this.sasClient == null || !SASClient.isFileReadWrite()) {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Not connected to SAS server"));
                return;
            }
            byArray = this.sasClient.clientCall(byArray);
            if (byArray == null) {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Cannot get Remote Files"));
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            if (n != GET_FILE_RESP) {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Not able to get the file"));
                return;
            }
            string2 = dataInputStream.readUTF();
            FileOutputStream fileOutputStream = new FileOutputStream(this.sasBrowser.childList.getSelectedValue().toString());
            dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.writeBytes(string2);
            this.println("Successfully got the file");
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    void listFiles(String string) {
        Object object;
        byte[] byArray = null;
        String string2 = null;
        int n = string.indexOf("|");
        String string3 = n > 0 ? string.substring(n + 1) : string;
        try {
            object = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
            dataOutputStream.writeInt(LIST_DIR_REQ);
            dataOutputStream.writeUTF(string3);
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            if (this.sasClient == null || !SASClient.isFileReadWrite()) {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Not connected to SAS server"));
                return;
            }
            byArray = this.sasClient.clientCall(byArray);
            if (byArray == null) {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Cannot List Remote Files"));
                return;
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n2 = dataInputStream.readInt();
            if (n2 == LIST_DIR_RESP) {
                string2 = dataInputStream.readUTF();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        if (string2 != null) {
            object = new StringTokenizer(string2, "\n");
            int n3 = ((DefaultListModel)this.sasBrowser.childList.getModel()).getSize();
            if (n3 > 0) {
                ((DefaultListModel)this.sasBrowser.childList.getModel()).removeRange(0, n3 - 1);
                this.sasBrowser.childList.updateUI();
            }
            if ((n3 = ((DefaultListModel)this.sasBrowser.DirList.getModel()).getSize()) > 0) {
                ((DefaultListModel)this.sasBrowser.DirList.getModel()).removeRange(0, n3 - 1);
                this.sasBrowser.DirList.updateUI();
            }
            boolean bl = false;
            if (string.length() == 4 && string.indexOf("|/") > 0) {
                bl = true;
            }
            if (!(string.equals("/") || string.equals("\\") || bl)) {
                ((DefaultListModel)this.sasBrowser.DirList.getModel()).addElement(".." + File.separator);
                this.sasBrowser.DirList.updateUI();
            }
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4 = ((StringTokenizer)object).nextToken();
                if (string4.indexOf("<DIR>") < 0) {
                    if (!string4.endsWith(this.sasBrowser.fileExt)) continue;
                    ((DefaultListModel)this.sasBrowser.childList.getModel()).addElement(string4);
                    continue;
                }
                string4 = string4.substring(5);
                ((DefaultListModel)this.sasBrowser.DirList.getModel()).addElement(string4);
            }
        } else {
            JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Cannot List Remote Files"));
            return;
        }
        this.sasBrowser.childList.updateUI();
        this.sasBrowser.DirList.updateUI();
        this.updateDir(string);
        this.PrevDir = string;
    }

    void listFilesOnly(String string) {
        String string2 = new String("/");
        if (this.sasBrowser.DirectoryBox.getItemCount() == 1) {
            this.sasBrowser.setDirectory("/");
        }
        int n = 0;
        while (n < this.sasBrowser.DirectoryBox.getSelectedIndex()) {
            string2 = String.valueOf(string2) + this.sasBrowser.DirectoryBox.getItemAt(n).toString() + "/";
            ++n;
        }
        string2 = String.valueOf(string2) + "/" + string;
        this.listFiles(string2);
        this.state = true;
    }

    void println(String string) {
    }

    void saveFile() {
        FileDialog fileDialog = new FileDialog((Frame)this.fra, SnmpUtils.getString("Save File"), 1);
        Utils.centerWindow(fileDialog);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        byte[] byArray = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(string) + string2);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[fileInputStream.available()];
            dataInputStream.readFully(byArray);
            if (this.sasClient != null) {
                this.sasClient.saveFile(string2, byArray);
            } else {
                JOptionPane.showMessageDialog(this.sasBrowser, SnmpUtils.getString("Not connected to SAS server"));
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    void updateDir(String string) {
        int n = this.sasBrowser.DirectoryBox.getItemCount();
        if (n != 0 && string != null) {
            this.state = false;
            this.sasBrowser.DirectoryBox.removeAllItems();
        }
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n2 = stringTokenizer.countTokens();
        this.sasBrowser.DirectoryBox.addItem("/");
        int n3 = 0;
        while (n3 < n2) {
            string2 = (String)stringTokenizer.nextElement();
            this.sasBrowser.DirectoryBox.addItem(string2);
            ++n3;
        }
        this.state = false;
        this.prevItem = string2;
        this.sasBrowser.DirectoryBox.setSelectedItem(string2);
        this.state = true;
    }
}

