/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.beans.SnmpTable;
import com.adventnet.snmp.beans.SnmpTableEvent;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.ui.BaseColumnClass;
import java.applet.Applet;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class SnmpTableModel
extends SnmpTable
implements TableModel {
    boolean endoftable = false;
    Class[] columnClass = null;
    Vector tableModelListeners = new Vector();
    static /* synthetic */ Class class$java$lang$String;

    public SnmpTableModel() {
    }

    public SnmpTableModel(Applet applet) {
        super(applet);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListeners.addElement(tableModelListener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void genTableEvent(SnmpTableEvent snmpTableEvent) {
        int n;
        super.genTableEvent(snmpTableEvent);
        Object var2_2 = null;
        if (snmpTableEvent.isEndOfTable()) {
            this.endoftable = true;
        }
        if (this.tableModelListeners.size() == 0) {
            return;
        }
        int n2 = snmpTableEvent.getColumn();
        if (n2 == -1) {
            n2 = -1;
        }
        if ((n = snmpTableEvent.getType()) == 1) {
            n = 1;
        } else if (n == 3) {
            n = 0;
        } else if (n == 2) {
            n = -1;
        }
        TableModelEvent tableModelEvent = new TableModelEvent(this, snmpTableEvent.getFirstRow(), snmpTableEvent.getLastRow(), n2, n);
        Enumeration enumeration = this.tableModelListeners.elements();
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public Class getColumnClass(int n) {
        try {
            if (this.columnClass == null || this.columnClass[n] == null) {
                return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SnmpTableModel.class$("java.lang.String"));
            }
            return this.columnClass[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isEndOfTable() {
        return this.endoftable;
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.tableModelListeners.removeElement(tableModelListener);
    }

    public void setObjectIDList(String[] stringArray) {
        super.setObjectIDList(stringArray);
        this.columnClass = new Class[stringArray.length];
        MibOperations mibOperations = super.getMibOperations();
        int n = 0;
        while (n < stringArray.length) {
            MibNode mibNode = null;
            mibNode = stringArray[n].indexOf(".") != -1 ? mibOperations.getMibNode(stringArray[n].substring(stringArray[n].lastIndexOf(".") + 1)) : mibOperations.getMibNode(stringArray[n]);
            if (mibNode != null) {
                this.columnClass[n] = BaseColumnClass.getColumnClass(mibNode.getSyntax());
            }
            ++n;
        }
    }

    public void setTableOID(String string) throws DataException {
        super.setTableOID(string);
        this.columnClass = new Class[this.getColumnCount()];
        int n = 0;
        while (n < this.getColumnCount()) {
            MibNode mibNode = this.getColumnMibNode(n);
            if (mibNode != null) {
                this.columnClass[n] = BaseColumnClass.getColumnClass(mibNode.getSyntax());
            }
            ++n;
        }
    }

    public void startPolling() {
        if (this.getPollInterval() > 0) {
            super.setPollInterval(this.getPollInterval());
        } else {
            super.setPollInterval(5);
        }
    }

    public void stopPolling() {
        super.setPollInterval(0);
    }
}

