/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.DataException;
import com.adventnet.snmp.beans.SnmpTable;
import com.adventnet.snmp.mibs.MibException;
import com.adventnet.snmp.ui.DefaultSnmpTablePanelModel;
import com.adventnet.snmp.ui.SnmpTablePanelModel;
import com.adventnet.snmp.ui.SnmpTablePanelUI;
import com.adventnet.utils.Output;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JPanel;

public class SnmpTablePanel
extends JPanel {
    SnmpTablePanelUI tablebeanui = null;
    SnmpTablePanelModel tablebeanmodel = null;
    Applet applet = null;
    boolean isDefaultTableModel = false;

    public SnmpTablePanel() {
        this.init(null);
        this.tablebeanmodel = new DefaultSnmpTablePanelModel();
        this.tablebeanmodel.setSnmpTablePanel(this);
    }

    public SnmpTablePanel(Applet applet) {
        this.applet = applet;
        this.init(applet);
        this.tablebeanmodel = new DefaultSnmpTablePanelModel(applet);
        this.tablebeanmodel.setSnmpTablePanel(this);
    }

    public String getCharacterEncoding() {
        return this.tablebeanmodel.getCharacterEncoding();
    }

    public String[] getColumnNames() {
        if (this.tablebeanmodel != null) {
            int n = this.tablebeanmodel.getTotalColumnCount() > 5 ? this.tablebeanmodel.getColumnCount() : this.tablebeanmodel.getTotalColumnCount();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = this.tablebeanmodel.getColumnName(n2);
                ++n2;
            }
            return stringArray;
        }
        String[] stringArray = new String[]{""};
        return stringArray;
    }

    public String getCommunity() {
        if (this.tablebeanmodel != null) {
            return this.tablebeanmodel.getCommunity();
        }
        return "";
    }

    public String getMibModules() {
        if (this.tablebeanmodel == null) {
            return "";
        }
        return this.tablebeanmodel.getMibModules();
    }

    public SnmpTablePanelModel getModel() {
        if (this.tablebeanmodel == null) {
            return null;
        }
        return this.tablebeanmodel;
    }

    public String[] getObjectIDList() {
        return this.tablebeanmodel.getObjectIDList();
    }

    public boolean getOverwriteCMI() {
        if (this.tablebeanmodel == null) {
            return false;
        }
        return this.tablebeanmodel.getOverwriteCMI();
    }

    public int getRetries() {
        if (this.tablebeanmodel == null) {
            return 0;
        }
        return this.tablebeanmodel.getRetries();
    }

    public String getSerializedMibFileName() {
        if (this.tablebeanmodel == null) {
            return "";
        }
        return this.tablebeanmodel.getSerializedMibFileName();
    }

    public SnmpTable getSnmpTable() {
        if (this.tablebeanmodel == null) {
            return null;
        }
        return this.tablebeanmodel.getSnmpTable();
    }

    public String getTableOID() {
        if (this.tablebeanmodel == null) {
            return "";
        }
        return this.tablebeanmodel.getTableOID();
    }

    public int getTableViewColumnCount() {
        if (this.tablebeanmodel == null) {
            return 0;
        }
        return this.tablebeanmodel.getTableViewColumnCount();
    }

    public int getTableViewRowCount() {
        if (this.tablebeanmodel == null) {
            return 0;
        }
        return this.tablebeanmodel.getTableViewRowCount();
    }

    public String getTargetHost() {
        if (this.tablebeanmodel == null) {
            return "";
        }
        return this.tablebeanmodel.getTargetHost();
    }

    public int getTargetPort() {
        if (this.tablebeanmodel == null) {
            return 0;
        }
        return this.tablebeanmodel.getTargetPort();
    }

    public int getTimeout() {
        if (this.tablebeanmodel == null) {
            return 5;
        }
        return this.tablebeanmodel.getTimeout();
    }

    public String getWriteCommunity() {
        if (this.tablebeanmodel == null) {
            return "";
        }
        return this.tablebeanmodel.getWriteCommunity();
    }

    private void init(Applet applet) {
        this.tablebeanui = new SnmpTablePanelUI();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.tablebeanui, gridBagConstraints);
        this.add(this.tablebeanui);
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) {
        try {
            this.tablebeanmodel.initJdbcParams(string, string2, string3, string4);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception);
        }
    }

    public boolean isCustomPanel() {
        return this.tablebeanui.isCustomPanel();
    }

    boolean isDefaultTableModel() {
        return this.isDefaultTableModel;
    }

    public boolean isLoadFromCompiledMibs() {
        if (this.tablebeanmodel == null) {
            return false;
        }
        return this.tablebeanmodel.isLoadFromCompiledMibs();
    }

    public boolean isLoadFromSerializedMibs() {
        if (this.tablebeanmodel == null) {
            return false;
        }
        return this.tablebeanmodel.isLoadFromSerializedMibs();
    }

    public boolean isLoadMibsFromDatabase() {
        return this.tablebeanmodel.isLoadMibsFromDatabase();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.tablebeanmodel.isOverwriteMibsInDatabase();
    }

    public boolean isReadDesc() {
        if (this.tablebeanmodel == null) {
            return false;
        }
        return this.tablebeanmodel.isReadDesc();
    }

    public boolean isSerializeMibs() {
        if (this.tablebeanmodel == null) {
            return false;
        }
        return this.tablebeanmodel.isSerializeMibs();
    }

    public void loadMibs(String string) throws MibException, IOException, FileNotFoundException {
        if (this.tablebeanmodel == null) {
            return;
        }
        try {
            this.tablebeanmodel.loadMibs(string);
        }
        catch (Exception exception) {
            Output.put(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception.toString());
        }
    }

    public void removeAll() {
        this.tablebeanui.stopPoll();
        this.tablebeanmodel.stopCurrentThread(true);
        Object object = new Object();
        this.tablebeanui.actionPerformed(new ActionEvent(object, 0, "Exit All"));
        this.tablebeanui.removeAll();
        this.tablebeanui = null;
        this.tablebeanmodel = null;
        super.removeAll();
    }

    public void setCharacterEncoding(String string) {
        this.tablebeanmodel.setCharacterEncoding(string);
    }

    public void setColumnNames(String[] stringArray) {
        if (this.tablebeanmodel != null && stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.tablebeanmodel.setColumnNameAt(stringArray[n], n);
                ++n;
            }
            this.tablebeanui.setModel1(this.tablebeanmodel);
        }
    }

    public void setCommunity(String string) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setCommunity(string);
    }

    public void setCustomPanel(boolean bl) {
        this.tablebeanui.setCustomPanel(bl);
        this.stpUpdate();
    }

    public void setDebug(boolean bl) {
        this.tablebeanmodel.setDebug(bl);
    }

    void setDefaultTableModel(boolean bl) {
        if (!bl) {
            this.tablebeanmodel = this.applet == null ? new DefaultSnmpTablePanelModel() : new DefaultSnmpTablePanelModel(this.applet);
        }
        this.isDefaultTableModel = true;
    }

    public void setLoadFromCompiledMibs(boolean bl) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setLoadFromCompiledMibs(bl);
    }

    public void setLoadFromSerializedMibs(boolean bl) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setLoadFromSerializedMibs(bl);
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.tablebeanmodel.setLoadMibsFromDatabase(bl);
    }

    public void setMibModules(String string) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setMibModules(string);
    }

    public void setObjectIDList(String[] stringArray) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setObjectIDList(stringArray);
        this.tablebeanui.setModel(this.tablebeanmodel);
        this.tablebeanmodel.setupCellEditor(this.tablebeanui.table);
    }

    public void setOverwriteCMI(boolean bl) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setOverwriteCMI(bl);
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.tablebeanmodel.setOverwriteMibsInDatabase(bl);
    }

    public void setReadDesc(boolean bl) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setReadDesc(bl);
    }

    public void setRetries(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Retries Value cannot be negative"));
            return;
        }
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setRetries(n);
    }

    public void setSerializeMibs(boolean bl) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setSerializeMibs(bl);
    }

    public void setSerializedMibFileName(String string) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setSerializedMibFileName(string);
    }

    void setTableModel(SnmpTablePanelModel snmpTablePanelModel) {
        this.tablebeanmodel = snmpTablePanelModel;
        this.isDefaultTableModel = false;
    }

    public void setTableOID(String string) throws DataException {
        if (this.tablebeanmodel == null) {
            return;
        }
        try {
            this.tablebeanmodel.setTableOID(string);
            this.tablebeanui.setModel(this.tablebeanmodel);
            this.tablebeanmodel.setupCellEditor(this.tablebeanui.table);
        }
        catch (DataException dataException) {
            throw new DataException(dataException.toString());
        }
    }

    public void setTableViewColumnCount(int n) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setTableViewColumnCount(n);
        this.tablebeanui.setModel1(this.tablebeanmodel);
    }

    public void setTableViewRowCount(int n) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanui.setTableViewRowCount(n);
        this.tablebeanmodel.setTableViewRowCount(n);
    }

    public void setTargetHost(String string) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setTargetHost(string);
        this.tablebeanui.hostBox.setText(string);
    }

    public void setTargetPort(int n) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setTargetPort(n);
    }

    public void setTimeout(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Timeout Value cannot be negative"));
            return;
        }
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setTimeout(n);
    }

    public void setWriteCommunity(String string) {
        if (this.tablebeanmodel == null) {
            return;
        }
        this.tablebeanmodel.setWriteCommunity(string);
    }

    public void startPoll() {
        this.tablebeanui.startPoll();
    }

    public void stopPoll() {
        this.tablebeanui.stopPoll();
    }

    private void stpUpdate() {
        this.tablebeanmodel.prepareEntries();
        this.tablebeanui.setModel(this.tablebeanmodel);
        this.tablebeanmodel.setupCellEditor(this.tablebeanui.table);
    }
}

