/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ResultEvent;
import com.adventnet.snmp.beans.ResultListener;
import com.adventnet.snmp.beans.SnmpRequestServer;
import com.adventnet.snmp.beans.SnmpTarget;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.snmp.ui.MibBrowser;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;

class SnmpTasks
extends SnmpRequestServer
implements ResultListener,
ItemListener {
    String oidString = " ";
    boolean multiVar = false;
    boolean appletexist = false;
    boolean expandTree = true;
    SnmpOID nulloid = null;
    private int count = 0;
    MibBrowser browser;
    String host = "localhost";
    String community = "public";
    String writeCommunity = null;
    String oid = "";
    SnmpOID rootoid = null;
    String setval = "";
    String append_errstr = null;
    Runnable appendErrStr = new Runnable(){

        public void run() {
            SnmpTasks.this.browser.display.statusDisplay.append(SnmpTasks.this.append_errstr);
        }
    };
    String append_str = null;
    Runnable appendStr = new Runnable(){

        public void run() {
            SnmpTasks.this.browser.display.statusDisplay.append(SnmpTasks.this.append_str);
        }
    };
    String append_get_str = null;
    Runnable appendGetStr = new Runnable(){

        public void run() {
            SnmpTasks.this.browser.display.statusDisplay.append(SnmpTasks.this.append_get_str);
        }
    };
    String append_next_str = null;
    Runnable appendNextStr = new Runnable(){

        public void run() {
            SnmpTasks.this.browser.display.statusDisplay.append(SnmpTasks.this.append_next_str);
        }
    };
    String append_bulk_str = null;
    Runnable appendBulkStr = new Runnable(){

        public void run() {
            SnmpTasks.this.browser.display.statusDisplay.append(SnmpTasks.this.append_bulk_str);
        }
    };
    String append_set_str = null;
    Runnable appendSetStr = new Runnable(){

        public void run() {
            SnmpTasks.this.browser.display.statusDisplay.append(SnmpTasks.this.append_set_str);
        }
    };
    private MibNode treenode = null;
    Runnable expandingTree = new Runnable(){

        public void run() {
            SnmpTasks.this.browser.tree.setSelectedMibNode(SnmpTasks.this.treenode);
            SnmpTasks.this.browser.tree.getTree().scrollPathToVisible(SnmpTasks.this.browser.tree.getTree().getSelectionPath());
        }
    };
    boolean isNumericOid = false;
    boolean polling = false;
    Vector multiOids = new Vector();
    Vector values = new Vector();

    SnmpTasks(MibBrowser mibBrowser) {
        this.browser = mibBrowser;
        this.addResultListener(this);
        this.setSendTimeoutEvents(true);
    }

    SnmpTasks(MibBrowser mibBrowser, Applet applet) {
        super(applet);
        this.browser = mibBrowser;
        this.appletexist = true;
        this.addResultListener(this);
        this.setSendTimeoutEvents(true);
    }

    void addVarBindList() {
        String string;
        String string2 = null;
        String string3 = null;
        if (this.browser.getObjectID().trim().equals("")) {
            this.browser.display.statusDisplay.setText(SnmpUtils.getString("No ObjectID Specified"));
            return;
        }
        string3 = this.browser.getSetValue();
        string2 = this.browser.getObjectID().trim();
        SnmpOID snmpOID = this.getMibOperations().getSnmpOID(string2);
        MibNode mibNode = this.getMibOperations().getMibNode(snmpOID);
        if (mibNode != null && ((string = this.getMibOperations().getInstanceString(snmpOID, mibNode)) == null || string.equals("")) && mibNode.isScalar()) {
            string2 = String.valueOf(string2) + ".0";
        }
        string = null;
        string = string3 != null && !string3.trim().equals("") ? String.valueOf(string2) + " : " + string3 : String.valueOf(string2) + ":";
        this.browser.display.newModel.addElement(string.toString());
        this.browser.display.varbindList.setSelectionInterval(0, 0);
        this.multiOids.addElement(string2);
        this.values.addElement(string3);
    }

    boolean checkData(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            this.append_str = String.valueOf(SnmpUtils.getString("No ")) + " " + string2 + " " + SnmpUtils.getString(" specified") + ".\n";
            try {
                SwingUtilities.invokeLater(this.appendStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
            return false;
        }
        return true;
    }

    boolean checkValues() {
        if (!this.checkData(this.host, SnmpUtils.getString("HOST"))) {
            return false;
        }
        return this.checkData(this.oid, SnmpUtils.getString("Object ID"));
    }

    protected void cleanUp() {
        this.stopPoll();
        this.removeResultListener(this);
    }

    public void debugPrint(String string) {
        if (this.browser.getDebugText() != null) {
            this.browser.appendDebugText(String.valueOf(string) + "\n");
        }
    }

    void editVarBindList() {
        if (!this.browser.display.varbindList.isSelectionEmpty()) {
            String string = this.browser.display.oid.getText().trim();
            String string2 = (String)this.browser.display.setval.getEditor().getItem();
            String string3 = null;
            string3 = string2 != null && !string2.trim().equals("") ? String.valueOf(string) + " : " + string2 : String.valueOf(string) + ":";
            int n = this.browser.display.varbindList.getSelectedIndex();
            this.browser.display.newModel.setElementAt(string3.toString(), n);
            this.multiOids.setElementAt(string, n);
            this.values.setElementAt(string2, n);
        }
    }

    void get() {
        if (this.rootoid != null || this.polling) {
            return;
        }
        this.getValues();
        if (!this.multiVar || this.multiOids.size() < 2) {
            if (!this.checkValues()) {
                return;
            }
            this.polling = true;
            MibNode mibNode = null;
            if (this.nulloid != null) {
                mibNode = this.getMibOperations().getMibNode(this.getSnmpOID());
            }
            if (mibNode == null) {
                if (this.sendGetRequest() == -1) {
                    this.stopPoll();
                }
            } else {
                String string = this.getMibOperations().getInstanceString(this.getSnmpOID(), mibNode);
                if (string == null || string.equals("")) {
                    if (mibNode.isScalar()) {
                        this.oid = String.valueOf(this.oid) + ".0";
                        this.setObjectID(this.oid);
                        if (this.sendGetRequest() == -1) {
                            this.stopPoll();
                        }
                    } else {
                        this.rootoid = this.getSnmpOID();
                        if (this.sendGetNextRequest() == -1) {
                            this.stopPoll();
                        }
                    }
                } else if (this.sendGetRequest() == -1) {
                    this.stopPoll();
                }
            }
        } else {
            this.polling = true;
            if (this.sendGetRequest() == -1) {
                this.stopPoll();
            }
        }
        if (this.polling) {
            this.browser.display.statusDisplay.append("\n" + SnmpUtils.getString("Sent get request to ") + " " + this.host + " : " + this.getTargetPort() + "\n");
        } else {
            this.append_get_str = this.nulloid == null ? "\n" + SnmpUtils.getString("Error in  get request to ") + " " + this.host + " : " + this.getTargetPort() + "\n" + SnmpUtils.getString("Invalid OID format") + "\n" : "\n" + SnmpUtils.getString("Error in  get request to ") + " " + this.host + " : " + this.getTargetPort() + "\n" + this.getErrorString() + "\n";
            try {
                SwingUtilities.invokeLater(this.appendGetStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
        }
    }

    Vector getMultipleOids() {
        return this.multiOids;
    }

    String[] getSetValues() {
        Object[] objectArray = new String[this.values.size()];
        this.values.copyInto(objectArray);
        return objectArray;
    }

    void getValues() {
        this.host = (String)this.browser.display.host.getEditor().getItem();
        if (this.host == null || this.host.trim().equals("")) {
            return;
        }
        this.setTargetHost(this.host.trim());
        if (this.multiVar && this.multiOids.size() > 0) {
            Object[] objectArray = new String[this.multiOids.size()];
            this.multiOids.copyInto(objectArray);
            this.setObjectIDList((String[])objectArray);
        } else {
            this.oid = this.browser.getObjectID();
            if (this.browser.getMibOperations() != null) {
                this.nulloid = this.browser.getMibOperations().getSnmpOID(this.oid);
                if (this.nulloid == null) {
                    return;
                }
            }
            if (this.oid == null || this.oid.trim().equals("")) {
                return;
            }
            this.setObjectID(this.oid.trim());
        }
        this.community = this.browser.display.community.getText();
        this.setCommunity(this.community);
        if (this.browser.display.writeCommunity.getText().trim().equals("")) {
            this.writeCommunity = null;
            this.setWriteCommunity(null);
        } else {
            this.writeCommunity = this.browser.display.writeCommunity.getText();
            this.setWriteCommunity(this.writeCommunity);
        }
        this.setval = this.browser.getSetValue();
    }

    void getnext() {
        if (this.rootoid != null || this.polling) {
            return;
        }
        this.getValues();
        if (!this.multiVar && !this.checkValues()) {
            return;
        }
        this.polling = true;
        this.isNumericOid = true;
        if (this.sendGetNextRequest() == -1) {
            this.polling = false;
            this.append_next_str = this.nulloid == null ? "\n" + SnmpUtils.getString("Error in  getnext request to ") + " " + this.host + " : " + this.getTargetPort() + "\n" + SnmpUtils.getString("Invalid OID format") + "\n" : "\n" + SnmpUtils.getString("Error in  getnext request to ") + " " + this.host + " : " + this.getTargetPort() + "\n" + this.getErrorString() + "\n";
            try {
                SwingUtilities.invokeLater(this.appendNextStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
        } else {
            this.browser.display.statusDisplay.append("\n" + SnmpUtils.getString("Sent getnext request to ") + " " + this.host + " : " + this.getTargetPort() + "\n");
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string;
        Object object = itemEvent.getItem();
        if (object instanceof JCheckBox && (string = ((JCheckBox)object).getText()).equals(SnmpUtils.getString("Multi-Var"))) {
            this.multiVar = ((JCheckBox)object).isSelected();
        }
    }

    void removeVarBindList() {
        int[] nArray = this.browser.display.varbindList.getSelectedIndices();
        if (!this.browser.display.varbindList.isSelectionEmpty()) {
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = nArray[n] - n;
                this.browser.display.newModel.removeElementAt(nArray[n]);
                if (nArray[n] == 0) {
                    this.browser.display.varbindList.setSelectionInterval(nArray[n], nArray[n]);
                }
                this.browser.display.varbindList.setSelectionInterval(nArray[n] - 1, nArray[n] - 1);
                this.multiOids.removeElementAt(nArray[n]);
                this.values.removeElementAt(nArray[n]);
                ++n;
            }
        }
    }

    void set() {
        block16: {
            String[] stringArray;
            if (this.rootoid != null || this.polling) {
                return;
            }
            this.getValues();
            if (!this.multiVar) {
                String string;
                if (!this.checkValues()) {
                    return;
                }
                stringArray = null;
                if (this.nulloid != null) {
                    stringArray = this.getMibOperations().getMibNode(this.getSnmpOID());
                }
                if (stringArray != null && ((string = this.getMibOperations().getInstanceString(this.getSnmpOID(), (MibNode)stringArray)) == null || string.equals("")) && stringArray.isScalar()) {
                    this.oid = String.valueOf(this.oid) + ".0";
                    this.setObjectID(this.oid);
                }
            }
            this.polling = true;
            try {
                stringArray = this.getSetValues();
                if (this.multiVar && stringArray.length > 0) {
                    if (this.sendSetRequestList(stringArray) == -1) {
                        this.stopPoll();
                    }
                } else if (this.sendSetRequest(this.setval) == -1) {
                    this.stopPoll();
                }
                if (this.polling) {
                    this.browser.display.statusDisplay.append("\n" + SnmpUtils.getString("Sent set request to ") + " " + this.host + " : " + this.getTargetPort() + "\n");
                    break block16;
                }
                this.append_set_str = this.nulloid == null ? "\n" + SnmpUtils.getString("Error in  set request to ") + " " + this.host + " : " + this.getTargetPort() + "\n" + SnmpUtils.getString("Invalid OID format") + "\n" : "\n" + SnmpUtils.getString("Error in set request to ") + " " + this.host + " : " + this.getTargetPort() + "\n" + this.getErrorString() + "\n";
                try {
                    SwingUtilities.invokeLater(this.appendSetStr);
                }
                catch (Exception exception) {
                    System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
                }
            }
            catch (Exception exception) {
                this.polling = false;
                this.append_set_str = this.nulloid == null ? "\n" + SnmpUtils.getString("Error in  set request to ") + " " + this.host + " : " + this.getTargetPort() + "\n" + SnmpUtils.getString("Invalid OID format") + "\n" : "\n" + SnmpUtils.getString("Error sending set request: ") + " " + exception + "\n";
                try {
                    SwingUtilities.invokeLater(this.appendSetStr);
                }
                catch (Exception exception2) {
                    System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception2);
                }
            }
        }
    }

    public void setMibOperations(MibOperations mibOperations) {
        super.setMibOperations(mibOperations);
    }

    public void setNumericResult(long l) {
    }

    public void setResult(ResultEvent resultEvent) {
        this.oidList = null;
        String string = "";
        String string2 = null;
        string2 = this.getErrorResultString((SnmpPDU)resultEvent.getResponse());
        if (string2 != null) {
            string = String.valueOf(SnmpUtils.getString("Request Failed: ")) + " " + string2;
            this.append_errstr = String.valueOf(string) + "\n";
            this.stopPoll();
            try {
                SwingUtilities.invokeAndWait(this.appendErrStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
            return;
        }
        if (!resultEvent.isSuccess()) {
            string = String.valueOf(SnmpUtils.getString("Request Failed: ")) + " " + resultEvent.getErrorString();
            this.append_str = String.valueOf(string) + this.host + "\n";
            try {
                SwingUtilities.invokeAndWait(this.appendStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
            this.stopPoll();
            return;
        }
        SnmpPDU snmpPDU = (SnmpPDU)resultEvent.getResponse();
        if (snmpPDU == null) {
            string = String.valueOf(SnmpUtils.getString("Request Failed: ")) + " " + resultEvent.getErrorString();
            this.append_str = String.valueOf(string) + this.host + "\n";
            try {
                SwingUtilities.invokeAndWait(this.appendStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
            this.stopPoll();
            return;
        }
        SnmpOID snmpOID = snmpPDU.getObjectID(0);
        if (snmpOID == null) {
            this.append_str = String.valueOf(SnmpUtils.getString("Error: Agent Returned Empty Varbind(s)")) + "\n";
            try {
                SwingUtilities.invokeAndWait(this.appendStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
            this.stopPoll();
            return;
        }
        if (this.rootoid != null) {
            this.oidList = null;
            if (SnmpTarget.isInSubTree(this.rootoid, snmpOID)) {
                ++this.count;
                this.setSnmpOID(snmpOID);
                if (this.sendGetNextRequest() == -1) {
                    this.stopPoll();
                    return;
                }
            } else {
                if (this.count == 0) {
                    this.append_str = String.valueOf(SnmpUtils.getString("No data available in this sub-tree")) + "\n";
                    try {
                        SwingUtilities.invokeAndWait(this.appendStr);
                    }
                    catch (Exception exception) {
                        System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
                    }
                }
                this.count = 0;
                this.stopPoll();
                return;
            }
        }
        Enumeration enumeration = snmpPDU.getVariableBindings().elements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            this.append_str = String.valueOf(this.getMibOperations().toString(snmpVarBind)) + "\n";
            StringTokenizer stringTokenizer = new StringTokenizer(this.append_str, ":");
            if (stringTokenizer.countTokens() == 2) {
                this.append_str = String.valueOf(stringTokenizer.nextToken()) + ":-->" + stringTokenizer.nextToken();
            }
            try {
                SwingUtilities.invokeAndWait(this.appendStr);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
            }
        }
        if (this.rootoid == null) {
            this.treenode = this.getMibOperations().getMibNode(snmpPDU.getObjectID(0));
            if (this.treenode != null || this.isNumericOid) {
                if (this.expandTree && this.browser.tree.isEnabled()) {
                    try {
                        SwingUtilities.invokeLater(this.expandingTree);
                    }
                    catch (Exception exception) {
                        System.out.println(String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception);
                    }
                }
                this.browser.display.oid.setText(this.getMibOperations().toString(snmpPDU.getObjectID(0)));
                this.isNumericOid = false;
            }
            this.polling = false;
        }
    }

    public void setStringResult(String string) {
    }

    void stopPoll() {
        this.polling = false;
        this.rootoid = null;
    }
}

